package software.amazon.awscdk.services.ec2;

/**
 * Which strategy to use when launching instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceType instanceType;
 * PlacementGroup pg = PlacementGroup.Builder.create(this, "test-pg")
 *         .strategy(PlacementGroupStrategy.SPREAD)
 *         .build();
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .placementGroup(pg)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:47.010Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PlacementGroupStrategy")
public enum PlacementGroupStrategy {
    /**
     * Packs instances close together inside an Availability Zone.
     * <p>
     * This strategy enables workloads to achieve the low-latency network
     * performance necessary for tightly-coupled node-to-node communication that
     * is typical of high-performance computing (HPC) applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLUSTER,
    /**
     * Spreads your instances across logical partitions such that groups of instances in one partition do not share the underlying hardware with groups of instances in different partitions.
     * <p>
     * This strategy is typically used by large distributed and replicated workloads,
     * such as Hadoop, Cassandra, and Kafka.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARTITION,
    /**
     * Strictly places a small group of instances across distinct underlying hardware to reduce correlated failures.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SPREAD,
}
