package software.amazon.awscdk.services.eks;

/**
 * Kubectl Provider Attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole handlerRole = Role.fromRoleArn(this, "HandlerRole", "arn:aws:iam::123456789012:role/lambda-role");
 * // get the serviceToken from the custom resource provider
 * String functionArn = Function.fromFunctionName(this, "ProviderOnEventFunc", "ProviderframeworkonEvent-XXX").getFunctionArn();
 * IKubectlProvider kubectlProvider = KubectlProvider.fromKubectlProviderAttributes(this, "KubectlProvider", KubectlProviderAttributes.builder()
 *         .functionArn(functionArn)
 *         .kubectlRoleArn("arn:aws:iam::123456789012:role/kubectl-role")
 *         .handlerRole(handlerRole)
 *         .build());
 * ICluster cluster = Cluster.fromClusterAttributes(this, "Cluster", ClusterAttributes.builder()
 *         .clusterName("cluster")
 *         .kubectlProvider(kubectlProvider)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:47.762Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubectlProviderAttributes")
@software.amazon.jsii.Jsii.Proxy(KubectlProviderAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KubectlProviderAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The custom resource provider's service token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

    /**
     * The IAM execution role of the handler.
     * <p>
     * This role must be able to assume kubectlRoleArn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getHandlerRole();

    /**
     * The IAM role to assume in order to perform kubectl operations against this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKubectlRoleArn();

    /**
     * @return a {@link Builder} of {@link KubectlProviderAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubectlProviderAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KubectlProviderAttributes> {
        java.lang.String functionArn;
        software.amazon.awscdk.services.iam.IRole handlerRole;
        java.lang.String kubectlRoleArn;

        /**
         * Sets the value of {@link KubectlProviderAttributes#getFunctionArn}
         * @param functionArn The custom resource provider's service token. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionArn(java.lang.String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        /**
         * Sets the value of {@link KubectlProviderAttributes#getHandlerRole}
         * @param handlerRole The IAM execution role of the handler. This parameter is required.
         *                    This role must be able to assume kubectlRoleArn
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handlerRole(software.amazon.awscdk.services.iam.IRole handlerRole) {
            this.handlerRole = handlerRole;
            return this;
        }

        /**
         * Sets the value of {@link KubectlProviderAttributes#getKubectlRoleArn}
         * @param kubectlRoleArn The IAM role to assume in order to perform kubectl operations against this cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlRoleArn(java.lang.String kubectlRoleArn) {
            this.kubectlRoleArn = kubectlRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubectlProviderAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KubectlProviderAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KubectlProviderAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubectlProviderAttributes {
        private final java.lang.String functionArn;
        private final software.amazon.awscdk.services.iam.IRole handlerRole;
        private final java.lang.String kubectlRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.handlerRole = software.amazon.jsii.Kernel.get(this, "handlerRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.kubectlRoleArn = software.amazon.jsii.Kernel.get(this, "kubectlRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
            this.handlerRole = java.util.Objects.requireNonNull(builder.handlerRole, "handlerRole is required");
            this.kubectlRoleArn = java.util.Objects.requireNonNull(builder.kubectlRoleArn, "kubectlRoleArn is required");
        }

        @Override
        public final java.lang.String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getHandlerRole() {
            return this.handlerRole;
        }

        @Override
        public final java.lang.String getKubectlRoleArn() {
            return this.kubectlRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionArn", om.valueToTree(this.getFunctionArn()));
            data.set("handlerRole", om.valueToTree(this.getHandlerRole()));
            data.set("kubectlRoleArn", om.valueToTree(this.getKubectlRoleArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.KubectlProviderAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubectlProviderAttributes.Jsii$Proxy that = (KubectlProviderAttributes.Jsii$Proxy) o;

            if (!functionArn.equals(that.functionArn)) return false;
            if (!handlerRole.equals(that.handlerRole)) return false;
            return this.kubectlRoleArn.equals(that.kubectlRoleArn);
        }

        @Override
        public final int hashCode() {
            int result = this.functionArn.hashCode();
            result = 31 * result + (this.handlerRole.hashCode());
            result = 31 * result + (this.kubectlRoleArn.hashCode());
            return result;
        }
    }
}
