package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Backend protocol for network load balancers and health checks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .ipAddressType(IpAddressType.DUAL_STACK)
 *         .enablePrefixForIpv6SourceNat(true)
 *         .build();
 * NetworkListener listener = lb.addListener("Listener", BaseNetworkListenerProps.builder()
 *         .port(1229)
 *         .protocol(Protocol.UDP)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:48.403Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.Protocol")
public enum Protocol {
    /**
     * HTTP (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * HTTPS (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
    /**
     * TCP (NLB, NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP,
    /**
     * TLS (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS,
    /**
     * UDP (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UDP,
    /**
     * Listen to both TCP and UDP on the same port (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP_UDP,
}
