package software.amazon.awscdk.services.elasticsearch;

/**
 * Elasticsearch version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(ElasticsearchVersion.V7_4)
 *         .ebs(EbsOptions.builder()
 *                 .volumeSize(100)
 *                 .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD)
 *                 .build())
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:48.533Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.ElasticsearchVersion")
public class ElasticsearchVersion extends software.amazon.jsii.JsiiObject {

    protected ElasticsearchVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ElasticsearchVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        V1_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V1_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V5_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V5_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V5_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V5_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V5_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V5_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V5_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V5_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V6_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V6_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V7_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V7_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V7_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V7_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V7_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V7_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V7_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V7_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V7_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V7_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
        V7_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "V7_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
    }

    /**
     * Custom Elasticsearch version.
     * <p>
     * @param version custom version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * AWS Elasticsearch 1.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V1_5;

    /**
     * AWS Elasticsearch 2.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V2_3;

    /**
     * AWS Elasticsearch 5.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V5_1;

    /**
     * AWS Elasticsearch 5.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V5_3;

    /**
     * AWS Elasticsearch 5.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V5_5;

    /**
     * AWS Elasticsearch 5.6.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V5_6;

    /**
     * AWS Elasticsearch 6.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_0;

    /**
     * AWS Elasticsearch 6.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_2;

    /**
     * AWS Elasticsearch 6.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_3;

    /**
     * AWS Elasticsearch 6.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_4;

    /**
     * AWS Elasticsearch 6.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_5;

    /**
     * AWS Elasticsearch 6.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_7;

    /**
     * AWS Elasticsearch 6.8.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V6_8;

    /**
     * AWS Elasticsearch 7.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V7_1;

    /**
     * AWS Elasticsearch 7.10.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V7_10;

    /**
     * AWS Elasticsearch 7.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V7_4;

    /**
     * AWS Elasticsearch 7.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V7_7;

    /**
     * AWS Elasticsearch 7.8.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V7_8;

    /**
     * AWS Elasticsearch 7.9.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion V7_9;

    /**
     * Elasticsearch version number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
