package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a <code>CfnSecurityConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.emr.*;
 * CfnSecurityConfiguration cfnSecurityConfiguration = CfnSecurityConfiguration.Builder.create(this, "EmrSecurityConfiguration")
 *         .name("AddStepRuntimeRoleSecConfig")
 *         .securityConfiguration(JSON.parse("\n    {\n      \"AuthorizationConfiguration\": {\n          \"IAMConfiguration\": {\n              \"EnableApplicationScopedIAMRole\": true,\n              \"ApplicationScopedIAMRoleConfiguration\":\n                  {\n                      \"PropagateSourceIdentity\": true\n                  }\n          },\n          \"LakeFormationConfiguration\": {\n              \"AuthorizedSessionTagValue\": \"Amazon EMR\"\n          }\n      }\n    }"))
 *         .build();
 * EmrCreateCluster task = EmrCreateCluster.Builder.create(this, "Create Cluster")
 *         .instances(InstancesConfigProperty.builder().build())
 *         .name(TaskInput.fromJsonPathAt("$.ClusterName").getValue())
 *         .securityConfiguration(cfnSecurityConfiguration.getName())
 *         .build();
 * Role executionRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ArnPrincipal(task.getClusterRole().getRoleArn()))
 *         .build();
 * executionRole.assumeRolePolicy.addStatements(
 * PolicyStatement.Builder.create()
 *         .effect(Effect.ALLOW)
 *         .principals(List.of(task.getClusterRole()))
 *         .actions(List.of("sts:SetSourceIdentity"))
 *         .build(),
 * PolicyStatement.Builder.create()
 *         .effect(Effect.ALLOW)
 *         .principals(List.of(task.getClusterRole()))
 *         .actions(List.of("sts:TagSession"))
 *         .conditions(Map.of(
 *                 "StringEquals", Map.of(
 *                         "aws:RequestTag/LakeFormationAuthorizedCaller", "Amazon EMR")))
 *         .build());
 * EmrAddStep.Builder.create(this, "Task")
 *         .clusterId("ClusterId")
 *         .executionRoleArn(executionRole.getRoleArn())
 *         .name("StepName")
 *         .jar("Jar")
 *         .actionOnFailure(ActionOnFailure.CONTINUE)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-securityconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-securityconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:48.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnSecurityConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecurityConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The security configuration details in JSON format.
     * <p>
     * For JSON parameters and examples, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security Configurations to Set Up Cluster Security</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-securityconfiguration.html#cfn-emr-securityconfiguration-securityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-securityconfiguration.html#cfn-emr-securityconfiguration-securityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSecurityConfiguration();

    /**
     * The name of the security configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-securityconfiguration.html#cfn-emr-securityconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-securityconfiguration.html#cfn-emr-securityconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecurityConfigurationProps> {
        java.lang.Object securityConfiguration;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnSecurityConfigurationProps#getSecurityConfiguration}
         * @param securityConfiguration The security configuration details in JSON format. This parameter is required.
         *                              For JSON parameters and examples, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security Configurations to Set Up Cluster Security</a> in the <em>Amazon EMR Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.Object securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityConfigurationProps#getName}
         * @param name The name of the security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecurityConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityConfigurationProps {
        private final java.lang.Object securityConfiguration;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityConfiguration = java.util.Objects.requireNonNull(builder.securityConfiguration, "securityConfiguration is required");
            this.name = builder.name;
        }

        @Override
        public final java.lang.Object getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnSecurityConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityConfigurationProps.Jsii$Proxy that = (CfnSecurityConfigurationProps.Jsii$Proxy) o;

            if (!securityConfiguration.equals(that.securityConfiguration)) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.securityConfiguration.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
