package software.amazon.awscdk.services.entityresolution;

/**
 * Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use it.
 * <p>
 * Each ID namespace must have a unique name. To modify an existing ID namespace, use the <code>UpdateIdNamespace</code> API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * CfnIdNamespace cfnIdNamespace = CfnIdNamespace.Builder.create(this, "MyCfnIdNamespace")
 *         .idNamespaceName("idNamespaceName")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .idMappingWorkflowProperties(List.of(IdNamespaceIdMappingWorkflowPropertiesProperty.builder()
 *                 .idMappingType("idMappingType")
 *                 // the properties below are optional
 *                 .providerProperties(NamespaceProviderPropertiesProperty.builder()
 *                         .providerServiceArn("providerServiceArn")
 *                         // the properties below are optional
 *                         .providerConfiguration(Map.of(
 *                                 "providerConfigurationKey", "providerConfiguration"))
 *                         .build())
 *                 .ruleBasedProperties(NamespaceRuleBasedPropertiesProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         .recordMatchingModels(List.of("recordMatchingModels"))
 *                         .ruleDefinitionTypes(List.of("ruleDefinitionTypes"))
 *                         .rules(List.of(RuleProperty.builder()
 *                                 .matchingKeys(List.of("matchingKeys"))
 *                                 .ruleName("ruleName")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .inputSourceConfig(List.of(IdNamespaceInputSourceProperty.builder()
 *                 .inputSourceArn("inputSourceArn")
 *                 // the properties below are optional
 *                 .schemaName("schemaName")
 *                 .build()))
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:48.823Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdNamespace")
public class CfnIdNamespace extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnIdNamespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdNamespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.entityresolution.CfnIdNamespace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdNamespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.CfnIdNamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time when the IdNamespace was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The arn associated with the IdNamespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the IdNamespace was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the ID namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "idNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ID namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdNamespaceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "idNamespaceName", java.util.Objects.requireNonNull(value, "idNamespaceName is required"));
    }

    /**
     * The type of ID namespace.
     * <p>
     * There are two types: <code>SOURCE</code> and <code>TARGET</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of ID namespace.
     * <p>
     * There are two types: <code>SOURCE</code> and <code>TARGET</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The description of the ID namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the ID namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdMappingWorkflowProperties() {
        return software.amazon.jsii.Kernel.get(this, "idMappingWorkflowProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingWorkflowProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "idMappingWorkflowProperties", value);
    }

    /**
     * Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingWorkflowProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnIdNamespace.IdNamespaceIdMappingWorkflowPropertiesProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnIdNamespace.IdNamespaceIdMappingWorkflowPropertiesProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "idMappingWorkflowProperties", value);
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInputSourceConfig() {
        return software.amazon.jsii.Kernel.get(this, "inputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSourceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputSourceConfig", value);
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSourceConfig(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnIdNamespace.IdNamespaceInputSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnIdNamespace.IdNamespaceInputSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inputSourceConfig", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * An object containing <code>IdMappingType</code> , <code>ProviderProperties</code> , and <code>RuleBasedProperties</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdNamespaceIdMappingWorkflowPropertiesProperty idNamespaceIdMappingWorkflowPropertiesProperty = IdNamespaceIdMappingWorkflowPropertiesProperty.builder()
     *         .idMappingType("idMappingType")
     *         // the properties below are optional
     *         .providerProperties(NamespaceProviderPropertiesProperty.builder()
     *                 .providerServiceArn("providerServiceArn")
     *                 // the properties below are optional
     *                 .providerConfiguration(Map.of(
     *                         "providerConfigurationKey", "providerConfiguration"))
     *                 .build())
     *         .ruleBasedProperties(NamespaceRuleBasedPropertiesProperty.builder()
     *                 .attributeMatchingModel("attributeMatchingModel")
     *                 .recordMatchingModels(List.of("recordMatchingModels"))
     *                 .ruleDefinitionTypes(List.of("ruleDefinitionTypes"))
     *                 .rules(List.of(RuleProperty.builder()
     *                         .matchingKeys(List.of("matchingKeys"))
     *                         .ruleName("ruleName")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdNamespace.IdNamespaceIdMappingWorkflowPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(IdNamespaceIdMappingWorkflowPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdNamespaceIdMappingWorkflowPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of ID mapping.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html#cfn-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties-idmappingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html#cfn-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties-idmappingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdMappingType();

        /**
         * An object which defines any additional configurations required by the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html#cfn-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties-providerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html#cfn-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties-providerproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProviderProperties() {
            return null;
        }

        /**
         * An object which defines any additional configurations required by rule-based matching.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html#cfn-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties-rulebasedproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties.html#cfn-entityresolution-idnamespace-idnamespaceidmappingworkflowproperties-rulebasedproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleBasedProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdNamespaceIdMappingWorkflowPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdNamespaceIdMappingWorkflowPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdNamespaceIdMappingWorkflowPropertiesProperty> {
            java.lang.String idMappingType;
            java.lang.Object providerProperties;
            java.lang.Object ruleBasedProperties;

            /**
             * Sets the value of {@link IdNamespaceIdMappingWorkflowPropertiesProperty#getIdMappingType}
             * @param idMappingType The type of ID mapping. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idMappingType(java.lang.String idMappingType) {
                this.idMappingType = idMappingType;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceIdMappingWorkflowPropertiesProperty#getProviderProperties}
             * @param providerProperties An object which defines any additional configurations required by the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerProperties(software.amazon.awscdk.IResolvable providerProperties) {
                this.providerProperties = providerProperties;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceIdMappingWorkflowPropertiesProperty#getProviderProperties}
             * @param providerProperties An object which defines any additional configurations required by the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerProperties(software.amazon.awscdk.services.entityresolution.CfnIdNamespace.NamespaceProviderPropertiesProperty providerProperties) {
                this.providerProperties = providerProperties;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceIdMappingWorkflowPropertiesProperty#getRuleBasedProperties}
             * @param ruleBasedProperties An object which defines any additional configurations required by rule-based matching.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleBasedProperties(software.amazon.awscdk.IResolvable ruleBasedProperties) {
                this.ruleBasedProperties = ruleBasedProperties;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceIdMappingWorkflowPropertiesProperty#getRuleBasedProperties}
             * @param ruleBasedProperties An object which defines any additional configurations required by rule-based matching.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleBasedProperties(software.amazon.awscdk.services.entityresolution.CfnIdNamespace.NamespaceRuleBasedPropertiesProperty ruleBasedProperties) {
                this.ruleBasedProperties = ruleBasedProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdNamespaceIdMappingWorkflowPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdNamespaceIdMappingWorkflowPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdNamespaceIdMappingWorkflowPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdNamespaceIdMappingWorkflowPropertiesProperty {
            private final java.lang.String idMappingType;
            private final java.lang.Object providerProperties;
            private final java.lang.Object ruleBasedProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idMappingType = software.amazon.jsii.Kernel.get(this, "idMappingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.providerProperties = software.amazon.jsii.Kernel.get(this, "providerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleBasedProperties = software.amazon.jsii.Kernel.get(this, "ruleBasedProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idMappingType = java.util.Objects.requireNonNull(builder.idMappingType, "idMappingType is required");
                this.providerProperties = builder.providerProperties;
                this.ruleBasedProperties = builder.ruleBasedProperties;
            }

            @Override
            public final java.lang.String getIdMappingType() {
                return this.idMappingType;
            }

            @Override
            public final java.lang.Object getProviderProperties() {
                return this.providerProperties;
            }

            @Override
            public final java.lang.Object getRuleBasedProperties() {
                return this.ruleBasedProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idMappingType", om.valueToTree(this.getIdMappingType()));
                if (this.getProviderProperties() != null) {
                    data.set("providerProperties", om.valueToTree(this.getProviderProperties()));
                }
                if (this.getRuleBasedProperties() != null) {
                    data.set("ruleBasedProperties", om.valueToTree(this.getRuleBasedProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdNamespace.IdNamespaceIdMappingWorkflowPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdNamespaceIdMappingWorkflowPropertiesProperty.Jsii$Proxy that = (IdNamespaceIdMappingWorkflowPropertiesProperty.Jsii$Proxy) o;

                if (!idMappingType.equals(that.idMappingType)) return false;
                if (this.providerProperties != null ? !this.providerProperties.equals(that.providerProperties) : that.providerProperties != null) return false;
                return this.ruleBasedProperties != null ? this.ruleBasedProperties.equals(that.ruleBasedProperties) : that.ruleBasedProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idMappingType.hashCode();
                result = 31 * result + (this.providerProperties != null ? this.providerProperties.hashCode() : 0);
                result = 31 * result + (this.ruleBasedProperties != null ? this.ruleBasedProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing <code>InputSourceARN</code> and <code>SchemaName</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdNamespaceInputSourceProperty idNamespaceInputSourceProperty = IdNamespaceInputSourceProperty.builder()
     *         .inputSourceArn("inputSourceArn")
     *         // the properties below are optional
     *         .schemaName("schemaName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceinputsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceinputsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdNamespace.IdNamespaceInputSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(IdNamespaceInputSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdNamespaceInputSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceinputsource.html#cfn-entityresolution-idnamespace-idnamespaceinputsource-inputsourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceinputsource.html#cfn-entityresolution-idnamespace-idnamespaceinputsource-inputsourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputSourceArn();

        /**
         * The name of the schema.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceinputsource.html#cfn-entityresolution-idnamespace-idnamespaceinputsource-schemaname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-idnamespaceinputsource.html#cfn-entityresolution-idnamespace-idnamespaceinputsource-schemaname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdNamespaceInputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdNamespaceInputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdNamespaceInputSourceProperty> {
            java.lang.String inputSourceArn;
            java.lang.String schemaName;

            /**
             * Sets the value of {@link IdNamespaceInputSourceProperty#getInputSourceArn}
             * @param inputSourceArn An AWS Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSourceArn(java.lang.String inputSourceArn) {
                this.inputSourceArn = inputSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link IdNamespaceInputSourceProperty#getSchemaName}
             * @param schemaName The name of the schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaName(java.lang.String schemaName) {
                this.schemaName = schemaName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdNamespaceInputSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdNamespaceInputSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdNamespaceInputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdNamespaceInputSourceProperty {
            private final java.lang.String inputSourceArn;
            private final java.lang.String schemaName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputSourceArn = software.amazon.jsii.Kernel.get(this, "inputSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaName = software.amazon.jsii.Kernel.get(this, "schemaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputSourceArn = java.util.Objects.requireNonNull(builder.inputSourceArn, "inputSourceArn is required");
                this.schemaName = builder.schemaName;
            }

            @Override
            public final java.lang.String getInputSourceArn() {
                return this.inputSourceArn;
            }

            @Override
            public final java.lang.String getSchemaName() {
                return this.schemaName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputSourceArn", om.valueToTree(this.getInputSourceArn()));
                if (this.getSchemaName() != null) {
                    data.set("schemaName", om.valueToTree(this.getSchemaName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdNamespace.IdNamespaceInputSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdNamespaceInputSourceProperty.Jsii$Proxy that = (IdNamespaceInputSourceProperty.Jsii$Proxy) o;

                if (!inputSourceArn.equals(that.inputSourceArn)) return false;
                return this.schemaName != null ? this.schemaName.equals(that.schemaName) : that.schemaName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputSourceArn.hashCode();
                result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing <code>ProviderConfiguration</code> and <code>ProviderServiceArn</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * NamespaceProviderPropertiesProperty namespaceProviderPropertiesProperty = NamespaceProviderPropertiesProperty.builder()
     *         .providerServiceArn("providerServiceArn")
     *         // the properties below are optional
     *         .providerConfiguration(Map.of(
     *                 "providerConfigurationKey", "providerConfiguration"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespaceproviderproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespaceproviderproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdNamespace.NamespaceProviderPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(NamespaceProviderPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NamespaceProviderPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespaceproviderproperties.html#cfn-entityresolution-idnamespace-namespaceproviderproperties-providerservicearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespaceproviderproperties.html#cfn-entityresolution-idnamespace-namespaceproviderproperties-providerservicearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderServiceArn();

        /**
         * An object which defines any additional configurations required by the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespaceproviderproperties.html#cfn-entityresolution-idnamespace-namespaceproviderproperties-providerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespaceproviderproperties.html#cfn-entityresolution-idnamespace-namespaceproviderproperties-providerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProviderConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NamespaceProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NamespaceProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NamespaceProviderPropertiesProperty> {
            java.lang.String providerServiceArn;
            java.lang.Object providerConfiguration;

            /**
             * Sets the value of {@link NamespaceProviderPropertiesProperty#getProviderServiceArn}
             * @param providerServiceArn The Amazon Resource Name (ARN) of the provider service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerServiceArn(java.lang.String providerServiceArn) {
                this.providerServiceArn = providerServiceArn;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProviderPropertiesProperty#getProviderConfiguration}
             * @param providerConfiguration An object which defines any additional configurations required by the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerConfiguration(java.util.Map<java.lang.String, java.lang.String> providerConfiguration) {
                this.providerConfiguration = providerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceProviderPropertiesProperty#getProviderConfiguration}
             * @param providerConfiguration An object which defines any additional configurations required by the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerConfiguration(software.amazon.awscdk.IResolvable providerConfiguration) {
                this.providerConfiguration = providerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NamespaceProviderPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NamespaceProviderPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NamespaceProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NamespaceProviderPropertiesProperty {
            private final java.lang.String providerServiceArn;
            private final java.lang.Object providerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerServiceArn = software.amazon.jsii.Kernel.get(this, "providerServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.providerConfiguration = software.amazon.jsii.Kernel.get(this, "providerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerServiceArn = java.util.Objects.requireNonNull(builder.providerServiceArn, "providerServiceArn is required");
                this.providerConfiguration = builder.providerConfiguration;
            }

            @Override
            public final java.lang.String getProviderServiceArn() {
                return this.providerServiceArn;
            }

            @Override
            public final java.lang.Object getProviderConfiguration() {
                return this.providerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerServiceArn", om.valueToTree(this.getProviderServiceArn()));
                if (this.getProviderConfiguration() != null) {
                    data.set("providerConfiguration", om.valueToTree(this.getProviderConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdNamespace.NamespaceProviderPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NamespaceProviderPropertiesProperty.Jsii$Proxy that = (NamespaceProviderPropertiesProperty.Jsii$Proxy) o;

                if (!providerServiceArn.equals(that.providerServiceArn)) return false;
                return this.providerConfiguration != null ? this.providerConfiguration.equals(that.providerConfiguration) : that.providerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerServiceArn.hashCode();
                result = 31 * result + (this.providerConfiguration != null ? this.providerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The rule-based properties of an ID namespace.
     * <p>
     * These properties define how the ID namespace can be used in an ID mapping workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * NamespaceRuleBasedPropertiesProperty namespaceRuleBasedPropertiesProperty = NamespaceRuleBasedPropertiesProperty.builder()
     *         .attributeMatchingModel("attributeMatchingModel")
     *         .recordMatchingModels(List.of("recordMatchingModels"))
     *         .ruleDefinitionTypes(List.of("ruleDefinitionTypes"))
     *         .rules(List.of(RuleProperty.builder()
     *                 .matchingKeys(List.of("matchingKeys"))
     *                 .ruleName("ruleName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdNamespace.NamespaceRuleBasedPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(NamespaceRuleBasedPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NamespaceRuleBasedPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code> .
         * <p>
         * If you choose <code>MANY_TO_MANY</code> , the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute type.
         * <p>
         * If you choose <code>ONE_TO_ONE</code> , the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-attributematchingmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-attributematchingmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeMatchingModel() {
            return null;
        }

        /**
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code> , only one record in the source is matched to one record in the target.
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code> , all matching records in the source are matched to one record in the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-recordmatchingmodels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-recordmatchingmodels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRecordMatchingModels() {
            return null;
        }

        /**
         * The sets of rules you can use in an ID mapping workflow.
         * <p>
         * The limitations specified for the source and target must be compatible.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-ruledefinitiontypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-ruledefinitiontypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRuleDefinitionTypes() {
            return null;
        }

        /**
         * The rules for the ID namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-namespacerulebasedproperties.html#cfn-entityresolution-idnamespace-namespacerulebasedproperties-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NamespaceRuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NamespaceRuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NamespaceRuleBasedPropertiesProperty> {
            java.lang.String attributeMatchingModel;
            java.util.List<java.lang.String> recordMatchingModels;
            java.util.List<java.lang.String> ruleDefinitionTypes;
            java.lang.Object rules;

            /**
             * Sets the value of {@link NamespaceRuleBasedPropertiesProperty#getAttributeMatchingModel}
             * @param attributeMatchingModel The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code> .
             *                               If you choose <code>MANY_TO_MANY</code> , the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute type.
             *                               <p>
             *                               If you choose <code>ONE_TO_ONE</code> , the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeMatchingModel(java.lang.String attributeMatchingModel) {
                this.attributeMatchingModel = attributeMatchingModel;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceRuleBasedPropertiesProperty#getRecordMatchingModels}
             * @param recordMatchingModels The type of matching record that is allowed to be used in an ID mapping workflow.
             *                             If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code> , only one record in the source is matched to one record in the target.
             *                             <p>
             *                             If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code> , all matching records in the source are matched to one record in the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordMatchingModels(java.util.List<java.lang.String> recordMatchingModels) {
                this.recordMatchingModels = recordMatchingModels;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceRuleBasedPropertiesProperty#getRuleDefinitionTypes}
             * @param ruleDefinitionTypes The sets of rules you can use in an ID mapping workflow.
             *                            The limitations specified for the source and target must be compatible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleDefinitionTypes(java.util.List<java.lang.String> ruleDefinitionTypes) {
                this.ruleDefinitionTypes = ruleDefinitionTypes;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceRuleBasedPropertiesProperty#getRules}
             * @param rules The rules for the ID namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link NamespaceRuleBasedPropertiesProperty#getRules}
             * @param rules The rules for the ID namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NamespaceRuleBasedPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NamespaceRuleBasedPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NamespaceRuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NamespaceRuleBasedPropertiesProperty {
            private final java.lang.String attributeMatchingModel;
            private final java.util.List<java.lang.String> recordMatchingModels;
            private final java.util.List<java.lang.String> ruleDefinitionTypes;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeMatchingModel = software.amazon.jsii.Kernel.get(this, "attributeMatchingModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordMatchingModels = software.amazon.jsii.Kernel.get(this, "recordMatchingModels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ruleDefinitionTypes = software.amazon.jsii.Kernel.get(this, "ruleDefinitionTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeMatchingModel = builder.attributeMatchingModel;
                this.recordMatchingModels = builder.recordMatchingModels;
                this.ruleDefinitionTypes = builder.ruleDefinitionTypes;
                this.rules = builder.rules;
            }

            @Override
            public final java.lang.String getAttributeMatchingModel() {
                return this.attributeMatchingModel;
            }

            @Override
            public final java.util.List<java.lang.String> getRecordMatchingModels() {
                return this.recordMatchingModels;
            }

            @Override
            public final java.util.List<java.lang.String> getRuleDefinitionTypes() {
                return this.ruleDefinitionTypes;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributeMatchingModel() != null) {
                    data.set("attributeMatchingModel", om.valueToTree(this.getAttributeMatchingModel()));
                }
                if (this.getRecordMatchingModels() != null) {
                    data.set("recordMatchingModels", om.valueToTree(this.getRecordMatchingModels()));
                }
                if (this.getRuleDefinitionTypes() != null) {
                    data.set("ruleDefinitionTypes", om.valueToTree(this.getRuleDefinitionTypes()));
                }
                if (this.getRules() != null) {
                    data.set("rules", om.valueToTree(this.getRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdNamespace.NamespaceRuleBasedPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NamespaceRuleBasedPropertiesProperty.Jsii$Proxy that = (NamespaceRuleBasedPropertiesProperty.Jsii$Proxy) o;

                if (this.attributeMatchingModel != null ? !this.attributeMatchingModel.equals(that.attributeMatchingModel) : that.attributeMatchingModel != null) return false;
                if (this.recordMatchingModels != null ? !this.recordMatchingModels.equals(that.recordMatchingModels) : that.recordMatchingModels != null) return false;
                if (this.ruleDefinitionTypes != null ? !this.ruleDefinitionTypes.equals(that.ruleDefinitionTypes) : that.ruleDefinitionTypes != null) return false;
                return this.rules != null ? this.rules.equals(that.rules) : that.rules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeMatchingModel != null ? this.attributeMatchingModel.hashCode() : 0;
                result = 31 * result + (this.recordMatchingModels != null ? this.recordMatchingModels.hashCode() : 0);
                result = 31 * result + (this.ruleDefinitionTypes != null ? this.ruleDefinitionTypes.hashCode() : 0);
                result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing <code>RuleName</code> , and <code>MatchingKeys</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .matchingKeys(List.of("matchingKeys"))
     *         .ruleName("ruleName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdNamespace.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of <code>MatchingKeys</code> .
         * <p>
         * The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code> . Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-rule.html#cfn-entityresolution-idnamespace-rule-matchingkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-rule.html#cfn-entityresolution-idnamespace-rule-matchingkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchingKeys();

        /**
         * A name for the matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-rule.html#cfn-entityresolution-idnamespace-rule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idnamespace-rule.html#cfn-entityresolution-idnamespace-rule-rulename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.util.List<java.lang.String> matchingKeys;
            java.lang.String ruleName;

            /**
             * Sets the value of {@link RuleProperty#getMatchingKeys}
             * @param matchingKeys A list of <code>MatchingKeys</code> . This parameter is required.
             *                     The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code> . Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingKeys(java.util.List<java.lang.String> matchingKeys) {
                this.matchingKeys = matchingKeys;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getRuleName}
             * @param ruleName A name for the matching rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.util.List<java.lang.String> matchingKeys;
            private final java.lang.String ruleName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchingKeys = software.amazon.jsii.Kernel.get(this, "matchingKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchingKeys = java.util.Objects.requireNonNull(builder.matchingKeys, "matchingKeys is required");
                this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            }

            @Override
            public final java.util.List<java.lang.String> getMatchingKeys() {
                return this.matchingKeys;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchingKeys", om.valueToTree(this.getMatchingKeys()));
                data.set("ruleName", om.valueToTree(this.getRuleName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdNamespace.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!matchingKeys.equals(that.matchingKeys)) return false;
                return this.ruleName.equals(that.ruleName);
            }

            @Override
            public final int hashCode() {
                int result = this.matchingKeys.hashCode();
                result = 31 * result + (this.ruleName.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.entityresolution.CfnIdNamespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.entityresolution.CfnIdNamespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.entityresolution.CfnIdNamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.entityresolution.CfnIdNamespaceProps.Builder();
        }

        /**
         * The name of the ID namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-idnamespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-idnamespacename</a>
         * @param idNamespaceName The name of the ID namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idNamespaceName(final java.lang.String idNamespaceName) {
            this.props.idNamespaceName(idNamespaceName);
            return this;
        }

        /**
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code> .
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow.
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will resolve to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-type</a>
         * @param type The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The description of the ID namespace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-description</a>
         * @param description The description of the ID namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-idmappingworkflowproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-idmappingworkflowproperties</a>
         * @param idMappingWorkflowProperties Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingWorkflowProperties(final software.amazon.awscdk.IResolvable idMappingWorkflowProperties) {
            this.props.idMappingWorkflowProperties(idMappingWorkflowProperties);
            return this;
        }
        /**
         * Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-idmappingworkflowproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-idmappingworkflowproperties</a>
         * @param idMappingWorkflowProperties Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingWorkflowProperties(final java.util.List<? extends java.lang.Object> idMappingWorkflowProperties) {
            this.props.idMappingWorkflowProperties(idMappingWorkflowProperties);
            return this;
        }

        /**
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-inputsourceconfig</a>
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(final software.amazon.awscdk.IResolvable inputSourceConfig) {
            this.props.inputSourceConfig(inputSourceConfig);
            return this;
        }
        /**
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-inputsourceconfig</a>
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(final java.util.List<? extends java.lang.Object> inputSourceConfig) {
            this.props.inputSourceConfig(inputSourceConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         * <p>
         * AWS Entity Resolution assumes this role to access the resources defined in this <code>IdNamespace</code> on your behalf as part of the workflow run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idnamespace.html#cfn-entityresolution-idnamespace-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.entityresolution.CfnIdNamespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.entityresolution.CfnIdNamespace build() {
            return new software.amazon.awscdk.services.entityresolution.CfnIdNamespace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
