package software.amazon.awscdk.services.events.targets;

/**
 * Customize the Amazon Data Firehose Stream Event Target V2 to support L2 Amazon Data Firehose Delivery Stream instead of L1 Cfn Firehose Delivery Stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * import software.amazon.awscdk.services.events.targets.*;
 * IDeliveryStream deliveryStream;
 * RuleTargetInput ruleTargetInput;
 * KinesisFirehoseStreamV2 kinesisFirehoseStreamV2 = KinesisFirehoseStreamV2.Builder.create(deliveryStream)
 *         .message(ruleTargetInput)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:49.162Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.KinesisFirehoseStreamV2")
public class KinesisFirehoseStreamV2 extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected KinesisFirehoseStreamV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisFirehoseStreamV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisFirehoseStreamV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.IDeliveryStream stream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), props });
    }

    /**
     * @param stream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisFirehoseStreamV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.IDeliveryStream stream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamV2> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.events.targets.IDeliveryStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.events.targets.IDeliveryStream stream;
        private software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamProps.Builder props;

        private Builder(final software.amazon.awscdk.services.events.targets.IDeliveryStream stream) {
            this.stream = stream;
        }

        /**
         * The message to send to the stream.
         * <p>
         * Must be a valid JSON text passed to the target stream.
         * <p>
         * Default: - the entire Event Bridge event
         * <p>
         * @return {@code this}
         * @param message The message to send to the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(final software.amazon.awscdk.services.events.RuleTargetInput message) {
            this.props().message(message);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamV2 build() {
            return new software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamV2(
                this.stream,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.KinesisFirehoseStreamProps.Builder();
            }
            return this.props;
        }
    }
}
