package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnSchema</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnSchemaProps cfnSchemaProps = CfnSchemaProps.builder()
 *         .compatibility("compatibility")
 *         .dataFormat("dataFormat")
 *         .name("name")
 *         // the properties below are optional
 *         .checkpointVersion(SchemaVersionProperty.builder()
 *                 .isLatest(false)
 *                 .versionNumber(123)
 *                 .build())
 *         .description("description")
 *         .registry(RegistryProperty.builder()
 *                 .arn("arn")
 *                 .name("name")
 *                 .build())
 *         .schemaDefinition("schemaDefinition")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:49.865Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnSchemaProps")
@software.amazon.jsii.Jsii.Proxy(CfnSchemaProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSchemaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The compatibility mode of the schema.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-compatibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-compatibility</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCompatibility();

    /**
     * The data format of the schema definition.
     * <p>
     * Currently only <code>AVRO</code> is supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-dataformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-dataformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataFormat();

    /**
     * Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.
     * <p>
     * No whitespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specify the <code>VersionNumber</code> or the <code>IsLatest</code> for setting the checkpoint for the schema.
     * <p>
     * This is only required for updating a checkpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-checkpointversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-checkpointversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCheckpointVersion() {
        return null;
    }

    /**
     * A description of the schema if specified when created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The registry where a schema is stored.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-registry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-registry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRegistry() {
        return null;
    }

    /**
     * The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-schemadefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-schemadefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchemaDefinition() {
        return null;
    }

    /**
     * AWS tags that contain a key value pair and may be searched by console, command line, or API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSchemaProps> {
        java.lang.String compatibility;
        java.lang.String dataFormat;
        java.lang.String name;
        java.lang.Object checkpointVersion;
        java.lang.String description;
        java.lang.Object registry;
        java.lang.String schemaDefinition;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSchemaProps#getCompatibility}
         * @param compatibility The compatibility mode of the schema. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibility(java.lang.String compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getDataFormat}
         * @param dataFormat The data format of the schema definition. This parameter is required.
         *                   Currently only <code>AVRO</code> is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataFormat(java.lang.String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getName}
         * @param name Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark. This parameter is required.
         *             No whitespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getCheckpointVersion}
         * @param checkpointVersion Specify the <code>VersionNumber</code> or the <code>IsLatest</code> for setting the checkpoint for the schema.
         *                          This is only required for updating a checkpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder checkpointVersion(software.amazon.awscdk.IResolvable checkpointVersion) {
            this.checkpointVersion = checkpointVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getCheckpointVersion}
         * @param checkpointVersion Specify the <code>VersionNumber</code> or the <code>IsLatest</code> for setting the checkpoint for the schema.
         *                          This is only required for updating a checkpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder checkpointVersion(software.amazon.awscdk.services.glue.CfnSchema.SchemaVersionProperty checkpointVersion) {
            this.checkpointVersion = checkpointVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getDescription}
         * @param description A description of the schema if specified when created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getRegistry}
         * @param registry The registry where a schema is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registry(software.amazon.awscdk.IResolvable registry) {
            this.registry = registry;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getRegistry}
         * @param registry The registry where a schema is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registry(software.amazon.awscdk.services.glue.CfnSchema.RegistryProperty registry) {
            this.registry = registry;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getSchemaDefinition}
         * @param schemaDefinition The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaDefinition(java.lang.String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnSchemaProps#getTags}
         * @param tags AWS tags that contain a key value pair and may be searched by console, command line, or API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSchemaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSchemaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSchemaProps {
        private final java.lang.String compatibility;
        private final java.lang.String dataFormat;
        private final java.lang.String name;
        private final java.lang.Object checkpointVersion;
        private final java.lang.String description;
        private final java.lang.Object registry;
        private final java.lang.String schemaDefinition;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compatibility = software.amazon.jsii.Kernel.get(this, "compatibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataFormat = software.amazon.jsii.Kernel.get(this, "dataFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.checkpointVersion = software.amazon.jsii.Kernel.get(this, "checkpointVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.registry = software.amazon.jsii.Kernel.get(this, "registry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schemaDefinition = software.amazon.jsii.Kernel.get(this, "schemaDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compatibility = java.util.Objects.requireNonNull(builder.compatibility, "compatibility is required");
            this.dataFormat = java.util.Objects.requireNonNull(builder.dataFormat, "dataFormat is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.checkpointVersion = builder.checkpointVersion;
            this.description = builder.description;
            this.registry = builder.registry;
            this.schemaDefinition = builder.schemaDefinition;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCompatibility() {
            return this.compatibility;
        }

        @Override
        public final java.lang.String getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getCheckpointVersion() {
            return this.checkpointVersion;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getRegistry() {
            return this.registry;
        }

        @Override
        public final java.lang.String getSchemaDefinition() {
            return this.schemaDefinition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("compatibility", om.valueToTree(this.getCompatibility()));
            data.set("dataFormat", om.valueToTree(this.getDataFormat()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCheckpointVersion() != null) {
                data.set("checkpointVersion", om.valueToTree(this.getCheckpointVersion()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRegistry() != null) {
                data.set("registry", om.valueToTree(this.getRegistry()));
            }
            if (this.getSchemaDefinition() != null) {
                data.set("schemaDefinition", om.valueToTree(this.getSchemaDefinition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnSchemaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSchemaProps.Jsii$Proxy that = (CfnSchemaProps.Jsii$Proxy) o;

            if (!compatibility.equals(that.compatibility)) return false;
            if (!dataFormat.equals(that.dataFormat)) return false;
            if (!name.equals(that.name)) return false;
            if (this.checkpointVersion != null ? !this.checkpointVersion.equals(that.checkpointVersion) : that.checkpointVersion != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.registry != null ? !this.registry.equals(that.registry) : that.registry != null) return false;
            if (this.schemaDefinition != null ? !this.schemaDefinition.equals(that.schemaDefinition) : that.schemaDefinition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.compatibility.hashCode();
            result = 31 * result + (this.dataFormat.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.checkpointVersion != null ? this.checkpointVersion.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.registry != null ? this.registry.hashCode() : 0);
            result = 31 * result + (this.schemaDefinition != null ? this.schemaDefinition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
