package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a <code>CfnSubscriptionDefinitionVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnSubscriptionDefinitionVersionProps cfnSubscriptionDefinitionVersionProps = CfnSubscriptionDefinitionVersionProps.builder()
 *         .subscriptionDefinitionId("subscriptionDefinitionId")
 *         .subscriptions(List.of(SubscriptionProperty.builder()
 *                 .id("id")
 *                 .source("source")
 *                 .subject("subject")
 *                 .target("target")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:50.007Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnSubscriptionDefinitionVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriptionDefinitionVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriptionDefinitionVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the subscription definition associated with this version.
     * <p>
     * This value is a GUID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptiondefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptiondefinitionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriptionDefinitionId();

    /**
     * The subscriptions in this version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubscriptions();

    /**
     * @return a {@link Builder} of {@link CfnSubscriptionDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriptionDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriptionDefinitionVersionProps> {
        java.lang.String subscriptionDefinitionId;
        java.lang.Object subscriptions;

        /**
         * Sets the value of {@link CfnSubscriptionDefinitionVersionProps#getSubscriptionDefinitionId}
         * @param subscriptionDefinitionId The ID of the subscription definition associated with this version. This parameter is required.
         *                                 This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionDefinitionId(java.lang.String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionDefinitionVersionProps#getSubscriptions}
         * @param subscriptions The subscriptions in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptions(software.amazon.awscdk.IResolvable subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionDefinitionVersionProps#getSubscriptions}
         * @param subscriptions The subscriptions in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptions(java.util.List<? extends java.lang.Object> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriptionDefinitionVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriptionDefinitionVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubscriptionDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriptionDefinitionVersionProps {
        private final java.lang.String subscriptionDefinitionId;
        private final java.lang.Object subscriptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subscriptionDefinitionId = software.amazon.jsii.Kernel.get(this, "subscriptionDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptions = software.amazon.jsii.Kernel.get(this, "subscriptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subscriptionDefinitionId = java.util.Objects.requireNonNull(builder.subscriptionDefinitionId, "subscriptionDefinitionId is required");
            this.subscriptions = java.util.Objects.requireNonNull(builder.subscriptions, "subscriptions is required");
        }

        @Override
        public final java.lang.String getSubscriptionDefinitionId() {
            return this.subscriptionDefinitionId;
        }

        @Override
        public final java.lang.Object getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subscriptionDefinitionId", om.valueToTree(this.getSubscriptionDefinitionId()));
            data.set("subscriptions", om.valueToTree(this.getSubscriptions()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnSubscriptionDefinitionVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriptionDefinitionVersionProps.Jsii$Proxy that = (CfnSubscriptionDefinitionVersionProps.Jsii$Proxy) o;

            if (!subscriptionDefinitionId.equals(that.subscriptionDefinitionId)) return false;
            return this.subscriptions.equals(that.subscriptions);
        }

        @Override
        public final int hashCode() {
            int result = this.subscriptionDefinitionId.hashCode();
            result = 31 * result + (this.subscriptions.hashCode());
            return result;
        }
    }
}
