package software.amazon.awscdk.services.greengrassv2;

/**
 * Creates a component.
 * <p>
 * Components are software that run on AWS IoT Greengrass core devices. After you develop and test a component on your core device, you can use this operation to upload your component to AWS IoT Greengrass . Then, you can deploy the component to other core devices.
 * <p>
 * You can use this operation to do the following:
 * <p>
 * <ul>
 * <li><em>Create components from recipes</em></li>
 * </ul>
 * <p>
 * Create a component from a recipe, which is a file that defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">AWS IoT Greengrass component recipe reference</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
 * <p>
 * To create a component from a recipe, specify <code>inlineRecipe</code> when you call this operation.
 * <p>
 * <ul>
 * <li><em>Create components from Lambda functions</em></li>
 * </ul>
 * <p>
 * Create a component from an AWS Lambda function that runs on AWS IoT Greengrass . This creates a recipe and artifacts from the Lambda function's deployment package. You can use this operation to migrate Lambda functions from AWS IoT Greengrass V1 to AWS IoT Greengrass V2 .
 * <p>
 * This function accepts Lambda functions in all supported versions of Python, Node.js, and Java runtimes. AWS IoT Greengrass doesn't apply any additional restrictions on deprecated Lambda runtime versions.
 * <p>
 * To create a component from a Lambda function, specify <code>lambdaFunction</code> when you call this operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrassv2.*;
 * CfnComponentVersion cfnComponentVersion = CfnComponentVersion.Builder.create(this, "MyCfnComponentVersion")
 *         .inlineRecipe("inlineRecipe")
 *         .lambdaFunction(LambdaFunctionRecipeSourceProperty.builder()
 *                 .componentDependencies(Map.of(
 *                         "componentDependenciesKey", ComponentDependencyRequirementProperty.builder()
 *                                 .dependencyType("dependencyType")
 *                                 .versionRequirement("versionRequirement")
 *                                 .build()))
 *                 .componentLambdaParameters(LambdaExecutionParametersProperty.builder()
 *                         .environmentVariables(Map.of(
 *                                 "environmentVariablesKey", "environmentVariables"))
 *                         .eventSources(List.of(LambdaEventSourceProperty.builder()
 *                                 .topic("topic")
 *                                 .type("type")
 *                                 .build()))
 *                         .execArgs(List.of("execArgs"))
 *                         .inputPayloadEncodingType("inputPayloadEncodingType")
 *                         .linuxProcessParams(LambdaLinuxProcessParamsProperty.builder()
 *                                 .containerParams(LambdaContainerParamsProperty.builder()
 *                                         .devices(List.of(LambdaDeviceMountProperty.builder()
 *                                                 .addGroupOwner(false)
 *                                                 .path("path")
 *                                                 .permission("permission")
 *                                                 .build()))
 *                                         .memorySizeInKb(123)
 *                                         .mountRoSysfs(false)
 *                                         .volumes(List.of(LambdaVolumeMountProperty.builder()
 *                                                 .addGroupOwner(false)
 *                                                 .destinationPath("destinationPath")
 *                                                 .permission("permission")
 *                                                 .sourcePath("sourcePath")
 *                                                 .build()))
 *                                         .build())
 *                                 .isolationMode("isolationMode")
 *                                 .build())
 *                         .maxIdleTimeInSeconds(123)
 *                         .maxInstancesCount(123)
 *                         .maxQueueSize(123)
 *                         .pinned(false)
 *                         .statusTimeoutInSeconds(123)
 *                         .timeoutInSeconds(123)
 *                         .build())
 *                 .componentName("componentName")
 *                 .componentPlatforms(List.of(ComponentPlatformProperty.builder()
 *                         .attributes(Map.of(
 *                                 "attributesKey", "attributes"))
 *                         .name("name")
 *                         .build()))
 *                 .componentVersion("componentVersion")
 *                 .lambdaArn("lambdaArn")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:50.008Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion")
public class CfnComponentVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnComponentVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComponentVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComponentVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrassv2.CfnComponentVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComponentVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the component version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComponentName() {
        return software.amazon.jsii.Kernel.get(this, "attrComponentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComponentVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrComponentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The recipe to use to create the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInlineRecipe() {
        return software.amazon.jsii.Kernel.get(this, "inlineRecipe", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The recipe to use to create the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInlineRecipe(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inlineRecipe", value);
    }

    /**
     * The parameters to create a component from a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunction() {
        return software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters to create a component from a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaFunction(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lambdaFunction", value);
    }

    /**
     * The parameters to create a component from a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaFunction(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.LambdaFunctionRecipeSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "lambdaFunction", value);
    }

    /**
     * Application-specific metadata to attach to the component version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Application-specific metadata to attach to the component version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Contains information about a component dependency for a Lambda function component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * ComponentDependencyRequirementProperty componentDependencyRequirementProperty = ComponentDependencyRequirementProperty.builder()
     *         .dependencyType("dependencyType")
     *         .versionRequirement("versionRequirement")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.ComponentDependencyRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentDependencyRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentDependencyRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of this dependency. Choose from the following options:.
         * <p>
         * <ul>
         * <li><code>SOFT</code> – The component doesn't restart if the dependency changes state.</li>
         * <li><code>HARD</code> – The component restarts if the dependency changes state.</li>
         * </ul>
         * <p>
         * Default: <code>HARD</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-dependencytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-dependencytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDependencyType() {
            return null;
        }

        /**
         * The component version requirement for the component dependency.
         * <p>
         * AWS IoT Greengrass uses semantic version constraints. For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-versionrequirement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-versionrequirement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersionRequirement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentDependencyRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentDependencyRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentDependencyRequirementProperty> {
            java.lang.String dependencyType;
            java.lang.String versionRequirement;

            /**
             * Sets the value of {@link ComponentDependencyRequirementProperty#getDependencyType}
             * @param dependencyType The type of this dependency. Choose from the following options:.
             *                       <ul>
             *                       <li><code>SOFT</code> – The component doesn't restart if the dependency changes state.</li>
             *                       <li><code>HARD</code> – The component restarts if the dependency changes state.</li>
             *                       </ul>
             *                       <p>
             *                       Default: <code>HARD</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyType(java.lang.String dependencyType) {
                this.dependencyType = dependencyType;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDependencyRequirementProperty#getVersionRequirement}
             * @param versionRequirement The component version requirement for the component dependency.
             *                           AWS IoT Greengrass uses semantic version constraints. For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionRequirement(java.lang.String versionRequirement) {
                this.versionRequirement = versionRequirement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentDependencyRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentDependencyRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentDependencyRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentDependencyRequirementProperty {
            private final java.lang.String dependencyType;
            private final java.lang.String versionRequirement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dependencyType = software.amazon.jsii.Kernel.get(this, "dependencyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionRequirement = software.amazon.jsii.Kernel.get(this, "versionRequirement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dependencyType = builder.dependencyType;
                this.versionRequirement = builder.versionRequirement;
            }

            @Override
            public final java.lang.String getDependencyType() {
                return this.dependencyType;
            }

            @Override
            public final java.lang.String getVersionRequirement() {
                return this.versionRequirement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDependencyType() != null) {
                    data.set("dependencyType", om.valueToTree(this.getDependencyType()));
                }
                if (this.getVersionRequirement() != null) {
                    data.set("versionRequirement", om.valueToTree(this.getVersionRequirement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.ComponentDependencyRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentDependencyRequirementProperty.Jsii$Proxy that = (ComponentDependencyRequirementProperty.Jsii$Proxy) o;

                if (this.dependencyType != null ? !this.dependencyType.equals(that.dependencyType) : that.dependencyType != null) return false;
                return this.versionRequirement != null ? this.versionRequirement.equals(that.versionRequirement) : that.versionRequirement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dependencyType != null ? this.dependencyType.hashCode() : 0;
                result = 31 * result + (this.versionRequirement != null ? this.versionRequirement.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a platform that a component supports.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * ComponentPlatformProperty componentPlatformProperty = ComponentPlatformProperty.builder()
     *         .attributes(Map.of(
     *                 "attributesKey", "attributes"))
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.ComponentPlatformProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentPlatformProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentPlatformProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A dictionary of attributes for the platform.
         * <p>
         * The AWS IoT Greengrass Core software defines the <code>os</code> and <code>platform</code> by default. You can specify additional platform attributes for a core device when you deploy the AWS IoT Greengrass nucleus component. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">AWS IoT Greengrass nucleus component</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-attributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The friendly name of the platform. This name helps you identify the platform.
         * <p>
         * If you omit this parameter, AWS IoT Greengrass creates a friendly name from the <code>os</code> and <code>architecture</code> of the platform.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentPlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentPlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentPlatformProperty> {
            java.lang.Object attributes;
            java.lang.String name;

            /**
             * Sets the value of {@link ComponentPlatformProperty#getAttributes}
             * @param attributes A dictionary of attributes for the platform.
             *                   The AWS IoT Greengrass Core software defines the <code>os</code> and <code>platform</code> by default. You can specify additional platform attributes for a core device when you deploy the AWS IoT Greengrass nucleus component. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">AWS IoT Greengrass nucleus component</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPlatformProperty#getAttributes}
             * @param attributes A dictionary of attributes for the platform.
             *                   The AWS IoT Greengrass Core software defines the <code>os</code> and <code>platform</code> by default. You can specify additional platform attributes for a core device when you deploy the AWS IoT Greengrass nucleus component. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">AWS IoT Greengrass nucleus component</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPlatformProperty#getName}
             * @param name The friendly name of the platform. This name helps you identify the platform.
             *             If you omit this parameter, AWS IoT Greengrass creates a friendly name from the <code>os</code> and <code>architecture</code> of the platform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentPlatformProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentPlatformProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentPlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentPlatformProperty {
            private final java.lang.Object attributes;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = builder.attributes;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.ComponentPlatformProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentPlatformProperty.Jsii$Proxy that = (ComponentPlatformProperty.Jsii$Proxy) o;

                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes != null ? this.attributes.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a container in which AWS Lambda functions run on AWS IoT Greengrass core devices.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaContainerParamsProperty lambdaContainerParamsProperty = LambdaContainerParamsProperty.builder()
     *         .devices(List.of(LambdaDeviceMountProperty.builder()
     *                 .addGroupOwner(false)
     *                 .path("path")
     *                 .permission("permission")
     *                 .build()))
     *         .memorySizeInKb(123)
     *         .mountRoSysfs(false)
     *         .volumes(List.of(LambdaVolumeMountProperty.builder()
     *                 .addGroupOwner(false)
     *                 .destinationPath("destinationPath")
     *                 .permission("permission")
     *                 .sourcePath("sourcePath")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaContainerParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaContainerParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaContainerParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of system devices that the container can access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-devices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDevices() {
            return null;
        }

        /**
         * The memory size of the container, expressed in kilobytes.
         * <p>
         * Default: <code>16384</code> (16 MB)
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-memorysizeinkb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-memorysizeinkb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySizeInKb() {
            return null;
        }

        /**
         * Whether or not the container can read information from the device's <code>/sys</code> folder.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-mountrosysfs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-mountrosysfs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountRoSysfs() {
            return null;
        }

        /**
         * The list of volumes that the container can access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-volumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaContainerParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaContainerParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaContainerParamsProperty> {
            java.lang.Object devices;
            java.lang.Number memorySizeInKb;
            java.lang.Object mountRoSysfs;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getDevices}
             * @param devices The list of system devices that the container can access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(software.amazon.awscdk.IResolvable devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getDevices}
             * @param devices The list of system devices that the container can access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(java.util.List<? extends java.lang.Object> devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getMemorySizeInKb}
             * @param memorySizeInKb The memory size of the container, expressed in kilobytes.
             *                       Default: <code>16384</code> (16 MB)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memorySizeInKb(java.lang.Number memorySizeInKb) {
                this.memorySizeInKb = memorySizeInKb;
                return this;
            }

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getMountRoSysfs}
             * @param mountRoSysfs Whether or not the container can read information from the device's <code>/sys</code> folder.
             *                     Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountRoSysfs(java.lang.Boolean mountRoSysfs) {
                this.mountRoSysfs = mountRoSysfs;
                return this;
            }

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getMountRoSysfs}
             * @param mountRoSysfs Whether or not the container can read information from the device's <code>/sys</code> folder.
             *                     Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountRoSysfs(software.amazon.awscdk.IResolvable mountRoSysfs) {
                this.mountRoSysfs = mountRoSysfs;
                return this;
            }

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getVolumes}
             * @param volumes The list of volumes that the container can access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link LambdaContainerParamsProperty#getVolumes}
             * @param volumes The list of volumes that the container can access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaContainerParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaContainerParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaContainerParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaContainerParamsProperty {
            private final java.lang.Object devices;
            private final java.lang.Number memorySizeInKb;
            private final java.lang.Object mountRoSysfs;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.devices = software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memorySizeInKb = software.amazon.jsii.Kernel.get(this, "memorySizeInKb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountRoSysfs = software.amazon.jsii.Kernel.get(this, "mountRoSysfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.devices = builder.devices;
                this.memorySizeInKb = builder.memorySizeInKb;
                this.mountRoSysfs = builder.mountRoSysfs;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.Object getDevices() {
                return this.devices;
            }

            @Override
            public final java.lang.Number getMemorySizeInKb() {
                return this.memorySizeInKb;
            }

            @Override
            public final java.lang.Object getMountRoSysfs() {
                return this.mountRoSysfs;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDevices() != null) {
                    data.set("devices", om.valueToTree(this.getDevices()));
                }
                if (this.getMemorySizeInKb() != null) {
                    data.set("memorySizeInKb", om.valueToTree(this.getMemorySizeInKb()));
                }
                if (this.getMountRoSysfs() != null) {
                    data.set("mountRoSysfs", om.valueToTree(this.getMountRoSysfs()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaContainerParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaContainerParamsProperty.Jsii$Proxy that = (LambdaContainerParamsProperty.Jsii$Proxy) o;

                if (this.devices != null ? !this.devices.equals(that.devices) : that.devices != null) return false;
                if (this.memorySizeInKb != null ? !this.memorySizeInKb.equals(that.memorySizeInKb) : that.memorySizeInKb != null) return false;
                if (this.mountRoSysfs != null ? !this.mountRoSysfs.equals(that.mountRoSysfs) : that.mountRoSysfs != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.devices != null ? this.devices.hashCode() : 0;
                result = 31 * result + (this.memorySizeInKb != null ? this.memorySizeInKb.hashCode() : 0);
                result = 31 * result + (this.mountRoSysfs != null ? this.mountRoSysfs.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a device that Linux processes in a container can access.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaDeviceMountProperty lambdaDeviceMountProperty = LambdaDeviceMountProperty.builder()
     *         .addGroupOwner(false)
     *         .path("path")
     *         .permission("permission")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaDeviceMountProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaDeviceMountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaDeviceMountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether or not to add the component's system user as an owner of the device.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-addgroupowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-addgroupowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddGroupOwner() {
            return null;
        }

        /**
         * The mount path for the device in the file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The permission to access the device: read/only ( <code>ro</code> ) or read/write ( <code>rw</code> ).
         * <p>
         * Default: <code>ro</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-permission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-permission</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPermission() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaDeviceMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaDeviceMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaDeviceMountProperty> {
            java.lang.Object addGroupOwner;
            java.lang.String path;
            java.lang.String permission;

            /**
             * Sets the value of {@link LambdaDeviceMountProperty#getAddGroupOwner}
             * @param addGroupOwner Whether or not to add the component's system user as an owner of the device.
             *                      Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addGroupOwner(java.lang.Boolean addGroupOwner) {
                this.addGroupOwner = addGroupOwner;
                return this;
            }

            /**
             * Sets the value of {@link LambdaDeviceMountProperty#getAddGroupOwner}
             * @param addGroupOwner Whether or not to add the component's system user as an owner of the device.
             *                      Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addGroupOwner(software.amazon.awscdk.IResolvable addGroupOwner) {
                this.addGroupOwner = addGroupOwner;
                return this;
            }

            /**
             * Sets the value of {@link LambdaDeviceMountProperty#getPath}
             * @param path The mount path for the device in the file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link LambdaDeviceMountProperty#getPermission}
             * @param permission The permission to access the device: read/only ( <code>ro</code> ) or read/write ( <code>rw</code> ).
             *                   Default: <code>ro</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permission(java.lang.String permission) {
                this.permission = permission;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaDeviceMountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaDeviceMountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaDeviceMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaDeviceMountProperty {
            private final java.lang.Object addGroupOwner;
            private final java.lang.String path;
            private final java.lang.String permission;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addGroupOwner = software.amazon.jsii.Kernel.get(this, "addGroupOwner", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permission = software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addGroupOwner = builder.addGroupOwner;
                this.path = builder.path;
                this.permission = builder.permission;
            }

            @Override
            public final java.lang.Object getAddGroupOwner() {
                return this.addGroupOwner;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getPermission() {
                return this.permission;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddGroupOwner() != null) {
                    data.set("addGroupOwner", om.valueToTree(this.getAddGroupOwner()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPermission() != null) {
                    data.set("permission", om.valueToTree(this.getPermission()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaDeviceMountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaDeviceMountProperty.Jsii$Proxy that = (LambdaDeviceMountProperty.Jsii$Proxy) o;

                if (this.addGroupOwner != null ? !this.addGroupOwner.equals(that.addGroupOwner) : that.addGroupOwner != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                return this.permission != null ? this.permission.equals(that.permission) : that.permission == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addGroupOwner != null ? this.addGroupOwner.hashCode() : 0;
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about an event source for an AWS Lambda function.
     * <p>
     * The event source defines the topics on which this Lambda function subscribes to receive messages that run the function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaEventSourceProperty lambdaEventSourceProperty = LambdaEventSourceProperty.builder()
     *         .topic("topic")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaEventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaEventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaEventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The topic to which to subscribe to receive event messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-topic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-topic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopic() {
            return null;
        }

        /**
         * The type of event source. Choose from the following options:.
         * <p>
         * <ul>
         * <li><code>PUB_SUB</code> – Subscribe to local publish/subscribe messages. This event source type doesn't support MQTT wildcards ( <code>+</code> and <code>#</code> ) in the event source topic.</li>
         * <li><code>IOT_CORE</code> – Subscribe to AWS IoT Core MQTT messages. This event source type supports MQTT wildcards ( <code>+</code> and <code>#</code> ) in the event source topic.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaEventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaEventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaEventSourceProperty> {
            java.lang.String topic;
            java.lang.String type;

            /**
             * Sets the value of {@link LambdaEventSourceProperty#getTopic}
             * @param topic The topic to which to subscribe to receive event messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Sets the value of {@link LambdaEventSourceProperty#getType}
             * @param type The type of event source. Choose from the following options:.
             *             <ul>
             *             <li><code>PUB_SUB</code> – Subscribe to local publish/subscribe messages. This event source type doesn't support MQTT wildcards ( <code>+</code> and <code>#</code> ) in the event source topic.</li>
             *             <li><code>IOT_CORE</code> – Subscribe to AWS IoT Core MQTT messages. This event source type supports MQTT wildcards ( <code>+</code> and <code>#</code> ) in the event source topic.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaEventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaEventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaEventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaEventSourceProperty {
            private final java.lang.String topic;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topic = builder.topic;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTopic() != null) {
                    data.set("topic", om.valueToTree(this.getTopic()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaEventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaEventSourceProperty.Jsii$Proxy that = (LambdaEventSourceProperty.Jsii$Proxy) o;

                if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.topic != null ? this.topic.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains parameters for a Lambda function that runs on AWS IoT Greengrass .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaExecutionParametersProperty lambdaExecutionParametersProperty = LambdaExecutionParametersProperty.builder()
     *         .environmentVariables(Map.of(
     *                 "environmentVariablesKey", "environmentVariables"))
     *         .eventSources(List.of(LambdaEventSourceProperty.builder()
     *                 .topic("topic")
     *                 .type("type")
     *                 .build()))
     *         .execArgs(List.of("execArgs"))
     *         .inputPayloadEncodingType("inputPayloadEncodingType")
     *         .linuxProcessParams(LambdaLinuxProcessParamsProperty.builder()
     *                 .containerParams(LambdaContainerParamsProperty.builder()
     *                         .devices(List.of(LambdaDeviceMountProperty.builder()
     *                                 .addGroupOwner(false)
     *                                 .path("path")
     *                                 .permission("permission")
     *                                 .build()))
     *                         .memorySizeInKb(123)
     *                         .mountRoSysfs(false)
     *                         .volumes(List.of(LambdaVolumeMountProperty.builder()
     *                                 .addGroupOwner(false)
     *                                 .destinationPath("destinationPath")
     *                                 .permission("permission")
     *                                 .sourcePath("sourcePath")
     *                                 .build()))
     *                         .build())
     *                 .isolationMode("isolationMode")
     *                 .build())
     *         .maxIdleTimeInSeconds(123)
     *         .maxInstancesCount(123)
     *         .maxQueueSize(123)
     *         .pinned(false)
     *         .statusTimeoutInSeconds(123)
     *         .timeoutInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaExecutionParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaExecutionParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaExecutionParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The map of environment variables that are available to the Lambda function when it runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-environmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * The list of event sources to which to subscribe to receive work messages.
         * <p>
         * The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and AWS IoT Core MQTT messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-eventsources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-eventsources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventSources() {
            return null;
        }

        /**
         * The list of arguments to pass to the Lambda function when it runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-execargs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-execargs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExecArgs() {
            return null;
        }

        /**
         * The encoding type that the Lambda function supports.
         * <p>
         * Default: <code>json</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-inputpayloadencodingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-inputpayloadencodingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPayloadEncodingType() {
            return null;
        }

        /**
         * The parameters for the Linux process that contains the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-linuxprocessparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-linuxprocessparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinuxProcessParams() {
            return null;
        }

        /**
         * The maximum amount of time in seconds that a non-pinned Lambda function can idle before the AWS IoT Greengrass Core software stops its process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxidletimeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxidletimeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxIdleTimeInSeconds() {
            return null;
        }

        /**
         * The maximum number of instances that a non-pinned Lambda function can run at the same time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxinstancescount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxinstancescount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxInstancesCount() {
            return null;
        }

        /**
         * The maximum size of the message queue for the Lambda function component.
         * <p>
         * The AWS IoT Greengrass core device stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxqueuesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxqueuesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxQueueSize() {
            return null;
        }

        /**
         * Whether or not the Lambda function is pinned, or long-lived.
         * <p>
         * <ul>
         * <li>A pinned Lambda function starts when the AWS IoT Greengrass Core starts and keeps running in its own container.</li>
         * <li>A non-pinned Lambda function starts only when it receives a work item and exists after it idles for <code>maxIdleTimeInSeconds</code> . If the function has multiple work items, the AWS IoT Greengrass Core software creates multiple instances of the function.</li>
         * </ul>
         * <p>
         * Default: <code>true</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-pinned">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-pinned</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPinned() {
            return null;
        }

        /**
         * The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-statustimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-statustimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStatusTimeoutInSeconds() {
            return null;
        }

        /**
         * The maximum amount of time in seconds that the Lambda function can process a work item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-timeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-timeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaExecutionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaExecutionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaExecutionParametersProperty> {
            java.lang.Object environmentVariables;
            java.lang.Object eventSources;
            java.util.List<java.lang.String> execArgs;
            java.lang.String inputPayloadEncodingType;
            java.lang.Object linuxProcessParams;
            java.lang.Number maxIdleTimeInSeconds;
            java.lang.Number maxInstancesCount;
            java.lang.Number maxQueueSize;
            java.lang.Object pinned;
            java.lang.Number statusTimeoutInSeconds;
            java.lang.Number timeoutInSeconds;

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getEnvironmentVariables}
             * @param environmentVariables The map of environment variables that are available to the Lambda function when it runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getEnvironmentVariables}
             * @param environmentVariables The map of environment variables that are available to the Lambda function when it runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getEventSources}
             * @param eventSources The list of event sources to which to subscribe to receive work messages.
             *                     The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and AWS IoT Core MQTT messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSources(software.amazon.awscdk.IResolvable eventSources) {
                this.eventSources = eventSources;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getEventSources}
             * @param eventSources The list of event sources to which to subscribe to receive work messages.
             *                     The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and AWS IoT Core MQTT messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSources(java.util.List<? extends java.lang.Object> eventSources) {
                this.eventSources = eventSources;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getExecArgs}
             * @param execArgs The list of arguments to pass to the Lambda function when it runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execArgs(java.util.List<java.lang.String> execArgs) {
                this.execArgs = execArgs;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getInputPayloadEncodingType}
             * @param inputPayloadEncodingType The encoding type that the Lambda function supports.
             *                                 Default: <code>json</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPayloadEncodingType(java.lang.String inputPayloadEncodingType) {
                this.inputPayloadEncodingType = inputPayloadEncodingType;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getLinuxProcessParams}
             * @param linuxProcessParams The parameters for the Linux process that contains the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxProcessParams(software.amazon.awscdk.IResolvable linuxProcessParams) {
                this.linuxProcessParams = linuxProcessParams;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getLinuxProcessParams}
             * @param linuxProcessParams The parameters for the Linux process that contains the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxProcessParams(software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.LambdaLinuxProcessParamsProperty linuxProcessParams) {
                this.linuxProcessParams = linuxProcessParams;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getMaxIdleTimeInSeconds}
             * @param maxIdleTimeInSeconds The maximum amount of time in seconds that a non-pinned Lambda function can idle before the AWS IoT Greengrass Core software stops its process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxIdleTimeInSeconds(java.lang.Number maxIdleTimeInSeconds) {
                this.maxIdleTimeInSeconds = maxIdleTimeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getMaxInstancesCount}
             * @param maxInstancesCount The maximum number of instances that a non-pinned Lambda function can run at the same time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxInstancesCount(java.lang.Number maxInstancesCount) {
                this.maxInstancesCount = maxInstancesCount;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getMaxQueueSize}
             * @param maxQueueSize The maximum size of the message queue for the Lambda function component.
             *                     The AWS IoT Greengrass core device stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxQueueSize(java.lang.Number maxQueueSize) {
                this.maxQueueSize = maxQueueSize;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getPinned}
             * @param pinned Whether or not the Lambda function is pinned, or long-lived.
             *               <ul>
             *               <li>A pinned Lambda function starts when the AWS IoT Greengrass Core starts and keeps running in its own container.</li>
             *               <li>A non-pinned Lambda function starts only when it receives a work item and exists after it idles for <code>maxIdleTimeInSeconds</code> . If the function has multiple work items, the AWS IoT Greengrass Core software creates multiple instances of the function.</li>
             *               </ul>
             *               <p>
             *               Default: <code>true</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pinned(java.lang.Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getPinned}
             * @param pinned Whether or not the Lambda function is pinned, or long-lived.
             *               <ul>
             *               <li>A pinned Lambda function starts when the AWS IoT Greengrass Core starts and keeps running in its own container.</li>
             *               <li>A non-pinned Lambda function starts only when it receives a work item and exists after it idles for <code>maxIdleTimeInSeconds</code> . If the function has multiple work items, the AWS IoT Greengrass Core software creates multiple instances of the function.</li>
             *               </ul>
             *               <p>
             *               Default: <code>true</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pinned(software.amazon.awscdk.IResolvable pinned) {
                this.pinned = pinned;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getStatusTimeoutInSeconds}
             * @param statusTimeoutInSeconds The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusTimeoutInSeconds(java.lang.Number statusTimeoutInSeconds) {
                this.statusTimeoutInSeconds = statusTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LambdaExecutionParametersProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds The maximum amount of time in seconds that the Lambda function can process a work item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaExecutionParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaExecutionParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaExecutionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaExecutionParametersProperty {
            private final java.lang.Object environmentVariables;
            private final java.lang.Object eventSources;
            private final java.util.List<java.lang.String> execArgs;
            private final java.lang.String inputPayloadEncodingType;
            private final java.lang.Object linuxProcessParams;
            private final java.lang.Number maxIdleTimeInSeconds;
            private final java.lang.Number maxInstancesCount;
            private final java.lang.Number maxQueueSize;
            private final java.lang.Object pinned;
            private final java.lang.Number statusTimeoutInSeconds;
            private final java.lang.Number timeoutInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventSources = software.amazon.jsii.Kernel.get(this, "eventSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.execArgs = software.amazon.jsii.Kernel.get(this, "execArgs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inputPayloadEncodingType = software.amazon.jsii.Kernel.get(this, "inputPayloadEncodingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.linuxProcessParams = software.amazon.jsii.Kernel.get(this, "linuxProcessParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxIdleTimeInSeconds = software.amazon.jsii.Kernel.get(this, "maxIdleTimeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxInstancesCount = software.amazon.jsii.Kernel.get(this, "maxInstancesCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxQueueSize = software.amazon.jsii.Kernel.get(this, "maxQueueSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pinned = software.amazon.jsii.Kernel.get(this, "pinned", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statusTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "statusTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.environmentVariables = builder.environmentVariables;
                this.eventSources = builder.eventSources;
                this.execArgs = builder.execArgs;
                this.inputPayloadEncodingType = builder.inputPayloadEncodingType;
                this.linuxProcessParams = builder.linuxProcessParams;
                this.maxIdleTimeInSeconds = builder.maxIdleTimeInSeconds;
                this.maxInstancesCount = builder.maxInstancesCount;
                this.maxQueueSize = builder.maxQueueSize;
                this.pinned = builder.pinned;
                this.statusTimeoutInSeconds = builder.statusTimeoutInSeconds;
                this.timeoutInSeconds = builder.timeoutInSeconds;
            }

            @Override
            public final java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public final java.lang.Object getEventSources() {
                return this.eventSources;
            }

            @Override
            public final java.util.List<java.lang.String> getExecArgs() {
                return this.execArgs;
            }

            @Override
            public final java.lang.String getInputPayloadEncodingType() {
                return this.inputPayloadEncodingType;
            }

            @Override
            public final java.lang.Object getLinuxProcessParams() {
                return this.linuxProcessParams;
            }

            @Override
            public final java.lang.Number getMaxIdleTimeInSeconds() {
                return this.maxIdleTimeInSeconds;
            }

            @Override
            public final java.lang.Number getMaxInstancesCount() {
                return this.maxInstancesCount;
            }

            @Override
            public final java.lang.Number getMaxQueueSize() {
                return this.maxQueueSize;
            }

            @Override
            public final java.lang.Object getPinned() {
                return this.pinned;
            }

            @Override
            public final java.lang.Number getStatusTimeoutInSeconds() {
                return this.statusTimeoutInSeconds;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getEventSources() != null) {
                    data.set("eventSources", om.valueToTree(this.getEventSources()));
                }
                if (this.getExecArgs() != null) {
                    data.set("execArgs", om.valueToTree(this.getExecArgs()));
                }
                if (this.getInputPayloadEncodingType() != null) {
                    data.set("inputPayloadEncodingType", om.valueToTree(this.getInputPayloadEncodingType()));
                }
                if (this.getLinuxProcessParams() != null) {
                    data.set("linuxProcessParams", om.valueToTree(this.getLinuxProcessParams()));
                }
                if (this.getMaxIdleTimeInSeconds() != null) {
                    data.set("maxIdleTimeInSeconds", om.valueToTree(this.getMaxIdleTimeInSeconds()));
                }
                if (this.getMaxInstancesCount() != null) {
                    data.set("maxInstancesCount", om.valueToTree(this.getMaxInstancesCount()));
                }
                if (this.getMaxQueueSize() != null) {
                    data.set("maxQueueSize", om.valueToTree(this.getMaxQueueSize()));
                }
                if (this.getPinned() != null) {
                    data.set("pinned", om.valueToTree(this.getPinned()));
                }
                if (this.getStatusTimeoutInSeconds() != null) {
                    data.set("statusTimeoutInSeconds", om.valueToTree(this.getStatusTimeoutInSeconds()));
                }
                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaExecutionParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaExecutionParametersProperty.Jsii$Proxy that = (LambdaExecutionParametersProperty.Jsii$Proxy) o;

                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.eventSources != null ? !this.eventSources.equals(that.eventSources) : that.eventSources != null) return false;
                if (this.execArgs != null ? !this.execArgs.equals(that.execArgs) : that.execArgs != null) return false;
                if (this.inputPayloadEncodingType != null ? !this.inputPayloadEncodingType.equals(that.inputPayloadEncodingType) : that.inputPayloadEncodingType != null) return false;
                if (this.linuxProcessParams != null ? !this.linuxProcessParams.equals(that.linuxProcessParams) : that.linuxProcessParams != null) return false;
                if (this.maxIdleTimeInSeconds != null ? !this.maxIdleTimeInSeconds.equals(that.maxIdleTimeInSeconds) : that.maxIdleTimeInSeconds != null) return false;
                if (this.maxInstancesCount != null ? !this.maxInstancesCount.equals(that.maxInstancesCount) : that.maxInstancesCount != null) return false;
                if (this.maxQueueSize != null ? !this.maxQueueSize.equals(that.maxQueueSize) : that.maxQueueSize != null) return false;
                if (this.pinned != null ? !this.pinned.equals(that.pinned) : that.pinned != null) return false;
                if (this.statusTimeoutInSeconds != null ? !this.statusTimeoutInSeconds.equals(that.statusTimeoutInSeconds) : that.statusTimeoutInSeconds != null) return false;
                return this.timeoutInSeconds != null ? this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.environmentVariables != null ? this.environmentVariables.hashCode() : 0;
                result = 31 * result + (this.eventSources != null ? this.eventSources.hashCode() : 0);
                result = 31 * result + (this.execArgs != null ? this.execArgs.hashCode() : 0);
                result = 31 * result + (this.inputPayloadEncodingType != null ? this.inputPayloadEncodingType.hashCode() : 0);
                result = 31 * result + (this.linuxProcessParams != null ? this.linuxProcessParams.hashCode() : 0);
                result = 31 * result + (this.maxIdleTimeInSeconds != null ? this.maxIdleTimeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maxInstancesCount != null ? this.maxInstancesCount.hashCode() : 0);
                result = 31 * result + (this.maxQueueSize != null ? this.maxQueueSize.hashCode() : 0);
                result = 31 * result + (this.pinned != null ? this.pinned.hashCode() : 0);
                result = 31 * result + (this.statusTimeoutInSeconds != null ? this.statusTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about an AWS Lambda function to import to create a component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaFunctionRecipeSourceProperty lambdaFunctionRecipeSourceProperty = LambdaFunctionRecipeSourceProperty.builder()
     *         .componentDependencies(Map.of(
     *                 "componentDependenciesKey", ComponentDependencyRequirementProperty.builder()
     *                         .dependencyType("dependencyType")
     *                         .versionRequirement("versionRequirement")
     *                         .build()))
     *         .componentLambdaParameters(LambdaExecutionParametersProperty.builder()
     *                 .environmentVariables(Map.of(
     *                         "environmentVariablesKey", "environmentVariables"))
     *                 .eventSources(List.of(LambdaEventSourceProperty.builder()
     *                         .topic("topic")
     *                         .type("type")
     *                         .build()))
     *                 .execArgs(List.of("execArgs"))
     *                 .inputPayloadEncodingType("inputPayloadEncodingType")
     *                 .linuxProcessParams(LambdaLinuxProcessParamsProperty.builder()
     *                         .containerParams(LambdaContainerParamsProperty.builder()
     *                                 .devices(List.of(LambdaDeviceMountProperty.builder()
     *                                         .addGroupOwner(false)
     *                                         .path("path")
     *                                         .permission("permission")
     *                                         .build()))
     *                                 .memorySizeInKb(123)
     *                                 .mountRoSysfs(false)
     *                                 .volumes(List.of(LambdaVolumeMountProperty.builder()
     *                                         .addGroupOwner(false)
     *                                         .destinationPath("destinationPath")
     *                                         .permission("permission")
     *                                         .sourcePath("sourcePath")
     *                                         .build()))
     *                                 .build())
     *                         .isolationMode("isolationMode")
     *                         .build())
     *                 .maxIdleTimeInSeconds(123)
     *                 .maxInstancesCount(123)
     *                 .maxQueueSize(123)
     *                 .pinned(false)
     *                 .statusTimeoutInSeconds(123)
     *                 .timeoutInSeconds(123)
     *                 .build())
     *         .componentName("componentName")
     *         .componentPlatforms(List.of(ComponentPlatformProperty.builder()
     *                 .attributes(Map.of(
     *                         "attributesKey", "attributes"))
     *                 .name("name")
     *                 .build()))
     *         .componentVersion("componentVersion")
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaFunctionRecipeSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionRecipeSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionRecipeSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component versions on which this Lambda function component depends.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentdependencies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentdependencies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponentDependencies() {
            return null;
        }

        /**
         * The system and runtime parameters for the Lambda function as it runs on the AWS IoT Greengrass core device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentlambdaparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentlambdaparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponentLambdaParameters() {
            return null;
        }

        /**
         * The name of the component.
         * <p>
         * Defaults to the name of the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentName() {
            return null;
        }

        /**
         * The platforms that the component version supports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentplatforms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentplatforms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponentPlatforms() {
            return null;
        }

        /**
         * The version of the component.
         * <p>
         * Defaults to the version of the Lambda function as a semantic version. For example, if your function version is <code>3</code> , the component version becomes <code>3.0.0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentVersion() {
            return null;
        }

        /**
         * The ARN of the Lambda function.
         * <p>
         * The ARN must include the version of the function to import. You can't use version aliases like <code>$LATEST</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaFunctionRecipeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionRecipeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionRecipeSourceProperty> {
            java.lang.Object componentDependencies;
            java.lang.Object componentLambdaParameters;
            java.lang.String componentName;
            java.lang.Object componentPlatforms;
            java.lang.String componentVersion;
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentDependencies}
             * @param componentDependencies The component versions on which this Lambda function component depends.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentDependencies(software.amazon.awscdk.IResolvable componentDependencies) {
                this.componentDependencies = componentDependencies;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentDependencies}
             * @param componentDependencies The component versions on which this Lambda function component depends.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentDependencies(java.util.Map<java.lang.String, ? extends java.lang.Object> componentDependencies) {
                this.componentDependencies = componentDependencies;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentLambdaParameters}
             * @param componentLambdaParameters The system and runtime parameters for the Lambda function as it runs on the AWS IoT Greengrass core device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentLambdaParameters(software.amazon.awscdk.IResolvable componentLambdaParameters) {
                this.componentLambdaParameters = componentLambdaParameters;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentLambdaParameters}
             * @param componentLambdaParameters The system and runtime parameters for the Lambda function as it runs on the AWS IoT Greengrass core device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentLambdaParameters(software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.LambdaExecutionParametersProperty componentLambdaParameters) {
                this.componentLambdaParameters = componentLambdaParameters;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentName}
             * @param componentName The name of the component.
             *                      Defaults to the name of the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentPlatforms}
             * @param componentPlatforms The platforms that the component version supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentPlatforms(software.amazon.awscdk.IResolvable componentPlatforms) {
                this.componentPlatforms = componentPlatforms;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentPlatforms}
             * @param componentPlatforms The platforms that the component version supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentPlatforms(java.util.List<? extends java.lang.Object> componentPlatforms) {
                this.componentPlatforms = componentPlatforms;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getComponentVersion}
             * @param componentVersion The version of the component.
             *                         Defaults to the version of the Lambda function as a semantic version. For example, if your function version is <code>3</code> , the component version becomes <code>3.0.0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentVersion(java.lang.String componentVersion) {
                this.componentVersion = componentVersion;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionRecipeSourceProperty#getLambdaArn}
             * @param lambdaArn The ARN of the Lambda function.
             *                  The ARN must include the version of the function to import. You can't use version aliases like <code>$LATEST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionRecipeSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionRecipeSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionRecipeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionRecipeSourceProperty {
            private final java.lang.Object componentDependencies;
            private final java.lang.Object componentLambdaParameters;
            private final java.lang.String componentName;
            private final java.lang.Object componentPlatforms;
            private final java.lang.String componentVersion;
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentDependencies = software.amazon.jsii.Kernel.get(this, "componentDependencies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentLambdaParameters = software.amazon.jsii.Kernel.get(this, "componentLambdaParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentPlatforms = software.amazon.jsii.Kernel.get(this, "componentPlatforms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentVersion = software.amazon.jsii.Kernel.get(this, "componentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentDependencies = builder.componentDependencies;
                this.componentLambdaParameters = builder.componentLambdaParameters;
                this.componentName = builder.componentName;
                this.componentPlatforms = builder.componentPlatforms;
                this.componentVersion = builder.componentVersion;
                this.lambdaArn = builder.lambdaArn;
            }

            @Override
            public final java.lang.Object getComponentDependencies() {
                return this.componentDependencies;
            }

            @Override
            public final java.lang.Object getComponentLambdaParameters() {
                return this.componentLambdaParameters;
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.lang.Object getComponentPlatforms() {
                return this.componentPlatforms;
            }

            @Override
            public final java.lang.String getComponentVersion() {
                return this.componentVersion;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentDependencies() != null) {
                    data.set("componentDependencies", om.valueToTree(this.getComponentDependencies()));
                }
                if (this.getComponentLambdaParameters() != null) {
                    data.set("componentLambdaParameters", om.valueToTree(this.getComponentLambdaParameters()));
                }
                if (this.getComponentName() != null) {
                    data.set("componentName", om.valueToTree(this.getComponentName()));
                }
                if (this.getComponentPlatforms() != null) {
                    data.set("componentPlatforms", om.valueToTree(this.getComponentPlatforms()));
                }
                if (this.getComponentVersion() != null) {
                    data.set("componentVersion", om.valueToTree(this.getComponentVersion()));
                }
                if (this.getLambdaArn() != null) {
                    data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaFunctionRecipeSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionRecipeSourceProperty.Jsii$Proxy that = (LambdaFunctionRecipeSourceProperty.Jsii$Proxy) o;

                if (this.componentDependencies != null ? !this.componentDependencies.equals(that.componentDependencies) : that.componentDependencies != null) return false;
                if (this.componentLambdaParameters != null ? !this.componentLambdaParameters.equals(that.componentLambdaParameters) : that.componentLambdaParameters != null) return false;
                if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) return false;
                if (this.componentPlatforms != null ? !this.componentPlatforms.equals(that.componentPlatforms) : that.componentPlatforms != null) return false;
                if (this.componentVersion != null ? !this.componentVersion.equals(that.componentVersion) : that.componentVersion != null) return false;
                return this.lambdaArn != null ? this.lambdaArn.equals(that.lambdaArn) : that.lambdaArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentDependencies != null ? this.componentDependencies.hashCode() : 0;
                result = 31 * result + (this.componentLambdaParameters != null ? this.componentLambdaParameters.hashCode() : 0);
                result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
                result = 31 * result + (this.componentPlatforms != null ? this.componentPlatforms.hashCode() : 0);
                result = 31 * result + (this.componentVersion != null ? this.componentVersion.hashCode() : 0);
                result = 31 * result + (this.lambdaArn != null ? this.lambdaArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains parameters for a Linux process that contains an AWS Lambda function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaLinuxProcessParamsProperty lambdaLinuxProcessParamsProperty = LambdaLinuxProcessParamsProperty.builder()
     *         .containerParams(LambdaContainerParamsProperty.builder()
     *                 .devices(List.of(LambdaDeviceMountProperty.builder()
     *                         .addGroupOwner(false)
     *                         .path("path")
     *                         .permission("permission")
     *                         .build()))
     *                 .memorySizeInKb(123)
     *                 .mountRoSysfs(false)
     *                 .volumes(List.of(LambdaVolumeMountProperty.builder()
     *                         .addGroupOwner(false)
     *                         .destinationPath("destinationPath")
     *                         .permission("permission")
     *                         .sourcePath("sourcePath")
     *                         .build()))
     *                 .build())
     *         .isolationMode("isolationMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaLinuxProcessParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaLinuxProcessParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaLinuxProcessParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for the container in which the Lambda function runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-containerparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-containerparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerParams() {
            return null;
        }

        /**
         * The isolation mode for the process that contains the Lambda function.
         * <p>
         * The process can run in an isolated runtime environment inside the AWS IoT Greengrass container, or as a regular process outside any container.
         * <p>
         * Default: <code>GreengrassContainer</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-isolationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-isolationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIsolationMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaLinuxProcessParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaLinuxProcessParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaLinuxProcessParamsProperty> {
            java.lang.Object containerParams;
            java.lang.String isolationMode;

            /**
             * Sets the value of {@link LambdaLinuxProcessParamsProperty#getContainerParams}
             * @param containerParams The parameters for the container in which the Lambda function runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerParams(software.amazon.awscdk.IResolvable containerParams) {
                this.containerParams = containerParams;
                return this;
            }

            /**
             * Sets the value of {@link LambdaLinuxProcessParamsProperty#getContainerParams}
             * @param containerParams The parameters for the container in which the Lambda function runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerParams(software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.LambdaContainerParamsProperty containerParams) {
                this.containerParams = containerParams;
                return this;
            }

            /**
             * Sets the value of {@link LambdaLinuxProcessParamsProperty#getIsolationMode}
             * @param isolationMode The isolation mode for the process that contains the Lambda function.
             *                      The process can run in an isolated runtime environment inside the AWS IoT Greengrass container, or as a regular process outside any container.
             *                      <p>
             *                      Default: <code>GreengrassContainer</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isolationMode(java.lang.String isolationMode) {
                this.isolationMode = isolationMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaLinuxProcessParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaLinuxProcessParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaLinuxProcessParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaLinuxProcessParamsProperty {
            private final java.lang.Object containerParams;
            private final java.lang.String isolationMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerParams = software.amazon.jsii.Kernel.get(this, "containerParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isolationMode = software.amazon.jsii.Kernel.get(this, "isolationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerParams = builder.containerParams;
                this.isolationMode = builder.isolationMode;
            }

            @Override
            public final java.lang.Object getContainerParams() {
                return this.containerParams;
            }

            @Override
            public final java.lang.String getIsolationMode() {
                return this.isolationMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerParams() != null) {
                    data.set("containerParams", om.valueToTree(this.getContainerParams()));
                }
                if (this.getIsolationMode() != null) {
                    data.set("isolationMode", om.valueToTree(this.getIsolationMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaLinuxProcessParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaLinuxProcessParamsProperty.Jsii$Proxy that = (LambdaLinuxProcessParamsProperty.Jsii$Proxy) o;

                if (this.containerParams != null ? !this.containerParams.equals(that.containerParams) : that.containerParams != null) return false;
                return this.isolationMode != null ? this.isolationMode.equals(that.isolationMode) : that.isolationMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerParams != null ? this.containerParams.hashCode() : 0;
                result = 31 * result + (this.isolationMode != null ? this.isolationMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a volume that Linux processes in a container can access.
     * <p>
     * When you define a volume, the AWS IoT Greengrass Core software mounts the source files to the destination inside the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * LambdaVolumeMountProperty lambdaVolumeMountProperty = LambdaVolumeMountProperty.builder()
     *         .addGroupOwner(false)
     *         .destinationPath("destinationPath")
     *         .permission("permission")
     *         .sourcePath("sourcePath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaVolumeMountProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaVolumeMountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaVolumeMountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether or not to add the AWS IoT Greengrass user group as an owner of the volume.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-addgroupowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-addgroupowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddGroupOwner() {
            return null;
        }

        /**
         * The path to the logical volume in the file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-destinationpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-destinationpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPath() {
            return null;
        }

        /**
         * The permission to access the volume: read/only ( <code>ro</code> ) or read/write ( <code>rw</code> ).
         * <p>
         * Default: <code>ro</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-permission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-permission</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPermission() {
            return null;
        }

        /**
         * The path to the physical volume in the file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-sourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-sourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaVolumeMountProperty> {
            java.lang.Object addGroupOwner;
            java.lang.String destinationPath;
            java.lang.String permission;
            java.lang.String sourcePath;

            /**
             * Sets the value of {@link LambdaVolumeMountProperty#getAddGroupOwner}
             * @param addGroupOwner Whether or not to add the AWS IoT Greengrass user group as an owner of the volume.
             *                      Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addGroupOwner(java.lang.Boolean addGroupOwner) {
                this.addGroupOwner = addGroupOwner;
                return this;
            }

            /**
             * Sets the value of {@link LambdaVolumeMountProperty#getAddGroupOwner}
             * @param addGroupOwner Whether or not to add the AWS IoT Greengrass user group as an owner of the volume.
             *                      Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addGroupOwner(software.amazon.awscdk.IResolvable addGroupOwner) {
                this.addGroupOwner = addGroupOwner;
                return this;
            }

            /**
             * Sets the value of {@link LambdaVolumeMountProperty#getDestinationPath}
             * @param destinationPath The path to the logical volume in the file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPath(java.lang.String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            /**
             * Sets the value of {@link LambdaVolumeMountProperty#getPermission}
             * @param permission The permission to access the volume: read/only ( <code>ro</code> ) or read/write ( <code>rw</code> ).
             *                   Default: <code>ro</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permission(java.lang.String permission) {
                this.permission = permission;
                return this;
            }

            /**
             * Sets the value of {@link LambdaVolumeMountProperty#getSourcePath}
             * @param sourcePath The path to the physical volume in the file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaVolumeMountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaVolumeMountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaVolumeMountProperty {
            private final java.lang.Object addGroupOwner;
            private final java.lang.String destinationPath;
            private final java.lang.String permission;
            private final java.lang.String sourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addGroupOwner = software.amazon.jsii.Kernel.get(this, "addGroupOwner", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationPath = software.amazon.jsii.Kernel.get(this, "destinationPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permission = software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addGroupOwner = builder.addGroupOwner;
                this.destinationPath = builder.destinationPath;
                this.permission = builder.permission;
                this.sourcePath = builder.sourcePath;
            }

            @Override
            public final java.lang.Object getAddGroupOwner() {
                return this.addGroupOwner;
            }

            @Override
            public final java.lang.String getDestinationPath() {
                return this.destinationPath;
            }

            @Override
            public final java.lang.String getPermission() {
                return this.permission;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddGroupOwner() != null) {
                    data.set("addGroupOwner", om.valueToTree(this.getAddGroupOwner()));
                }
                if (this.getDestinationPath() != null) {
                    data.set("destinationPath", om.valueToTree(this.getDestinationPath()));
                }
                if (this.getPermission() != null) {
                    data.set("permission", om.valueToTree(this.getPermission()));
                }
                if (this.getSourcePath() != null) {
                    data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersion.LambdaVolumeMountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaVolumeMountProperty.Jsii$Proxy that = (LambdaVolumeMountProperty.Jsii$Proxy) o;

                if (this.addGroupOwner != null ? !this.addGroupOwner.equals(that.addGroupOwner) : that.addGroupOwner != null) return false;
                if (this.destinationPath != null ? !this.destinationPath.equals(that.destinationPath) : that.destinationPath != null) return false;
                if (this.permission != null ? !this.permission.equals(that.permission) : that.permission != null) return false;
                return this.sourcePath != null ? this.sourcePath.equals(that.sourcePath) : that.sourcePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addGroupOwner != null ? this.addGroupOwner.hashCode() : 0;
                result = 31 * result + (this.destinationPath != null ? this.destinationPath.hashCode() : 0);
                result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
                result = 31 * result + (this.sourcePath != null ? this.sourcePath.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrassv2.CfnComponentVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrassv2.CfnComponentVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.greengrassv2.CfnComponentVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The recipe to use to create the component.
         * <p>
         * The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.
         * <p>
         * You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-inlinerecipe">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-inlinerecipe</a>
         * @param inlineRecipe The recipe to use to create the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineRecipe(final java.lang.String inlineRecipe) {
            this.props().inlineRecipe(inlineRecipe);
            return this;
        }

        /**
         * The parameters to create a component from a Lambda function.
         * <p>
         * You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction</a>
         * @param lambdaFunction The parameters to create a component from a Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(final software.amazon.awscdk.IResolvable lambdaFunction) {
            this.props().lambdaFunction(lambdaFunction);
            return this;
        }
        /**
         * The parameters to create a component from a Lambda function.
         * <p>
         * You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction</a>
         * @param lambdaFunction The parameters to create a component from a Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(final software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.LambdaFunctionRecipeSourceProperty lambdaFunction) {
            this.props().lambdaFunction(lambdaFunction);
            return this;
        }

        /**
         * Application-specific metadata to attach to the component version.
         * <p>
         * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your AWS IoT Greengrass Version 2 resources</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         * <p>
         * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         * <p>
         * <blockquote><pre>
         * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-tags</a>
         * @param tags Application-specific metadata to attach to the component version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrassv2.CfnComponentVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrassv2.CfnComponentVersion build() {
            return new software.amazon.awscdk.services.greengrassv2.CfnComponentVersion(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.greengrassv2.CfnComponentVersionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.greengrassv2.CfnComponentVersionProps.Builder();
            }
            return this.props;
        }
    }
}
