package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a <code>CfnImage</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnImageProps cfnImageProps = CfnImageProps.builder()
 *         .containerRecipeArn("containerRecipeArn")
 *         .distributionConfigurationArn("distributionConfigurationArn")
 *         .enhancedImageMetadataEnabled(false)
 *         .executionRole("executionRole")
 *         .imageRecipeArn("imageRecipeArn")
 *         .imageScanningConfiguration(ImageScanningConfigurationProperty.builder()
 *                 .ecrConfiguration(EcrConfigurationProperty.builder()
 *                         .containerTags(List.of("containerTags"))
 *                         .repositoryName("repositoryName")
 *                         .build())
 *                 .imageScanningEnabled(false)
 *                 .build())
 *         .imageTestsConfiguration(ImageTestsConfigurationProperty.builder()
 *                 .imageTestsEnabled(false)
 *                 .timeoutMinutes(123)
 *                 .build())
 *         .infrastructureConfigurationArn("infrastructureConfigurationArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workflows(List.of(WorkflowConfigurationProperty.builder()
 *                 .onFailure("onFailure")
 *                 .parallelGroup("parallelGroup")
 *                 .parameters(List.of(WorkflowParameterProperty.builder()
 *                         .name("name")
 *                         .value(List.of("value"))
 *                         .build()))
 *                 .workflowArn("workflowArn")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:50.288Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImageProps")
@software.amazon.jsii.Jsii.Proxy(CfnImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-containerrecipearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-containerrecipearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerRecipeArn() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-distributionconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-distributionconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistributionConfigurationArn() {
        return null;
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-enhancedimagemetadataenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-enhancedimagemetadataenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedImageMetadataEnabled() {
        return null;
    }

    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-executionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagerecipearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagerecipearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageRecipeArn() {
        return null;
    }

    /**
     * Contains settings for vulnerability scans.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagescanningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagescanningconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageScanningConfiguration() {
        return null;
    }

    /**
     * The image tests configuration of the image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagetestsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagetestsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-infrastructureconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-infrastructureconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInfrastructureConfigurationArn() {
        return null;
    }

    /**
     * The tags of the image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Contains an array of workflow configuration objects.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-workflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-workflows</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflows() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImageProps> {
        java.lang.String containerRecipeArn;
        java.lang.String distributionConfigurationArn;
        java.lang.Object enhancedImageMetadataEnabled;
        java.lang.String executionRole;
        java.lang.String imageRecipeArn;
        java.lang.Object imageScanningConfiguration;
        java.lang.Object imageTestsConfiguration;
        java.lang.String infrastructureConfigurationArn;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object workflows;

        /**
         * Sets the value of {@link CfnImageProps#getContainerRecipeArn}
         * @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRecipeArn(java.lang.String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getDistributionConfigurationArn}
         * @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfigurationArn(java.lang.String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getEnhancedImageMetadataEnabled}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list.
         *                                     This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(java.lang.Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getEnhancedImageMetadataEnabled}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list.
         *                                     This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(software.amazon.awscdk.IResolvable enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getExecutionRole}
         * @param executionRole The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageRecipeArn}
         * @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageRecipeArn(java.lang.String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageScanningConfiguration}
         * @param imageScanningConfiguration Contains settings for vulnerability scans.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanningConfiguration(software.amazon.awscdk.IResolvable imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageScanningConfiguration}
         * @param imageScanningConfiguration Contains settings for vulnerability scans.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanningConfiguration(software.amazon.awscdk.services.imagebuilder.CfnImage.ImageScanningConfigurationProperty imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageTestsConfiguration}
         * @param imageTestsConfiguration The image tests configuration of the image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(software.amazon.awscdk.IResolvable imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageTestsConfiguration}
         * @param imageTestsConfiguration The image tests configuration of the image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(software.amazon.awscdk.services.imagebuilder.CfnImage.ImageTestsConfigurationProperty imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getInfrastructureConfigurationArn}
         * @param infrastructureConfigurationArn The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureConfigurationArn(java.lang.String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getTags}
         * @param tags The tags of the image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getWorkflows}
         * @param workflows Contains an array of workflow configuration objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(software.amazon.awscdk.IResolvable workflows) {
            this.workflows = workflows;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getWorkflows}
         * @param workflows Contains an array of workflow configuration objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(java.util.List<? extends java.lang.Object> workflows) {
            this.workflows = workflows;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImageProps {
        private final java.lang.String containerRecipeArn;
        private final java.lang.String distributionConfigurationArn;
        private final java.lang.Object enhancedImageMetadataEnabled;
        private final java.lang.String executionRole;
        private final java.lang.String imageRecipeArn;
        private final java.lang.Object imageScanningConfiguration;
        private final java.lang.Object imageTestsConfiguration;
        private final java.lang.String infrastructureConfigurationArn;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object workflows;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerRecipeArn = software.amazon.jsii.Kernel.get(this, "containerRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributionConfigurationArn = software.amazon.jsii.Kernel.get(this, "distributionConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enhancedImageMetadataEnabled = software.amazon.jsii.Kernel.get(this, "enhancedImageMetadataEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageRecipeArn = software.amazon.jsii.Kernel.get(this, "imageRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageScanningConfiguration = software.amazon.jsii.Kernel.get(this, "imageScanningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageTestsConfiguration = software.amazon.jsii.Kernel.get(this, "imageTestsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.infrastructureConfigurationArn = software.amazon.jsii.Kernel.get(this, "infrastructureConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workflows = software.amazon.jsii.Kernel.get(this, "workflows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerRecipeArn = builder.containerRecipeArn;
            this.distributionConfigurationArn = builder.distributionConfigurationArn;
            this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
            this.executionRole = builder.executionRole;
            this.imageRecipeArn = builder.imageRecipeArn;
            this.imageScanningConfiguration = builder.imageScanningConfiguration;
            this.imageTestsConfiguration = builder.imageTestsConfiguration;
            this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
            this.tags = builder.tags;
            this.workflows = builder.workflows;
        }

        @Override
        public final java.lang.String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        @Override
        public final java.lang.String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        @Override
        public final java.lang.Object getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        @Override
        public final java.lang.Object getImageScanningConfiguration() {
            return this.imageScanningConfiguration;
        }

        @Override
        public final java.lang.Object getImageTestsConfiguration() {
            return this.imageTestsConfiguration;
        }

        @Override
        public final java.lang.String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkflows() {
            return this.workflows;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContainerRecipeArn() != null) {
                data.set("containerRecipeArn", om.valueToTree(this.getContainerRecipeArn()));
            }
            if (this.getDistributionConfigurationArn() != null) {
                data.set("distributionConfigurationArn", om.valueToTree(this.getDistributionConfigurationArn()));
            }
            if (this.getEnhancedImageMetadataEnabled() != null) {
                data.set("enhancedImageMetadataEnabled", om.valueToTree(this.getEnhancedImageMetadataEnabled()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getImageRecipeArn() != null) {
                data.set("imageRecipeArn", om.valueToTree(this.getImageRecipeArn()));
            }
            if (this.getImageScanningConfiguration() != null) {
                data.set("imageScanningConfiguration", om.valueToTree(this.getImageScanningConfiguration()));
            }
            if (this.getImageTestsConfiguration() != null) {
                data.set("imageTestsConfiguration", om.valueToTree(this.getImageTestsConfiguration()));
            }
            if (this.getInfrastructureConfigurationArn() != null) {
                data.set("infrastructureConfigurationArn", om.valueToTree(this.getInfrastructureConfigurationArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkflows() != null) {
                data.set("workflows", om.valueToTree(this.getWorkflows()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImageProps.Jsii$Proxy that = (CfnImageProps.Jsii$Proxy) o;

            if (this.containerRecipeArn != null ? !this.containerRecipeArn.equals(that.containerRecipeArn) : that.containerRecipeArn != null) return false;
            if (this.distributionConfigurationArn != null ? !this.distributionConfigurationArn.equals(that.distributionConfigurationArn) : that.distributionConfigurationArn != null) return false;
            if (this.enhancedImageMetadataEnabled != null ? !this.enhancedImageMetadataEnabled.equals(that.enhancedImageMetadataEnabled) : that.enhancedImageMetadataEnabled != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.imageRecipeArn != null ? !this.imageRecipeArn.equals(that.imageRecipeArn) : that.imageRecipeArn != null) return false;
            if (this.imageScanningConfiguration != null ? !this.imageScanningConfiguration.equals(that.imageScanningConfiguration) : that.imageScanningConfiguration != null) return false;
            if (this.imageTestsConfiguration != null ? !this.imageTestsConfiguration.equals(that.imageTestsConfiguration) : that.imageTestsConfiguration != null) return false;
            if (this.infrastructureConfigurationArn != null ? !this.infrastructureConfigurationArn.equals(that.infrastructureConfigurationArn) : that.infrastructureConfigurationArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workflows != null ? this.workflows.equals(that.workflows) : that.workflows == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerRecipeArn != null ? this.containerRecipeArn.hashCode() : 0;
            result = 31 * result + (this.distributionConfigurationArn != null ? this.distributionConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.enhancedImageMetadataEnabled != null ? this.enhancedImageMetadataEnabled.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.imageRecipeArn != null ? this.imageRecipeArn.hashCode() : 0);
            result = 31 * result + (this.imageScanningConfiguration != null ? this.imageScanningConfiguration.hashCode() : 0);
            result = 31 * result + (this.imageTestsConfiguration != null ? this.imageTestsConfiguration.hashCode() : 0);
            result = 31 * result + (this.infrastructureConfigurationArn != null ? this.infrastructureConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workflows != null ? this.workflows.hashCode() : 0);
            return result;
        }
    }
}
