package software.amazon.awscdk.services.iotwireless;

/**
 * Creates a new service profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnServiceProfile cfnServiceProfile = CfnServiceProfile.Builder.create(this, "MyCfnServiceProfile")
 *         .loRaWan(LoRaWANServiceProfileProperty.builder()
 *                 .addGwMetadata(false)
 *                 .channelMask("channelMask")
 *                 .devStatusReqFreq(123)
 *                 .dlBucketSize(123)
 *                 .dlRate(123)
 *                 .dlRatePolicy("dlRatePolicy")
 *                 .drMax(123)
 *                 .drMin(123)
 *                 .hrAllowed(false)
 *                 .minGwDiversity(123)
 *                 .nwkGeoLoc(false)
 *                 .prAllowed(false)
 *                 .raAllowed(false)
 *                 .reportDevStatusBattery(false)
 *                 .reportDevStatusMargin(false)
 *                 .targetPer(123)
 *                 .ulBucketSize(123)
 *                 .ulRate(123)
 *                 .ulRatePolicy("ulRatePolicy")
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:50.743Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnServiceProfile")
public class CfnServiceProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnServiceProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServiceProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotwireless.CfnServiceProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServiceProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnServiceProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServiceProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the service profile created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the service profile created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ChannelMask value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoRaWanChannelMask() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanChannelMask", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DevStatusReqFreq value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanDevStatusReqFreq() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanDevStatusReqFreq", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The DLBucketSize value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanDlBucketSize() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanDlBucketSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The DLRate value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanDlRate() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanDlRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The DLRatePolicy value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoRaWanDlRatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanDlRatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DRMax value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanDrMax() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanDrMax", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The DRMin value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanDrMin() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanDrMin", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The HRAllowed value that describes whether handover roaming is allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLoRaWanHrAllowed() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanHrAllowed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The MinGwDiversity value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanMinGwDiversity() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanMinGwDiversity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The NwkGeoLoc value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLoRaWanNwkGeoLoc() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanNwkGeoLoc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The ReportDevStatusBattery value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLoRaWanReportDevStatusBattery() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanReportDevStatusBattery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The ReportDevStatusMargin value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLoRaWanReportDevStatusMargin() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanReportDevStatusMargin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLoRaWanResponse() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The TargetPer value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanTargetPer() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanTargetPer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The UlBucketSize value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanUlBucketSize() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanUlBucketSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The ULRate value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanUlRate() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanUlRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The ULRatePolicy value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoRaWanUlRatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanUlRatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * LoRaWAN service profile object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoRaWan() {
        return software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * LoRaWAN service profile object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWan(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loRaWan", value);
    }

    /**
     * LoRaWAN service profile object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWan(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnServiceProfile.LoRaWANServiceProfileProperty value) {
        software.amazon.jsii.Kernel.set(this, "loRaWan", value);
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * LoRaWANServiceProfile object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * LoRaWANServiceProfileProperty loRaWANServiceProfileProperty = LoRaWANServiceProfileProperty.builder()
     *         .addGwMetadata(false)
     *         .channelMask("channelMask")
     *         .devStatusReqFreq(123)
     *         .dlBucketSize(123)
     *         .dlRate(123)
     *         .dlRatePolicy("dlRatePolicy")
     *         .drMax(123)
     *         .drMin(123)
     *         .hrAllowed(false)
     *         .minGwDiversity(123)
     *         .nwkGeoLoc(false)
     *         .prAllowed(false)
     *         .raAllowed(false)
     *         .reportDevStatusBattery(false)
     *         .reportDevStatusMargin(false)
     *         .targetPer(123)
     *         .ulBucketSize(123)
     *         .ulRate(123)
     *         .ulRatePolicy("ulRatePolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnServiceProfile.LoRaWANServiceProfileProperty")
    @software.amazon.jsii.Jsii.Proxy(LoRaWANServiceProfileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoRaWANServiceProfileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AddGWMetaData value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-addgwmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-addgwmetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddGwMetadata() {
            return null;
        }

        /**
         * The ChannelMask value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-channelmask">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-channelmask</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChannelMask() {
            return null;
        }

        /**
         * The DevStatusReqFreq value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-devstatusreqfreq">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-devstatusreqfreq</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDevStatusReqFreq() {
            return null;
        }

        /**
         * The DLBucketSize value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlbucketsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlbucketsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDlBucketSize() {
            return null;
        }

        /**
         * The DLRate value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDlRate() {
            return null;
        }

        /**
         * The DLRatePolicy value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlratepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlratepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDlRatePolicy() {
            return null;
        }

        /**
         * The DRMax value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-drmax">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-drmax</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDrMax() {
            return null;
        }

        /**
         * The DRMin value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-drmin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-drmin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDrMin() {
            return null;
        }

        /**
         * The HRAllowed value that describes whether handover roaming is allowed.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-hrallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-hrallowed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHrAllowed() {
            return null;
        }

        /**
         * The MinGwDiversity value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-mingwdiversity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-mingwdiversity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinGwDiversity() {
            return null;
        }

        /**
         * The NwkGeoLoc value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-nwkgeoloc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-nwkgeoloc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNwkGeoLoc() {
            return null;
        }

        /**
         * The PRAllowed value that describes whether passive roaming is allowed.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-prallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-prallowed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrAllowed() {
            return null;
        }

        /**
         * The RAAllowed value that describes whether roaming activation is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-raallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-raallowed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRaAllowed() {
            return null;
        }

        /**
         * The ReportDevStatusBattery value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-reportdevstatusbattery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-reportdevstatusbattery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReportDevStatusBattery() {
            return null;
        }

        /**
         * The ReportDevStatusMargin value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-reportdevstatusmargin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-reportdevstatusmargin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReportDevStatusMargin() {
            return null;
        }

        /**
         * The TargetPer value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-targetper">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-targetper</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPer() {
            return null;
        }

        /**
         * The UlBucketSize value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulbucketsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulbucketsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUlBucketSize() {
            return null;
        }

        /**
         * The ULRate value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUlRate() {
            return null;
        }

        /**
         * The ULRatePolicy value.
         * <p>
         * This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulratepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulratepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUlRatePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoRaWANServiceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoRaWANServiceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoRaWANServiceProfileProperty> {
            java.lang.Object addGwMetadata;
            java.lang.String channelMask;
            java.lang.Number devStatusReqFreq;
            java.lang.Number dlBucketSize;
            java.lang.Number dlRate;
            java.lang.String dlRatePolicy;
            java.lang.Number drMax;
            java.lang.Number drMin;
            java.lang.Object hrAllowed;
            java.lang.Number minGwDiversity;
            java.lang.Object nwkGeoLoc;
            java.lang.Object prAllowed;
            java.lang.Object raAllowed;
            java.lang.Object reportDevStatusBattery;
            java.lang.Object reportDevStatusMargin;
            java.lang.Number targetPer;
            java.lang.Number ulBucketSize;
            java.lang.Number ulRate;
            java.lang.String ulRatePolicy;

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getAddGwMetadata}
             * @param addGwMetadata The AddGWMetaData value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addGwMetadata(java.lang.Boolean addGwMetadata) {
                this.addGwMetadata = addGwMetadata;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getAddGwMetadata}
             * @param addGwMetadata The AddGWMetaData value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addGwMetadata(software.amazon.awscdk.IResolvable addGwMetadata) {
                this.addGwMetadata = addGwMetadata;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getChannelMask}
             * @param channelMask The ChannelMask value.
             *                    This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelMask(java.lang.String channelMask) {
                this.channelMask = channelMask;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getDevStatusReqFreq}
             * @param devStatusReqFreq The DevStatusReqFreq value.
             *                         This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devStatusReqFreq(java.lang.Number devStatusReqFreq) {
                this.devStatusReqFreq = devStatusReqFreq;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getDlBucketSize}
             * @param dlBucketSize The DLBucketSize value.
             *                     This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlBucketSize(java.lang.Number dlBucketSize) {
                this.dlBucketSize = dlBucketSize;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getDlRate}
             * @param dlRate The DLRate value.
             *               This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlRate(java.lang.Number dlRate) {
                this.dlRate = dlRate;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getDlRatePolicy}
             * @param dlRatePolicy The DLRatePolicy value.
             *                     This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlRatePolicy(java.lang.String dlRatePolicy) {
                this.dlRatePolicy = dlRatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getDrMax}
             * @param drMax The DRMax value.
             *              This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drMax(java.lang.Number drMax) {
                this.drMax = drMax;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getDrMin}
             * @param drMin The DRMin value.
             *              This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drMin(java.lang.Number drMin) {
                this.drMin = drMin;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getHrAllowed}
             * @param hrAllowed The HRAllowed value that describes whether handover roaming is allowed.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hrAllowed(java.lang.Boolean hrAllowed) {
                this.hrAllowed = hrAllowed;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getHrAllowed}
             * @param hrAllowed The HRAllowed value that describes whether handover roaming is allowed.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hrAllowed(software.amazon.awscdk.IResolvable hrAllowed) {
                this.hrAllowed = hrAllowed;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getMinGwDiversity}
             * @param minGwDiversity The MinGwDiversity value.
             *                       This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minGwDiversity(java.lang.Number minGwDiversity) {
                this.minGwDiversity = minGwDiversity;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getNwkGeoLoc}
             * @param nwkGeoLoc The NwkGeoLoc value.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nwkGeoLoc(java.lang.Boolean nwkGeoLoc) {
                this.nwkGeoLoc = nwkGeoLoc;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getNwkGeoLoc}
             * @param nwkGeoLoc The NwkGeoLoc value.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nwkGeoLoc(software.amazon.awscdk.IResolvable nwkGeoLoc) {
                this.nwkGeoLoc = nwkGeoLoc;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getPrAllowed}
             * @param prAllowed The PRAllowed value that describes whether passive roaming is allowed.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prAllowed(java.lang.Boolean prAllowed) {
                this.prAllowed = prAllowed;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getPrAllowed}
             * @param prAllowed The PRAllowed value that describes whether passive roaming is allowed.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prAllowed(software.amazon.awscdk.IResolvable prAllowed) {
                this.prAllowed = prAllowed;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getRaAllowed}
             * @param raAllowed The RAAllowed value that describes whether roaming activation is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder raAllowed(java.lang.Boolean raAllowed) {
                this.raAllowed = raAllowed;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getRaAllowed}
             * @param raAllowed The RAAllowed value that describes whether roaming activation is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder raAllowed(software.amazon.awscdk.IResolvable raAllowed) {
                this.raAllowed = raAllowed;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getReportDevStatusBattery}
             * @param reportDevStatusBattery The ReportDevStatusBattery value.
             *                               This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportDevStatusBattery(java.lang.Boolean reportDevStatusBattery) {
                this.reportDevStatusBattery = reportDevStatusBattery;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getReportDevStatusBattery}
             * @param reportDevStatusBattery The ReportDevStatusBattery value.
             *                               This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportDevStatusBattery(software.amazon.awscdk.IResolvable reportDevStatusBattery) {
                this.reportDevStatusBattery = reportDevStatusBattery;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getReportDevStatusMargin}
             * @param reportDevStatusMargin The ReportDevStatusMargin value.
             *                              This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportDevStatusMargin(java.lang.Boolean reportDevStatusMargin) {
                this.reportDevStatusMargin = reportDevStatusMargin;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getReportDevStatusMargin}
             * @param reportDevStatusMargin The ReportDevStatusMargin value.
             *                              This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportDevStatusMargin(software.amazon.awscdk.IResolvable reportDevStatusMargin) {
                this.reportDevStatusMargin = reportDevStatusMargin;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getTargetPer}
             * @param targetPer The TargetPer value.
             *                  This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetPer(java.lang.Number targetPer) {
                this.targetPer = targetPer;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getUlBucketSize}
             * @param ulBucketSize The UlBucketSize value.
             *                     This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulBucketSize(java.lang.Number ulBucketSize) {
                this.ulBucketSize = ulBucketSize;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getUlRate}
             * @param ulRate The ULRate value.
             *               This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulRate(java.lang.Number ulRate) {
                this.ulRate = ulRate;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANServiceProfileProperty#getUlRatePolicy}
             * @param ulRatePolicy The ULRatePolicy value.
             *                     This property is <code>ReadOnly</code> and can't be inputted for create. It's returned with <code>Fn::GetAtt</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulRatePolicy(java.lang.String ulRatePolicy) {
                this.ulRatePolicy = ulRatePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoRaWANServiceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoRaWANServiceProfileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoRaWANServiceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoRaWANServiceProfileProperty {
            private final java.lang.Object addGwMetadata;
            private final java.lang.String channelMask;
            private final java.lang.Number devStatusReqFreq;
            private final java.lang.Number dlBucketSize;
            private final java.lang.Number dlRate;
            private final java.lang.String dlRatePolicy;
            private final java.lang.Number drMax;
            private final java.lang.Number drMin;
            private final java.lang.Object hrAllowed;
            private final java.lang.Number minGwDiversity;
            private final java.lang.Object nwkGeoLoc;
            private final java.lang.Object prAllowed;
            private final java.lang.Object raAllowed;
            private final java.lang.Object reportDevStatusBattery;
            private final java.lang.Object reportDevStatusMargin;
            private final java.lang.Number targetPer;
            private final java.lang.Number ulBucketSize;
            private final java.lang.Number ulRate;
            private final java.lang.String ulRatePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addGwMetadata = software.amazon.jsii.Kernel.get(this, "addGwMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.channelMask = software.amazon.jsii.Kernel.get(this, "channelMask", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.devStatusReqFreq = software.amazon.jsii.Kernel.get(this, "devStatusReqFreq", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dlBucketSize = software.amazon.jsii.Kernel.get(this, "dlBucketSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dlRate = software.amazon.jsii.Kernel.get(this, "dlRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dlRatePolicy = software.amazon.jsii.Kernel.get(this, "dlRatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.drMax = software.amazon.jsii.Kernel.get(this, "drMax", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.drMin = software.amazon.jsii.Kernel.get(this, "drMin", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.hrAllowed = software.amazon.jsii.Kernel.get(this, "hrAllowed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minGwDiversity = software.amazon.jsii.Kernel.get(this, "minGwDiversity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.nwkGeoLoc = software.amazon.jsii.Kernel.get(this, "nwkGeoLoc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prAllowed = software.amazon.jsii.Kernel.get(this, "prAllowed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.raAllowed = software.amazon.jsii.Kernel.get(this, "raAllowed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.reportDevStatusBattery = software.amazon.jsii.Kernel.get(this, "reportDevStatusBattery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.reportDevStatusMargin = software.amazon.jsii.Kernel.get(this, "reportDevStatusMargin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetPer = software.amazon.jsii.Kernel.get(this, "targetPer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ulBucketSize = software.amazon.jsii.Kernel.get(this, "ulBucketSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ulRate = software.amazon.jsii.Kernel.get(this, "ulRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ulRatePolicy = software.amazon.jsii.Kernel.get(this, "ulRatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addGwMetadata = builder.addGwMetadata;
                this.channelMask = builder.channelMask;
                this.devStatusReqFreq = builder.devStatusReqFreq;
                this.dlBucketSize = builder.dlBucketSize;
                this.dlRate = builder.dlRate;
                this.dlRatePolicy = builder.dlRatePolicy;
                this.drMax = builder.drMax;
                this.drMin = builder.drMin;
                this.hrAllowed = builder.hrAllowed;
                this.minGwDiversity = builder.minGwDiversity;
                this.nwkGeoLoc = builder.nwkGeoLoc;
                this.prAllowed = builder.prAllowed;
                this.raAllowed = builder.raAllowed;
                this.reportDevStatusBattery = builder.reportDevStatusBattery;
                this.reportDevStatusMargin = builder.reportDevStatusMargin;
                this.targetPer = builder.targetPer;
                this.ulBucketSize = builder.ulBucketSize;
                this.ulRate = builder.ulRate;
                this.ulRatePolicy = builder.ulRatePolicy;
            }

            @Override
            public final java.lang.Object getAddGwMetadata() {
                return this.addGwMetadata;
            }

            @Override
            public final java.lang.String getChannelMask() {
                return this.channelMask;
            }

            @Override
            public final java.lang.Number getDevStatusReqFreq() {
                return this.devStatusReqFreq;
            }

            @Override
            public final java.lang.Number getDlBucketSize() {
                return this.dlBucketSize;
            }

            @Override
            public final java.lang.Number getDlRate() {
                return this.dlRate;
            }

            @Override
            public final java.lang.String getDlRatePolicy() {
                return this.dlRatePolicy;
            }

            @Override
            public final java.lang.Number getDrMax() {
                return this.drMax;
            }

            @Override
            public final java.lang.Number getDrMin() {
                return this.drMin;
            }

            @Override
            public final java.lang.Object getHrAllowed() {
                return this.hrAllowed;
            }

            @Override
            public final java.lang.Number getMinGwDiversity() {
                return this.minGwDiversity;
            }

            @Override
            public final java.lang.Object getNwkGeoLoc() {
                return this.nwkGeoLoc;
            }

            @Override
            public final java.lang.Object getPrAllowed() {
                return this.prAllowed;
            }

            @Override
            public final java.lang.Object getRaAllowed() {
                return this.raAllowed;
            }

            @Override
            public final java.lang.Object getReportDevStatusBattery() {
                return this.reportDevStatusBattery;
            }

            @Override
            public final java.lang.Object getReportDevStatusMargin() {
                return this.reportDevStatusMargin;
            }

            @Override
            public final java.lang.Number getTargetPer() {
                return this.targetPer;
            }

            @Override
            public final java.lang.Number getUlBucketSize() {
                return this.ulBucketSize;
            }

            @Override
            public final java.lang.Number getUlRate() {
                return this.ulRate;
            }

            @Override
            public final java.lang.String getUlRatePolicy() {
                return this.ulRatePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddGwMetadata() != null) {
                    data.set("addGwMetadata", om.valueToTree(this.getAddGwMetadata()));
                }
                if (this.getChannelMask() != null) {
                    data.set("channelMask", om.valueToTree(this.getChannelMask()));
                }
                if (this.getDevStatusReqFreq() != null) {
                    data.set("devStatusReqFreq", om.valueToTree(this.getDevStatusReqFreq()));
                }
                if (this.getDlBucketSize() != null) {
                    data.set("dlBucketSize", om.valueToTree(this.getDlBucketSize()));
                }
                if (this.getDlRate() != null) {
                    data.set("dlRate", om.valueToTree(this.getDlRate()));
                }
                if (this.getDlRatePolicy() != null) {
                    data.set("dlRatePolicy", om.valueToTree(this.getDlRatePolicy()));
                }
                if (this.getDrMax() != null) {
                    data.set("drMax", om.valueToTree(this.getDrMax()));
                }
                if (this.getDrMin() != null) {
                    data.set("drMin", om.valueToTree(this.getDrMin()));
                }
                if (this.getHrAllowed() != null) {
                    data.set("hrAllowed", om.valueToTree(this.getHrAllowed()));
                }
                if (this.getMinGwDiversity() != null) {
                    data.set("minGwDiversity", om.valueToTree(this.getMinGwDiversity()));
                }
                if (this.getNwkGeoLoc() != null) {
                    data.set("nwkGeoLoc", om.valueToTree(this.getNwkGeoLoc()));
                }
                if (this.getPrAllowed() != null) {
                    data.set("prAllowed", om.valueToTree(this.getPrAllowed()));
                }
                if (this.getRaAllowed() != null) {
                    data.set("raAllowed", om.valueToTree(this.getRaAllowed()));
                }
                if (this.getReportDevStatusBattery() != null) {
                    data.set("reportDevStatusBattery", om.valueToTree(this.getReportDevStatusBattery()));
                }
                if (this.getReportDevStatusMargin() != null) {
                    data.set("reportDevStatusMargin", om.valueToTree(this.getReportDevStatusMargin()));
                }
                if (this.getTargetPer() != null) {
                    data.set("targetPer", om.valueToTree(this.getTargetPer()));
                }
                if (this.getUlBucketSize() != null) {
                    data.set("ulBucketSize", om.valueToTree(this.getUlBucketSize()));
                }
                if (this.getUlRate() != null) {
                    data.set("ulRate", om.valueToTree(this.getUlRate()));
                }
                if (this.getUlRatePolicy() != null) {
                    data.set("ulRatePolicy", om.valueToTree(this.getUlRatePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnServiceProfile.LoRaWANServiceProfileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoRaWANServiceProfileProperty.Jsii$Proxy that = (LoRaWANServiceProfileProperty.Jsii$Proxy) o;

                if (this.addGwMetadata != null ? !this.addGwMetadata.equals(that.addGwMetadata) : that.addGwMetadata != null) return false;
                if (this.channelMask != null ? !this.channelMask.equals(that.channelMask) : that.channelMask != null) return false;
                if (this.devStatusReqFreq != null ? !this.devStatusReqFreq.equals(that.devStatusReqFreq) : that.devStatusReqFreq != null) return false;
                if (this.dlBucketSize != null ? !this.dlBucketSize.equals(that.dlBucketSize) : that.dlBucketSize != null) return false;
                if (this.dlRate != null ? !this.dlRate.equals(that.dlRate) : that.dlRate != null) return false;
                if (this.dlRatePolicy != null ? !this.dlRatePolicy.equals(that.dlRatePolicy) : that.dlRatePolicy != null) return false;
                if (this.drMax != null ? !this.drMax.equals(that.drMax) : that.drMax != null) return false;
                if (this.drMin != null ? !this.drMin.equals(that.drMin) : that.drMin != null) return false;
                if (this.hrAllowed != null ? !this.hrAllowed.equals(that.hrAllowed) : that.hrAllowed != null) return false;
                if (this.minGwDiversity != null ? !this.minGwDiversity.equals(that.minGwDiversity) : that.minGwDiversity != null) return false;
                if (this.nwkGeoLoc != null ? !this.nwkGeoLoc.equals(that.nwkGeoLoc) : that.nwkGeoLoc != null) return false;
                if (this.prAllowed != null ? !this.prAllowed.equals(that.prAllowed) : that.prAllowed != null) return false;
                if (this.raAllowed != null ? !this.raAllowed.equals(that.raAllowed) : that.raAllowed != null) return false;
                if (this.reportDevStatusBattery != null ? !this.reportDevStatusBattery.equals(that.reportDevStatusBattery) : that.reportDevStatusBattery != null) return false;
                if (this.reportDevStatusMargin != null ? !this.reportDevStatusMargin.equals(that.reportDevStatusMargin) : that.reportDevStatusMargin != null) return false;
                if (this.targetPer != null ? !this.targetPer.equals(that.targetPer) : that.targetPer != null) return false;
                if (this.ulBucketSize != null ? !this.ulBucketSize.equals(that.ulBucketSize) : that.ulBucketSize != null) return false;
                if (this.ulRate != null ? !this.ulRate.equals(that.ulRate) : that.ulRate != null) return false;
                return this.ulRatePolicy != null ? this.ulRatePolicy.equals(that.ulRatePolicy) : that.ulRatePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addGwMetadata != null ? this.addGwMetadata.hashCode() : 0;
                result = 31 * result + (this.channelMask != null ? this.channelMask.hashCode() : 0);
                result = 31 * result + (this.devStatusReqFreq != null ? this.devStatusReqFreq.hashCode() : 0);
                result = 31 * result + (this.dlBucketSize != null ? this.dlBucketSize.hashCode() : 0);
                result = 31 * result + (this.dlRate != null ? this.dlRate.hashCode() : 0);
                result = 31 * result + (this.dlRatePolicy != null ? this.dlRatePolicy.hashCode() : 0);
                result = 31 * result + (this.drMax != null ? this.drMax.hashCode() : 0);
                result = 31 * result + (this.drMin != null ? this.drMin.hashCode() : 0);
                result = 31 * result + (this.hrAllowed != null ? this.hrAllowed.hashCode() : 0);
                result = 31 * result + (this.minGwDiversity != null ? this.minGwDiversity.hashCode() : 0);
                result = 31 * result + (this.nwkGeoLoc != null ? this.nwkGeoLoc.hashCode() : 0);
                result = 31 * result + (this.prAllowed != null ? this.prAllowed.hashCode() : 0);
                result = 31 * result + (this.raAllowed != null ? this.raAllowed.hashCode() : 0);
                result = 31 * result + (this.reportDevStatusBattery != null ? this.reportDevStatusBattery.hashCode() : 0);
                result = 31 * result + (this.reportDevStatusMargin != null ? this.reportDevStatusMargin.hashCode() : 0);
                result = 31 * result + (this.targetPer != null ? this.targetPer.hashCode() : 0);
                result = 31 * result + (this.ulBucketSize != null ? this.ulBucketSize.hashCode() : 0);
                result = 31 * result + (this.ulRate != null ? this.ulRate.hashCode() : 0);
                result = 31 * result + (this.ulRatePolicy != null ? this.ulRatePolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotwireless.CfnServiceProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotwireless.CfnServiceProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iotwireless.CfnServiceProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * LoRaWAN service profile object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawan</a>
         * @param loRaWan LoRaWAN service profile object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(final software.amazon.awscdk.IResolvable loRaWan) {
            this.props().loRaWan(loRaWan);
            return this;
        }
        /**
         * LoRaWAN service profile object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawan</a>
         * @param loRaWan LoRaWAN service profile object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(final software.amazon.awscdk.services.iotwireless.CfnServiceProfile.LoRaWANServiceProfileProperty loRaWan) {
            this.props().loRaWan(loRaWan);
            return this;
        }

        /**
         * The name of the new resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-name</a>
         * @param name The name of the new resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The tags are an array of key-value pairs to attach to the specified resource.
         * <p>
         * Tags can have a minimum of 0 and a maximum of 50 items.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-tags</a>
         * @param tags The tags are an array of key-value pairs to attach to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotwireless.CfnServiceProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotwireless.CfnServiceProfile build() {
            return new software.amazon.awscdk.services.iotwireless.CfnServiceProfile(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iotwireless.CfnServiceProfileProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iotwireless.CfnServiceProfileProps.Builder();
            }
            return this.props;
        }
    }
}
