package software.amazon.awscdk.services.kinesis;

/**
 * Properties for a Kinesis Stream Consumer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role lambdaRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .description("Example role...")
 *         .build();
 * Stream stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.KMS)
 *         .build();
 * StreamConsumer streamConsumer = StreamConsumer.Builder.create(this, "MyStreamConsumer")
 *         .streamConsumerName("MyStreamConsumer")
 *         .stream(stream)
 *         .build();
 * // give lambda permissions to read stream via the stream consumer
 * streamConsumer.grantRead(lambdaRole);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:50.938Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.StreamConsumerProps")
@software.amazon.jsii.Jsii.Proxy(StreamConsumerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamConsumerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Kinesis data stream to associate this consumer with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream getStream();

    /**
     * The name of the stream consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamConsumerName();

    /**
     * @return a {@link Builder} of {@link StreamConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamConsumerProps> {
        software.amazon.awscdk.services.kinesis.IStream stream;
        java.lang.String streamConsumerName;

        /**
         * Sets the value of {@link StreamConsumerProps#getStream}
         * @param stream The Kinesis data stream to associate this consumer with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of {@link StreamConsumerProps#getStreamConsumerName}
         * @param streamConsumerName The name of the stream consumer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConsumerName(java.lang.String streamConsumerName) {
            this.streamConsumerName = streamConsumerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamConsumerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamConsumerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StreamConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConsumerProps {
        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final java.lang.String streamConsumerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.streamConsumerName = software.amazon.jsii.Kernel.get(this, "streamConsumerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stream = java.util.Objects.requireNonNull(builder.stream, "stream is required");
            this.streamConsumerName = java.util.Objects.requireNonNull(builder.streamConsumerName, "streamConsumerName is required");
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getStream() {
            return this.stream;
        }

        @Override
        public final java.lang.String getStreamConsumerName() {
            return this.streamConsumerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stream", om.valueToTree(this.getStream()));
            data.set("streamConsumerName", om.valueToTree(this.getStreamConsumerName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesis.StreamConsumerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamConsumerProps.Jsii$Proxy that = (StreamConsumerProps.Jsii$Proxy) o;

            if (!stream.equals(that.stream)) return false;
            return this.streamConsumerName.equals(that.streamConsumerName);
        }

        @Override
        public final int hashCode() {
            int result = this.stream.hashCode();
            result = 31 * result + (this.streamConsumerName.hashCode());
            return result;
        }
    }
}
