package software.amazon.awscdk.services.kinesisanalytics;

/**
 * Properties for defining a <code>CfnApplicationOutput</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalytics.*;
 * CfnApplicationOutputProps cfnApplicationOutputProps = CfnApplicationOutputProps.builder()
 *         .applicationName("applicationName")
 *         .output(OutputProperty.builder()
 *                 .destinationSchema(DestinationSchemaProperty.builder()
 *                         .recordFormatType("recordFormatType")
 *                         .build())
 *                 // the properties below are optional
 *                 .kinesisFirehoseOutput(KinesisFirehoseOutputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .kinesisStreamsOutput(KinesisStreamsOutputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .lambdaOutput(LambdaOutputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .name("name")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:50.951Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the application to which you want to add the output configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * An array of objects, each describing one output configuration.
     * <p>
     * In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOutput();

    /**
     * @return a {@link Builder} of {@link CfnApplicationOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationOutputProps> {
        java.lang.String applicationName;
        java.lang.Object output;

        /**
         * Sets the value of {@link CfnApplicationOutputProps#getApplicationName}
         * @param applicationName Name of the application to which you want to add the output configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationOutputProps#getOutput}
         * @param output An array of objects, each describing one output configuration. This parameter is required.
         *               In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.IResolvable output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationOutputProps#getOutput}
         * @param output An array of objects, each describing one output configuration. This parameter is required.
         *               In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.OutputProperty output) {
            this.output = output;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationOutputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationOutputProps {
        private final java.lang.String applicationName;
        private final java.lang.Object output;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(builder.applicationName, "applicationName is required");
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.Object getOutput() {
            return this.output;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("output", om.valueToTree(this.getOutput()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationOutputProps.Jsii$Proxy that = (CfnApplicationOutputProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            return this.output.equals(that.output);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.output.hashCode());
            return result;
        }
    }
}
