package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Properties for defining a <code>CfnDeliveryStream</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket destinationBucket = new Bucket(this, "Bucket");
 * Role deliveryStreamRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("firehose.amazonaws.com"))
 *         .build();
 * CfnDeliveryStream stream = CfnDeliveryStream.Builder.create(this, "MyStream")
 *         .deliveryStreamName("amazon-apigateway-delivery-stream")
 *         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                 .bucketArn(destinationBucket.getBucketArn())
 *                 .roleArn(deliveryStreamRole.getRoleArn())
 *                 .build())
 *         .build();
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new FirehoseLogDestination(stream))
 *                 .accessLogFormat(AccessLogFormat.jsonWithStandardFields())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:51.111Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStreamProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeliveryStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeliveryStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonOpenSearchServerlessDestinationConfiguration() {
        return null;
    }

    /**
     * The destination in Amazon OpenSearch Service.
     * <p>
     * You can specify only one destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonopensearchserviceDestinationConfiguration() {
        return null;
    }

    /**
     * The top level object for configuring streams with database as a source.
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseSourceConfiguration() {
        return null;
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryStreamEncryptionConfigurationInput() {
        return null;
    }

    /**
     * The name of the Firehose stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return null;
    }

    /**
     * The Firehose stream type. This can be one of the following values:.
     * <p>
     * <ul>
     * <li><code>DirectPut</code> : Provider applications access the Firehose stream directly.</li>
     * <li><code>KinesisStreamAsSource</code> : The Firehose stream uses a Kinesis data stream as a source.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamType() {
        return null;
    }

    /**
     * The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-directputsourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-directputsourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDirectPutSourceConfiguration() {
        return null;
    }

    /**
     * An Amazon ES destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchDestinationConfiguration() {
        return null;
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExtendedS3DestinationConfiguration() {
        return null;
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     * <p>
     * You can specify only one destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpEndpointDestinationConfiguration() {
        return null;
    }

    /**
     * Specifies the destination configure settings for Apache Iceberg Table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIcebergDestinationConfiguration() {
        return null;
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSourceConfiguration() {
        return null;
    }

    /**
     * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMskSourceConfiguration() {
        return null;
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDestinationConfiguration() {
        return null;
    }

    /**
     * The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3DestinationConfiguration() {
        return null;
    }

    /**
     * Configure Snowflake destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflakeDestinationConfiguration() {
        return null;
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSplunkDestinationConfiguration() {
        return null;
    }

    /**
     * A set of tags to assign to the Firehose stream.
     * <p>
     * A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the Firehose stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
     * <p>
     * You can specify up to 50 tags when creating a Firehose stream.
     * <p>
     * If you specify tags in the <code>CreateDeliveryStream</code> action, Amazon Data Firehose performs an additional authorization on the <code>firehose:TagDeliveryStream</code> action to verify if users have permissions to create tags. If you do not provide this permission, requests to create new Firehose streams with IAM resource tags will fail with an <code>AccessDeniedException</code> such as following.
     * <p>
     * <em>AccessDeniedException</em>
     * <p>
     * User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform: firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in an identity-based policy.
     * <p>
     * For an example IAM policy, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples">Tag example.</a>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeliveryStreamProps> {
        java.lang.Object amazonOpenSearchServerlessDestinationConfiguration;
        java.lang.Object amazonopensearchserviceDestinationConfiguration;
        java.lang.Object databaseSourceConfiguration;
        java.lang.Object deliveryStreamEncryptionConfigurationInput;
        java.lang.String deliveryStreamName;
        java.lang.String deliveryStreamType;
        java.lang.Object directPutSourceConfiguration;
        java.lang.Object elasticsearchDestinationConfiguration;
        java.lang.Object extendedS3DestinationConfiguration;
        java.lang.Object httpEndpointDestinationConfiguration;
        java.lang.Object icebergDestinationConfiguration;
        java.lang.Object kinesisStreamSourceConfiguration;
        java.lang.Object mskSourceConfiguration;
        java.lang.Object redshiftDestinationConfiguration;
        java.lang.Object s3DestinationConfiguration;
        java.lang.Object snowflakeDestinationConfiguration;
        java.lang.Object splunkDestinationConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getAmazonOpenSearchServerlessDestinationConfiguration}
         * @param amazonOpenSearchServerlessDestinationConfiguration Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonOpenSearchServerlessDestinationConfiguration(software.amazon.awscdk.IResolvable amazonOpenSearchServerlessDestinationConfiguration) {
            this.amazonOpenSearchServerlessDestinationConfiguration = amazonOpenSearchServerlessDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getAmazonOpenSearchServerlessDestinationConfiguration}
         * @param amazonOpenSearchServerlessDestinationConfiguration Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonOpenSearchServerlessDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessDestinationConfigurationProperty amazonOpenSearchServerlessDestinationConfiguration) {
            this.amazonOpenSearchServerlessDestinationConfiguration = amazonOpenSearchServerlessDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getAmazonopensearchserviceDestinationConfiguration}
         * @param amazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service.
         *                                                        You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonopensearchserviceDestinationConfiguration(software.amazon.awscdk.IResolvable amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getAmazonopensearchserviceDestinationConfiguration}
         * @param amazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service.
         *                                                        You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonopensearchserviceDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDatabaseSourceConfiguration}
         * @param databaseSourceConfiguration The top level object for configuring streams with database as a source.
         *                                    Amazon Data Firehose is in preview release and is subject to change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseSourceConfiguration(software.amazon.awscdk.IResolvable databaseSourceConfiguration) {
            this.databaseSourceConfiguration = databaseSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDatabaseSourceConfiguration}
         * @param databaseSourceConfiguration The top level object for configuring streams with database as a source.
         *                                    Amazon Data Firehose is in preview release and is subject to change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseSourceConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabaseSourceConfigurationProperty databaseSourceConfiguration) {
            this.databaseSourceConfiguration = databaseSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamEncryptionConfigurationInput}
         * @param deliveryStreamEncryptionConfigurationInput Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamEncryptionConfigurationInput(software.amazon.awscdk.IResolvable deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamEncryptionConfigurationInput}
         * @param deliveryStreamEncryptionConfigurationInput Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamEncryptionConfigurationInput(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamName}
         * @param deliveryStreamName The name of the Firehose stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamType}
         * @param deliveryStreamType The Firehose stream type. This can be one of the following values:.
         *                           <ul>
         *                           <li><code>DirectPut</code> : Provider applications access the Firehose stream directly.</li>
         *                           <li><code>KinesisStreamAsSource</code> : The Firehose stream uses a Kinesis data stream as a source.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamType(java.lang.String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDirectPutSourceConfiguration}
         * @param directPutSourceConfiguration The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directPutSourceConfiguration(software.amazon.awscdk.IResolvable directPutSourceConfiguration) {
            this.directPutSourceConfiguration = directPutSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDirectPutSourceConfiguration}
         * @param directPutSourceConfiguration The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directPutSourceConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DirectPutSourceConfigurationProperty directPutSourceConfiguration) {
            this.directPutSourceConfiguration = directPutSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getElasticsearchDestinationConfiguration}
         * @param elasticsearchDestinationConfiguration An Amazon ES destination for the delivery stream.
         *                                              Conditional. You must specify only one destination configuration.
         *                                              <p>
         *                                              If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchDestinationConfiguration(software.amazon.awscdk.IResolvable elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getElasticsearchDestinationConfiguration}
         * @param elasticsearchDestinationConfiguration An Amazon ES destination for the delivery stream.
         *                                              Conditional. You must specify only one destination configuration.
         *                                              <p>
         *                                              If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getExtendedS3DestinationConfiguration}
         * @param extendedS3DestinationConfiguration An Amazon S3 destination for the delivery stream.
         *                                           Conditional. You must specify only one destination configuration.
         *                                           <p>
         *                                           If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(software.amazon.awscdk.IResolvable extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getExtendedS3DestinationConfiguration}
         * @param extendedS3DestinationConfiguration An Amazon S3 destination for the delivery stream.
         *                                           Conditional. You must specify only one destination configuration.
         *                                           <p>
         *                                           If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getHttpEndpointDestinationConfiguration}
         * @param httpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
         *                                             You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpointDestinationConfiguration(software.amazon.awscdk.IResolvable httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getHttpEndpointDestinationConfiguration}
         * @param httpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
         *                                             You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpointDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getIcebergDestinationConfiguration}
         * @param icebergDestinationConfiguration Specifies the destination configure settings for Apache Iceberg Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder icebergDestinationConfiguration(software.amazon.awscdk.IResolvable icebergDestinationConfiguration) {
            this.icebergDestinationConfiguration = icebergDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getIcebergDestinationConfiguration}
         * @param icebergDestinationConfiguration Specifies the destination configure settings for Apache Iceberg Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder icebergDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.IcebergDestinationConfigurationProperty icebergDestinationConfiguration) {
            this.icebergDestinationConfiguration = icebergDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getKinesisStreamSourceConfiguration}
         * @param kinesisStreamSourceConfiguration When a Kinesis stream is used as the source for the delivery stream, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSourceConfiguration(software.amazon.awscdk.IResolvable kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getKinesisStreamSourceConfiguration}
         * @param kinesisStreamSourceConfiguration When a Kinesis stream is used as the source for the delivery stream, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSourceConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getMskSourceConfiguration}
         * @param mskSourceConfiguration The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mskSourceConfiguration(software.amazon.awscdk.IResolvable mskSourceConfiguration) {
            this.mskSourceConfiguration = mskSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getMskSourceConfiguration}
         * @param mskSourceConfiguration The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mskSourceConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.MSKSourceConfigurationProperty mskSourceConfiguration) {
            this.mskSourceConfiguration = mskSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getRedshiftDestinationConfiguration}
         * @param redshiftDestinationConfiguration An Amazon Redshift destination for the delivery stream.
         *                                         Conditional. You must specify only one destination configuration.
         *                                         <p>
         *                                         If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftDestinationConfiguration(software.amazon.awscdk.IResolvable redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getRedshiftDestinationConfiguration}
         * @param redshiftDestinationConfiguration An Amazon Redshift destination for the delivery stream.
         *                                         Conditional. You must specify only one destination configuration.
         *                                         <p>
         *                                         If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getS3DestinationConfiguration}
         * @param s3DestinationConfiguration The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
         *                                   Conditional. You must specify only one destination configuration.
         *                                   <p>
         *                                   If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DestinationConfiguration(software.amazon.awscdk.IResolvable s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getS3DestinationConfiguration}
         * @param s3DestinationConfiguration The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
         *                                   Conditional. You must specify only one destination configuration.
         *                                   <p>
         *                                   If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getSnowflakeDestinationConfiguration}
         * @param snowflakeDestinationConfiguration Configure Snowflake destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snowflakeDestinationConfiguration(software.amazon.awscdk.IResolvable snowflakeDestinationConfiguration) {
            this.snowflakeDestinationConfiguration = snowflakeDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getSnowflakeDestinationConfiguration}
         * @param snowflakeDestinationConfiguration Configure Snowflake destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snowflakeDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SnowflakeDestinationConfigurationProperty snowflakeDestinationConfiguration) {
            this.snowflakeDestinationConfiguration = snowflakeDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getSplunkDestinationConfiguration}
         * @param splunkDestinationConfiguration The configuration of a destination in Splunk for the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splunkDestinationConfiguration(software.amazon.awscdk.IResolvable splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getSplunkDestinationConfiguration}
         * @param splunkDestinationConfiguration The configuration of a destination in Splunk for the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splunkDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getTags}
         * @param tags A set of tags to assign to the Firehose stream.
         *             A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the Firehose stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
         *             <p>
         *             You can specify up to 50 tags when creating a Firehose stream.
         *             <p>
         *             If you specify tags in the <code>CreateDeliveryStream</code> action, Amazon Data Firehose performs an additional authorization on the <code>firehose:TagDeliveryStream</code> action to verify if users have permissions to create tags. If you do not provide this permission, requests to create new Firehose streams with IAM resource tags will fail with an <code>AccessDeniedException</code> such as following.
         *             <p>
         *             <em>AccessDeniedException</em>
         *             <p>
         *             User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform: firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in an identity-based policy.
         *             <p>
         *             For an example IAM policy, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples">Tag example.</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeliveryStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeliveryStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeliveryStreamProps {
        private final java.lang.Object amazonOpenSearchServerlessDestinationConfiguration;
        private final java.lang.Object amazonopensearchserviceDestinationConfiguration;
        private final java.lang.Object databaseSourceConfiguration;
        private final java.lang.Object deliveryStreamEncryptionConfigurationInput;
        private final java.lang.String deliveryStreamName;
        private final java.lang.String deliveryStreamType;
        private final java.lang.Object directPutSourceConfiguration;
        private final java.lang.Object elasticsearchDestinationConfiguration;
        private final java.lang.Object extendedS3DestinationConfiguration;
        private final java.lang.Object httpEndpointDestinationConfiguration;
        private final java.lang.Object icebergDestinationConfiguration;
        private final java.lang.Object kinesisStreamSourceConfiguration;
        private final java.lang.Object mskSourceConfiguration;
        private final java.lang.Object redshiftDestinationConfiguration;
        private final java.lang.Object s3DestinationConfiguration;
        private final java.lang.Object snowflakeDestinationConfiguration;
        private final java.lang.Object splunkDestinationConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.amazonOpenSearchServerlessDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "amazonOpenSearchServerlessDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.amazonopensearchserviceDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "amazonopensearchserviceDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.databaseSourceConfiguration = software.amazon.jsii.Kernel.get(this, "databaseSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryStreamEncryptionConfigurationInput = software.amazon.jsii.Kernel.get(this, "deliveryStreamEncryptionConfigurationInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryStreamType = software.amazon.jsii.Kernel.get(this, "deliveryStreamType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directPutSourceConfiguration = software.amazon.jsii.Kernel.get(this, "directPutSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "elasticsearchDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.extendedS3DestinationConfiguration = software.amazon.jsii.Kernel.get(this, "extendedS3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.httpEndpointDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "httpEndpointDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.icebergDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "icebergDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisStreamSourceConfiguration = software.amazon.jsii.Kernel.get(this, "kinesisStreamSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mskSourceConfiguration = software.amazon.jsii.Kernel.get(this, "mskSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redshiftDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "redshiftDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3DestinationConfiguration = software.amazon.jsii.Kernel.get(this, "s3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snowflakeDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "snowflakeDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.splunkDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "splunkDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.amazonOpenSearchServerlessDestinationConfiguration = builder.amazonOpenSearchServerlessDestinationConfiguration;
            this.amazonopensearchserviceDestinationConfiguration = builder.amazonopensearchserviceDestinationConfiguration;
            this.databaseSourceConfiguration = builder.databaseSourceConfiguration;
            this.deliveryStreamEncryptionConfigurationInput = builder.deliveryStreamEncryptionConfigurationInput;
            this.deliveryStreamName = builder.deliveryStreamName;
            this.deliveryStreamType = builder.deliveryStreamType;
            this.directPutSourceConfiguration = builder.directPutSourceConfiguration;
            this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
            this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
            this.httpEndpointDestinationConfiguration = builder.httpEndpointDestinationConfiguration;
            this.icebergDestinationConfiguration = builder.icebergDestinationConfiguration;
            this.kinesisStreamSourceConfiguration = builder.kinesisStreamSourceConfiguration;
            this.mskSourceConfiguration = builder.mskSourceConfiguration;
            this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
            this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
            this.snowflakeDestinationConfiguration = builder.snowflakeDestinationConfiguration;
            this.splunkDestinationConfiguration = builder.splunkDestinationConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAmazonOpenSearchServerlessDestinationConfiguration() {
            return this.amazonOpenSearchServerlessDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getAmazonopensearchserviceDestinationConfiguration() {
            return this.amazonopensearchserviceDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getDatabaseSourceConfiguration() {
            return this.databaseSourceConfiguration;
        }

        @Override
        public final java.lang.Object getDeliveryStreamEncryptionConfigurationInput() {
            return this.deliveryStreamEncryptionConfigurationInput;
        }

        @Override
        public final java.lang.String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final java.lang.String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        @Override
        public final java.lang.Object getDirectPutSourceConfiguration() {
            return this.directPutSourceConfiguration;
        }

        @Override
        public final java.lang.Object getElasticsearchDestinationConfiguration() {
            return this.elasticsearchDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getExtendedS3DestinationConfiguration() {
            return this.extendedS3DestinationConfiguration;
        }

        @Override
        public final java.lang.Object getHttpEndpointDestinationConfiguration() {
            return this.httpEndpointDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getIcebergDestinationConfiguration() {
            return this.icebergDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getKinesisStreamSourceConfiguration() {
            return this.kinesisStreamSourceConfiguration;
        }

        @Override
        public final java.lang.Object getMskSourceConfiguration() {
            return this.mskSourceConfiguration;
        }

        @Override
        public final java.lang.Object getRedshiftDestinationConfiguration() {
            return this.redshiftDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getS3DestinationConfiguration() {
            return this.s3DestinationConfiguration;
        }

        @Override
        public final java.lang.Object getSnowflakeDestinationConfiguration() {
            return this.snowflakeDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getSplunkDestinationConfiguration() {
            return this.splunkDestinationConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAmazonOpenSearchServerlessDestinationConfiguration() != null) {
                data.set("amazonOpenSearchServerlessDestinationConfiguration", om.valueToTree(this.getAmazonOpenSearchServerlessDestinationConfiguration()));
            }
            if (this.getAmazonopensearchserviceDestinationConfiguration() != null) {
                data.set("amazonopensearchserviceDestinationConfiguration", om.valueToTree(this.getAmazonopensearchserviceDestinationConfiguration()));
            }
            if (this.getDatabaseSourceConfiguration() != null) {
                data.set("databaseSourceConfiguration", om.valueToTree(this.getDatabaseSourceConfiguration()));
            }
            if (this.getDeliveryStreamEncryptionConfigurationInput() != null) {
                data.set("deliveryStreamEncryptionConfigurationInput", om.valueToTree(this.getDeliveryStreamEncryptionConfigurationInput()));
            }
            if (this.getDeliveryStreamName() != null) {
                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
            }
            if (this.getDeliveryStreamType() != null) {
                data.set("deliveryStreamType", om.valueToTree(this.getDeliveryStreamType()));
            }
            if (this.getDirectPutSourceConfiguration() != null) {
                data.set("directPutSourceConfiguration", om.valueToTree(this.getDirectPutSourceConfiguration()));
            }
            if (this.getElasticsearchDestinationConfiguration() != null) {
                data.set("elasticsearchDestinationConfiguration", om.valueToTree(this.getElasticsearchDestinationConfiguration()));
            }
            if (this.getExtendedS3DestinationConfiguration() != null) {
                data.set("extendedS3DestinationConfiguration", om.valueToTree(this.getExtendedS3DestinationConfiguration()));
            }
            if (this.getHttpEndpointDestinationConfiguration() != null) {
                data.set("httpEndpointDestinationConfiguration", om.valueToTree(this.getHttpEndpointDestinationConfiguration()));
            }
            if (this.getIcebergDestinationConfiguration() != null) {
                data.set("icebergDestinationConfiguration", om.valueToTree(this.getIcebergDestinationConfiguration()));
            }
            if (this.getKinesisStreamSourceConfiguration() != null) {
                data.set("kinesisStreamSourceConfiguration", om.valueToTree(this.getKinesisStreamSourceConfiguration()));
            }
            if (this.getMskSourceConfiguration() != null) {
                data.set("mskSourceConfiguration", om.valueToTree(this.getMskSourceConfiguration()));
            }
            if (this.getRedshiftDestinationConfiguration() != null) {
                data.set("redshiftDestinationConfiguration", om.valueToTree(this.getRedshiftDestinationConfiguration()));
            }
            if (this.getS3DestinationConfiguration() != null) {
                data.set("s3DestinationConfiguration", om.valueToTree(this.getS3DestinationConfiguration()));
            }
            if (this.getSnowflakeDestinationConfiguration() != null) {
                data.set("snowflakeDestinationConfiguration", om.valueToTree(this.getSnowflakeDestinationConfiguration()));
            }
            if (this.getSplunkDestinationConfiguration() != null) {
                data.set("splunkDestinationConfiguration", om.valueToTree(this.getSplunkDestinationConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeliveryStreamProps.Jsii$Proxy that = (CfnDeliveryStreamProps.Jsii$Proxy) o;

            if (this.amazonOpenSearchServerlessDestinationConfiguration != null ? !this.amazonOpenSearchServerlessDestinationConfiguration.equals(that.amazonOpenSearchServerlessDestinationConfiguration) : that.amazonOpenSearchServerlessDestinationConfiguration != null) return false;
            if (this.amazonopensearchserviceDestinationConfiguration != null ? !this.amazonopensearchserviceDestinationConfiguration.equals(that.amazonopensearchserviceDestinationConfiguration) : that.amazonopensearchserviceDestinationConfiguration != null) return false;
            if (this.databaseSourceConfiguration != null ? !this.databaseSourceConfiguration.equals(that.databaseSourceConfiguration) : that.databaseSourceConfiguration != null) return false;
            if (this.deliveryStreamEncryptionConfigurationInput != null ? !this.deliveryStreamEncryptionConfigurationInput.equals(that.deliveryStreamEncryptionConfigurationInput) : that.deliveryStreamEncryptionConfigurationInput != null) return false;
            if (this.deliveryStreamName != null ? !this.deliveryStreamName.equals(that.deliveryStreamName) : that.deliveryStreamName != null) return false;
            if (this.deliveryStreamType != null ? !this.deliveryStreamType.equals(that.deliveryStreamType) : that.deliveryStreamType != null) return false;
            if (this.directPutSourceConfiguration != null ? !this.directPutSourceConfiguration.equals(that.directPutSourceConfiguration) : that.directPutSourceConfiguration != null) return false;
            if (this.elasticsearchDestinationConfiguration != null ? !this.elasticsearchDestinationConfiguration.equals(that.elasticsearchDestinationConfiguration) : that.elasticsearchDestinationConfiguration != null) return false;
            if (this.extendedS3DestinationConfiguration != null ? !this.extendedS3DestinationConfiguration.equals(that.extendedS3DestinationConfiguration) : that.extendedS3DestinationConfiguration != null) return false;
            if (this.httpEndpointDestinationConfiguration != null ? !this.httpEndpointDestinationConfiguration.equals(that.httpEndpointDestinationConfiguration) : that.httpEndpointDestinationConfiguration != null) return false;
            if (this.icebergDestinationConfiguration != null ? !this.icebergDestinationConfiguration.equals(that.icebergDestinationConfiguration) : that.icebergDestinationConfiguration != null) return false;
            if (this.kinesisStreamSourceConfiguration != null ? !this.kinesisStreamSourceConfiguration.equals(that.kinesisStreamSourceConfiguration) : that.kinesisStreamSourceConfiguration != null) return false;
            if (this.mskSourceConfiguration != null ? !this.mskSourceConfiguration.equals(that.mskSourceConfiguration) : that.mskSourceConfiguration != null) return false;
            if (this.redshiftDestinationConfiguration != null ? !this.redshiftDestinationConfiguration.equals(that.redshiftDestinationConfiguration) : that.redshiftDestinationConfiguration != null) return false;
            if (this.s3DestinationConfiguration != null ? !this.s3DestinationConfiguration.equals(that.s3DestinationConfiguration) : that.s3DestinationConfiguration != null) return false;
            if (this.snowflakeDestinationConfiguration != null ? !this.snowflakeDestinationConfiguration.equals(that.snowflakeDestinationConfiguration) : that.snowflakeDestinationConfiguration != null) return false;
            if (this.splunkDestinationConfiguration != null ? !this.splunkDestinationConfiguration.equals(that.splunkDestinationConfiguration) : that.splunkDestinationConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.amazonOpenSearchServerlessDestinationConfiguration != null ? this.amazonOpenSearchServerlessDestinationConfiguration.hashCode() : 0;
            result = 31 * result + (this.amazonopensearchserviceDestinationConfiguration != null ? this.amazonopensearchserviceDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.databaseSourceConfiguration != null ? this.databaseSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.deliveryStreamEncryptionConfigurationInput != null ? this.deliveryStreamEncryptionConfigurationInput.hashCode() : 0);
            result = 31 * result + (this.deliveryStreamName != null ? this.deliveryStreamName.hashCode() : 0);
            result = 31 * result + (this.deliveryStreamType != null ? this.deliveryStreamType.hashCode() : 0);
            result = 31 * result + (this.directPutSourceConfiguration != null ? this.directPutSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.elasticsearchDestinationConfiguration != null ? this.elasticsearchDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.httpEndpointDestinationConfiguration != null ? this.httpEndpointDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.icebergDestinationConfiguration != null ? this.icebergDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.kinesisStreamSourceConfiguration != null ? this.kinesisStreamSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.mskSourceConfiguration != null ? this.mskSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.redshiftDestinationConfiguration != null ? this.redshiftDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.snowflakeDestinationConfiguration != null ? this.snowflakeDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.splunkDestinationConfiguration != null ? this.splunkDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
