package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Possible compression options Amazon Data Firehose can use to compress data on delivery.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Compress data delivered to S3 using Snappy
 * Bucket bucket;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .compression(Compression.SNAPPY)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:51.114Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.Compression")
public class Compression extends software.amazon.jsii.JsiiObject {

    protected Compression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Compression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        GZIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.Compression.class, "GZIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
        HADOOP_SNAPPY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.Compression.class, "HADOOP_SNAPPY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
        SNAPPY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.Compression.class, "SNAPPY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
        UNCOMPRESSED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.Compression.class, "UNCOMPRESSED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
        ZIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.Compression.class, "ZIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
    }

    /**
     * Creates a new Compression instance with a custom value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.Compression of(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.Compression.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * gzip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.Compression GZIP;

    /**
     * Hadoop-compatible Snappy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.Compression HADOOP_SNAPPY;

    /**
     * Snappy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.Compression SNAPPY;

    /**
     * Uncompressed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.Compression UNCOMPRESSED;

    /**
     * ZIP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.Compression ZIP;

    /**
     * the string value of the Compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
