package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnDelivery</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnDeliveryProps cfnDeliveryProps = CfnDeliveryProps.builder()
 *         .deliveryDestinationArn("deliveryDestinationArn")
 *         .deliverySourceName("deliverySourceName")
 *         // the properties below are optional
 *         .fieldDelimiter("fieldDelimiter")
 *         .recordFields(List.of("recordFields"))
 *         .s3EnableHiveCompatiblePath(false)
 *         .s3SuffixPath("s3SuffixPath")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:51.692Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnDeliveryProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeliveryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeliveryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the delivery destination that is associated with this delivery.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-deliverydestinationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-deliverydestinationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryDestinationArn();

    /**
     * The name of the delivery source that is associated with this delivery.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-deliverysourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-deliverysourcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliverySourceName();

    /**
     * The field delimiter that is used between record fields when the final output format of a delivery is in <code>Plain</code> , <code>W3C</code> , or <code>Raw</code> format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-fielddelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-fielddelimiter</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFieldDelimiter() {
        return null;
    }

    /**
     * The list of record fields to be delivered to the destination, in order.
     * <p>
     * If the delivery's log source has mandatory fields, they must be included in this list.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-recordfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-recordfields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRecordFields() {
        return null;
    }

    /**
     * Use this parameter to cause the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-s3enablehivecompatiblepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-s3enablehivecompatiblepath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3EnableHiveCompatiblePath() {
        return null;
    }

    /**
     * Use this to reconfigure the S3 object prefix to contain either static or variable sections.
     * <p>
     * The valid variables to use in the suffix path will vary by each log source. To find the values supported for the suffix path for each log source, use the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeConfigurationTemplates.html">DescribeConfigurationTemplates</a> operation and check the <code>allowedSuffixPathFields</code> field in the response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-s3suffixpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-s3suffixpath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3SuffixPath() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the delivery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-delivery.html#cfn-logs-delivery-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeliveryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeliveryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeliveryProps> {
        java.lang.String deliveryDestinationArn;
        java.lang.String deliverySourceName;
        java.lang.String fieldDelimiter;
        java.util.List<java.lang.String> recordFields;
        java.lang.Object s3EnableHiveCompatiblePath;
        java.lang.String s3SuffixPath;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDeliveryProps#getDeliveryDestinationArn}
         * @param deliveryDestinationArn The ARN of the delivery destination that is associated with this delivery. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryDestinationArn(java.lang.String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getDeliverySourceName}
         * @param deliverySourceName The name of the delivery source that is associated with this delivery. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverySourceName(java.lang.String deliverySourceName) {
            this.deliverySourceName = deliverySourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getFieldDelimiter}
         * @param fieldDelimiter The field delimiter that is used between record fields when the final output format of a delivery is in <code>Plain</code> , <code>W3C</code> , or <code>Raw</code> format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldDelimiter(java.lang.String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getRecordFields}
         * @param recordFields The list of record fields to be delivered to the destination, in order.
         *                     If the delivery's log source has mandatory fields, they must be included in this list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordFields(java.util.List<java.lang.String> recordFields) {
            this.recordFields = recordFields;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getS3EnableHiveCompatiblePath}
         * @param s3EnableHiveCompatiblePath Use this parameter to cause the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3EnableHiveCompatiblePath(java.lang.Boolean s3EnableHiveCompatiblePath) {
            this.s3EnableHiveCompatiblePath = s3EnableHiveCompatiblePath;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getS3EnableHiveCompatiblePath}
         * @param s3EnableHiveCompatiblePath Use this parameter to cause the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3EnableHiveCompatiblePath(software.amazon.awscdk.IResolvable s3EnableHiveCompatiblePath) {
            this.s3EnableHiveCompatiblePath = s3EnableHiveCompatiblePath;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getS3SuffixPath}
         * @param s3SuffixPath Use this to reconfigure the S3 object prefix to contain either static or variable sections.
         *                     The valid variables to use in the suffix path will vary by each log source. To find the values supported for the suffix path for each log source, use the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeConfigurationTemplates.html">DescribeConfigurationTemplates</a> operation and check the <code>allowedSuffixPathFields</code> field in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3SuffixPath(java.lang.String s3SuffixPath) {
            this.s3SuffixPath = s3SuffixPath;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryProps#getTags}
         * @param tags An array of key-value pairs to apply to the delivery.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeliveryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeliveryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeliveryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeliveryProps {
        private final java.lang.String deliveryDestinationArn;
        private final java.lang.String deliverySourceName;
        private final java.lang.String fieldDelimiter;
        private final java.util.List<java.lang.String> recordFields;
        private final java.lang.Object s3EnableHiveCompatiblePath;
        private final java.lang.String s3SuffixPath;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryDestinationArn = software.amazon.jsii.Kernel.get(this, "deliveryDestinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliverySourceName = software.amazon.jsii.Kernel.get(this, "deliverySourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fieldDelimiter = software.amazon.jsii.Kernel.get(this, "fieldDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordFields = software.amazon.jsii.Kernel.get(this, "recordFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.s3EnableHiveCompatiblePath = software.amazon.jsii.Kernel.get(this, "s3EnableHiveCompatiblePath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3SuffixPath = software.amazon.jsii.Kernel.get(this, "s3SuffixPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryDestinationArn = java.util.Objects.requireNonNull(builder.deliveryDestinationArn, "deliveryDestinationArn is required");
            this.deliverySourceName = java.util.Objects.requireNonNull(builder.deliverySourceName, "deliverySourceName is required");
            this.fieldDelimiter = builder.fieldDelimiter;
            this.recordFields = builder.recordFields;
            this.s3EnableHiveCompatiblePath = builder.s3EnableHiveCompatiblePath;
            this.s3SuffixPath = builder.s3SuffixPath;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDeliveryDestinationArn() {
            return this.deliveryDestinationArn;
        }

        @Override
        public final java.lang.String getDeliverySourceName() {
            return this.deliverySourceName;
        }

        @Override
        public final java.lang.String getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        @Override
        public final java.util.List<java.lang.String> getRecordFields() {
            return this.recordFields;
        }

        @Override
        public final java.lang.Object getS3EnableHiveCompatiblePath() {
            return this.s3EnableHiveCompatiblePath;
        }

        @Override
        public final java.lang.String getS3SuffixPath() {
            return this.s3SuffixPath;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deliveryDestinationArn", om.valueToTree(this.getDeliveryDestinationArn()));
            data.set("deliverySourceName", om.valueToTree(this.getDeliverySourceName()));
            if (this.getFieldDelimiter() != null) {
                data.set("fieldDelimiter", om.valueToTree(this.getFieldDelimiter()));
            }
            if (this.getRecordFields() != null) {
                data.set("recordFields", om.valueToTree(this.getRecordFields()));
            }
            if (this.getS3EnableHiveCompatiblePath() != null) {
                data.set("s3EnableHiveCompatiblePath", om.valueToTree(this.getS3EnableHiveCompatiblePath()));
            }
            if (this.getS3SuffixPath() != null) {
                data.set("s3SuffixPath", om.valueToTree(this.getS3SuffixPath()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnDeliveryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeliveryProps.Jsii$Proxy that = (CfnDeliveryProps.Jsii$Proxy) o;

            if (!deliveryDestinationArn.equals(that.deliveryDestinationArn)) return false;
            if (!deliverySourceName.equals(that.deliverySourceName)) return false;
            if (this.fieldDelimiter != null ? !this.fieldDelimiter.equals(that.fieldDelimiter) : that.fieldDelimiter != null) return false;
            if (this.recordFields != null ? !this.recordFields.equals(that.recordFields) : that.recordFields != null) return false;
            if (this.s3EnableHiveCompatiblePath != null ? !this.s3EnableHiveCompatiblePath.equals(that.s3EnableHiveCompatiblePath) : that.s3EnableHiveCompatiblePath != null) return false;
            if (this.s3SuffixPath != null ? !this.s3SuffixPath.equals(that.s3SuffixPath) : that.s3SuffixPath != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryDestinationArn.hashCode();
            result = 31 * result + (this.deliverySourceName.hashCode());
            result = 31 * result + (this.fieldDelimiter != null ? this.fieldDelimiter.hashCode() : 0);
            result = 31 * result + (this.recordFields != null ? this.recordFields.hashCode() : 0);
            result = 31 * result + (this.s3EnableHiveCompatiblePath != null ? this.s3EnableHiveCompatiblePath.hashCode() : 0);
            result = 31 * result + (this.s3SuffixPath != null ? this.s3SuffixPath.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
