package software.amazon.awscdk.services.mediaconnect;

/**
 * The <code>AWS::MediaConnect::Bridge</code> resource defines a connection between your data center’s gateway instances and the cloud.
 * <p>
 * For each bridge, you specify the type of bridge, transport protocol to use, and details for any outputs and failover.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnBridge cfnBridge = CfnBridge.Builder.create(this, "MyCfnBridge")
 *         .name("name")
 *         .placementArn("placementArn")
 *         .sources(List.of(BridgeSourceProperty.builder()
 *                 .flowSource(BridgeFlowSourceProperty.builder()
 *                         .flowArn("flowArn")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .flowVpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                                 .vpcInterfaceName("vpcInterfaceName")
 *                                 .build())
 *                         .build())
 *                 .networkSource(BridgeNetworkSourceProperty.builder()
 *                         .multicastIp("multicastIp")
 *                         .name("name")
 *                         .networkName("networkName")
 *                         .port(123)
 *                         .protocol("protocol")
 *                         // the properties below are optional
 *                         .multicastSourceSettings(MulticastSourceSettingsProperty.builder()
 *                                 .multicastSourceIp("multicastSourceIp")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .egressGatewayBridge(EgressGatewayBridgeProperty.builder()
 *                 .maxBitrate(123)
 *                 .build())
 *         .ingressGatewayBridge(IngressGatewayBridgeProperty.builder()
 *                 .maxBitrate(123)
 *                 .maxOutputs(123)
 *                 .build())
 *         .outputs(List.of(BridgeOutputProperty.builder()
 *                 .networkOutput(BridgeNetworkOutputProperty.builder()
 *                         .ipAddress("ipAddress")
 *                         .name("name")
 *                         .networkName("networkName")
 *                         .port(123)
 *                         .protocol("protocol")
 *                         .ttl(123)
 *                         .build())
 *                 .build()))
 *         .sourceFailoverConfig(FailoverConfigProperty.builder()
 *                 .failoverMode("failoverMode")
 *                 // the properties below are optional
 *                 .sourcePriority(SourcePriorityProperty.builder()
 *                         .primarySource("primarySource")
 *                         .build())
 *                 .state("state")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:51.842Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge")
public class CfnBridge extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnBridge(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBridge(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnBridge.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBridge(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnBridgeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBridgeArn() {
        return software.amazon.jsii.Kernel.get(this, "attrBridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the bridge.
     * <p>
     * Possible values are: ACTIVE or STANDBY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBridgeState() {
        return software.amazon.jsii.Kernel.get(this, "attrBridgeState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The bridge placement Amazon Resource Number (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPlacementArn() {
        return software.amazon.jsii.Kernel.get(this, "placementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The bridge placement Amazon Resource Number (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "placementArn", java.util.Objects.requireNonNull(value, "placementArn is required"));
    }

    /**
     * The sources that you want to add to this bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSources() {
        return software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The sources that you want to add to this bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sources", java.util.Objects.requireNonNull(value, "sources is required"));
    }

    /**
     * The sources that you want to add to this bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSources(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sources", java.util.Objects.requireNonNull(value, "sources is required"));
    }

    /**
     * An egress bridge is a cloud-to-ground bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEgressGatewayBridge() {
        return software.amazon.jsii.Kernel.get(this, "egressGatewayBridge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An egress bridge is a cloud-to-ground bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEgressGatewayBridge(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "egressGatewayBridge", value);
    }

    /**
     * An egress bridge is a cloud-to-ground bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEgressGatewayBridge(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnBridge.EgressGatewayBridgeProperty value) {
        software.amazon.jsii.Kernel.set(this, "egressGatewayBridge", value);
    }

    /**
     * An ingress bridge is a ground-to-cloud bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIngressGatewayBridge() {
        return software.amazon.jsii.Kernel.get(this, "ingressGatewayBridge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An ingress bridge is a ground-to-cloud bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngressGatewayBridge(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ingressGatewayBridge", value);
    }

    /**
     * An ingress bridge is a ground-to-cloud bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngressGatewayBridge(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnBridge.IngressGatewayBridgeProperty value) {
        software.amazon.jsii.Kernel.set(this, "ingressGatewayBridge", value);
    }

    /**
     * The outputs that you want to add to this bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The outputs that you want to add to this bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputs", value);
    }

    /**
     * The outputs that you want to add to this bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeOutputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeOutputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "outputs", value);
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceFailoverConfig() {
        return software.amazon.jsii.Kernel.get(this, "sourceFailoverConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFailoverConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceFailoverConfig", value);
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFailoverConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnBridge.FailoverConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceFailoverConfig", value);
    }
    /**
     * The source of the bridge.
     * <p>
     * A flow source originates in MediaConnect as an existing cloud flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * BridgeFlowSourceProperty bridgeFlowSourceProperty = BridgeFlowSourceProperty.builder()
     *         .flowArn("flowArn")
     *         .name("name")
     *         // the properties below are optional
     *         .flowVpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
     *                 .vpcInterfaceName("vpcInterfaceName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeFlowSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(BridgeFlowSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BridgeFlowSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the cloud flow used as a source of this bridge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html#cfn-mediaconnect-bridge-bridgeflowsource-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html#cfn-mediaconnect-bridge-bridgeflowsource-flowarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFlowArn();

        /**
         * The name of the flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html#cfn-mediaconnect-bridge-bridgeflowsource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html#cfn-mediaconnect-bridge-bridgeflowsource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the VPC interface attachment to use for this source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html#cfn-mediaconnect-bridge-bridgeflowsource-flowvpcinterfaceattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeflowsource.html#cfn-mediaconnect-bridge-bridgeflowsource-flowvpcinterfaceattachment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFlowVpcInterfaceAttachment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BridgeFlowSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BridgeFlowSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BridgeFlowSourceProperty> {
            java.lang.String flowArn;
            java.lang.String name;
            java.lang.Object flowVpcInterfaceAttachment;

            /**
             * Sets the value of {@link BridgeFlowSourceProperty#getFlowArn}
             * @param flowArn The ARN of the cloud flow used as a source of this bridge. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowArn(java.lang.String flowArn) {
                this.flowArn = flowArn;
                return this;
            }

            /**
             * Sets the value of {@link BridgeFlowSourceProperty#getName}
             * @param name The name of the flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BridgeFlowSourceProperty#getFlowVpcInterfaceAttachment}
             * @param flowVpcInterfaceAttachment The name of the VPC interface attachment to use for this source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowVpcInterfaceAttachment(software.amazon.awscdk.IResolvable flowVpcInterfaceAttachment) {
                this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
                return this;
            }

            /**
             * Sets the value of {@link BridgeFlowSourceProperty#getFlowVpcInterfaceAttachment}
             * @param flowVpcInterfaceAttachment The name of the VPC interface attachment to use for this source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowVpcInterfaceAttachment(software.amazon.awscdk.services.mediaconnect.CfnBridge.VpcInterfaceAttachmentProperty flowVpcInterfaceAttachment) {
                this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BridgeFlowSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BridgeFlowSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BridgeFlowSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeFlowSourceProperty {
            private final java.lang.String flowArn;
            private final java.lang.String name;
            private final java.lang.Object flowVpcInterfaceAttachment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.flowVpcInterfaceAttachment = software.amazon.jsii.Kernel.get(this, "flowVpcInterfaceAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.flowArn = java.util.Objects.requireNonNull(builder.flowArn, "flowArn is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.flowVpcInterfaceAttachment = builder.flowVpcInterfaceAttachment;
            }

            @Override
            public final java.lang.String getFlowArn() {
                return this.flowArn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getFlowVpcInterfaceAttachment() {
                return this.flowVpcInterfaceAttachment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("flowArn", om.valueToTree(this.getFlowArn()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getFlowVpcInterfaceAttachment() != null) {
                    data.set("flowVpcInterfaceAttachment", om.valueToTree(this.getFlowVpcInterfaceAttachment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeFlowSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BridgeFlowSourceProperty.Jsii$Proxy that = (BridgeFlowSourceProperty.Jsii$Proxy) o;

                if (!flowArn.equals(that.flowArn)) return false;
                if (!name.equals(that.name)) return false;
                return this.flowVpcInterfaceAttachment != null ? this.flowVpcInterfaceAttachment.equals(that.flowVpcInterfaceAttachment) : that.flowVpcInterfaceAttachment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.flowArn.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.flowVpcInterfaceAttachment != null ? this.flowVpcInterfaceAttachment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The output of the bridge.
     * <p>
     * A network output is delivered to your premises.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * BridgeNetworkOutputProperty bridgeNetworkOutputProperty = BridgeNetworkOutputProperty.builder()
     *         .ipAddress("ipAddress")
     *         .name("name")
     *         .networkName("networkName")
     *         .port(123)
     *         .protocol("protocol")
     *         .ttl(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeNetworkOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(BridgeNetworkOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BridgeNetworkOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The network output IP address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-ipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-ipaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpAddress();

        /**
         * The network output name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The network output's gateway network name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-networkname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-networkname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNetworkName();

        /**
         * The network output's port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The network output protocol.
         * <p>
         * <blockquote>
         * <p>
         * AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * The network output TTL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-ttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworkoutput.html#cfn-mediaconnect-bridge-bridgenetworkoutput-ttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTtl();

        /**
         * @return a {@link Builder} of {@link BridgeNetworkOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BridgeNetworkOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BridgeNetworkOutputProperty> {
            java.lang.String ipAddress;
            java.lang.String name;
            java.lang.String networkName;
            java.lang.Number port;
            java.lang.String protocol;
            java.lang.Number ttl;

            /**
             * Sets the value of {@link BridgeNetworkOutputProperty#getIpAddress}
             * @param ipAddress The network output IP address. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddress(java.lang.String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkOutputProperty#getName}
             * @param name The network output name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkOutputProperty#getNetworkName}
             * @param networkName The network output's gateway network name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkName(java.lang.String networkName) {
                this.networkName = networkName;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkOutputProperty#getPort}
             * @param port The network output's port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkOutputProperty#getProtocol}
             * @param protocol The network output protocol. This parameter is required.
             *                 <blockquote>
             *                 <p>
             *                 AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkOutputProperty#getTtl}
             * @param ttl The network output TTL. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttl(java.lang.Number ttl) {
                this.ttl = ttl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BridgeNetworkOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BridgeNetworkOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BridgeNetworkOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeNetworkOutputProperty {
            private final java.lang.String ipAddress;
            private final java.lang.String name;
            private final java.lang.String networkName;
            private final java.lang.Number port;
            private final java.lang.String protocol;
            private final java.lang.Number ttl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkName = software.amazon.jsii.Kernel.get(this, "networkName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipAddress = java.util.Objects.requireNonNull(builder.ipAddress, "ipAddress is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.networkName = java.util.Objects.requireNonNull(builder.networkName, "networkName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.ttl = java.util.Objects.requireNonNull(builder.ttl, "ttl is required");
            }

            @Override
            public final java.lang.String getIpAddress() {
                return this.ipAddress;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNetworkName() {
                return this.networkName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getTtl() {
                return this.ttl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipAddress", om.valueToTree(this.getIpAddress()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("networkName", om.valueToTree(this.getNetworkName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("ttl", om.valueToTree(this.getTtl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeNetworkOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BridgeNetworkOutputProperty.Jsii$Proxy that = (BridgeNetworkOutputProperty.Jsii$Proxy) o;

                if (!ipAddress.equals(that.ipAddress)) return false;
                if (!name.equals(that.name)) return false;
                if (!networkName.equals(that.networkName)) return false;
                if (!port.equals(that.port)) return false;
                if (!protocol.equals(that.protocol)) return false;
                return this.ttl.equals(that.ttl);
            }

            @Override
            public final int hashCode() {
                int result = this.ipAddress.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.networkName.hashCode());
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.ttl.hashCode());
                return result;
            }
        }
    }
    /**
     * The source of the bridge.
     * <p>
     * A network source originates at your premises.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * BridgeNetworkSourceProperty bridgeNetworkSourceProperty = BridgeNetworkSourceProperty.builder()
     *         .multicastIp("multicastIp")
     *         .name("name")
     *         .networkName("networkName")
     *         .port(123)
     *         .protocol("protocol")
     *         // the properties below are optional
     *         .multicastSourceSettings(MulticastSourceSettingsProperty.builder()
     *                 .multicastSourceIp("multicastSourceIp")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeNetworkSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(BridgeNetworkSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BridgeNetworkSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The network source multicast IP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-multicastip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-multicastip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMulticastIp();

        /**
         * The name of the network source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The network source's gateway network name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-networkname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-networkname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNetworkName();

        /**
         * The network source port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The network source protocol.
         * <p>
         * <blockquote>
         * <p>
         * AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * The settings related to the multicast source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-multicastsourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgenetworksource.html#cfn-mediaconnect-bridge-bridgenetworksource-multicastsourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMulticastSourceSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BridgeNetworkSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BridgeNetworkSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BridgeNetworkSourceProperty> {
            java.lang.String multicastIp;
            java.lang.String name;
            java.lang.String networkName;
            java.lang.Number port;
            java.lang.String protocol;
            java.lang.Object multicastSourceSettings;

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getMulticastIp}
             * @param multicastIp The network source multicast IP. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multicastIp(java.lang.String multicastIp) {
                this.multicastIp = multicastIp;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getName}
             * @param name The name of the network source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getNetworkName}
             * @param networkName The network source's gateway network name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkName(java.lang.String networkName) {
                this.networkName = networkName;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getPort}
             * @param port The network source port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getProtocol}
             * @param protocol The network source protocol. This parameter is required.
             *                 <blockquote>
             *                 <p>
             *                 AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getMulticastSourceSettings}
             * @param multicastSourceSettings The settings related to the multicast source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multicastSourceSettings(software.amazon.awscdk.IResolvable multicastSourceSettings) {
                this.multicastSourceSettings = multicastSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link BridgeNetworkSourceProperty#getMulticastSourceSettings}
             * @param multicastSourceSettings The settings related to the multicast source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multicastSourceSettings(software.amazon.awscdk.services.mediaconnect.CfnBridge.MulticastSourceSettingsProperty multicastSourceSettings) {
                this.multicastSourceSettings = multicastSourceSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BridgeNetworkSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BridgeNetworkSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BridgeNetworkSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeNetworkSourceProperty {
            private final java.lang.String multicastIp;
            private final java.lang.String name;
            private final java.lang.String networkName;
            private final java.lang.Number port;
            private final java.lang.String protocol;
            private final java.lang.Object multicastSourceSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.multicastIp = software.amazon.jsii.Kernel.get(this, "multicastIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkName = software.amazon.jsii.Kernel.get(this, "networkName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.multicastSourceSettings = software.amazon.jsii.Kernel.get(this, "multicastSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.multicastIp = java.util.Objects.requireNonNull(builder.multicastIp, "multicastIp is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.networkName = java.util.Objects.requireNonNull(builder.networkName, "networkName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.multicastSourceSettings = builder.multicastSourceSettings;
            }

            @Override
            public final java.lang.String getMulticastIp() {
                return this.multicastIp;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNetworkName() {
                return this.networkName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Object getMulticastSourceSettings() {
                return this.multicastSourceSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("multicastIp", om.valueToTree(this.getMulticastIp()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("networkName", om.valueToTree(this.getNetworkName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                if (this.getMulticastSourceSettings() != null) {
                    data.set("multicastSourceSettings", om.valueToTree(this.getMulticastSourceSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeNetworkSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BridgeNetworkSourceProperty.Jsii$Proxy that = (BridgeNetworkSourceProperty.Jsii$Proxy) o;

                if (!multicastIp.equals(that.multicastIp)) return false;
                if (!name.equals(that.name)) return false;
                if (!networkName.equals(that.networkName)) return false;
                if (!port.equals(that.port)) return false;
                if (!protocol.equals(that.protocol)) return false;
                return this.multicastSourceSettings != null ? this.multicastSourceSettings.equals(that.multicastSourceSettings) : that.multicastSourceSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.multicastIp.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.networkName.hashCode());
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.multicastSourceSettings != null ? this.multicastSourceSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The output of the bridge.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * BridgeOutputProperty bridgeOutputProperty = BridgeOutputProperty.builder()
     *         .networkOutput(BridgeNetworkOutputProperty.builder()
     *                 .ipAddress("ipAddress")
     *                 .name("name")
     *                 .networkName("networkName")
     *                 .port(123)
     *                 .protocol("protocol")
     *                 .ttl(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(BridgeOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BridgeOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The output of the bridge.
         * <p>
         * A network output is delivered to your premises.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeoutput.html#cfn-mediaconnect-bridge-bridgeoutput-networkoutput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgeoutput.html#cfn-mediaconnect-bridge-bridgeoutput-networkoutput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkOutput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BridgeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BridgeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BridgeOutputProperty> {
            java.lang.Object networkOutput;

            /**
             * Sets the value of {@link BridgeOutputProperty#getNetworkOutput}
             * @param networkOutput The output of the bridge.
             *                      A network output is delivered to your premises.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkOutput(software.amazon.awscdk.IResolvable networkOutput) {
                this.networkOutput = networkOutput;
                return this;
            }

            /**
             * Sets the value of {@link BridgeOutputProperty#getNetworkOutput}
             * @param networkOutput The output of the bridge.
             *                      A network output is delivered to your premises.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkOutput(software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeNetworkOutputProperty networkOutput) {
                this.networkOutput = networkOutput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BridgeOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BridgeOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BridgeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeOutputProperty {
            private final java.lang.Object networkOutput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkOutput = software.amazon.jsii.Kernel.get(this, "networkOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkOutput = builder.networkOutput;
            }

            @Override
            public final java.lang.Object getNetworkOutput() {
                return this.networkOutput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkOutput() != null) {
                    data.set("networkOutput", om.valueToTree(this.getNetworkOutput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BridgeOutputProperty.Jsii$Proxy that = (BridgeOutputProperty.Jsii$Proxy) o;

                return this.networkOutput != null ? this.networkOutput.equals(that.networkOutput) : that.networkOutput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkOutput != null ? this.networkOutput.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The bridge's source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * BridgeSourceProperty bridgeSourceProperty = BridgeSourceProperty.builder()
     *         .flowSource(BridgeFlowSourceProperty.builder()
     *                 .flowArn("flowArn")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .flowVpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
     *                         .vpcInterfaceName("vpcInterfaceName")
     *                         .build())
     *                 .build())
     *         .networkSource(BridgeNetworkSourceProperty.builder()
     *                 .multicastIp("multicastIp")
     *                 .name("name")
     *                 .networkName("networkName")
     *                 .port(123)
     *                 .protocol("protocol")
     *                 // the properties below are optional
     *                 .multicastSourceSettings(MulticastSourceSettingsProperty.builder()
     *                         .multicastSourceIp("multicastSourceIp")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(BridgeSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BridgeSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the bridge.
         * <p>
         * A flow source originates in MediaConnect as an existing cloud flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgesource.html#cfn-mediaconnect-bridge-bridgesource-flowsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgesource.html#cfn-mediaconnect-bridge-bridgesource-flowsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFlowSource() {
            return null;
        }

        /**
         * The source of the bridge.
         * <p>
         * A network source originates at your premises.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgesource.html#cfn-mediaconnect-bridge-bridgesource-networksource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-bridgesource.html#cfn-mediaconnect-bridge-bridgesource-networksource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BridgeSourceProperty> {
            java.lang.Object flowSource;
            java.lang.Object networkSource;

            /**
             * Sets the value of {@link BridgeSourceProperty#getFlowSource}
             * @param flowSource The source of the bridge.
             *                   A flow source originates in MediaConnect as an existing cloud flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowSource(software.amazon.awscdk.IResolvable flowSource) {
                this.flowSource = flowSource;
                return this;
            }

            /**
             * Sets the value of {@link BridgeSourceProperty#getFlowSource}
             * @param flowSource The source of the bridge.
             *                   A flow source originates in MediaConnect as an existing cloud flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowSource(software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeFlowSourceProperty flowSource) {
                this.flowSource = flowSource;
                return this;
            }

            /**
             * Sets the value of {@link BridgeSourceProperty#getNetworkSource}
             * @param networkSource The source of the bridge.
             *                      A network source originates at your premises.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSource(software.amazon.awscdk.IResolvable networkSource) {
                this.networkSource = networkSource;
                return this;
            }

            /**
             * Sets the value of {@link BridgeSourceProperty#getNetworkSource}
             * @param networkSource The source of the bridge.
             *                      A network source originates at your premises.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSource(software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeNetworkSourceProperty networkSource) {
                this.networkSource = networkSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BridgeSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BridgeSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeSourceProperty {
            private final java.lang.Object flowSource;
            private final java.lang.Object networkSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.flowSource = software.amazon.jsii.Kernel.get(this, "flowSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkSource = software.amazon.jsii.Kernel.get(this, "networkSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.flowSource = builder.flowSource;
                this.networkSource = builder.networkSource;
            }

            @Override
            public final java.lang.Object getFlowSource() {
                return this.flowSource;
            }

            @Override
            public final java.lang.Object getNetworkSource() {
                return this.networkSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFlowSource() != null) {
                    data.set("flowSource", om.valueToTree(this.getFlowSource()));
                }
                if (this.getNetworkSource() != null) {
                    data.set("networkSource", om.valueToTree(this.getNetworkSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BridgeSourceProperty.Jsii$Proxy that = (BridgeSourceProperty.Jsii$Proxy) o;

                if (this.flowSource != null ? !this.flowSource.equals(that.flowSource) : that.flowSource != null) return false;
                return this.networkSource != null ? this.networkSource.equals(that.networkSource) : that.networkSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.flowSource != null ? this.flowSource.hashCode() : 0;
                result = 31 * result + (this.networkSource != null ? this.networkSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Create a bridge with the egress bridge type.
     * <p>
     * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EgressGatewayBridgeProperty egressGatewayBridgeProperty = EgressGatewayBridgeProperty.builder()
     *         .maxBitrate(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-egressgatewaybridge.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-egressgatewaybridge.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.EgressGatewayBridgeProperty")
    @software.amazon.jsii.Jsii.Proxy(EgressGatewayBridgeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EgressGatewayBridgeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum expected bitrate (in bps) of the egress bridge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-egressgatewaybridge.html#cfn-mediaconnect-bridge-egressgatewaybridge-maxbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-egressgatewaybridge.html#cfn-mediaconnect-bridge-egressgatewaybridge-maxbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxBitrate();

        /**
         * @return a {@link Builder} of {@link EgressGatewayBridgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EgressGatewayBridgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EgressGatewayBridgeProperty> {
            java.lang.Number maxBitrate;

            /**
             * Sets the value of {@link EgressGatewayBridgeProperty#getMaxBitrate}
             * @param maxBitrate The maximum expected bitrate (in bps) of the egress bridge. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxBitrate(java.lang.Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressGatewayBridgeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EgressGatewayBridgeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EgressGatewayBridgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EgressGatewayBridgeProperty {
            private final java.lang.Number maxBitrate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxBitrate = software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxBitrate = java.util.Objects.requireNonNull(builder.maxBitrate, "maxBitrate is required");
            }

            @Override
            public final java.lang.Number getMaxBitrate() {
                return this.maxBitrate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxBitrate", om.valueToTree(this.getMaxBitrate()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.EgressGatewayBridgeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EgressGatewayBridgeProperty.Jsii$Proxy that = (EgressGatewayBridgeProperty.Jsii$Proxy) o;

                return this.maxBitrate.equals(that.maxBitrate);
            }

            @Override
            public final int hashCode() {
                int result = this.maxBitrate.hashCode();
                return result;
            }
        }
    }
    /**
     * The settings for source failover.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * FailoverConfigProperty failoverConfigProperty = FailoverConfigProperty.builder()
     *         .failoverMode("failoverMode")
     *         // the properties below are optional
     *         .sourcePriority(SourcePriorityProperty.builder()
     *                 .primarySource("primarySource")
     *                 .build())
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.FailoverConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of failover you choose for this flow.
         * <p>
         * MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html#cfn-mediaconnect-bridge-failoverconfig-failovermode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html#cfn-mediaconnect-bridge-failoverconfig-failovermode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFailoverMode();

        /**
         * The priority you want to assign to a source.
         * <p>
         * You can have a primary stream and a backup stream or two equally prioritized streams.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html#cfn-mediaconnect-bridge-failoverconfig-sourcepriority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html#cfn-mediaconnect-bridge-failoverconfig-sourcepriority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourcePriority() {
            return null;
        }

        /**
         * The state of source failover on the flow.
         * <p>
         * If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html#cfn-mediaconnect-bridge-failoverconfig-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-failoverconfig.html#cfn-mediaconnect-bridge-failoverconfig-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverConfigProperty> {
            java.lang.String failoverMode;
            java.lang.Object sourcePriority;
            java.lang.String state;

            /**
             * Sets the value of {@link FailoverConfigProperty#getFailoverMode}
             * @param failoverMode The type of failover you choose for this flow. This parameter is required.
             *                     MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverMode(java.lang.String failoverMode) {
                this.failoverMode = failoverMode;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getSourcePriority}
             * @param sourcePriority The priority you want to assign to a source.
             *                       You can have a primary stream and a backup stream or two equally prioritized streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePriority(software.amazon.awscdk.IResolvable sourcePriority) {
                this.sourcePriority = sourcePriority;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getSourcePriority}
             * @param sourcePriority The priority you want to assign to a source.
             *                       You can have a primary stream and a backup stream or two equally prioritized streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePriority(software.amazon.awscdk.services.mediaconnect.CfnBridge.SourcePriorityProperty sourcePriority) {
                this.sourcePriority = sourcePriority;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getState}
             * @param state The state of source failover on the flow.
             *              If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverConfigProperty {
            private final java.lang.String failoverMode;
            private final java.lang.Object sourcePriority;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failoverMode = software.amazon.jsii.Kernel.get(this, "failoverMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourcePriority = software.amazon.jsii.Kernel.get(this, "sourcePriority", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failoverMode = java.util.Objects.requireNonNull(builder.failoverMode, "failoverMode is required");
                this.sourcePriority = builder.sourcePriority;
                this.state = builder.state;
            }

            @Override
            public final java.lang.String getFailoverMode() {
                return this.failoverMode;
            }

            @Override
            public final java.lang.Object getSourcePriority() {
                return this.sourcePriority;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("failoverMode", om.valueToTree(this.getFailoverMode()));
                if (this.getSourcePriority() != null) {
                    data.set("sourcePriority", om.valueToTree(this.getSourcePriority()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.FailoverConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverConfigProperty.Jsii$Proxy that = (FailoverConfigProperty.Jsii$Proxy) o;

                if (!failoverMode.equals(that.failoverMode)) return false;
                if (this.sourcePriority != null ? !this.sourcePriority.equals(that.sourcePriority) : that.sourcePriority != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failoverMode.hashCode();
                result = 31 * result + (this.sourcePriority != null ? this.sourcePriority.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Create a bridge with the ingress bridge type.
     * <p>
     * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * IngressGatewayBridgeProperty ingressGatewayBridgeProperty = IngressGatewayBridgeProperty.builder()
     *         .maxBitrate(123)
     *         .maxOutputs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-ingressgatewaybridge.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-ingressgatewaybridge.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.IngressGatewayBridgeProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressGatewayBridgeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressGatewayBridgeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum expected bitrate (in bps) of the ingress bridge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-ingressgatewaybridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge-maxbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-ingressgatewaybridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge-maxbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxBitrate();

        /**
         * The maximum number of outputs on the ingress bridge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-ingressgatewaybridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge-maxoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-ingressgatewaybridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge-maxoutputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxOutputs();

        /**
         * @return a {@link Builder} of {@link IngressGatewayBridgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressGatewayBridgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressGatewayBridgeProperty> {
            java.lang.Number maxBitrate;
            java.lang.Number maxOutputs;

            /**
             * Sets the value of {@link IngressGatewayBridgeProperty#getMaxBitrate}
             * @param maxBitrate The maximum expected bitrate (in bps) of the ingress bridge. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxBitrate(java.lang.Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            /**
             * Sets the value of {@link IngressGatewayBridgeProperty#getMaxOutputs}
             * @param maxOutputs The maximum number of outputs on the ingress bridge. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxOutputs(java.lang.Number maxOutputs) {
                this.maxOutputs = maxOutputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressGatewayBridgeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressGatewayBridgeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressGatewayBridgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressGatewayBridgeProperty {
            private final java.lang.Number maxBitrate;
            private final java.lang.Number maxOutputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxBitrate = software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxOutputs = software.amazon.jsii.Kernel.get(this, "maxOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxBitrate = java.util.Objects.requireNonNull(builder.maxBitrate, "maxBitrate is required");
                this.maxOutputs = java.util.Objects.requireNonNull(builder.maxOutputs, "maxOutputs is required");
            }

            @Override
            public final java.lang.Number getMaxBitrate() {
                return this.maxBitrate;
            }

            @Override
            public final java.lang.Number getMaxOutputs() {
                return this.maxOutputs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxBitrate", om.valueToTree(this.getMaxBitrate()));
                data.set("maxOutputs", om.valueToTree(this.getMaxOutputs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.IngressGatewayBridgeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressGatewayBridgeProperty.Jsii$Proxy that = (IngressGatewayBridgeProperty.Jsii$Proxy) o;

                if (!maxBitrate.equals(that.maxBitrate)) return false;
                return this.maxOutputs.equals(that.maxOutputs);
            }

            @Override
            public final int hashCode() {
                int result = this.maxBitrate.hashCode();
                result = 31 * result + (this.maxOutputs.hashCode());
                return result;
            }
        }
    }
    /**
     * The settings related to the multicast source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MulticastSourceSettingsProperty multicastSourceSettingsProperty = MulticastSourceSettingsProperty.builder()
     *         .multicastSourceIp("multicastSourceIp")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-multicastsourcesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-multicastsourcesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.MulticastSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MulticastSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MulticastSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP address of the source for source-specific multicast (SSM).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-multicastsourcesettings.html#cfn-mediaconnect-bridge-multicastsourcesettings-multicastsourceip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-multicastsourcesettings.html#cfn-mediaconnect-bridge-multicastsourcesettings-multicastsourceip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMulticastSourceIp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MulticastSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MulticastSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MulticastSourceSettingsProperty> {
            java.lang.String multicastSourceIp;

            /**
             * Sets the value of {@link MulticastSourceSettingsProperty#getMulticastSourceIp}
             * @param multicastSourceIp The IP address of the source for source-specific multicast (SSM).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multicastSourceIp(java.lang.String multicastSourceIp) {
                this.multicastSourceIp = multicastSourceIp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MulticastSourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MulticastSourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MulticastSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MulticastSourceSettingsProperty {
            private final java.lang.String multicastSourceIp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.multicastSourceIp = software.amazon.jsii.Kernel.get(this, "multicastSourceIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.multicastSourceIp = builder.multicastSourceIp;
            }

            @Override
            public final java.lang.String getMulticastSourceIp() {
                return this.multicastSourceIp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMulticastSourceIp() != null) {
                    data.set("multicastSourceIp", om.valueToTree(this.getMulticastSourceIp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.MulticastSourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MulticastSourceSettingsProperty.Jsii$Proxy that = (MulticastSourceSettingsProperty.Jsii$Proxy) o;

                return this.multicastSourceIp != null ? this.multicastSourceIp.equals(that.multicastSourceIp) : that.multicastSourceIp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.multicastSourceIp != null ? this.multicastSourceIp.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The priority you want to assign to a source.
     * <p>
     * You can have a primary stream and a backup stream or two equally prioritized streams.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SourcePriorityProperty sourcePriorityProperty = SourcePriorityProperty.builder()
     *         .primarySource("primarySource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-sourcepriority.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-sourcepriority.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.SourcePriorityProperty")
    @software.amazon.jsii.Jsii.Proxy(SourcePriorityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourcePriorityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the source you choose as the primary source for this flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-sourcepriority.html#cfn-mediaconnect-bridge-sourcepriority-primarysource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-sourcepriority.html#cfn-mediaconnect-bridge-sourcepriority-primarysource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrimarySource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourcePriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourcePriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourcePriorityProperty> {
            java.lang.String primarySource;

            /**
             * Sets the value of {@link SourcePriorityProperty#getPrimarySource}
             * @param primarySource The name of the source you choose as the primary source for this flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primarySource(java.lang.String primarySource) {
                this.primarySource = primarySource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourcePriorityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourcePriorityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourcePriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourcePriorityProperty {
            private final java.lang.String primarySource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primarySource = software.amazon.jsii.Kernel.get(this, "primarySource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primarySource = builder.primarySource;
            }

            @Override
            public final java.lang.String getPrimarySource() {
                return this.primarySource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrimarySource() != null) {
                    data.set("primarySource", om.valueToTree(this.getPrimarySource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.SourcePriorityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourcePriorityProperty.Jsii$Proxy that = (SourcePriorityProperty.Jsii$Proxy) o;

                return this.primarySource != null ? this.primarySource.equals(that.primarySource) : that.primarySource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.primarySource != null ? this.primarySource.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for attaching a VPC interface to an resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * VpcInterfaceAttachmentProperty vpcInterfaceAttachmentProperty = VpcInterfaceAttachmentProperty.builder()
     *         .vpcInterfaceName("vpcInterfaceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-vpcinterfaceattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-vpcinterfaceattachment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridge.VpcInterfaceAttachmentProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcInterfaceAttachmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcInterfaceAttachmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the VPC interface to use for this resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-vpcinterfaceattachment.html#cfn-mediaconnect-bridge-vpcinterfaceattachment-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-bridge-vpcinterfaceattachment.html#cfn-mediaconnect-bridge-vpcinterfaceattachment-vpcinterfacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcInterfaceAttachmentProperty> {
            java.lang.String vpcInterfaceName;

            /**
             * Sets the value of {@link VpcInterfaceAttachmentProperty#getVpcInterfaceName}
             * @param vpcInterfaceName The name of the VPC interface to use for this resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcInterfaceAttachmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcInterfaceAttachmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcInterfaceAttachmentProperty {
            private final java.lang.String vpcInterfaceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcInterfaceName = builder.vpcInterfaceName;
            }

            @Override
            public final java.lang.String getVpcInterfaceName() {
                return this.vpcInterfaceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcInterfaceName() != null) {
                    data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridge.VpcInterfaceAttachmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcInterfaceAttachmentProperty.Jsii$Proxy that = (VpcInterfaceAttachmentProperty.Jsii$Proxy) o;

                return this.vpcInterfaceName != null ? this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnBridge}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnBridge> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnBridgeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnBridgeProps.Builder();
        }

        /**
         * The name of the bridge.
         * <p>
         * This name can not be modified after the bridge is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-name</a>
         * @param name The name of the bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The bridge placement Amazon Resource Number (ARN).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-placementarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-placementarn</a>
         * @param placementArn The bridge placement Amazon Resource Number (ARN). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementArn(final java.lang.String placementArn) {
            this.props.placementArn(placementArn);
            return this;
        }

        /**
         * The sources that you want to add to this bridge.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sources</a>
         * @param sources The sources that you want to add to this bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final software.amazon.awscdk.IResolvable sources) {
            this.props.sources(sources);
            return this;
        }
        /**
         * The sources that you want to add to this bridge.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sources</a>
         * @param sources The sources that you want to add to this bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final java.util.List<? extends java.lang.Object> sources) {
            this.props.sources(sources);
            return this;
        }

        /**
         * An egress bridge is a cloud-to-ground bridge.
         * <p>
         * The content comes from an existing MediaConnect flow and is delivered to your premises.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-egressgatewaybridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-egressgatewaybridge</a>
         * @param egressGatewayBridge An egress bridge is a cloud-to-ground bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressGatewayBridge(final software.amazon.awscdk.IResolvable egressGatewayBridge) {
            this.props.egressGatewayBridge(egressGatewayBridge);
            return this;
        }
        /**
         * An egress bridge is a cloud-to-ground bridge.
         * <p>
         * The content comes from an existing MediaConnect flow and is delivered to your premises.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-egressgatewaybridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-egressgatewaybridge</a>
         * @param egressGatewayBridge An egress bridge is a cloud-to-ground bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressGatewayBridge(final software.amazon.awscdk.services.mediaconnect.CfnBridge.EgressGatewayBridgeProperty egressGatewayBridge) {
            this.props.egressGatewayBridge(egressGatewayBridge);
            return this;
        }

        /**
         * An ingress bridge is a ground-to-cloud bridge.
         * <p>
         * The content originates at your premises and is delivered to the cloud.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge</a>
         * @param ingressGatewayBridge An ingress bridge is a ground-to-cloud bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressGatewayBridge(final software.amazon.awscdk.IResolvable ingressGatewayBridge) {
            this.props.ingressGatewayBridge(ingressGatewayBridge);
            return this;
        }
        /**
         * An ingress bridge is a ground-to-cloud bridge.
         * <p>
         * The content originates at your premises and is delivered to the cloud.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge</a>
         * @param ingressGatewayBridge An ingress bridge is a ground-to-cloud bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressGatewayBridge(final software.amazon.awscdk.services.mediaconnect.CfnBridge.IngressGatewayBridgeProperty ingressGatewayBridge) {
            this.props.ingressGatewayBridge(ingressGatewayBridge);
            return this;
        }

        /**
         * The outputs that you want to add to this bridge.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-outputs</a>
         * @param outputs The outputs that you want to add to this bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final software.amazon.awscdk.IResolvable outputs) {
            this.props.outputs(outputs);
            return this;
        }
        /**
         * The outputs that you want to add to this bridge.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-outputs</a>
         * @param outputs The outputs that you want to add to this bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.util.List<? extends java.lang.Object> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * The settings for source failover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sourcefailoverconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sourcefailoverconfig</a>
         * @param sourceFailoverConfig The settings for source failover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(final software.amazon.awscdk.IResolvable sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }
        /**
         * The settings for source failover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sourcefailoverconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sourcefailoverconfig</a>
         * @param sourceFailoverConfig The settings for source failover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(final software.amazon.awscdk.services.mediaconnect.CfnBridge.FailoverConfigProperty sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnBridge}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnBridge build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnBridge(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
