package software.amazon.awscdk.services.medialive;

/**
 * Properties for defining a <code>CfnInput</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * Object tags;
 * CfnInputProps cfnInputProps = CfnInputProps.builder()
 *         .destinations(List.of(InputDestinationRequestProperty.builder()
 *                 .network("network")
 *                 .networkRoutes(List.of(InputRequestDestinationRouteProperty.builder()
 *                         .cidr("cidr")
 *                         .gateway("gateway")
 *                         .build()))
 *                 .staticIpAddress("staticIpAddress")
 *                 .streamName("streamName")
 *                 .build()))
 *         .inputDevices(List.of(InputDeviceSettingsProperty.builder()
 *                 .id("id")
 *                 .build()))
 *         .inputNetworkLocation("inputNetworkLocation")
 *         .inputSecurityGroups(List.of("inputSecurityGroups"))
 *         .mediaConnectFlows(List.of(MediaConnectFlowRequestProperty.builder()
 *                 .flowArn("flowArn")
 *                 .build()))
 *         .multicastSettings(MulticastSettingsCreateRequestProperty.builder()
 *                 .sources(List.of(MulticastSourceCreateRequestProperty.builder()
 *                         .sourceIp("sourceIp")
 *                         .url("url")
 *                         .build()))
 *                 .build())
 *         .name("name")
 *         .roleArn("roleArn")
 *         .sources(List.of(InputSourceRequestProperty.builder()
 *                 .passwordParam("passwordParam")
 *                 .url("url")
 *                 .username("username")
 *                 .build()))
 *         .srtSettings(SrtSettingsRequestProperty.builder()
 *                 .srtCallerSources(List.of(SrtCallerSourceRequestProperty.builder()
 *                         .decryption(SrtCallerDecryptionRequestProperty.builder()
 *                                 .algorithm("algorithm")
 *                                 .passphraseSecretArn("passphraseSecretArn")
 *                                 .build())
 *                         .minimumLatency(123)
 *                         .srtListenerAddress("srtListenerAddress")
 *                         .srtListenerPort("srtListenerPort")
 *                         .streamId("streamId")
 *                         .build()))
 *                 .build())
 *         .tags(tags)
 *         .type("type")
 *         .vpc(InputVpcRequestProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:52.103Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnInputProps")
@software.amazon.jsii.Jsii.Proxy(CfnInputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Settings that apply only if the input is a push type of input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return null;
    }

    /**
     * Settings that apply only if the input is an Elemental Link input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputdevices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputdevices</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputDevices() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputnetworklocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputnetworklocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputNetworkLocation() {
        return null;
    }

    /**
     * The list of input security groups (referenced by IDs) to attach to the input if the input is a push type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInputSecurityGroups() {
        return null;
    }

    /**
     * Settings that apply only if the input is a MediaConnect input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMediaConnectFlows() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-multicastsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-multicastsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMulticastSettings() {
        return null;
    }

    /**
     * A name for the input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The IAM role for MediaLive to assume when creating a MediaConnect input or Amazon VPC input.
     * <p>
     * This doesn't apply to other types of inputs. The role is identified by its ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * Settings that apply only if the input is a pull type of input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSources() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-srtsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-srtsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSrtSettings() {
        return null;
    }

    /**
     * A collection of tags for this input.
     * <p>
     * Each tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The type for this input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * Settings that apply only if the input is an push input where the source is on Amazon VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInputProps> {
        java.lang.Object destinations;
        java.lang.Object inputDevices;
        java.lang.String inputNetworkLocation;
        java.util.List<java.lang.String> inputSecurityGroups;
        java.lang.Object mediaConnectFlows;
        java.lang.Object multicastSettings;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.Object sources;
        java.lang.Object srtSettings;
        java.lang.Object tags;
        java.lang.String type;
        java.lang.Object vpc;

        /**
         * Sets the value of {@link CfnInputProps#getDestinations}
         * @param destinations Settings that apply only if the input is a push type of input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getDestinations}
         * @param destinations Settings that apply only if the input is a push type of input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputDevices}
         * @param inputDevices Settings that apply only if the input is an Elemental Link input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDevices(software.amazon.awscdk.IResolvable inputDevices) {
            this.inputDevices = inputDevices;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputDevices}
         * @param inputDevices Settings that apply only if the input is an Elemental Link input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDevices(java.util.List<? extends java.lang.Object> inputDevices) {
            this.inputDevices = inputDevices;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputNetworkLocation}
         * @param inputNetworkLocation the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputNetworkLocation(java.lang.String inputNetworkLocation) {
            this.inputNetworkLocation = inputNetworkLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputSecurityGroups}
         * @param inputSecurityGroups The list of input security groups (referenced by IDs) to attach to the input if the input is a push type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSecurityGroups(java.util.List<java.lang.String> inputSecurityGroups) {
            this.inputSecurityGroups = inputSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getMediaConnectFlows}
         * @param mediaConnectFlows Settings that apply only if the input is a MediaConnect input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaConnectFlows(software.amazon.awscdk.IResolvable mediaConnectFlows) {
            this.mediaConnectFlows = mediaConnectFlows;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getMediaConnectFlows}
         * @param mediaConnectFlows Settings that apply only if the input is a MediaConnect input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaConnectFlows(java.util.List<? extends java.lang.Object> mediaConnectFlows) {
            this.mediaConnectFlows = mediaConnectFlows;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getMulticastSettings}
         * @param multicastSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multicastSettings(software.amazon.awscdk.IResolvable multicastSettings) {
            this.multicastSettings = multicastSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getMulticastSettings}
         * @param multicastSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multicastSettings(software.amazon.awscdk.services.medialive.CfnInput.MulticastSettingsCreateRequestProperty multicastSettings) {
            this.multicastSettings = multicastSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getName}
         * @param name A name for the input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getRoleArn}
         * @param roleArn The IAM role for MediaLive to assume when creating a MediaConnect input or Amazon VPC input.
         *                This doesn't apply to other types of inputs. The role is identified by its ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getSources}
         * @param sources Settings that apply only if the input is a pull type of input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(software.amazon.awscdk.IResolvable sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getSources}
         * @param sources Settings that apply only if the input is a pull type of input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(java.util.List<? extends java.lang.Object> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getSrtSettings}
         * @param srtSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder srtSettings(software.amazon.awscdk.IResolvable srtSettings) {
            this.srtSettings = srtSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getSrtSettings}
         * @param srtSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder srtSettings(software.amazon.awscdk.services.medialive.CfnInput.SrtSettingsRequestProperty srtSettings) {
            this.srtSettings = srtSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getTags}
         * @param tags A collection of tags for this input.
         *             Each tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getType}
         * @param type The type for this input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getVpc}
         * @param vpc Settings that apply only if the input is an push input where the source is on Amazon VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.IResolvable vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getVpc}
         * @param vpc Settings that apply only if the input is an push input where the source is on Amazon VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.medialive.CfnInput.InputVpcRequestProperty vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInputProps {
        private final java.lang.Object destinations;
        private final java.lang.Object inputDevices;
        private final java.lang.String inputNetworkLocation;
        private final java.util.List<java.lang.String> inputSecurityGroups;
        private final java.lang.Object mediaConnectFlows;
        private final java.lang.Object multicastSettings;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.Object sources;
        private final java.lang.Object srtSettings;
        private final java.lang.Object tags;
        private final java.lang.String type;
        private final java.lang.Object vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputDevices = software.amazon.jsii.Kernel.get(this, "inputDevices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputNetworkLocation = software.amazon.jsii.Kernel.get(this, "inputNetworkLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputSecurityGroups = software.amazon.jsii.Kernel.get(this, "inputSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.mediaConnectFlows = software.amazon.jsii.Kernel.get(this, "mediaConnectFlows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.multicastSettings = software.amazon.jsii.Kernel.get(this, "multicastSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.srtSettings = software.amazon.jsii.Kernel.get(this, "srtSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinations = builder.destinations;
            this.inputDevices = builder.inputDevices;
            this.inputNetworkLocation = builder.inputNetworkLocation;
            this.inputSecurityGroups = builder.inputSecurityGroups;
            this.mediaConnectFlows = builder.mediaConnectFlows;
            this.multicastSettings = builder.multicastSettings;
            this.name = builder.name;
            this.roleArn = builder.roleArn;
            this.sources = builder.sources;
            this.srtSettings = builder.srtSettings;
            this.tags = builder.tags;
            this.type = builder.type;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.Object getDestinations() {
            return this.destinations;
        }

        @Override
        public final java.lang.Object getInputDevices() {
            return this.inputDevices;
        }

        @Override
        public final java.lang.String getInputNetworkLocation() {
            return this.inputNetworkLocation;
        }

        @Override
        public final java.util.List<java.lang.String> getInputSecurityGroups() {
            return this.inputSecurityGroups;
        }

        @Override
        public final java.lang.Object getMediaConnectFlows() {
            return this.mediaConnectFlows;
        }

        @Override
        public final java.lang.Object getMulticastSettings() {
            return this.multicastSettings;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getSources() {
            return this.sources;
        }

        @Override
        public final java.lang.Object getSrtSettings() {
            return this.srtSettings;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDestinations() != null) {
                data.set("destinations", om.valueToTree(this.getDestinations()));
            }
            if (this.getInputDevices() != null) {
                data.set("inputDevices", om.valueToTree(this.getInputDevices()));
            }
            if (this.getInputNetworkLocation() != null) {
                data.set("inputNetworkLocation", om.valueToTree(this.getInputNetworkLocation()));
            }
            if (this.getInputSecurityGroups() != null) {
                data.set("inputSecurityGroups", om.valueToTree(this.getInputSecurityGroups()));
            }
            if (this.getMediaConnectFlows() != null) {
                data.set("mediaConnectFlows", om.valueToTree(this.getMediaConnectFlows()));
            }
            if (this.getMulticastSettings() != null) {
                data.set("multicastSettings", om.valueToTree(this.getMulticastSettings()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getSources() != null) {
                data.set("sources", om.valueToTree(this.getSources()));
            }
            if (this.getSrtSettings() != null) {
                data.set("srtSettings", om.valueToTree(this.getSrtSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnInputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInputProps.Jsii$Proxy that = (CfnInputProps.Jsii$Proxy) o;

            if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
            if (this.inputDevices != null ? !this.inputDevices.equals(that.inputDevices) : that.inputDevices != null) return false;
            if (this.inputNetworkLocation != null ? !this.inputNetworkLocation.equals(that.inputNetworkLocation) : that.inputNetworkLocation != null) return false;
            if (this.inputSecurityGroups != null ? !this.inputSecurityGroups.equals(that.inputSecurityGroups) : that.inputSecurityGroups != null) return false;
            if (this.mediaConnectFlows != null ? !this.mediaConnectFlows.equals(that.mediaConnectFlows) : that.mediaConnectFlows != null) return false;
            if (this.multicastSettings != null ? !this.multicastSettings.equals(that.multicastSettings) : that.multicastSettings != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) return false;
            if (this.srtSettings != null ? !this.srtSettings.equals(that.srtSettings) : that.srtSettings != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinations != null ? this.destinations.hashCode() : 0;
            result = 31 * result + (this.inputDevices != null ? this.inputDevices.hashCode() : 0);
            result = 31 * result + (this.inputNetworkLocation != null ? this.inputNetworkLocation.hashCode() : 0);
            result = 31 * result + (this.inputSecurityGroups != null ? this.inputSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.mediaConnectFlows != null ? this.mediaConnectFlows.hashCode() : 0);
            result = 31 * result + (this.multicastSettings != null ? this.multicastSettings.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.sources != null ? this.sources.hashCode() : 0);
            result = 31 * result + (this.srtSettings != null ? this.srtSettings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
