package software.amazon.awscdk.services.mediatailor;

/**
 * Properties for defining a <code>CfnLiveSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * CfnLiveSourceProps cfnLiveSourceProps = CfnLiveSourceProps.builder()
 *         .httpPackageConfigurations(List.of(HttpPackageConfigurationProperty.builder()
 *                 .path("path")
 *                 .sourceGroup("sourceGroup")
 *                 .type("type")
 *                 .build()))
 *         .liveSourceName("liveSourceName")
 *         .sourceLocationName("sourceLocationName")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:52.224Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnLiveSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnLiveSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLiveSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP package configurations for the live source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-httppackageconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-httppackageconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getHttpPackageConfigurations();

    /**
     * The name that's used to refer to a live source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-livesourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-livesourcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLiveSourceName();

    /**
     * The name of the source location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-sourcelocationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-sourcelocationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationName();

    /**
     * The tags assigned to the live source.
     * <p>
     * Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-livesource.html#cfn-mediatailor-livesource-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLiveSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLiveSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLiveSourceProps> {
        java.lang.Object httpPackageConfigurations;
        java.lang.String liveSourceName;
        java.lang.String sourceLocationName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLiveSourceProps#getHttpPackageConfigurations}
         * @param httpPackageConfigurations The HTTP package configurations for the live source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPackageConfigurations(software.amazon.awscdk.IResolvable httpPackageConfigurations) {
            this.httpPackageConfigurations = httpPackageConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnLiveSourceProps#getHttpPackageConfigurations}
         * @param httpPackageConfigurations The HTTP package configurations for the live source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPackageConfigurations(java.util.List<? extends java.lang.Object> httpPackageConfigurations) {
            this.httpPackageConfigurations = httpPackageConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnLiveSourceProps#getLiveSourceName}
         * @param liveSourceName The name that's used to refer to a live source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveSourceName(java.lang.String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLiveSourceProps#getSourceLocationName}
         * @param sourceLocationName The name of the source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationName(java.lang.String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLiveSourceProps#getTags}
         * @param tags The tags assigned to the live source.
         *             Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLiveSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLiveSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLiveSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLiveSourceProps {
        private final java.lang.Object httpPackageConfigurations;
        private final java.lang.String liveSourceName;
        private final java.lang.String sourceLocationName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpPackageConfigurations = software.amazon.jsii.Kernel.get(this, "httpPackageConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.liveSourceName = software.amazon.jsii.Kernel.get(this, "liveSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceLocationName = software.amazon.jsii.Kernel.get(this, "sourceLocationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpPackageConfigurations = java.util.Objects.requireNonNull(builder.httpPackageConfigurations, "httpPackageConfigurations is required");
            this.liveSourceName = java.util.Objects.requireNonNull(builder.liveSourceName, "liveSourceName is required");
            this.sourceLocationName = java.util.Objects.requireNonNull(builder.sourceLocationName, "sourceLocationName is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getHttpPackageConfigurations() {
            return this.httpPackageConfigurations;
        }

        @Override
        public final java.lang.String getLiveSourceName() {
            return this.liveSourceName;
        }

        @Override
        public final java.lang.String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpPackageConfigurations", om.valueToTree(this.getHttpPackageConfigurations()));
            data.set("liveSourceName", om.valueToTree(this.getLiveSourceName()));
            data.set("sourceLocationName", om.valueToTree(this.getSourceLocationName()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnLiveSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLiveSourceProps.Jsii$Proxy that = (CfnLiveSourceProps.Jsii$Proxy) o;

            if (!httpPackageConfigurations.equals(that.httpPackageConfigurations)) return false;
            if (!liveSourceName.equals(that.liveSourceName)) return false;
            if (!sourceLocationName.equals(that.sourceLocationName)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpPackageConfigurations.hashCode();
            result = 31 * result + (this.liveSourceName.hashCode());
            result = 31 * result + (this.sourceLocationName.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
