package software.amazon.awscdk.services.msk;

/**
 * Properties for defining a <code>CfnConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnConfigurationProps cfnConfigurationProps = CfnConfigurationProps.builder()
 *         .name("name")
 *         .serverProperties("serverProperties")
 *         // the properties below are optional
 *         .description("description")
 *         .kafkaVersionsList(List.of("kafkaVersionsList"))
 *         .latestRevision(LatestRevisionProperty.builder()
 *                 .creationTime("creationTime")
 *                 .description("description")
 *                 .revision(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:52.291Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the configuration.
     * <p>
     * Configuration names are strings that match the regex "^[0-9A-Za-z][0-9A-Za-z-]{0,}$".
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Contents of the <code>server.properties</code> file. When using this property, you must ensure that the contents of the file are base64 encoded. When using the console, the SDK, or the AWS CLI , the contents of <code>server.properties</code> can be in plaintext.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-serverproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-serverproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerProperties();

    /**
     * The description of the configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">versions of Apache Kafka</a> with which you can use this MSK configuration.
     * <p>
     * When you update the <code>KafkaVersionsList</code> property, AWS CloudFormation recreates a new configuration with the updated property before deleting the old configuration. Such an update requires a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">resource replacement</a> . To successfully update <code>KafkaVersionsList</code> , you must also update the <code>Name</code> property in the same operation.
     * <p>
     * If your configuration is attached with any clusters created using the AWS Management Console or AWS CLI , you'll need to manually delete the old configuration from the console after the update completes.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/troubleshooting.html#troubleshoot-kafkaversionslist-cfn-update-failure">Can’t update KafkaVersionsList in MSK configuration</a> in the <em>Amazon MSK Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-kafkaversionslist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-kafkaversionslist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getKafkaVersionsList() {
        return null;
    }

    /**
     * Latest revision of the MSK configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-latestrevision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-configuration.html#cfn-msk-configuration-latestrevision</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLatestRevision() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationProps> {
        java.lang.String name;
        java.lang.String serverProperties;
        java.lang.String description;
        java.util.List<java.lang.String> kafkaVersionsList;
        java.lang.Object latestRevision;

        /**
         * Sets the value of {@link CfnConfigurationProps#getName}
         * @param name The name of the configuration. This parameter is required.
         *             Configuration names are strings that match the regex "^[0-9A-Za-z][0-9A-Za-z-]{0,}$".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationProps#getServerProperties}
         * @param serverProperties Contents of the <code>server.properties</code> file. When using this property, you must ensure that the contents of the file are base64 encoded. When using the console, the SDK, or the AWS CLI , the contents of <code>server.properties</code> can be in plaintext. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverProperties(java.lang.String serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationProps#getDescription}
         * @param description The description of the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationProps#getKafkaVersionsList}
         * @param kafkaVersionsList The <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">versions of Apache Kafka</a> with which you can use this MSK configuration.
         *                          When you update the <code>KafkaVersionsList</code> property, AWS CloudFormation recreates a new configuration with the updated property before deleting the old configuration. Such an update requires a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">resource replacement</a> . To successfully update <code>KafkaVersionsList</code> , you must also update the <code>Name</code> property in the same operation.
         *                          <p>
         *                          If your configuration is attached with any clusters created using the AWS Management Console or AWS CLI , you'll need to manually delete the old configuration from the console after the update completes.
         *                          <p>
         *                          For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/troubleshooting.html#troubleshoot-kafkaversionslist-cfn-update-failure">Can’t update KafkaVersionsList in MSK configuration</a> in the <em>Amazon MSK Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaVersionsList(java.util.List<java.lang.String> kafkaVersionsList) {
            this.kafkaVersionsList = kafkaVersionsList;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationProps#getLatestRevision}
         * @param latestRevision Latest revision of the MSK configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestRevision(software.amazon.awscdk.IResolvable latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationProps#getLatestRevision}
         * @param latestRevision Latest revision of the MSK configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestRevision(software.amazon.awscdk.services.msk.CfnConfiguration.LatestRevisionProperty latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationProps {
        private final java.lang.String name;
        private final java.lang.String serverProperties;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> kafkaVersionsList;
        private final java.lang.Object latestRevision;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverProperties = software.amazon.jsii.Kernel.get(this, "serverProperties", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kafkaVersionsList = software.amazon.jsii.Kernel.get(this, "kafkaVersionsList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.latestRevision = software.amazon.jsii.Kernel.get(this, "latestRevision", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.serverProperties = java.util.Objects.requireNonNull(builder.serverProperties, "serverProperties is required");
            this.description = builder.description;
            this.kafkaVersionsList = builder.kafkaVersionsList;
            this.latestRevision = builder.latestRevision;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getServerProperties() {
            return this.serverProperties;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getKafkaVersionsList() {
            return this.kafkaVersionsList;
        }

        @Override
        public final java.lang.Object getLatestRevision() {
            return this.latestRevision;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("serverProperties", om.valueToTree(this.getServerProperties()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getKafkaVersionsList() != null) {
                data.set("kafkaVersionsList", om.valueToTree(this.getKafkaVersionsList()));
            }
            if (this.getLatestRevision() != null) {
                data.set("latestRevision", om.valueToTree(this.getLatestRevision()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationProps.Jsii$Proxy that = (CfnConfigurationProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!serverProperties.equals(that.serverProperties)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.kafkaVersionsList != null ? !this.kafkaVersionsList.equals(that.kafkaVersionsList) : that.kafkaVersionsList != null) return false;
            return this.latestRevision != null ? this.latestRevision.equals(that.latestRevision) : that.latestRevision == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.serverProperties.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.kafkaVersionsList != null ? this.kafkaVersionsList.hashCode() : 0);
            result = 31 * result + (this.latestRevision != null ? this.latestRevision.hashCode() : 0);
            return result;
        }
    }
}
