package software.amazon.awscdk.services.networkfirewall;

/**
 * Use the <code>RuleGroup</code> to define a reusable collection of stateless or stateful network traffic filtering rules.
 * <p>
 * You use rule groups in an <code>FirewallPolicy</code> to specify the filtering behavior of an <code>Firewall</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnRuleGroup cfnRuleGroup = CfnRuleGroup.Builder.create(this, "MyCfnRuleGroup")
 *         .capacity(123)
 *         .ruleGroupName("ruleGroupName")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .ruleGroup(RuleGroupProperty.builder()
 *                 .rulesSource(RulesSourceProperty.builder()
 *                         .rulesSourceList(RulesSourceListProperty.builder()
 *                                 .generatedRulesType("generatedRulesType")
 *                                 .targets(List.of("targets"))
 *                                 .targetTypes(List.of("targetTypes"))
 *                                 .build())
 *                         .rulesString("rulesString")
 *                         .statefulRules(List.of(StatefulRuleProperty.builder()
 *                                 .action("action")
 *                                 .header(HeaderProperty.builder()
 *                                         .destination("destination")
 *                                         .destinationPort("destinationPort")
 *                                         .direction("direction")
 *                                         .protocol("protocol")
 *                                         .source("source")
 *                                         .sourcePort("sourcePort")
 *                                         .build())
 *                                 .ruleOptions(List.of(RuleOptionProperty.builder()
 *                                         .keyword("keyword")
 *                                         // the properties below are optional
 *                                         .settings(List.of("settings"))
 *                                         .build()))
 *                                 .build()))
 *                         .statelessRulesAndCustomActions(StatelessRulesAndCustomActionsProperty.builder()
 *                                 .statelessRules(List.of(StatelessRuleProperty.builder()
 *                                         .priority(123)
 *                                         .ruleDefinition(RuleDefinitionProperty.builder()
 *                                                 .actions(List.of("actions"))
 *                                                 .matchAttributes(MatchAttributesProperty.builder()
 *                                                         .destinationPorts(List.of(PortRangeProperty.builder()
 *                                                                 .fromPort(123)
 *                                                                 .toPort(123)
 *                                                                 .build()))
 *                                                         .destinations(List.of(AddressProperty.builder()
 *                                                                 .addressDefinition("addressDefinition")
 *                                                                 .build()))
 *                                                         .protocols(List.of(123))
 *                                                         .sourcePorts(List.of(PortRangeProperty.builder()
 *                                                                 .fromPort(123)
 *                                                                 .toPort(123)
 *                                                                 .build()))
 *                                                         .sources(List.of(AddressProperty.builder()
 *                                                                 .addressDefinition("addressDefinition")
 *                                                                 .build()))
 *                                                         .tcpFlags(List.of(TCPFlagFieldProperty.builder()
 *                                                                 .flags(List.of("flags"))
 *                                                                 // the properties below are optional
 *                                                                 .masks(List.of("masks"))
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build())
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .customActions(List.of(CustomActionProperty.builder()
 *                                         .actionDefinition(ActionDefinitionProperty.builder()
 *                                                 .publishMetricAction(PublishMetricActionProperty.builder()
 *                                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build())
 *                                         .actionName("actionName")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .referenceSets(ReferenceSetsProperty.builder()
 *                         .ipSetReferences(Map.of(
 *                                 "ipSetReferencesKey", Map.of(
 *                                         "referenceArn", "referenceArn")))
 *                         .build())
 *                 .ruleVariables(RuleVariablesProperty.builder()
 *                         .ipSets(Map.of(
 *                                 "ipSetsKey", Map.of(
 *                                         "definition", List.of("definition"))))
 *                         .portSets(Map.of(
 *                                 "portSetsKey", PortSetProperty.builder()
 *                                         .definition(List.of("definition"))
 *                                         .build()))
 *                         .build())
 *                 .statefulRuleOptions(StatefulRuleOptionsProperty.builder()
 *                         .ruleOrder("ruleOrder")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:52.369Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup")
public class CfnRuleGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnRuleGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRuleGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRuleGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnRuleGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the <code>RuleGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the <code>RuleGroup</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleGroupId() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The maximum operating resources that this rule group can use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getCapacity() {
        return software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum operating resources that this rule group can use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacity(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "capacity", java.util.Objects.requireNonNull(value, "capacity is required"));
    }

    /**
     * The descriptive name of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleGroupName() {
        return software.amazon.jsii.Kernel.get(this, "ruleGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The descriptive name of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleGroupName", java.util.Objects.requireNonNull(value, "ruleGroupName is required"));
    }

    /**
     * Indicates whether the rule group is stateless or stateful.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the rule group is stateless or stateful.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A description of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An object that defines the rule group rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRuleGroup() {
        return software.amazon.jsii.Kernel.get(this, "ruleGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines the rule group rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ruleGroup", value);
    }

    /**
     * An object that defines the rule group rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RuleGroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "ruleGroup", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A custom action to use in stateless rule actions settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * ActionDefinitionProperty actionDefinitionProperty = ActionDefinitionProperty.builder()
     *         .publishMetricAction(PublishMetricActionProperty.builder()
     *                 .dimensions(List.of(DimensionProperty.builder()
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.ActionDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
         * <p>
         * This setting defines a CloudWatch dimension value to be published.
         * <p>
         * You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html#cfn-networkfirewall-rulegroup-actiondefinition-publishmetricaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html#cfn-networkfirewall-rulegroup-actiondefinition-publishmetricaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishMetricAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionDefinitionProperty> {
            java.lang.Object publishMetricAction;

            /**
             * Sets the value of {@link ActionDefinitionProperty#getPublishMetricAction}
             * @param publishMetricAction Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
             *                            This setting defines a CloudWatch dimension value to be published.
             *                            <p>
             *                            You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishMetricAction(software.amazon.awscdk.IResolvable publishMetricAction) {
                this.publishMetricAction = publishMetricAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionDefinitionProperty#getPublishMetricAction}
             * @param publishMetricAction Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
             *                            This setting defines a CloudWatch dimension value to be published.
             *                            <p>
             *                            You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishMetricAction(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.PublishMetricActionProperty publishMetricAction) {
                this.publishMetricAction = publishMetricAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionDefinitionProperty {
            private final java.lang.Object publishMetricAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.publishMetricAction = software.amazon.jsii.Kernel.get(this, "publishMetricAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.publishMetricAction = builder.publishMetricAction;
            }

            @Override
            public final java.lang.Object getPublishMetricAction() {
                return this.publishMetricAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPublishMetricAction() != null) {
                    data.set("publishMetricAction", om.valueToTree(this.getPublishMetricAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.ActionDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionDefinitionProperty.Jsii$Proxy that = (ActionDefinitionProperty.Jsii$Proxy) o;

                return this.publishMetricAction != null ? this.publishMetricAction.equals(that.publishMetricAction) : that.publishMetricAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.publishMetricAction != null ? this.publishMetricAction.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A single IP address specification.
     * <p>
     * This is used in the <code>RuleGroup.MatchAttributes</code> source and destination specifications.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * AddressProperty addressProperty = AddressProperty.builder()
     *         .addressDefinition("addressDefinition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.AddressProperty")
    @software.amazon.jsii.Jsii.Proxy(AddressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
         * <p>
         * Network Firewall supports all address ranges for IPv4 and IPv6.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
         * <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html#cfn-networkfirewall-rulegroup-address-addressdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html#cfn-networkfirewall-rulegroup-address-addressdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAddressDefinition();

        /**
         * @return a {@link Builder} of {@link AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddressProperty> {
            java.lang.String addressDefinition;

            /**
             * Sets the value of {@link AddressProperty#getAddressDefinition}
             * @param addressDefinition Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. This parameter is required.
             *                          Network Firewall supports all address ranges for IPv4 and IPv6.
             *                          <p>
             *                          Examples:
             *                          <p>
             *                          <ul>
             *                          <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
             *                          <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
             *                          <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
             *                          <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
             *                          </ul>
             *                          <p>
             *                          For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addressDefinition(java.lang.String addressDefinition) {
                this.addressDefinition = addressDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddressProperty {
            private final java.lang.String addressDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addressDefinition = software.amazon.jsii.Kernel.get(this, "addressDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addressDefinition = java.util.Objects.requireNonNull(builder.addressDefinition, "addressDefinition is required");
            }

            @Override
            public final java.lang.String getAddressDefinition() {
                return this.addressDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("addressDefinition", om.valueToTree(this.getAddressDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.AddressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddressProperty.Jsii$Proxy that = (AddressProperty.Jsii$Proxy) o;

                return this.addressDefinition.equals(that.addressDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.addressDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * An optional, non-standard action to use for stateless packet handling.
     * <p>
     * You can define this in addition to the standard action that you must specify.
     * <p>
     * You define and name the custom actions that you want to be able to use, and then you reference them by name in your actions settings.
     * <p>
     * You can use custom actions in the following places:
     * <p>
     * <ul>
     * <li>In an <code>RuleGroup.StatelessRulesAndCustomActions</code> . The custom actions are available for use by name inside the <code>StatelessRulesAndCustomActions</code> where you define them. You can use them for your stateless rule actions to specify what to do with a packet that matches the rule's match attributes.</li>
     * <li>In an <code>FirewallPolicy</code> specification, in <code>StatelessCustomActions</code> . The custom actions are available for use inside the policy where you define them. You can use them for the policy's default stateless actions settings to specify what to do with packets that don't match any of the policy's stateless rules.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * CustomActionProperty customActionProperty = CustomActionProperty.builder()
     *         .actionDefinition(ActionDefinitionProperty.builder()
     *                 .publishMetricAction(PublishMetricActionProperty.builder()
     *                         .dimensions(List.of(DimensionProperty.builder()
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .actionName("actionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.CustomActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom action associated with the action name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actiondefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actiondefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActionDefinition();

        /**
         * The descriptive name of the custom action.
         * <p>
         * You can't change the name of a custom action after you create it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionName();

        /**
         * @return a {@link Builder} of {@link CustomActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomActionProperty> {
            java.lang.Object actionDefinition;
            java.lang.String actionName;

            /**
             * Sets the value of {@link CustomActionProperty#getActionDefinition}
             * @param actionDefinition The custom action associated with the action name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionDefinition(software.amazon.awscdk.IResolvable actionDefinition) {
                this.actionDefinition = actionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionProperty#getActionDefinition}
             * @param actionDefinition The custom action associated with the action name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionDefinition(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.ActionDefinitionProperty actionDefinition) {
                this.actionDefinition = actionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionProperty#getActionName}
             * @param actionName The descriptive name of the custom action. This parameter is required.
             *                   You can't change the name of a custom action after you create it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionName(java.lang.String actionName) {
                this.actionName = actionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomActionProperty {
            private final java.lang.Object actionDefinition;
            private final java.lang.String actionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionDefinition = software.amazon.jsii.Kernel.get(this, "actionDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionDefinition = java.util.Objects.requireNonNull(builder.actionDefinition, "actionDefinition is required");
                this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            }

            @Override
            public final java.lang.Object getActionDefinition() {
                return this.actionDefinition;
            }

            @Override
            public final java.lang.String getActionName() {
                return this.actionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionDefinition", om.valueToTree(this.getActionDefinition()));
                data.set("actionName", om.valueToTree(this.getActionName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.CustomActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomActionProperty.Jsii$Proxy that = (CustomActionProperty.Jsii$Proxy) o;

                if (!actionDefinition.equals(that.actionDefinition)) return false;
                return this.actionName.equals(that.actionName);
            }

            @Override
            public final int hashCode() {
                int result = this.actionDefinition.hashCode();
                result = 31 * result + (this.actionName.hashCode());
                return result;
            }
        }
    }
    /**
     * The value to use in an Amazon CloudWatch custom metric dimension.
     * <p>
     * This is used in the <code>PublishMetrics</code> custom action. A CloudWatch custom metric dimension is a name/value pair that's part of the identity of a metric.
     * <p>
     * AWS Network Firewall sets the dimension name to <code>CustomAction</code> and you provide the dimension value.
     * <p>
     * For more information about CloudWatch custom metric dimensions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions">Publishing Custom Metrics</a> in the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * DimensionProperty dimensionProperty = DimensionProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.DimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to use in the custom metric dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html#cfn-networkfirewall-rulegroup-dimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html#cfn-networkfirewall-rulegroup-dimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link DimensionProperty#getValue}
             * @param value The value to use in the custom metric dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.DimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionProperty.Jsii$Proxy that = (DimensionProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * The 5-tuple criteria for AWS Network Firewall to use to inspect packet headers in stateful traffic flow inspection.
     * <p>
     * Traffic flows that match the criteria are a match for the corresponding stateful rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * HeaderProperty headerProperty = HeaderProperty.builder()
     *         .destination("destination")
     *         .destinationPort("destinationPort")
     *         .direction("direction")
     *         .protocol("protocol")
     *         .source("source")
     *         .sourcePort("sourcePort")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.HeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(HeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination IP address or address range to inspect for, in CIDR notation.
         * <p>
         * To match with any address, specify <code>ANY</code> .
         * <p>
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
         * <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestination();

        /**
         * The destination port to inspect for.
         * <p>
         * You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destinationport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationPort();

        /**
         * The direction of traffic flow to inspect.
         * <p>
         * If set to <code>ANY</code> , the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to <code>FORWARD</code> , the inspection only matches traffic going from the source to the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-direction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-direction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDirection();

        /**
         * The protocol to inspect for.
         * <p>
         * To specify all, you can use <code>IP</code> , because all traffic on AWS and on the internet is IP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * The source IP address or address range to inspect for, in CIDR notation.
         * <p>
         * To match with any address, specify <code>ANY</code> .
         * <p>
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
         * <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The source port to inspect for.
         * <p>
         * You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-sourceport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-sourceport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourcePort();

        /**
         * @return a {@link Builder} of {@link HeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeaderProperty> {
            java.lang.String destination;
            java.lang.String destinationPort;
            java.lang.String direction;
            java.lang.String protocol;
            java.lang.String source;
            java.lang.String sourcePort;

            /**
             * Sets the value of {@link HeaderProperty#getDestination}
             * @param destination The destination IP address or address range to inspect for, in CIDR notation. This parameter is required.
             *                    To match with any address, specify <code>ANY</code> .
             *                    <p>
             *                    Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
             *                    <p>
             *                    Examples:
             *                    <p>
             *                    <ul>
             *                    <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
             *                    <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
             *                    <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
             *                    <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
             *                    </ul>
             *                    <p>
             *                    For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link HeaderProperty#getDestinationPort}
             * @param destinationPort The destination port to inspect for. This parameter is required.
             *                        You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPort(java.lang.String destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            /**
             * Sets the value of {@link HeaderProperty#getDirection}
             * @param direction The direction of traffic flow to inspect. This parameter is required.
             *                  If set to <code>ANY</code> , the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to <code>FORWARD</code> , the inspection only matches traffic going from the source to the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder direction(java.lang.String direction) {
                this.direction = direction;
                return this;
            }

            /**
             * Sets the value of {@link HeaderProperty#getProtocol}
             * @param protocol The protocol to inspect for. This parameter is required.
             *                 To specify all, you can use <code>IP</code> , because all traffic on AWS and on the internet is IP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link HeaderProperty#getSource}
             * @param source The source IP address or address range to inspect for, in CIDR notation. This parameter is required.
             *               To match with any address, specify <code>ANY</code> .
             *               <p>
             *               Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
             *               <p>
             *               Examples:
             *               <p>
             *               <ul>
             *               <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
             *               <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
             *               <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
             *               <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
             *               </ul>
             *               <p>
             *               For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link HeaderProperty#getSourcePort}
             * @param sourcePort The source port to inspect for. This parameter is required.
             *                   You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePort(java.lang.String sourcePort) {
                this.sourcePort = sourcePort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderProperty {
            private final java.lang.String destination;
            private final java.lang.String destinationPort;
            private final java.lang.String direction;
            private final java.lang.String protocol;
            private final java.lang.String source;
            private final java.lang.String sourcePort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPort = software.amazon.jsii.Kernel.get(this, "destinationPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourcePort = software.amazon.jsii.Kernel.get(this, "sourcePort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.destinationPort = java.util.Objects.requireNonNull(builder.destinationPort, "destinationPort is required");
                this.direction = java.util.Objects.requireNonNull(builder.direction, "direction is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.sourcePort = java.util.Objects.requireNonNull(builder.sourcePort, "sourcePort is required");
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getDestinationPort() {
                return this.destinationPort;
            }

            @Override
            public final java.lang.String getDirection() {
                return this.direction;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getSourcePort() {
                return this.sourcePort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("destinationPort", om.valueToTree(this.getDestinationPort()));
                data.set("direction", om.valueToTree(this.getDirection()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("sourcePort", om.valueToTree(this.getSourcePort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.HeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeaderProperty.Jsii$Proxy that = (HeaderProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!destinationPort.equals(that.destinationPort)) return false;
                if (!direction.equals(that.direction)) return false;
                if (!protocol.equals(that.protocol)) return false;
                if (!source.equals(that.source)) return false;
                return this.sourcePort.equals(that.sourcePort);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.destinationPort.hashCode());
                result = 31 * result + (this.direction.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.sourcePort.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of IP addresses and address ranges, in CIDR notation.
     * <p>
     * This is part of a <code>RuleGroup.RuleVariables</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * IPSetProperty iPSetProperty = Map.of(
     *         "definition", List.of("definition"));
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.IPSetProperty")
    @software.amazon.jsii.Jsii.Proxy(IPSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IPSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of IP addresses and address ranges, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html#cfn-networkfirewall-rulegroup-ipset-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html#cfn-networkfirewall-rulegroup-ipset-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IPSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IPSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IPSetProperty> {
            java.util.List<java.lang.String> definition;

            /**
             * Sets the value of {@link IPSetProperty#getDefinition}
             * @param definition The list of IP addresses and address ranges, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(java.util.List<java.lang.String> definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IPSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IPSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IPSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetProperty {
            private final java.util.List<java.lang.String> definition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.definition = builder.definition;
            }

            @Override
            public final java.util.List<java.lang.String> getDefinition() {
                return this.definition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefinition() != null) {
                    data.set("definition", om.valueToTree(this.getDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.IPSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IPSetProperty.Jsii$Proxy that = (IPSetProperty.Jsii$Proxy) o;

                return this.definition != null ? this.definition.equals(that.definition) : that.definition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.definition != null ? this.definition.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configures one or more <code>IPSetReferences</code> for a Suricata-compatible rule group.
     * <p>
     * An IP set reference is a rule variable that references a resource that you create and manage in another AWS service, such as an Amazon VPC prefix list. Network Firewall IP set references enable you to dynamically update the contents of your rules. When you create, update, or delete the IP set you are referencing in your rule, Network Firewall automatically updates the rule's content with the changes. For more information about IP set references in Network Firewall , see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html">Using IP set references</a> in the <em>Network Firewall Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * IPSetReferenceProperty iPSetReferenceProperty = Map.of(
     *         "referenceArn", "referenceArn");
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipsetreference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipsetreference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.IPSetReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(IPSetReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IPSetReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the resource to include in the <code>RuleGroup.IPSetReference</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipsetreference.html#cfn-networkfirewall-rulegroup-ipsetreference-referencearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipsetreference.html#cfn-networkfirewall-rulegroup-ipsetreference-referencearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReferenceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IPSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IPSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IPSetReferenceProperty> {
            java.lang.String referenceArn;

            /**
             * Sets the value of {@link IPSetReferenceProperty#getReferenceArn}
             * @param referenceArn The Amazon Resource Name (ARN) of the resource to include in the <code>RuleGroup.IPSetReference</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceArn(java.lang.String referenceArn) {
                this.referenceArn = referenceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IPSetReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IPSetReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IPSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetReferenceProperty {
            private final java.lang.String referenceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.referenceArn = software.amazon.jsii.Kernel.get(this, "referenceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.referenceArn = builder.referenceArn;
            }

            @Override
            public final java.lang.String getReferenceArn() {
                return this.referenceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReferenceArn() != null) {
                    data.set("referenceArn", om.valueToTree(this.getReferenceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.IPSetReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IPSetReferenceProperty.Jsii$Proxy that = (IPSetReferenceProperty.Jsii$Proxy) o;

                return this.referenceArn != null ? this.referenceArn.equals(that.referenceArn) : that.referenceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.referenceArn != null ? this.referenceArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection.
     * <p>
     * Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * MatchAttributesProperty matchAttributesProperty = MatchAttributesProperty.builder()
     *         .destinationPorts(List.of(PortRangeProperty.builder()
     *                 .fromPort(123)
     *                 .toPort(123)
     *                 .build()))
     *         .destinations(List.of(AddressProperty.builder()
     *                 .addressDefinition("addressDefinition")
     *                 .build()))
     *         .protocols(List.of(123))
     *         .sourcePorts(List.of(PortRangeProperty.builder()
     *                 .fromPort(123)
     *                 .toPort(123)
     *                 .build()))
     *         .sources(List.of(AddressProperty.builder()
     *                 .addressDefinition("addressDefinition")
     *                 .build()))
     *         .tcpFlags(List.of(TCPFlagFieldProperty.builder()
     *                 .flags(List.of("flags"))
     *                 // the properties below are optional
     *                 .masks(List.of("masks"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.MatchAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination port to inspect for.
         * <p>
         * You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
         * <p>
         * This setting is only used for protocols 6 (TCP) and 17 (UDP).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinationports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinationports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationPorts() {
            return null;
        }

        /**
         * The destination IP addresses and address ranges to inspect for, in CIDR notation.
         * <p>
         * If not specified, this matches with any destination address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
            return null;
        }

        /**
         * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
         * <p>
         * If not specified, this matches with any protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-protocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-protocols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProtocols() {
            return null;
        }

        /**
         * The source port to inspect for.
         * <p>
         * You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
         * <p>
         * If not specified, this matches with any source port.
         * <p>
         * This setting is only used for protocols 6 (TCP) and 17 (UDP).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sourceports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sourceports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourcePorts() {
            return null;
        }

        /**
         * The source IP addresses and address ranges to inspect for, in CIDR notation.
         * <p>
         * If not specified, this matches with any source address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSources() {
            return null;
        }

        /**
         * The TCP flags and masks to inspect for.
         * <p>
         * If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-tcpflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-tcpflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTcpFlags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MatchAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchAttributesProperty> {
            java.lang.Object destinationPorts;
            java.lang.Object destinations;
            java.lang.Object protocols;
            java.lang.Object sourcePorts;
            java.lang.Object sources;
            java.lang.Object tcpFlags;

            /**
             * Sets the value of {@link MatchAttributesProperty#getDestinationPorts}
             * @param destinationPorts The destination port to inspect for.
             *                         You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
             *                         <p>
             *                         This setting is only used for protocols 6 (TCP) and 17 (UDP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPorts(software.amazon.awscdk.IResolvable destinationPorts) {
                this.destinationPorts = destinationPorts;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getDestinationPorts}
             * @param destinationPorts The destination port to inspect for.
             *                         You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
             *                         <p>
             *                         This setting is only used for protocols 6 (TCP) and 17 (UDP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPorts(java.util.List<? extends java.lang.Object> destinationPorts) {
                this.destinationPorts = destinationPorts;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getDestinations}
             * @param destinations The destination IP addresses and address ranges to inspect for, in CIDR notation.
             *                     If not specified, this matches with any destination address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getDestinations}
             * @param destinations The destination IP addresses and address ranges to inspect for, in CIDR notation.
             *                     If not specified, this matches with any destination address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getProtocols}
             * @param protocols The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
             *                  If not specified, this matches with any protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocols(java.util.List<? extends java.lang.Number> protocols) {
                this.protocols = protocols;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getProtocols}
             * @param protocols The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
             *                  If not specified, this matches with any protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocols(software.amazon.awscdk.IResolvable protocols) {
                this.protocols = protocols;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getSourcePorts}
             * @param sourcePorts The source port to inspect for.
             *                    You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
             *                    <p>
             *                    If not specified, this matches with any source port.
             *                    <p>
             *                    This setting is only used for protocols 6 (TCP) and 17 (UDP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePorts(software.amazon.awscdk.IResolvable sourcePorts) {
                this.sourcePorts = sourcePorts;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getSourcePorts}
             * @param sourcePorts The source port to inspect for.
             *                    You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code> . To match with any port, specify <code>ANY</code> .
             *                    <p>
             *                    If not specified, this matches with any source port.
             *                    <p>
             *                    This setting is only used for protocols 6 (TCP) and 17 (UDP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePorts(java.util.List<? extends java.lang.Object> sourcePorts) {
                this.sourcePorts = sourcePorts;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getSources}
             * @param sources The source IP addresses and address ranges to inspect for, in CIDR notation.
             *                If not specified, this matches with any source address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sources(software.amazon.awscdk.IResolvable sources) {
                this.sources = sources;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getSources}
             * @param sources The source IP addresses and address ranges to inspect for, in CIDR notation.
             *                If not specified, this matches with any source address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sources(java.util.List<? extends java.lang.Object> sources) {
                this.sources = sources;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getTcpFlags}
             * @param tcpFlags The TCP flags and masks to inspect for.
             *                 If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcpFlags(software.amazon.awscdk.IResolvable tcpFlags) {
                this.tcpFlags = tcpFlags;
                return this;
            }

            /**
             * Sets the value of {@link MatchAttributesProperty#getTcpFlags}
             * @param tcpFlags The TCP flags and masks to inspect for.
             *                 If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcpFlags(java.util.List<? extends java.lang.Object> tcpFlags) {
                this.tcpFlags = tcpFlags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchAttributesProperty {
            private final java.lang.Object destinationPorts;
            private final java.lang.Object destinations;
            private final java.lang.Object protocols;
            private final java.lang.Object sourcePorts;
            private final java.lang.Object sources;
            private final java.lang.Object tcpFlags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationPorts = software.amazon.jsii.Kernel.get(this, "destinationPorts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocols = software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourcePorts = software.amazon.jsii.Kernel.get(this, "sourcePorts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tcpFlags = software.amazon.jsii.Kernel.get(this, "tcpFlags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationPorts = builder.destinationPorts;
                this.destinations = builder.destinations;
                this.protocols = builder.protocols;
                this.sourcePorts = builder.sourcePorts;
                this.sources = builder.sources;
                this.tcpFlags = builder.tcpFlags;
            }

            @Override
            public final java.lang.Object getDestinationPorts() {
                return this.destinationPorts;
            }

            @Override
            public final java.lang.Object getDestinations() {
                return this.destinations;
            }

            @Override
            public final java.lang.Object getProtocols() {
                return this.protocols;
            }

            @Override
            public final java.lang.Object getSourcePorts() {
                return this.sourcePorts;
            }

            @Override
            public final java.lang.Object getSources() {
                return this.sources;
            }

            @Override
            public final java.lang.Object getTcpFlags() {
                return this.tcpFlags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationPorts() != null) {
                    data.set("destinationPorts", om.valueToTree(this.getDestinationPorts()));
                }
                if (this.getDestinations() != null) {
                    data.set("destinations", om.valueToTree(this.getDestinations()));
                }
                if (this.getProtocols() != null) {
                    data.set("protocols", om.valueToTree(this.getProtocols()));
                }
                if (this.getSourcePorts() != null) {
                    data.set("sourcePorts", om.valueToTree(this.getSourcePorts()));
                }
                if (this.getSources() != null) {
                    data.set("sources", om.valueToTree(this.getSources()));
                }
                if (this.getTcpFlags() != null) {
                    data.set("tcpFlags", om.valueToTree(this.getTcpFlags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.MatchAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchAttributesProperty.Jsii$Proxy that = (MatchAttributesProperty.Jsii$Proxy) o;

                if (this.destinationPorts != null ? !this.destinationPorts.equals(that.destinationPorts) : that.destinationPorts != null) return false;
                if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
                if (this.protocols != null ? !this.protocols.equals(that.protocols) : that.protocols != null) return false;
                if (this.sourcePorts != null ? !this.sourcePorts.equals(that.sourcePorts) : that.sourcePorts != null) return false;
                if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) return false;
                return this.tcpFlags != null ? this.tcpFlags.equals(that.tcpFlags) : that.tcpFlags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationPorts != null ? this.destinationPorts.hashCode() : 0;
                result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
                result = 31 * result + (this.protocols != null ? this.protocols.hashCode() : 0);
                result = 31 * result + (this.sourcePorts != null ? this.sourcePorts.hashCode() : 0);
                result = 31 * result + (this.sources != null ? this.sources.hashCode() : 0);
                result = 31 * result + (this.tcpFlags != null ? this.tcpFlags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single port range specification.
     * <p>
     * This is used for source and destination port ranges in the stateless <code>RuleGroup.MatchAttributes</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * PortRangeProperty portRangeProperty = PortRangeProperty.builder()
     *         .fromPort(123)
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.PortRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(PortRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lower limit of the port range.
         * <p>
         * This must be less than or equal to the <code>ToPort</code> specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * The upper limit of the port range.
         * <p>
         * This must be greater than or equal to the <code>FromPort</code> specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortRangeProperty> {
            java.lang.Number fromPort;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link PortRangeProperty#getFromPort}
             * @param fromPort The lower limit of the port range. This parameter is required.
             *                 This must be less than or equal to the <code>ToPort</code> specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link PortRangeProperty#getToPort}
             * @param toPort The upper limit of the port range. This parameter is required.
             *               This must be greater than or equal to the <code>FromPort</code> specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortRangeProperty {
            private final java.lang.Number fromPort;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.PortRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortRangeProperty.Jsii$Proxy that = (PortRangeProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * A set of port ranges for use in the rules in a rule group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * PortSetProperty portSetProperty = PortSetProperty.builder()
     *         .definition(List.of("definition"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.PortSetProperty")
    @software.amazon.jsii.Jsii.Proxy(PortSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The set of port ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html#cfn-networkfirewall-rulegroup-portset-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html#cfn-networkfirewall-rulegroup-portset-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PortSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortSetProperty> {
            java.util.List<java.lang.String> definition;

            /**
             * Sets the value of {@link PortSetProperty#getDefinition}
             * @param definition The set of port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(java.util.List<java.lang.String> definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortSetProperty {
            private final java.util.List<java.lang.String> definition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.definition = builder.definition;
            }

            @Override
            public final java.util.List<java.lang.String> getDefinition() {
                return this.definition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefinition() != null) {
                    data.set("definition", om.valueToTree(this.getDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.PortSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortSetProperty.Jsii$Proxy that = (PortSetProperty.Jsii$Proxy) o;

                return this.definition != null ? this.definition.equals(that.definition) : that.definition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.definition != null ? this.definition.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
     * <p>
     * This setting defines a CloudWatch dimension value to be published.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * PublishMetricActionProperty publishMetricActionProperty = PublishMetricActionProperty.builder()
     *         .dimensions(List.of(DimensionProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.PublishMetricActionProperty")
    @software.amazon.jsii.Jsii.Proxy(PublishMetricActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublishMetricActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html#cfn-networkfirewall-rulegroup-publishmetricaction-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html#cfn-networkfirewall-rulegroup-publishmetricaction-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDimensions();

        /**
         * @return a {@link Builder} of {@link PublishMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublishMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublishMetricActionProperty> {
            java.lang.Object dimensions;

            /**
             * Sets the value of {@link PublishMetricActionProperty#getDimensions}
             * @param dimensions the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link PublishMetricActionProperty#getDimensions}
             * @param dimensions the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublishMetricActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublishMetricActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublishMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublishMetricActionProperty {
            private final java.lang.Object dimensions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = java.util.Objects.requireNonNull(builder.dimensions, "dimensions is required");
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensions", om.valueToTree(this.getDimensions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.PublishMetricActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublishMetricActionProperty.Jsii$Proxy that = (PublishMetricActionProperty.Jsii$Proxy) o;

                return this.dimensions.equals(that.dimensions);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions.hashCode();
                return result;
            }
        }
    }
    /**
     * Configures the <code>ReferenceSets</code> for a stateful rule group.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html">Using IP set references in Suricata compatible rule groups</a> in the <em>Network Firewall User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * ReferenceSetsProperty referenceSetsProperty = ReferenceSetsProperty.builder()
     *         .ipSetReferences(Map.of(
     *                 "ipSetReferencesKey", Map.of(
     *                         "referenceArn", "referenceArn")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-referencesets.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-referencesets.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.ReferenceSetsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReferenceSetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferenceSetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP set references to use in the stateful rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-referencesets.html#cfn-networkfirewall-rulegroup-referencesets-ipsetreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-referencesets.html#cfn-networkfirewall-rulegroup-referencesets-ipsetreferences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpSetReferences() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReferenceSetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReferenceSetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReferenceSetsProperty> {
            java.lang.Object ipSetReferences;

            /**
             * Sets the value of {@link ReferenceSetsProperty#getIpSetReferences}
             * @param ipSetReferences The IP set references to use in the stateful rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetReferences(software.amazon.awscdk.IResolvable ipSetReferences) {
                this.ipSetReferences = ipSetReferences;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceSetsProperty#getIpSetReferences}
             * @param ipSetReferences The IP set references to use in the stateful rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetReferences(java.util.Map<java.lang.String, ? extends java.lang.Object> ipSetReferences) {
                this.ipSetReferences = ipSetReferences;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferenceSetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReferenceSetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReferenceSetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReferenceSetsProperty {
            private final java.lang.Object ipSetReferences;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipSetReferences = software.amazon.jsii.Kernel.get(this, "ipSetReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipSetReferences = builder.ipSetReferences;
            }

            @Override
            public final java.lang.Object getIpSetReferences() {
                return this.ipSetReferences;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpSetReferences() != null) {
                    data.set("ipSetReferences", om.valueToTree(this.getIpSetReferences()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.ReferenceSetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReferenceSetsProperty.Jsii$Proxy that = (ReferenceSetsProperty.Jsii$Proxy) o;

                return this.ipSetReferences != null ? this.ipSetReferences.equals(that.ipSetReferences) : that.ipSetReferences == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipSetReferences != null ? this.ipSetReferences.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The inspection criteria and action for a single stateless rule.
     * <p>
     * AWS Network Firewall inspects each packet for the specified matching criteria. When a packet matches the criteria, Network Firewall performs the rule's actions on the packet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * RuleDefinitionProperty ruleDefinitionProperty = RuleDefinitionProperty.builder()
     *         .actions(List.of("actions"))
     *         .matchAttributes(MatchAttributesProperty.builder()
     *                 .destinationPorts(List.of(PortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .toPort(123)
     *                         .build()))
     *                 .destinations(List.of(AddressProperty.builder()
     *                         .addressDefinition("addressDefinition")
     *                         .build()))
     *                 .protocols(List.of(123))
     *                 .sourcePorts(List.of(PortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .toPort(123)
     *                         .build()))
     *                 .sources(List.of(AddressProperty.builder()
     *                         .addressDefinition("addressDefinition")
     *                         .build()))
     *                 .tcpFlags(List.of(TCPFlagFieldProperty.builder()
     *                         .flags(List.of("flags"))
     *                         // the properties below are optional
     *                         .masks(List.of("masks"))
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The actions to take on a packet that matches one of the stateless rule definition's match attributes.
         * <p>
         * You must specify a standard action and you can add custom actions.
         * <p>
         * <blockquote>
         * <p>
         * Network Firewall only forwards a packet for stateful rule inspection if you specify <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet doesn't match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the <code>StatelessDefaultActions</code> setting for the <code>FirewallPolicy</code> .
         * <p>
         * </blockquote>
         * <p>
         * For every rule, you must specify exactly one of the following standard actions.
         * <p>
         * <ul>
         * <li><em>aws:pass</em> - Discontinues all inspection of the packet and permits it to go to its intended destination.</li>
         * <li><em>aws:drop</em> - Discontinues all inspection of the packet and blocks it from going to its intended destination.</li>
         * <li><em>aws:forward_to_sfe</em> - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection.</li>
         * </ul>
         * <p>
         * Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you've assigned to the action in this <code>Actions</code> setting.
         * <p>
         * To provide more than one action in this setting, separate the settings with a comma. For example, if you have a publish metrics custom action that you've named <code>MyMetricsAction</code> , then you could specify the standard action <code>aws:pass</code> combined with the custom action using <code>[“aws:pass”, “MyMetricsAction”]</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection.
         * <p>
         * Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-matchattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-matchattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchAttributes();

        /**
         * @return a {@link Builder} of {@link RuleDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleDefinitionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.Object matchAttributes;

            /**
             * Sets the value of {@link RuleDefinitionProperty#getActions}
             * @param actions The actions to take on a packet that matches one of the stateless rule definition's match attributes. This parameter is required.
             *                You must specify a standard action and you can add custom actions.
             *                <p>
             *                <blockquote>
             *                <p>
             *                Network Firewall only forwards a packet for stateful rule inspection if you specify <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet doesn't match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the <code>StatelessDefaultActions</code> setting for the <code>FirewallPolicy</code> .
             *                <p>
             *                </blockquote>
             *                <p>
             *                For every rule, you must specify exactly one of the following standard actions.
             *                <p>
             *                <ul>
             *                <li><em>aws:pass</em> - Discontinues all inspection of the packet and permits it to go to its intended destination.</li>
             *                <li><em>aws:drop</em> - Discontinues all inspection of the packet and blocks it from going to its intended destination.</li>
             *                <li><em>aws:forward_to_sfe</em> - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection.</li>
             *                </ul>
             *                <p>
             *                Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you've assigned to the action in this <code>Actions</code> setting.
             *                <p>
             *                To provide more than one action in this setting, separate the settings with a comma. For example, if you have a publish metrics custom action that you've named <code>MyMetricsAction</code> , then you could specify the standard action <code>aws:pass</code> combined with the custom action using <code>[“aws:pass”, “MyMetricsAction”]</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link RuleDefinitionProperty#getMatchAttributes}
             * @param matchAttributes Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. This parameter is required.
             *                        Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAttributes(software.amazon.awscdk.IResolvable matchAttributes) {
                this.matchAttributes = matchAttributes;
                return this;
            }

            /**
             * Sets the value of {@link RuleDefinitionProperty#getMatchAttributes}
             * @param matchAttributes Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. This parameter is required.
             *                        Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAttributes(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.MatchAttributesProperty matchAttributes) {
                this.matchAttributes = matchAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleDefinitionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.Object matchAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAttributes = software.amazon.jsii.Kernel.get(this, "matchAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.matchAttributes = java.util.Objects.requireNonNull(builder.matchAttributes, "matchAttributes is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getMatchAttributes() {
                return this.matchAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("matchAttributes", om.valueToTree(this.getMatchAttributes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleDefinitionProperty.Jsii$Proxy that = (RuleDefinitionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.matchAttributes.equals(that.matchAttributes);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.matchAttributes.hashCode());
                return result;
            }
        }
    }
    /**
     * The object that defines the rules in a rule group.
     * <p>
     * AWS Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic flow.
     * <p>
     * To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall policy in more than one firewall.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * RuleGroupProperty ruleGroupProperty = RuleGroupProperty.builder()
     *         .rulesSource(RulesSourceProperty.builder()
     *                 .rulesSourceList(RulesSourceListProperty.builder()
     *                         .generatedRulesType("generatedRulesType")
     *                         .targets(List.of("targets"))
     *                         .targetTypes(List.of("targetTypes"))
     *                         .build())
     *                 .rulesString("rulesString")
     *                 .statefulRules(List.of(StatefulRuleProperty.builder()
     *                         .action("action")
     *                         .header(HeaderProperty.builder()
     *                                 .destination("destination")
     *                                 .destinationPort("destinationPort")
     *                                 .direction("direction")
     *                                 .protocol("protocol")
     *                                 .source("source")
     *                                 .sourcePort("sourcePort")
     *                                 .build())
     *                         .ruleOptions(List.of(RuleOptionProperty.builder()
     *                                 .keyword("keyword")
     *                                 // the properties below are optional
     *                                 .settings(List.of("settings"))
     *                                 .build()))
     *                         .build()))
     *                 .statelessRulesAndCustomActions(StatelessRulesAndCustomActionsProperty.builder()
     *                         .statelessRules(List.of(StatelessRuleProperty.builder()
     *                                 .priority(123)
     *                                 .ruleDefinition(RuleDefinitionProperty.builder()
     *                                         .actions(List.of("actions"))
     *                                         .matchAttributes(MatchAttributesProperty.builder()
     *                                                 .destinationPorts(List.of(PortRangeProperty.builder()
     *                                                         .fromPort(123)
     *                                                         .toPort(123)
     *                                                         .build()))
     *                                                 .destinations(List.of(AddressProperty.builder()
     *                                                         .addressDefinition("addressDefinition")
     *                                                         .build()))
     *                                                 .protocols(List.of(123))
     *                                                 .sourcePorts(List.of(PortRangeProperty.builder()
     *                                                         .fromPort(123)
     *                                                         .toPort(123)
     *                                                         .build()))
     *                                                 .sources(List.of(AddressProperty.builder()
     *                                                         .addressDefinition("addressDefinition")
     *                                                         .build()))
     *                                                 .tcpFlags(List.of(TCPFlagFieldProperty.builder()
     *                                                         .flags(List.of("flags"))
     *                                                         // the properties below are optional
     *                                                         .masks(List.of("masks"))
     *                                                         .build()))
     *                                                 .build())
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .customActions(List.of(CustomActionProperty.builder()
     *                                 .actionDefinition(ActionDefinitionProperty.builder()
     *                                         .publishMetricAction(PublishMetricActionProperty.builder()
     *                                                 .dimensions(List.of(DimensionProperty.builder()
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build())
     *                                 .actionName("actionName")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .referenceSets(ReferenceSetsProperty.builder()
     *                 .ipSetReferences(Map.of(
     *                         "ipSetReferencesKey", Map.of(
     *                                 "referenceArn", "referenceArn")))
     *                 .build())
     *         .ruleVariables(RuleVariablesProperty.builder()
     *                 .ipSets(Map.of(
     *                         "ipSetsKey", Map.of(
     *                                 "definition", List.of("definition"))))
     *                 .portSets(Map.of(
     *                         "portSetsKey", PortSetProperty.builder()
     *                                 .definition(List.of("definition"))
     *                                 .build()))
     *                 .build())
     *         .statefulRuleOptions(StatefulRuleOptionsProperty.builder()
     *                 .ruleOrder("ruleOrder")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The stateful rules or stateless rules for the rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulessource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulessource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRulesSource();

        /**
         * The reference sets for the stateful rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-referencesets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-referencesets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReferenceSets() {
            return null;
        }

        /**
         * Settings that are available for use in the rules in the rule group.
         * <p>
         * You can only use these for stateful rule groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulevariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulevariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleVariables() {
            return null;
        }

        /**
         * Additional options governing how Network Firewall handles stateful rules.
         * <p>
         * The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings. Some limitations apply; for more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html">Strict evaluation order</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-statefulruleoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-statefulruleoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatefulRuleOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleGroupProperty> {
            java.lang.Object rulesSource;
            java.lang.Object referenceSets;
            java.lang.Object ruleVariables;
            java.lang.Object statefulRuleOptions;

            /**
             * Sets the value of {@link RuleGroupProperty#getRulesSource}
             * @param rulesSource The stateful rules or stateless rules for the rule group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesSource(software.amazon.awscdk.IResolvable rulesSource) {
                this.rulesSource = rulesSource;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getRulesSource}
             * @param rulesSource The stateful rules or stateless rules for the rule group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesSource(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RulesSourceProperty rulesSource) {
                this.rulesSource = rulesSource;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getReferenceSets}
             * @param referenceSets The reference sets for the stateful rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceSets(software.amazon.awscdk.IResolvable referenceSets) {
                this.referenceSets = referenceSets;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getReferenceSets}
             * @param referenceSets The reference sets for the stateful rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceSets(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.ReferenceSetsProperty referenceSets) {
                this.referenceSets = referenceSets;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getRuleVariables}
             * @param ruleVariables Settings that are available for use in the rules in the rule group.
             *                      You can only use these for stateful rule groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleVariables(software.amazon.awscdk.IResolvable ruleVariables) {
                this.ruleVariables = ruleVariables;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getRuleVariables}
             * @param ruleVariables Settings that are available for use in the rules in the rule group.
             *                      You can only use these for stateful rule groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleVariables(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RuleVariablesProperty ruleVariables) {
                this.ruleVariables = ruleVariables;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getStatefulRuleOptions}
             * @param statefulRuleOptions Additional options governing how Network Firewall handles stateful rules.
             *                            The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings. Some limitations apply; for more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html">Strict evaluation order</a> in the <em>AWS Network Firewall Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulRuleOptions(software.amazon.awscdk.IResolvable statefulRuleOptions) {
                this.statefulRuleOptions = statefulRuleOptions;
                return this;
            }

            /**
             * Sets the value of {@link RuleGroupProperty#getStatefulRuleOptions}
             * @param statefulRuleOptions Additional options governing how Network Firewall handles stateful rules.
             *                            The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings. Some limitations apply; for more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html">Strict evaluation order</a> in the <em>AWS Network Firewall Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulRuleOptions(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.StatefulRuleOptionsProperty statefulRuleOptions) {
                this.statefulRuleOptions = statefulRuleOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleGroupProperty {
            private final java.lang.Object rulesSource;
            private final java.lang.Object referenceSets;
            private final java.lang.Object ruleVariables;
            private final java.lang.Object statefulRuleOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rulesSource = software.amazon.jsii.Kernel.get(this, "rulesSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.referenceSets = software.amazon.jsii.Kernel.get(this, "referenceSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleVariables = software.amazon.jsii.Kernel.get(this, "ruleVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statefulRuleOptions = software.amazon.jsii.Kernel.get(this, "statefulRuleOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rulesSource = java.util.Objects.requireNonNull(builder.rulesSource, "rulesSource is required");
                this.referenceSets = builder.referenceSets;
                this.ruleVariables = builder.ruleVariables;
                this.statefulRuleOptions = builder.statefulRuleOptions;
            }

            @Override
            public final java.lang.Object getRulesSource() {
                return this.rulesSource;
            }

            @Override
            public final java.lang.Object getReferenceSets() {
                return this.referenceSets;
            }

            @Override
            public final java.lang.Object getRuleVariables() {
                return this.ruleVariables;
            }

            @Override
            public final java.lang.Object getStatefulRuleOptions() {
                return this.statefulRuleOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rulesSource", om.valueToTree(this.getRulesSource()));
                if (this.getReferenceSets() != null) {
                    data.set("referenceSets", om.valueToTree(this.getReferenceSets()));
                }
                if (this.getRuleVariables() != null) {
                    data.set("ruleVariables", om.valueToTree(this.getRuleVariables()));
                }
                if (this.getStatefulRuleOptions() != null) {
                    data.set("statefulRuleOptions", om.valueToTree(this.getStatefulRuleOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleGroupProperty.Jsii$Proxy that = (RuleGroupProperty.Jsii$Proxy) o;

                if (!rulesSource.equals(that.rulesSource)) return false;
                if (this.referenceSets != null ? !this.referenceSets.equals(that.referenceSets) : that.referenceSets != null) return false;
                if (this.ruleVariables != null ? !this.ruleVariables.equals(that.ruleVariables) : that.ruleVariables != null) return false;
                return this.statefulRuleOptions != null ? this.statefulRuleOptions.equals(that.statefulRuleOptions) : that.statefulRuleOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rulesSource.hashCode();
                result = 31 * result + (this.referenceSets != null ? this.referenceSets.hashCode() : 0);
                result = 31 * result + (this.ruleVariables != null ? this.ruleVariables.hashCode() : 0);
                result = 31 * result + (this.statefulRuleOptions != null ? this.statefulRuleOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Additional settings for a stateful rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * RuleOptionProperty ruleOptionProperty = RuleOptionProperty.builder()
     *         .keyword("keyword")
     *         // the properties below are optional
     *         .settings(List.of("settings"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Suricata rule option keywords.
         * <p>
         * For Network Firewall , the keyword signature ID (sid) is required in the format <code>sid:112233</code> . The sid must be unique within the rule group. For information about Suricata rule option keywords, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options">Rule options</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-keyword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-keyword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyword();

        /**
         * The Suricata rule option settings.
         * <p>
         * Settings have zero or more values, and the number of possible settings and required settings depends on the keyword. The format for Settings is <code>number</code> . For information about Suricata rule option settings, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options">Rule options</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleOptionProperty> {
            java.lang.String keyword;
            java.util.List<java.lang.String> settings;

            /**
             * Sets the value of {@link RuleOptionProperty#getKeyword}
             * @param keyword The Suricata rule option keywords. This parameter is required.
             *                For Network Firewall , the keyword signature ID (sid) is required in the format <code>sid:112233</code> . The sid must be unique within the rule group. For information about Suricata rule option keywords, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options">Rule options</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyword(java.lang.String keyword) {
                this.keyword = keyword;
                return this;
            }

            /**
             * Sets the value of {@link RuleOptionProperty#getSettings}
             * @param settings The Suricata rule option settings.
             *                 Settings have zero or more values, and the number of possible settings and required settings depends on the keyword. The format for Settings is <code>number</code> . For information about Suricata rule option settings, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options">Rule options</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder settings(java.util.List<java.lang.String> settings) {
                this.settings = settings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleOptionProperty {
            private final java.lang.String keyword;
            private final java.util.List<java.lang.String> settings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyword = software.amazon.jsii.Kernel.get(this, "keyword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.settings = software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyword = java.util.Objects.requireNonNull(builder.keyword, "keyword is required");
                this.settings = builder.settings;
            }

            @Override
            public final java.lang.String getKeyword() {
                return this.keyword;
            }

            @Override
            public final java.util.List<java.lang.String> getSettings() {
                return this.settings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyword", om.valueToTree(this.getKeyword()));
                if (this.getSettings() != null) {
                    data.set("settings", om.valueToTree(this.getSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleOptionProperty.Jsii$Proxy that = (RuleOptionProperty.Jsii$Proxy) o;

                if (!keyword.equals(that.keyword)) return false;
                return this.settings != null ? this.settings.equals(that.settings) : that.settings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyword.hashCode();
                result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that are available for use in the rules in the <code>RuleGroup</code> where this is defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * RuleVariablesProperty ruleVariablesProperty = RuleVariablesProperty.builder()
     *         .ipSets(Map.of(
     *                 "ipSetsKey", Map.of(
     *                         "definition", List.of("definition"))))
     *         .portSets(Map.of(
     *                 "portSetsKey", PortSetProperty.builder()
     *                         .definition(List.of("definition"))
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleVariablesProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleVariablesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleVariablesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of IP addresses and address ranges, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-ipsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-ipsets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpSets() {
            return null;
        }

        /**
         * A list of port ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-portsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-portsets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortSets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleVariablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleVariablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleVariablesProperty> {
            java.lang.Object ipSets;
            java.lang.Object portSets;

            /**
             * Sets the value of {@link RuleVariablesProperty#getIpSets}
             * @param ipSets A list of IP addresses and address ranges, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSets(software.amazon.awscdk.IResolvable ipSets) {
                this.ipSets = ipSets;
                return this;
            }

            /**
             * Sets the value of {@link RuleVariablesProperty#getIpSets}
             * @param ipSets A list of IP addresses and address ranges, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSets(java.util.Map<java.lang.String, ? extends java.lang.Object> ipSets) {
                this.ipSets = ipSets;
                return this;
            }

            /**
             * Sets the value of {@link RuleVariablesProperty#getPortSets}
             * @param portSets A list of port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portSets(software.amazon.awscdk.IResolvable portSets) {
                this.portSets = portSets;
                return this;
            }

            /**
             * Sets the value of {@link RuleVariablesProperty#getPortSets}
             * @param portSets A list of port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portSets(java.util.Map<java.lang.String, ? extends java.lang.Object> portSets) {
                this.portSets = portSets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleVariablesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleVariablesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleVariablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleVariablesProperty {
            private final java.lang.Object ipSets;
            private final java.lang.Object portSets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipSets = software.amazon.jsii.Kernel.get(this, "ipSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portSets = software.amazon.jsii.Kernel.get(this, "portSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipSets = builder.ipSets;
                this.portSets = builder.portSets;
            }

            @Override
            public final java.lang.Object getIpSets() {
                return this.ipSets;
            }

            @Override
            public final java.lang.Object getPortSets() {
                return this.portSets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpSets() != null) {
                    data.set("ipSets", om.valueToTree(this.getIpSets()));
                }
                if (this.getPortSets() != null) {
                    data.set("portSets", om.valueToTree(this.getPortSets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RuleVariablesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleVariablesProperty.Jsii$Proxy that = (RuleVariablesProperty.Jsii$Proxy) o;

                if (this.ipSets != null ? !this.ipSets.equals(that.ipSets) : that.ipSets != null) return false;
                return this.portSets != null ? this.portSets.equals(that.portSets) : that.portSets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipSets != null ? this.ipSets.hashCode() : 0;
                result = 31 * result + (this.portSets != null ? this.portSets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Stateful inspection criteria for a domain list rule group.
     * <p>
     * For HTTPS traffic, domain filtering is SNI-based. It uses the server name indicator extension of the TLS handshake.
     * <p>
     * By default, Network Firewall domain list inspection only includes traffic coming from the VPC where you deploy the firewall. To inspect traffic from IP addresses outside of the deployment VPC, you set the <code>HOME_NET</code> rule variable to include the CIDR range of the deployment VPC plus the other CIDR ranges. For more information, see <code>RuleGroup.RuleVariables</code> in this guide and <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html">Stateful domain list rule groups in AWS Network Firewall</a> in the <em>Network Firewall Developer Guide</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * RulesSourceListProperty rulesSourceListProperty = RulesSourceListProperty.builder()
     *         .generatedRulesType("generatedRulesType")
     *         .targets(List.of("targets"))
     *         .targetTypes(List.of("targetTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RulesSourceListProperty")
    @software.amazon.jsii.Jsii.Proxy(RulesSourceListProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RulesSourceListProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether you want to allow or deny access to the domains in your target list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-generatedrulestype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-generatedrulestype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGeneratedRulesType();

        /**
         * The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:.
         * <p>
         * <ul>
         * <li>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code> .</li>
         * <li>Names that use a domain wildcard, which you indicate with an initial ' <code>.</code> '. For example, <code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code> , such as <code>abc.example.com</code> and <code>www.example.com</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargets();

        /**
         * The types of targets to inspect for.
         * <p>
         * Valid values are <code>TLS_SNI</code> and <code>HTTP_HOST</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targettypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targettypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetTypes();

        /**
         * @return a {@link Builder} of {@link RulesSourceListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RulesSourceListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RulesSourceListProperty> {
            java.lang.String generatedRulesType;
            java.util.List<java.lang.String> targets;
            java.util.List<java.lang.String> targetTypes;

            /**
             * Sets the value of {@link RulesSourceListProperty#getGeneratedRulesType}
             * @param generatedRulesType Whether you want to allow or deny access to the domains in your target list. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatedRulesType(java.lang.String generatedRulesType) {
                this.generatedRulesType = generatedRulesType;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceListProperty#getTargets}
             * @param targets The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:. This parameter is required.
             *                <ul>
             *                <li>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code> .</li>
             *                <li>Names that use a domain wildcard, which you indicate with an initial ' <code>.</code> '. For example, <code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code> , such as <code>abc.example.com</code> and <code>www.example.com</code> .</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(java.util.List<java.lang.String> targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceListProperty#getTargetTypes}
             * @param targetTypes The types of targets to inspect for. This parameter is required.
             *                    Valid values are <code>TLS_SNI</code> and <code>HTTP_HOST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTypes(java.util.List<java.lang.String> targetTypes) {
                this.targetTypes = targetTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RulesSourceListProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RulesSourceListProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RulesSourceListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RulesSourceListProperty {
            private final java.lang.String generatedRulesType;
            private final java.util.List<java.lang.String> targets;
            private final java.util.List<java.lang.String> targetTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.generatedRulesType = software.amazon.jsii.Kernel.get(this, "generatedRulesType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targetTypes = software.amazon.jsii.Kernel.get(this, "targetTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.generatedRulesType = java.util.Objects.requireNonNull(builder.generatedRulesType, "generatedRulesType is required");
                this.targets = java.util.Objects.requireNonNull(builder.targets, "targets is required");
                this.targetTypes = java.util.Objects.requireNonNull(builder.targetTypes, "targetTypes is required");
            }

            @Override
            public final java.lang.String getGeneratedRulesType() {
                return this.generatedRulesType;
            }

            @Override
            public final java.util.List<java.lang.String> getTargets() {
                return this.targets;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetTypes() {
                return this.targetTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("generatedRulesType", om.valueToTree(this.getGeneratedRulesType()));
                data.set("targets", om.valueToTree(this.getTargets()));
                data.set("targetTypes", om.valueToTree(this.getTargetTypes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RulesSourceListProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RulesSourceListProperty.Jsii$Proxy that = (RulesSourceListProperty.Jsii$Proxy) o;

                if (!generatedRulesType.equals(that.generatedRulesType)) return false;
                if (!targets.equals(that.targets)) return false;
                return this.targetTypes.equals(that.targetTypes);
            }

            @Override
            public final int hashCode() {
                int result = this.generatedRulesType.hashCode();
                result = 31 * result + (this.targets.hashCode());
                result = 31 * result + (this.targetTypes.hashCode());
                return result;
            }
        }
    }
    /**
     * The stateless or stateful rules definitions for use in a single rule group.
     * <p>
     * Each rule group requires a single <code>RulesSource</code> . You can use an instance of this for either stateless rules or stateful rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * RulesSourceProperty rulesSourceProperty = RulesSourceProperty.builder()
     *         .rulesSourceList(RulesSourceListProperty.builder()
     *                 .generatedRulesType("generatedRulesType")
     *                 .targets(List.of("targets"))
     *                 .targetTypes(List.of("targetTypes"))
     *                 .build())
     *         .rulesString("rulesString")
     *         .statefulRules(List.of(StatefulRuleProperty.builder()
     *                 .action("action")
     *                 .header(HeaderProperty.builder()
     *                         .destination("destination")
     *                         .destinationPort("destinationPort")
     *                         .direction("direction")
     *                         .protocol("protocol")
     *                         .source("source")
     *                         .sourcePort("sourcePort")
     *                         .build())
     *                 .ruleOptions(List.of(RuleOptionProperty.builder()
     *                         .keyword("keyword")
     *                         // the properties below are optional
     *                         .settings(List.of("settings"))
     *                         .build()))
     *                 .build()))
     *         .statelessRulesAndCustomActions(StatelessRulesAndCustomActionsProperty.builder()
     *                 .statelessRules(List.of(StatelessRuleProperty.builder()
     *                         .priority(123)
     *                         .ruleDefinition(RuleDefinitionProperty.builder()
     *                                 .actions(List.of("actions"))
     *                                 .matchAttributes(MatchAttributesProperty.builder()
     *                                         .destinationPorts(List.of(PortRangeProperty.builder()
     *                                                 .fromPort(123)
     *                                                 .toPort(123)
     *                                                 .build()))
     *                                         .destinations(List.of(AddressProperty.builder()
     *                                                 .addressDefinition("addressDefinition")
     *                                                 .build()))
     *                                         .protocols(List.of(123))
     *                                         .sourcePorts(List.of(PortRangeProperty.builder()
     *                                                 .fromPort(123)
     *                                                 .toPort(123)
     *                                                 .build()))
     *                                         .sources(List.of(AddressProperty.builder()
     *                                                 .addressDefinition("addressDefinition")
     *                                                 .build()))
     *                                         .tcpFlags(List.of(TCPFlagFieldProperty.builder()
     *                                                 .flags(List.of("flags"))
     *                                                 // the properties below are optional
     *                                                 .masks(List.of("masks"))
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .customActions(List.of(CustomActionProperty.builder()
     *                         .actionDefinition(ActionDefinitionProperty.builder()
     *                                 .publishMetricAction(PublishMetricActionProperty.builder()
     *                                         .dimensions(List.of(DimensionProperty.builder()
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .actionName("actionName")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RulesSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(RulesSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RulesSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Stateful inspection criteria for a domain list rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulessourcelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulessourcelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRulesSourceList() {
            return null;
        }

        /**
         * Stateful inspection criteria, provided in Suricata compatible rules.
         * <p>
         * Suricata is an open-source threat detection framework that includes a standard rule-based language for network traffic inspection.
         * <p>
         * These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so this type of rule group doesn't have a separate action setting.
         * <p>
         * <blockquote>
         * <p>
         * You can't use the <code>priority</code> keyword if the <code>RuleOrder</code> option in <code>StatefulRuleOptions</code> is set to <code>STRICT_ORDER</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulesstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulesstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRulesString() {
            return null;
        }

        /**
         * An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
         * <p>
         * Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html">Rules Format</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statefulrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statefulrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatefulRules() {
            return null;
        }

        /**
         * Stateless inspection criteria to be used in a stateless rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statelessrulesandcustomactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statelessrulesandcustomactions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatelessRulesAndCustomActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RulesSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RulesSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RulesSourceProperty> {
            java.lang.Object rulesSourceList;
            java.lang.String rulesString;
            java.lang.Object statefulRules;
            java.lang.Object statelessRulesAndCustomActions;

            /**
             * Sets the value of {@link RulesSourceProperty#getRulesSourceList}
             * @param rulesSourceList Stateful inspection criteria for a domain list rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesSourceList(software.amazon.awscdk.IResolvable rulesSourceList) {
                this.rulesSourceList = rulesSourceList;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceProperty#getRulesSourceList}
             * @param rulesSourceList Stateful inspection criteria for a domain list rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesSourceList(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RulesSourceListProperty rulesSourceList) {
                this.rulesSourceList = rulesSourceList;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceProperty#getRulesString}
             * @param rulesString Stateful inspection criteria, provided in Suricata compatible rules.
             *                    Suricata is an open-source threat detection framework that includes a standard rule-based language for network traffic inspection.
             *                    <p>
             *                    These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so this type of rule group doesn't have a separate action setting.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    You can't use the <code>priority</code> keyword if the <code>RuleOrder</code> option in <code>StatefulRuleOptions</code> is set to <code>STRICT_ORDER</code> .
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesString(java.lang.String rulesString) {
                this.rulesString = rulesString;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceProperty#getStatefulRules}
             * @param statefulRules An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
             *                      Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html">Rules Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulRules(software.amazon.awscdk.IResolvable statefulRules) {
                this.statefulRules = statefulRules;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceProperty#getStatefulRules}
             * @param statefulRules An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
             *                      Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html">Rules Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulRules(java.util.List<? extends java.lang.Object> statefulRules) {
                this.statefulRules = statefulRules;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceProperty#getStatelessRulesAndCustomActions}
             * @param statelessRulesAndCustomActions Stateless inspection criteria to be used in a stateless rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessRulesAndCustomActions(software.amazon.awscdk.IResolvable statelessRulesAndCustomActions) {
                this.statelessRulesAndCustomActions = statelessRulesAndCustomActions;
                return this;
            }

            /**
             * Sets the value of {@link RulesSourceProperty#getStatelessRulesAndCustomActions}
             * @param statelessRulesAndCustomActions Stateless inspection criteria to be used in a stateless rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessRulesAndCustomActions(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.StatelessRulesAndCustomActionsProperty statelessRulesAndCustomActions) {
                this.statelessRulesAndCustomActions = statelessRulesAndCustomActions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RulesSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RulesSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RulesSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RulesSourceProperty {
            private final java.lang.Object rulesSourceList;
            private final java.lang.String rulesString;
            private final java.lang.Object statefulRules;
            private final java.lang.Object statelessRulesAndCustomActions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rulesSourceList = software.amazon.jsii.Kernel.get(this, "rulesSourceList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rulesString = software.amazon.jsii.Kernel.get(this, "rulesString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statefulRules = software.amazon.jsii.Kernel.get(this, "statefulRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statelessRulesAndCustomActions = software.amazon.jsii.Kernel.get(this, "statelessRulesAndCustomActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rulesSourceList = builder.rulesSourceList;
                this.rulesString = builder.rulesString;
                this.statefulRules = builder.statefulRules;
                this.statelessRulesAndCustomActions = builder.statelessRulesAndCustomActions;
            }

            @Override
            public final java.lang.Object getRulesSourceList() {
                return this.rulesSourceList;
            }

            @Override
            public final java.lang.String getRulesString() {
                return this.rulesString;
            }

            @Override
            public final java.lang.Object getStatefulRules() {
                return this.statefulRules;
            }

            @Override
            public final java.lang.Object getStatelessRulesAndCustomActions() {
                return this.statelessRulesAndCustomActions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRulesSourceList() != null) {
                    data.set("rulesSourceList", om.valueToTree(this.getRulesSourceList()));
                }
                if (this.getRulesString() != null) {
                    data.set("rulesString", om.valueToTree(this.getRulesString()));
                }
                if (this.getStatefulRules() != null) {
                    data.set("statefulRules", om.valueToTree(this.getStatefulRules()));
                }
                if (this.getStatelessRulesAndCustomActions() != null) {
                    data.set("statelessRulesAndCustomActions", om.valueToTree(this.getStatelessRulesAndCustomActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.RulesSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RulesSourceProperty.Jsii$Proxy that = (RulesSourceProperty.Jsii$Proxy) o;

                if (this.rulesSourceList != null ? !this.rulesSourceList.equals(that.rulesSourceList) : that.rulesSourceList != null) return false;
                if (this.rulesString != null ? !this.rulesString.equals(that.rulesString) : that.rulesString != null) return false;
                if (this.statefulRules != null ? !this.statefulRules.equals(that.statefulRules) : that.statefulRules != null) return false;
                return this.statelessRulesAndCustomActions != null ? this.statelessRulesAndCustomActions.equals(that.statelessRulesAndCustomActions) : that.statelessRulesAndCustomActions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rulesSourceList != null ? this.rulesSourceList.hashCode() : 0;
                result = 31 * result + (this.rulesString != null ? this.rulesString.hashCode() : 0);
                result = 31 * result + (this.statefulRules != null ? this.statefulRules.hashCode() : 0);
                result = 31 * result + (this.statelessRulesAndCustomActions != null ? this.statelessRulesAndCustomActions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Additional options governing how Network Firewall handles the rule group.
     * <p>
     * You can only use these for stateful rule groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatefulRuleOptionsProperty statefulRuleOptionsProperty = StatefulRuleOptionsProperty.builder()
     *         .ruleOrder("ruleOrder")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulruleoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulruleoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatefulRuleOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(StatefulRuleOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatefulRuleOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates how to manage the order of the rule evaluation for the rule group.
         * <p>
         * <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulruleoptions.html#cfn-networkfirewall-rulegroup-statefulruleoptions-ruleorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulruleoptions.html#cfn-networkfirewall-rulegroup-statefulruleoptions-ruleorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleOrder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatefulRuleOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatefulRuleOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatefulRuleOptionsProperty> {
            java.lang.String ruleOrder;

            /**
             * Sets the value of {@link StatefulRuleOptionsProperty#getRuleOrder}
             * @param ruleOrder Indicates how to manage the order of the rule evaluation for the rule group.
             *                  <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <em>AWS Network Firewall Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleOrder(java.lang.String ruleOrder) {
                this.ruleOrder = ruleOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatefulRuleOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatefulRuleOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatefulRuleOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatefulRuleOptionsProperty {
            private final java.lang.String ruleOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleOrder = software.amazon.jsii.Kernel.get(this, "ruleOrder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleOrder = builder.ruleOrder;
            }

            @Override
            public final java.lang.String getRuleOrder() {
                return this.ruleOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRuleOrder() != null) {
                    data.set("ruleOrder", om.valueToTree(this.getRuleOrder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatefulRuleOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatefulRuleOptionsProperty.Jsii$Proxy that = (StatefulRuleOptionsProperty.Jsii$Proxy) o;

                return this.ruleOrder != null ? this.ruleOrder.equals(that.ruleOrder) : that.ruleOrder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleOrder != null ? this.ruleOrder.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A single Suricata rules specification, for use in a stateful rule group.
     * <p>
     * Use this option to specify a simple Suricata rule with protocol, source and destination, ports, direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a href="https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html">Rules Format</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatefulRuleProperty statefulRuleProperty = StatefulRuleProperty.builder()
     *         .action("action")
     *         .header(HeaderProperty.builder()
     *                 .destination("destination")
     *                 .destinationPort("destinationPort")
     *                 .direction("direction")
     *                 .protocol("protocol")
     *                 .source("source")
     *                 .sourcePort("sourcePort")
     *                 .build())
     *         .ruleOptions(List.of(RuleOptionProperty.builder()
     *                 .keyword("keyword")
     *                 // the properties below are optional
     *                 .settings(List.of("settings"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatefulRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(StatefulRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatefulRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria.
         * <p>
         * For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow.
         * <p>
         * The actions for a stateful rule are defined as follows:
         * <p>
         * <ul>
         * <li><em>PASS</em> - Permits the packets to go to the intended destination.</li>
         * <li><em>DROP</em> - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the <code>Firewall</code> <code>LoggingConfiguration</code> .</li>
         * <li><em>REJECT</em> - Drops traffic that matches the conditions of the stateful rule and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a <code>RST</code> bit contained in the TCP header flags. <code>REJECT</code> is available only for TCP traffic.</li>
         * <li><em>ALERT</em> - Permits the packets to go to the intended destination and sends an alert log message, if alert logging is configured in the <code>Firewall</code> <code>LoggingConfiguration</code> .</li>
         * </ul>
         * <p>
         * You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with <code>ALERT</code> action, verify in the logs that the rule is filtering as you want, then change the action to <code>DROP</code> .
         * <p>
         * <ul>
         * <li><em>REJECT</em> - Drops TCP traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a <code>RST</code> bit contained in the TCP header flags. Also sends an alert log mesage if alert logging is configured in the <code>Firewall</code> <code>LoggingConfiguration</code> .</li>
         * </ul>
         * <p>
         * <code>REJECT</code> isn't currently available for use with IMAP and FTP protocols.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The stateful inspection criteria for this rule, used to inspect traffic flows.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHeader();

        /**
         * Additional settings for a stateful rule, provided as keywords and settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-ruleoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-ruleoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRuleOptions();

        /**
         * @return a {@link Builder} of {@link StatefulRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatefulRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatefulRuleProperty> {
            java.lang.String action;
            java.lang.Object header;
            java.lang.Object ruleOptions;

            /**
             * Sets the value of {@link StatefulRuleProperty#getAction}
             * @param action Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria. This parameter is required.
             *               For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow.
             *               <p>
             *               The actions for a stateful rule are defined as follows:
             *               <p>
             *               <ul>
             *               <li><em>PASS</em> - Permits the packets to go to the intended destination.</li>
             *               <li><em>DROP</em> - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the <code>Firewall</code> <code>LoggingConfiguration</code> .</li>
             *               <li><em>REJECT</em> - Drops traffic that matches the conditions of the stateful rule and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a <code>RST</code> bit contained in the TCP header flags. <code>REJECT</code> is available only for TCP traffic.</li>
             *               <li><em>ALERT</em> - Permits the packets to go to the intended destination and sends an alert log message, if alert logging is configured in the <code>Firewall</code> <code>LoggingConfiguration</code> .</li>
             *               </ul>
             *               <p>
             *               You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with <code>ALERT</code> action, verify in the logs that the rule is filtering as you want, then change the action to <code>DROP</code> .
             *               <p>
             *               <ul>
             *               <li><em>REJECT</em> - Drops TCP traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a <code>RST</code> bit contained in the TCP header flags. Also sends an alert log mesage if alert logging is configured in the <code>Firewall</code> <code>LoggingConfiguration</code> .</li>
             *               </ul>
             *               <p>
             *               <code>REJECT</code> isn't currently available for use with IMAP and FTP protocols.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link StatefulRuleProperty#getHeader}
             * @param header The stateful inspection criteria for this rule, used to inspect traffic flows. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(software.amazon.awscdk.IResolvable header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link StatefulRuleProperty#getHeader}
             * @param header The stateful inspection criteria for this rule, used to inspect traffic flows. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.HeaderProperty header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link StatefulRuleProperty#getRuleOptions}
             * @param ruleOptions Additional settings for a stateful rule, provided as keywords and settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleOptions(software.amazon.awscdk.IResolvable ruleOptions) {
                this.ruleOptions = ruleOptions;
                return this;
            }

            /**
             * Sets the value of {@link StatefulRuleProperty#getRuleOptions}
             * @param ruleOptions Additional settings for a stateful rule, provided as keywords and settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleOptions(java.util.List<? extends java.lang.Object> ruleOptions) {
                this.ruleOptions = ruleOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatefulRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatefulRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatefulRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatefulRuleProperty {
            private final java.lang.String action;
            private final java.lang.Object header;
            private final java.lang.Object ruleOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleOptions = software.amazon.jsii.Kernel.get(this, "ruleOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.header = java.util.Objects.requireNonNull(builder.header, "header is required");
                this.ruleOptions = java.util.Objects.requireNonNull(builder.ruleOptions, "ruleOptions is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.Object getRuleOptions() {
                return this.ruleOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("header", om.valueToTree(this.getHeader()));
                data.set("ruleOptions", om.valueToTree(this.getRuleOptions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatefulRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatefulRuleProperty.Jsii$Proxy that = (StatefulRuleProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!header.equals(that.header)) return false;
                return this.ruleOptions.equals(that.ruleOptions);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.header.hashCode());
                result = 31 * result + (this.ruleOptions.hashCode());
                return result;
            }
        }
    }
    /**
     * A single stateless rule.
     * <p>
     * This is used in <code>RuleGroup.StatelessRulesAndCustomActions</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatelessRuleProperty statelessRuleProperty = StatelessRuleProperty.builder()
     *         .priority(123)
     *         .ruleDefinition(RuleDefinitionProperty.builder()
     *                 .actions(List.of("actions"))
     *                 .matchAttributes(MatchAttributesProperty.builder()
     *                         .destinationPorts(List.of(PortRangeProperty.builder()
     *                                 .fromPort(123)
     *                                 .toPort(123)
     *                                 .build()))
     *                         .destinations(List.of(AddressProperty.builder()
     *                                 .addressDefinition("addressDefinition")
     *                                 .build()))
     *                         .protocols(List.of(123))
     *                         .sourcePorts(List.of(PortRangeProperty.builder()
     *                                 .fromPort(123)
     *                                 .toPort(123)
     *                                 .build()))
     *                         .sources(List.of(AddressProperty.builder()
     *                                 .addressDefinition("addressDefinition")
     *                                 .build()))
     *                         .tcpFlags(List.of(TCPFlagFieldProperty.builder()
     *                                 .flags(List.of("flags"))
     *                                 // the properties below are optional
     *                                 .masks(List.of("masks"))
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatelessRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(StatelessRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatelessRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group.
         * <p>
         * Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group.
         * <p>
         * Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code> object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single <code>StatelessRules</code> object.
         * <p>
         * You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there's a wide range in between, for example use 100, 200, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-ruledefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-ruledefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRuleDefinition();

        /**
         * @return a {@link Builder} of {@link StatelessRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatelessRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatelessRuleProperty> {
            java.lang.Number priority;
            java.lang.Object ruleDefinition;

            /**
             * Sets the value of {@link StatelessRuleProperty#getPriority}
             * @param priority Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. This parameter is required.
             *                 Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group.
             *                 <p>
             *                 Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code> object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single <code>StatelessRules</code> object.
             *                 <p>
             *                 You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there's a wide range in between, for example use 100, 200, and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link StatelessRuleProperty#getRuleDefinition}
             * @param ruleDefinition Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleDefinition(software.amazon.awscdk.IResolvable ruleDefinition) {
                this.ruleDefinition = ruleDefinition;
                return this;
            }

            /**
             * Sets the value of {@link StatelessRuleProperty#getRuleDefinition}
             * @param ruleDefinition Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleDefinition(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RuleDefinitionProperty ruleDefinition) {
                this.ruleDefinition = ruleDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatelessRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatelessRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatelessRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatelessRuleProperty {
            private final java.lang.Number priority;
            private final java.lang.Object ruleDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ruleDefinition = software.amazon.jsii.Kernel.get(this, "ruleDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.ruleDefinition = java.util.Objects.requireNonNull(builder.ruleDefinition, "ruleDefinition is required");
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Object getRuleDefinition() {
                return this.ruleDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("ruleDefinition", om.valueToTree(this.getRuleDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatelessRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatelessRuleProperty.Jsii$Proxy that = (StatelessRuleProperty.Jsii$Proxy) o;

                if (!priority.equals(that.priority)) return false;
                return this.ruleDefinition.equals(that.ruleDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.priority.hashCode();
                result = 31 * result + (this.ruleDefinition.hashCode());
                return result;
            }
        }
    }
    /**
     * Stateless inspection criteria.
     * <p>
     * Each stateless rule group uses exactly one of these data types to define its stateless rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatelessRulesAndCustomActionsProperty statelessRulesAndCustomActionsProperty = StatelessRulesAndCustomActionsProperty.builder()
     *         .statelessRules(List.of(StatelessRuleProperty.builder()
     *                 .priority(123)
     *                 .ruleDefinition(RuleDefinitionProperty.builder()
     *                         .actions(List.of("actions"))
     *                         .matchAttributes(MatchAttributesProperty.builder()
     *                                 .destinationPorts(List.of(PortRangeProperty.builder()
     *                                         .fromPort(123)
     *                                         .toPort(123)
     *                                         .build()))
     *                                 .destinations(List.of(AddressProperty.builder()
     *                                         .addressDefinition("addressDefinition")
     *                                         .build()))
     *                                 .protocols(List.of(123))
     *                                 .sourcePorts(List.of(PortRangeProperty.builder()
     *                                         .fromPort(123)
     *                                         .toPort(123)
     *                                         .build()))
     *                                 .sources(List.of(AddressProperty.builder()
     *                                         .addressDefinition("addressDefinition")
     *                                         .build()))
     *                                 .tcpFlags(List.of(TCPFlagFieldProperty.builder()
     *                                         .flags(List.of("flags"))
     *                                         // the properties below are optional
     *                                         .masks(List.of("masks"))
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .customActions(List.of(CustomActionProperty.builder()
     *                 .actionDefinition(ActionDefinitionProperty.builder()
     *                         .publishMetricAction(PublishMetricActionProperty.builder()
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .actionName("actionName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatelessRulesAndCustomActionsProperty")
    @software.amazon.jsii.Jsii.Proxy(StatelessRulesAndCustomActionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatelessRulesAndCustomActionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the set of stateless rules for use in a stateless rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-statelessrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-statelessrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatelessRules();

        /**
         * Defines an array of individual custom action definitions that are available for use by the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification.
         * <p>
         * You name each custom action that you define, and then you can use it by name in your stateless rule <code>RuleGroup.RuleDefinition</code> <code>Actions</code> specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-customactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-customactions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatelessRulesAndCustomActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatelessRulesAndCustomActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatelessRulesAndCustomActionsProperty> {
            java.lang.Object statelessRules;
            java.lang.Object customActions;

            /**
             * Sets the value of {@link StatelessRulesAndCustomActionsProperty#getStatelessRules}
             * @param statelessRules Defines the set of stateless rules for use in a stateless rule group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessRules(software.amazon.awscdk.IResolvable statelessRules) {
                this.statelessRules = statelessRules;
                return this;
            }

            /**
             * Sets the value of {@link StatelessRulesAndCustomActionsProperty#getStatelessRules}
             * @param statelessRules Defines the set of stateless rules for use in a stateless rule group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessRules(java.util.List<? extends java.lang.Object> statelessRules) {
                this.statelessRules = statelessRules;
                return this;
            }

            /**
             * Sets the value of {@link StatelessRulesAndCustomActionsProperty#getCustomActions}
             * @param customActions Defines an array of individual custom action definitions that are available for use by the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification.
             *                      You name each custom action that you define, and then you can use it by name in your stateless rule <code>RuleGroup.RuleDefinition</code> <code>Actions</code> specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customActions(software.amazon.awscdk.IResolvable customActions) {
                this.customActions = customActions;
                return this;
            }

            /**
             * Sets the value of {@link StatelessRulesAndCustomActionsProperty#getCustomActions}
             * @param customActions Defines an array of individual custom action definitions that are available for use by the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification.
             *                      You name each custom action that you define, and then you can use it by name in your stateless rule <code>RuleGroup.RuleDefinition</code> <code>Actions</code> specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customActions(java.util.List<? extends java.lang.Object> customActions) {
                this.customActions = customActions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatelessRulesAndCustomActionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatelessRulesAndCustomActionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatelessRulesAndCustomActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatelessRulesAndCustomActionsProperty {
            private final java.lang.Object statelessRules;
            private final java.lang.Object customActions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statelessRules = software.amazon.jsii.Kernel.get(this, "statelessRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customActions = software.amazon.jsii.Kernel.get(this, "customActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statelessRules = java.util.Objects.requireNonNull(builder.statelessRules, "statelessRules is required");
                this.customActions = builder.customActions;
            }

            @Override
            public final java.lang.Object getStatelessRules() {
                return this.statelessRules;
            }

            @Override
            public final java.lang.Object getCustomActions() {
                return this.customActions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statelessRules", om.valueToTree(this.getStatelessRules()));
                if (this.getCustomActions() != null) {
                    data.set("customActions", om.valueToTree(this.getCustomActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.StatelessRulesAndCustomActionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatelessRulesAndCustomActionsProperty.Jsii$Proxy that = (StatelessRulesAndCustomActionsProperty.Jsii$Proxy) o;

                if (!statelessRules.equals(that.statelessRules)) return false;
                return this.customActions != null ? this.customActions.equals(that.customActions) : that.customActions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statelessRules.hashCode();
                result = 31 * result + (this.customActions != null ? this.customActions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * TCP flags and masks to inspect packets for. This is used in the <code>RuleGroup.MatchAttributes</code> specification.
     * <p>
     * For example:
     * <p>
     * <code>"TCPFlags": [ { "Flags": [ "ECE", "SYN" ], "Masks": [ "SYN", "ECE" ] } ]</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * TCPFlagFieldProperty tCPFlagFieldProperty = TCPFlagFieldProperty.builder()
     *         .flags(List.of("flags"))
     *         // the properties below are optional
     *         .masks(List.of("masks"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.TCPFlagFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(TCPFlagFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TCPFlagFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match.
         * <p>
         * This setting can only specify values that are also specified in the <code>Masks</code> setting.
         * <p>
         * For the flags that are specified in the masks setting, the following must be true for the packet to match:
         * <p>
         * <ul>
         * <li>The ones that are set in this flags setting must be set in the packet.</li>
         * <li>The ones that are not set in this flags setting must also not be set in the packet.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-flags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-flags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getFlags();

        /**
         * The set of flags to consider in the inspection.
         * <p>
         * To inspect all flags in the valid values list, leave this with no setting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-masks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-masks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMasks() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TCPFlagFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TCPFlagFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TCPFlagFieldProperty> {
            java.util.List<java.lang.String> flags;
            java.util.List<java.lang.String> masks;

            /**
             * Sets the value of {@link TCPFlagFieldProperty#getFlags}
             * @param flags Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match. This parameter is required.
             *              This setting can only specify values that are also specified in the <code>Masks</code> setting.
             *              <p>
             *              For the flags that are specified in the masks setting, the following must be true for the packet to match:
             *              <p>
             *              <ul>
             *              <li>The ones that are set in this flags setting must be set in the packet.</li>
             *              <li>The ones that are not set in this flags setting must also not be set in the packet.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flags(java.util.List<java.lang.String> flags) {
                this.flags = flags;
                return this;
            }

            /**
             * Sets the value of {@link TCPFlagFieldProperty#getMasks}
             * @param masks The set of flags to consider in the inspection.
             *              To inspect all flags in the valid values list, leave this with no setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masks(java.util.List<java.lang.String> masks) {
                this.masks = masks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TCPFlagFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TCPFlagFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TCPFlagFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TCPFlagFieldProperty {
            private final java.util.List<java.lang.String> flags;
            private final java.util.List<java.lang.String> masks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.flags = software.amazon.jsii.Kernel.get(this, "flags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.masks = software.amazon.jsii.Kernel.get(this, "masks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.flags = java.util.Objects.requireNonNull(builder.flags, "flags is required");
                this.masks = builder.masks;
            }

            @Override
            public final java.util.List<java.lang.String> getFlags() {
                return this.flags;
            }

            @Override
            public final java.util.List<java.lang.String> getMasks() {
                return this.masks;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("flags", om.valueToTree(this.getFlags()));
                if (this.getMasks() != null) {
                    data.set("masks", om.valueToTree(this.getMasks()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroup.TCPFlagFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TCPFlagFieldProperty.Jsii$Proxy that = (TCPFlagFieldProperty.Jsii$Proxy) o;

                if (!flags.equals(that.flags)) return false;
                return this.masks != null ? this.masks.equals(that.masks) : that.masks == null;
            }

            @Override
            public final int hashCode() {
                int result = this.flags.hashCode();
                result = 31 * result + (this.masks != null ? this.masks.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkfirewall.CfnRuleGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkfirewall.CfnRuleGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.networkfirewall.CfnRuleGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.networkfirewall.CfnRuleGroupProps.Builder();
        }

        /**
         * The maximum operating resources that this rule group can use.
         * <p>
         * You can't change a rule group's capacity setting after you create the rule group. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity</a>
         * @param capacity The maximum operating resources that this rule group can use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(final java.lang.Number capacity) {
            this.props.capacity(capacity);
            return this;
        }

        /**
         * The descriptive name of the rule group.
         * <p>
         * You can't change the name of a rule group after you create it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname</a>
         * @param ruleGroupName The descriptive name of the rule group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroupName(final java.lang.String ruleGroupName) {
            this.props.ruleGroupName(ruleGroupName);
            return this;
        }

        /**
         * Indicates whether the rule group is stateless or stateful.
         * <p>
         * If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type</a>
         * @param type Indicates whether the rule group is stateless or stateful. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * A description of the rule group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description</a>
         * @param description A description of the rule group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An object that defines the rule group rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup</a>
         * @param ruleGroup An object that defines the rule group rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroup(final software.amazon.awscdk.IResolvable ruleGroup) {
            this.props.ruleGroup(ruleGroup);
            return this;
        }
        /**
         * An object that defines the rule group rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup</a>
         * @param ruleGroup An object that defines the rule group rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroup(final software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RuleGroupProperty ruleGroup) {
            this.props.ruleGroup(ruleGroup);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.networkfirewall.CfnRuleGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkfirewall.CfnRuleGroup build() {
            return new software.amazon.awscdk.services.networkfirewall.CfnRuleGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
