package software.amazon.awscdk.services.networkfirewall;

/**
 * The object that defines a TLS inspection configuration.
 * <p>
 * AWS Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
 * <p>
 * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnTLSInspectionConfiguration cfnTLSInspectionConfiguration = CfnTLSInspectionConfiguration.Builder.create(this, "MyCfnTLSInspectionConfiguration")
 *         .tlsInspectionConfiguration(TLSInspectionConfigurationProperty.builder()
 *                 .serverCertificateConfigurations(List.of(ServerCertificateConfigurationProperty.builder()
 *                         .certificateAuthorityArn("certificateAuthorityArn")
 *                         .checkCertificateRevocationStatus(CheckCertificateRevocationStatusProperty.builder()
 *                                 .revokedStatusAction("revokedStatusAction")
 *                                 .unknownStatusAction("unknownStatusAction")
 *                                 .build())
 *                         .scopes(List.of(ServerCertificateScopeProperty.builder()
 *                                 .destinationPorts(List.of(PortRangeProperty.builder()
 *                                         .fromPort(123)
 *                                         .toPort(123)
 *                                         .build()))
 *                                 .destinations(List.of(AddressProperty.builder()
 *                                         .addressDefinition("addressDefinition")
 *                                         .build()))
 *                                 .protocols(List.of(123))
 *                                 .sourcePorts(List.of(PortRangeProperty.builder()
 *                                         .fromPort(123)
 *                                         .toPort(123)
 *                                         .build()))
 *                                 .sources(List.of(AddressProperty.builder()
 *                                         .addressDefinition("addressDefinition")
 *                                         .build()))
 *                                 .build()))
 *                         .serverCertificates(List.of(ServerCertificateProperty.builder()
 *                                 .resourceArn("resourceArn")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .tlsInspectionConfigurationName("tlsInspectionConfigurationName")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:52.385Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration")
public class CfnTLSInspectionConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnTLSInspectionConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTLSInspectionConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTLSInspectionConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTlsInspectionConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTlsInspectionConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the TLS inspection configuration.
     * <p>
     * This ID is returned in the responses to create and list commands. You provide it to operations such as update and delete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTlsInspectionConfigurationId() {
        return software.amazon.jsii.Kernel.get(this, "attrTlsInspectionConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The object that defines a TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTlsInspectionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "tlsInspectionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The object that defines a TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsInspectionConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tlsInspectionConfiguration", java.util.Objects.requireNonNull(value, "tlsInspectionConfiguration is required"));
    }

    /**
     * The object that defines a TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsInspectionConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration.TLSInspectionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "tlsInspectionConfiguration", java.util.Objects.requireNonNull(value, "tlsInspectionConfiguration is required"));
    }

    /**
     * The descriptive name of the TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTlsInspectionConfigurationName() {
        return software.amazon.jsii.Kernel.get(this, "tlsInspectionConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The descriptive name of the TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsInspectionConfigurationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tlsInspectionConfigurationName", java.util.Objects.requireNonNull(value, "tlsInspectionConfigurationName is required"));
    }

    /**
     * A description of the TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the TLS inspection configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The key:value pairs to associate with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The key:value pairs to associate with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A single IP address specification.
     * <p>
     * This is used in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html">MatchAttributes</a> source and destination settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * AddressProperty addressProperty = AddressProperty.builder()
     *         .addressDefinition("addressDefinition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-address.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-address.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.AddressProperty")
    @software.amazon.jsii.Jsii.Proxy(AddressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
         * <p>
         * Network Firewall supports all address ranges for IPv4 and IPv6.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
         * <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
         * <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-address.html#cfn-networkfirewall-tlsinspectionconfiguration-address-addressdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-address.html#cfn-networkfirewall-tlsinspectionconfiguration-address-addressdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAddressDefinition();

        /**
         * @return a {@link Builder} of {@link AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddressProperty> {
            java.lang.String addressDefinition;

            /**
             * Sets the value of {@link AddressProperty#getAddressDefinition}
             * @param addressDefinition Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. This parameter is required.
             *                          Network Firewall supports all address ranges for IPv4 and IPv6.
             *                          <p>
             *                          Examples:
             *                          <p>
             *                          <ul>
             *                          <li>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code> .</li>
             *                          <li>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code> .</li>
             *                          <li>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code> .</li>
             *                          <li>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code> .</li>
             *                          </ul>
             *                          <p>
             *                          For more information about CIDR notation, see the Wikipedia entry <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addressDefinition(java.lang.String addressDefinition) {
                this.addressDefinition = addressDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddressProperty {
            private final java.lang.String addressDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addressDefinition = software.amazon.jsii.Kernel.get(this, "addressDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addressDefinition = java.util.Objects.requireNonNull(builder.addressDefinition, "addressDefinition is required");
            }

            @Override
            public final java.lang.String getAddressDefinition() {
                return this.addressDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("addressDefinition", om.valueToTree(this.getAddressDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.AddressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddressProperty.Jsii$Proxy that = (AddressProperty.Jsii$Proxy) o;

                return this.addressDefinition.equals(that.addressDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.addressDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status.
     * <p>
     * If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a <code>CertificateAuthorityArn</code> in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html">ServerCertificateConfiguration</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * CheckCertificateRevocationStatusProperty checkCertificateRevocationStatusProperty = CheckCertificateRevocationStatusProperty.builder()
     *         .revokedStatusAction("revokedStatusAction")
     *         .unknownStatusAction("unknownStatusAction")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.CheckCertificateRevocationStatusProperty")
    @software.amazon.jsii.Jsii.Proxy(CheckCertificateRevocationStatusProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CheckCertificateRevocationStatusProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has a revoked status.
         * <p>
         * <ul>
         * <li><em>PASS</em> - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.</li>
         * <li><em>DROP</em> - Network Firewall closes the connection and drops subsequent packets for that connection.</li>
         * <li><em>REJECT</em> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus.html#cfn-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus-revokedstatusaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus.html#cfn-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus-revokedstatusaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRevokedStatusAction() {
            return null;
        }

        /**
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
         * <p>
         * <ul>
         * <li><em>PASS</em> - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.</li>
         * <li><em>DROP</em> - Network Firewall closes the connection and drops subsequent packets for that connection.</li>
         * <li><em>REJECT</em> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus.html#cfn-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus-unknownstatusaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus.html#cfn-networkfirewall-tlsinspectionconfiguration-checkcertificaterevocationstatus-unknownstatusaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnknownStatusAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CheckCertificateRevocationStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CheckCertificateRevocationStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CheckCertificateRevocationStatusProperty> {
            java.lang.String revokedStatusAction;
            java.lang.String unknownStatusAction;

            /**
             * Sets the value of {@link CheckCertificateRevocationStatusProperty#getRevokedStatusAction}
             * @param revokedStatusAction Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has a revoked status.
             *                            <ul>
             *                            <li><em>PASS</em> - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.</li>
             *                            <li><em>DROP</em> - Network Firewall closes the connection and drops subsequent packets for that connection.</li>
             *                            <li><em>REJECT</em> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revokedStatusAction(java.lang.String revokedStatusAction) {
                this.revokedStatusAction = revokedStatusAction;
                return this;
            }

            /**
             * Sets the value of {@link CheckCertificateRevocationStatusProperty#getUnknownStatusAction}
             * @param unknownStatusAction Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
             *                            <ul>
             *                            <li><em>PASS</em> - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.</li>
             *                            <li><em>DROP</em> - Network Firewall closes the connection and drops subsequent packets for that connection.</li>
             *                            <li><em>REJECT</em> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unknownStatusAction(java.lang.String unknownStatusAction) {
                this.unknownStatusAction = unknownStatusAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CheckCertificateRevocationStatusProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CheckCertificateRevocationStatusProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CheckCertificateRevocationStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CheckCertificateRevocationStatusProperty {
            private final java.lang.String revokedStatusAction;
            private final java.lang.String unknownStatusAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.revokedStatusAction = software.amazon.jsii.Kernel.get(this, "revokedStatusAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unknownStatusAction = software.amazon.jsii.Kernel.get(this, "unknownStatusAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.revokedStatusAction = builder.revokedStatusAction;
                this.unknownStatusAction = builder.unknownStatusAction;
            }

            @Override
            public final java.lang.String getRevokedStatusAction() {
                return this.revokedStatusAction;
            }

            @Override
            public final java.lang.String getUnknownStatusAction() {
                return this.unknownStatusAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRevokedStatusAction() != null) {
                    data.set("revokedStatusAction", om.valueToTree(this.getRevokedStatusAction()));
                }
                if (this.getUnknownStatusAction() != null) {
                    data.set("unknownStatusAction", om.valueToTree(this.getUnknownStatusAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.CheckCertificateRevocationStatusProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CheckCertificateRevocationStatusProperty.Jsii$Proxy that = (CheckCertificateRevocationStatusProperty.Jsii$Proxy) o;

                if (this.revokedStatusAction != null ? !this.revokedStatusAction.equals(that.revokedStatusAction) : that.revokedStatusAction != null) return false;
                return this.unknownStatusAction != null ? this.unknownStatusAction.equals(that.unknownStatusAction) : that.unknownStatusAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.revokedStatusAction != null ? this.revokedStatusAction.hashCode() : 0;
                result = 31 * result + (this.unknownStatusAction != null ? this.unknownStatusAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single port range specification.
     * <p>
     * This is used for source and destination port ranges in the stateless rule <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html">MatchAttributes</a> , <code>SourcePorts</code> , and <code>DestinationPorts</code> settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * PortRangeProperty portRangeProperty = PortRangeProperty.builder()
     *         .fromPort(123)
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-portrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-portrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.PortRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(PortRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lower limit of the port range.
         * <p>
         * This must be less than or equal to the <code>ToPort</code> specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-portrange.html#cfn-networkfirewall-tlsinspectionconfiguration-portrange-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-portrange.html#cfn-networkfirewall-tlsinspectionconfiguration-portrange-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * The upper limit of the port range.
         * <p>
         * This must be greater than or equal to the <code>FromPort</code> specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-portrange.html#cfn-networkfirewall-tlsinspectionconfiguration-portrange-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-portrange.html#cfn-networkfirewall-tlsinspectionconfiguration-portrange-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortRangeProperty> {
            java.lang.Number fromPort;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link PortRangeProperty#getFromPort}
             * @param fromPort The lower limit of the port range. This parameter is required.
             *                 This must be less than or equal to the <code>ToPort</code> specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link PortRangeProperty#getToPort}
             * @param toPort The upper limit of the port range. This parameter is required.
             *               This must be greater than or equal to the <code>FromPort</code> specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortRangeProperty {
            private final java.lang.Number fromPort;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.PortRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortRangeProperty.Jsii$Proxy that = (PortRangeProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Configures the AWS Certificate Manager certificates and scope that Network Firewall uses to decrypt and re-encrypt traffic using a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html">TLSInspectionConfiguration</a> . You can configure <code>ServerCertificates</code> for inbound SSL/TLS inspection, a <code>CertificateAuthorityArn</code> for outbound SSL/TLS inspection, or both. For information about working with certificates for TLS inspection, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html">Using SSL/TLS server certficiates with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If a server certificate that's associated with your <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html">TLSInspectionConfiguration</a> is revoked, deleted, or expired it can result in client-side TLS errors.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * ServerCertificateConfigurationProperty serverCertificateConfigurationProperty = ServerCertificateConfigurationProperty.builder()
     *         .certificateAuthorityArn("certificateAuthorityArn")
     *         .checkCertificateRevocationStatus(CheckCertificateRevocationStatusProperty.builder()
     *                 .revokedStatusAction("revokedStatusAction")
     *                 .unknownStatusAction("unknownStatusAction")
     *                 .build())
     *         .scopes(List.of(ServerCertificateScopeProperty.builder()
     *                 .destinationPorts(List.of(PortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .toPort(123)
     *                         .build()))
     *                 .destinations(List.of(AddressProperty.builder()
     *                         .addressDefinition("addressDefinition")
     *                         .build()))
     *                 .protocols(List.of(123))
     *                 .sourcePorts(List.of(PortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .toPort(123)
     *                         .build()))
     *                 .sources(List.of(AddressProperty.builder()
     *                         .addressDefinition("addressDefinition")
     *                         .build()))
     *                 .build()))
     *         .serverCertificates(List.of(ServerCertificateProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.ServerCertificateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerCertificateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerCertificateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within AWS Certificate Manager (ACM) to use for outbound SSL/TLS inspection.
         * <p>
         * The following limitations apply:
         * <p>
         * <ul>
         * <li>You can use CA certificates that you imported into ACM, but you can't generate CA certificates with ACM.</li>
         * <li>You can't use certificates issued by AWS Private Certificate Authority .</li>
         * </ul>
         * <p>
         * For more information about configuring certificates for outbound inspection, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html">Using SSL/TLS certificates with certificates with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * <p>
         * For information about working with certificates in ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-certificateauthorityarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-certificateauthorityarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateAuthorityArn() {
            return null;
        }

        /**
         * When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status.
         * <p>
         * If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a <code>CertificateAuthorityArn</code> in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html">ServerCertificateConfiguration</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-checkcertificaterevocationstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-checkcertificaterevocationstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCheckCertificateRevocationStatus() {
            return null;
        }

        /**
         * A list of scopes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-scopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-scopes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScopes() {
            return null;
        }

        /**
         * The list of server certificates to use for inbound SSL/TLS inspection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-servercertificates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration-servercertificates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerCertificates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerCertificateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerCertificateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateConfigurationProperty> {
            java.lang.String certificateAuthorityArn;
            java.lang.Object checkCertificateRevocationStatus;
            java.lang.Object scopes;
            java.lang.Object serverCertificates;

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getCertificateAuthorityArn}
             * @param certificateAuthorityArn The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within AWS Certificate Manager (ACM) to use for outbound SSL/TLS inspection.
             *                                The following limitations apply:
             *                                <p>
             *                                <ul>
             *                                <li>You can use CA certificates that you imported into ACM, but you can't generate CA certificates with ACM.</li>
             *                                <li>You can't use certificates issued by AWS Private Certificate Authority .</li>
             *                                </ul>
             *                                <p>
             *                                For more information about configuring certificates for outbound inspection, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html">Using SSL/TLS certificates with certificates with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
             *                                <p>
             *                                For information about working with certificates in ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates</a> in the <em>AWS Certificate Manager User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateAuthorityArn(java.lang.String certificateAuthorityArn) {
                this.certificateAuthorityArn = certificateAuthorityArn;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getCheckCertificateRevocationStatus}
             * @param checkCertificateRevocationStatus When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status.
             *                                         If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a <code>CertificateAuthorityArn</code> in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html">ServerCertificateConfiguration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkCertificateRevocationStatus(software.amazon.awscdk.IResolvable checkCertificateRevocationStatus) {
                this.checkCertificateRevocationStatus = checkCertificateRevocationStatus;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getCheckCertificateRevocationStatus}
             * @param checkCertificateRevocationStatus When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status.
             *                                         If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a <code>CertificateAuthorityArn</code> in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html">ServerCertificateConfiguration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkCertificateRevocationStatus(software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration.CheckCertificateRevocationStatusProperty checkCertificateRevocationStatus) {
                this.checkCertificateRevocationStatus = checkCertificateRevocationStatus;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getScopes}
             * @param scopes A list of scopes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopes(software.amazon.awscdk.IResolvable scopes) {
                this.scopes = scopes;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getScopes}
             * @param scopes A list of scopes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopes(java.util.List<? extends java.lang.Object> scopes) {
                this.scopes = scopes;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getServerCertificates}
             * @param serverCertificates The list of server certificates to use for inbound SSL/TLS inspection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificates(software.amazon.awscdk.IResolvable serverCertificates) {
                this.serverCertificates = serverCertificates;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigurationProperty#getServerCertificates}
             * @param serverCertificates The list of server certificates to use for inbound SSL/TLS inspection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificates(java.util.List<? extends java.lang.Object> serverCertificates) {
                this.serverCertificates = serverCertificates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerCertificateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerCertificateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerCertificateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateConfigurationProperty {
            private final java.lang.String certificateAuthorityArn;
            private final java.lang.Object checkCertificateRevocationStatus;
            private final java.lang.Object scopes;
            private final java.lang.Object serverCertificates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateAuthorityArn = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.checkCertificateRevocationStatus = software.amazon.jsii.Kernel.get(this, "checkCertificateRevocationStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverCertificates = software.amazon.jsii.Kernel.get(this, "serverCertificates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateAuthorityArn = builder.certificateAuthorityArn;
                this.checkCertificateRevocationStatus = builder.checkCertificateRevocationStatus;
                this.scopes = builder.scopes;
                this.serverCertificates = builder.serverCertificates;
            }

            @Override
            public final java.lang.String getCertificateAuthorityArn() {
                return this.certificateAuthorityArn;
            }

            @Override
            public final java.lang.Object getCheckCertificateRevocationStatus() {
                return this.checkCertificateRevocationStatus;
            }

            @Override
            public final java.lang.Object getScopes() {
                return this.scopes;
            }

            @Override
            public final java.lang.Object getServerCertificates() {
                return this.serverCertificates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateAuthorityArn() != null) {
                    data.set("certificateAuthorityArn", om.valueToTree(this.getCertificateAuthorityArn()));
                }
                if (this.getCheckCertificateRevocationStatus() != null) {
                    data.set("checkCertificateRevocationStatus", om.valueToTree(this.getCheckCertificateRevocationStatus()));
                }
                if (this.getScopes() != null) {
                    data.set("scopes", om.valueToTree(this.getScopes()));
                }
                if (this.getServerCertificates() != null) {
                    data.set("serverCertificates", om.valueToTree(this.getServerCertificates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.ServerCertificateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerCertificateConfigurationProperty.Jsii$Proxy that = (ServerCertificateConfigurationProperty.Jsii$Proxy) o;

                if (this.certificateAuthorityArn != null ? !this.certificateAuthorityArn.equals(that.certificateAuthorityArn) : that.certificateAuthorityArn != null) return false;
                if (this.checkCertificateRevocationStatus != null ? !this.checkCertificateRevocationStatus.equals(that.checkCertificateRevocationStatus) : that.checkCertificateRevocationStatus != null) return false;
                if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
                return this.serverCertificates != null ? this.serverCertificates.equals(that.serverCertificates) : that.serverCertificates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateAuthorityArn != null ? this.certificateAuthorityArn.hashCode() : 0;
                result = 31 * result + (this.checkCertificateRevocationStatus != null ? this.checkCertificateRevocationStatus.hashCode() : 0);
                result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
                result = 31 * result + (this.serverCertificates != null ? this.serverCertificates.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Any AWS Certificate Manager (ACM) Secure Sockets Layer/Transport Layer Security (SSL/TLS) server certificate that's associated with a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificateconfiguration.html">ServerCertificateConfiguration</a> . Used in a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html">TLSInspectionConfiguration</a> for inspection of inbound traffic to your firewall. You must request or import a SSL/TLS certificate into ACM for each domain Network Firewall needs to decrypt and inspect. AWS Network Firewall uses the SSL/TLS certificates to decrypt specified inbound SSL/TLS traffic going to your firewall. For information about working with certificates in AWS Certificate Manager , see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * ServerCertificateProperty serverCertificateProperty = ServerCertificateProperty.builder()
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.ServerCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificate.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificate-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificate.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificate-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateProperty> {
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link ServerCertificateProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the AWS Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = builder.resourceArn;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceArn() != null) {
                    data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.ServerCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerCertificateProperty.Jsii$Proxy that = (ServerCertificateProperty.Jsii$Proxy) o;

                return this.resourceArn != null ? this.resourceArn.equals(that.resourceArn) : that.resourceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn != null ? this.resourceArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings that define the Secure Sockets Layer/Transport Layer Security (SSL/TLS) traffic that Network Firewall should decrypt for inspection by the stateful rule engine.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * ServerCertificateScopeProperty serverCertificateScopeProperty = ServerCertificateScopeProperty.builder()
     *         .destinationPorts(List.of(PortRangeProperty.builder()
     *                 .fromPort(123)
     *                 .toPort(123)
     *                 .build()))
     *         .destinations(List.of(AddressProperty.builder()
     *                 .addressDefinition("addressDefinition")
     *                 .build()))
     *         .protocols(List.of(123))
     *         .sourcePorts(List.of(PortRangeProperty.builder()
     *                 .fromPort(123)
     *                 .toPort(123)
     *                 .build()))
     *         .sources(List.of(AddressProperty.builder()
     *                 .addressDefinition("addressDefinition")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.ServerCertificateScopeProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerCertificateScopeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerCertificateScopeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format.
         * <p>
         * If not specified, this matches with any destination port.
         * <p>
         * You can specify individual ports, for example <code>1994</code> , and you can specify port ranges, such as <code>1990:1994</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-destinationports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-destinationports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationPorts() {
            return null;
        }

        /**
         * The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation.
         * <p>
         * If not specified, this
         * matches with any destination address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-destinations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
            return null;
        }

        /**
         * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
         * <p>
         * If not specified, this matches with any protocol.
         * <p>
         * Network Firewall currently supports only TCP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-protocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-protocols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProtocols() {
            return null;
        }

        /**
         * The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format.
         * <p>
         * If not specified, this matches with any source port.
         * <p>
         * You can specify individual ports, for example <code>1994</code> , and you can specify port ranges, such as <code>1990:1994</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-sourceports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-sourceports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourcePorts() {
            return null;
        }

        /**
         * The source IP addresses and address ranges to decrypt for inspection, in CIDR notation.
         * <p>
         * If not specified, this
         * matches with any source address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-servercertificatescope.html#cfn-networkfirewall-tlsinspectionconfiguration-servercertificatescope-sources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSources() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerCertificateScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerCertificateScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateScopeProperty> {
            java.lang.Object destinationPorts;
            java.lang.Object destinations;
            java.lang.Object protocols;
            java.lang.Object sourcePorts;
            java.lang.Object sources;

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getDestinationPorts}
             * @param destinationPorts The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format.
             *                         If not specified, this matches with any destination port.
             *                         <p>
             *                         You can specify individual ports, for example <code>1994</code> , and you can specify port ranges, such as <code>1990:1994</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPorts(software.amazon.awscdk.IResolvable destinationPorts) {
                this.destinationPorts = destinationPorts;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getDestinationPorts}
             * @param destinationPorts The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format.
             *                         If not specified, this matches with any destination port.
             *                         <p>
             *                         You can specify individual ports, for example <code>1994</code> , and you can specify port ranges, such as <code>1990:1994</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPorts(java.util.List<? extends java.lang.Object> destinationPorts) {
                this.destinationPorts = destinationPorts;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getDestinations}
             * @param destinations The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation.
             *                     If not specified, this
             *                     matches with any destination address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getDestinations}
             * @param destinations The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation.
             *                     If not specified, this
             *                     matches with any destination address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getProtocols}
             * @param protocols The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
             *                  If not specified, this matches with any protocol.
             *                  <p>
             *                  Network Firewall currently supports only TCP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocols(java.util.List<? extends java.lang.Number> protocols) {
                this.protocols = protocols;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getProtocols}
             * @param protocols The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
             *                  If not specified, this matches with any protocol.
             *                  <p>
             *                  Network Firewall currently supports only TCP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocols(software.amazon.awscdk.IResolvable protocols) {
                this.protocols = protocols;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getSourcePorts}
             * @param sourcePorts The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format.
             *                    If not specified, this matches with any source port.
             *                    <p>
             *                    You can specify individual ports, for example <code>1994</code> , and you can specify port ranges, such as <code>1990:1994</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePorts(software.amazon.awscdk.IResolvable sourcePorts) {
                this.sourcePorts = sourcePorts;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getSourcePorts}
             * @param sourcePorts The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format.
             *                    If not specified, this matches with any source port.
             *                    <p>
             *                    You can specify individual ports, for example <code>1994</code> , and you can specify port ranges, such as <code>1990:1994</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePorts(java.util.List<? extends java.lang.Object> sourcePorts) {
                this.sourcePorts = sourcePorts;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getSources}
             * @param sources The source IP addresses and address ranges to decrypt for inspection, in CIDR notation.
             *                If not specified, this
             *                matches with any source address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sources(software.amazon.awscdk.IResolvable sources) {
                this.sources = sources;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateScopeProperty#getSources}
             * @param sources The source IP addresses and address ranges to decrypt for inspection, in CIDR notation.
             *                If not specified, this
             *                matches with any source address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sources(java.util.List<? extends java.lang.Object> sources) {
                this.sources = sources;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerCertificateScopeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerCertificateScopeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerCertificateScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateScopeProperty {
            private final java.lang.Object destinationPorts;
            private final java.lang.Object destinations;
            private final java.lang.Object protocols;
            private final java.lang.Object sourcePorts;
            private final java.lang.Object sources;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationPorts = software.amazon.jsii.Kernel.get(this, "destinationPorts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocols = software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourcePorts = software.amazon.jsii.Kernel.get(this, "sourcePorts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationPorts = builder.destinationPorts;
                this.destinations = builder.destinations;
                this.protocols = builder.protocols;
                this.sourcePorts = builder.sourcePorts;
                this.sources = builder.sources;
            }

            @Override
            public final java.lang.Object getDestinationPorts() {
                return this.destinationPorts;
            }

            @Override
            public final java.lang.Object getDestinations() {
                return this.destinations;
            }

            @Override
            public final java.lang.Object getProtocols() {
                return this.protocols;
            }

            @Override
            public final java.lang.Object getSourcePorts() {
                return this.sourcePorts;
            }

            @Override
            public final java.lang.Object getSources() {
                return this.sources;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationPorts() != null) {
                    data.set("destinationPorts", om.valueToTree(this.getDestinationPorts()));
                }
                if (this.getDestinations() != null) {
                    data.set("destinations", om.valueToTree(this.getDestinations()));
                }
                if (this.getProtocols() != null) {
                    data.set("protocols", om.valueToTree(this.getProtocols()));
                }
                if (this.getSourcePorts() != null) {
                    data.set("sourcePorts", om.valueToTree(this.getSourcePorts()));
                }
                if (this.getSources() != null) {
                    data.set("sources", om.valueToTree(this.getSources()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.ServerCertificateScopeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerCertificateScopeProperty.Jsii$Proxy that = (ServerCertificateScopeProperty.Jsii$Proxy) o;

                if (this.destinationPorts != null ? !this.destinationPorts.equals(that.destinationPorts) : that.destinationPorts != null) return false;
                if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
                if (this.protocols != null ? !this.protocols.equals(that.protocols) : that.protocols != null) return false;
                if (this.sourcePorts != null ? !this.sourcePorts.equals(that.sourcePorts) : that.sourcePorts != null) return false;
                return this.sources != null ? this.sources.equals(that.sources) : that.sources == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationPorts != null ? this.destinationPorts.hashCode() : 0;
                result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
                result = 31 * result + (this.protocols != null ? this.protocols.hashCode() : 0);
                result = 31 * result + (this.sourcePorts != null ? this.sourcePorts.hashCode() : 0);
                result = 31 * result + (this.sources != null ? this.sources.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The object that defines a TLS inspection configuration. This defines the TLS inspection configuration.
     * <p>
     * AWS Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
     * <p>
     * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * TLSInspectionConfigurationProperty tLSInspectionConfigurationProperty = TLSInspectionConfigurationProperty.builder()
     *         .serverCertificateConfigurations(List.of(ServerCertificateConfigurationProperty.builder()
     *                 .certificateAuthorityArn("certificateAuthorityArn")
     *                 .checkCertificateRevocationStatus(CheckCertificateRevocationStatusProperty.builder()
     *                         .revokedStatusAction("revokedStatusAction")
     *                         .unknownStatusAction("unknownStatusAction")
     *                         .build())
     *                 .scopes(List.of(ServerCertificateScopeProperty.builder()
     *                         .destinationPorts(List.of(PortRangeProperty.builder()
     *                                 .fromPort(123)
     *                                 .toPort(123)
     *                                 .build()))
     *                         .destinations(List.of(AddressProperty.builder()
     *                                 .addressDefinition("addressDefinition")
     *                                 .build()))
     *                         .protocols(List.of(123))
     *                         .sourcePorts(List.of(PortRangeProperty.builder()
     *                                 .fromPort(123)
     *                                 .toPort(123)
     *                                 .build()))
     *                         .sources(List.of(AddressProperty.builder()
     *                                 .addressDefinition("addressDefinition")
     *                                 .build()))
     *                         .build()))
     *                 .serverCertificates(List.of(ServerCertificateProperty.builder()
     *                         .resourceArn("resourceArn")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.TLSInspectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TLSInspectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TLSInspectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Lists the server certificate configurations that are associated with the TLS configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration-servercertificateconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration-servercertificateconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerCertificateConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TLSInspectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TLSInspectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TLSInspectionConfigurationProperty> {
            java.lang.Object serverCertificateConfigurations;

            /**
             * Sets the value of {@link TLSInspectionConfigurationProperty#getServerCertificateConfigurations}
             * @param serverCertificateConfigurations Lists the server certificate configurations that are associated with the TLS configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateConfigurations(software.amazon.awscdk.IResolvable serverCertificateConfigurations) {
                this.serverCertificateConfigurations = serverCertificateConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TLSInspectionConfigurationProperty#getServerCertificateConfigurations}
             * @param serverCertificateConfigurations Lists the server certificate configurations that are associated with the TLS configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateConfigurations(java.util.List<? extends java.lang.Object> serverCertificateConfigurations) {
                this.serverCertificateConfigurations = serverCertificateConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TLSInspectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TLSInspectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TLSInspectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TLSInspectionConfigurationProperty {
            private final java.lang.Object serverCertificateConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverCertificateConfigurations = software.amazon.jsii.Kernel.get(this, "serverCertificateConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverCertificateConfigurations = builder.serverCertificateConfigurations;
            }

            @Override
            public final java.lang.Object getServerCertificateConfigurations() {
                return this.serverCertificateConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServerCertificateConfigurations() != null) {
                    data.set("serverCertificateConfigurations", om.valueToTree(this.getServerCertificateConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfiguration.TLSInspectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TLSInspectionConfigurationProperty.Jsii$Proxy that = (TLSInspectionConfigurationProperty.Jsii$Proxy) o;

                return this.serverCertificateConfigurations != null ? this.serverCertificateConfigurations.equals(that.serverCertificateConfigurations) : that.serverCertificateConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serverCertificateConfigurations != null ? this.serverCertificateConfigurations.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfigurationProps.Builder();
        }

        /**
         * The object that defines a TLS inspection configuration.
         * <p>
         * AWS Network Firewall uses TLS inspection configurations to decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, AWS Network Firewall inspects the traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using AWS Certificate Manager , create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration</a>
         * @param tlsInspectionConfiguration The object that defines a TLS inspection configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsInspectionConfiguration(final software.amazon.awscdk.IResolvable tlsInspectionConfiguration) {
            this.props.tlsInspectionConfiguration(tlsInspectionConfiguration);
            return this;
        }
        /**
         * The object that defines a TLS inspection configuration.
         * <p>
         * AWS Network Firewall uses TLS inspection configurations to decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, AWS Network Firewall inspects the traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using AWS Certificate Manager , create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration</a>
         * @param tlsInspectionConfiguration The object that defines a TLS inspection configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsInspectionConfiguration(final software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration.TLSInspectionConfigurationProperty tlsInspectionConfiguration) {
            this.props.tlsInspectionConfiguration(tlsInspectionConfiguration);
            return this;
        }

        /**
         * The descriptive name of the TLS inspection configuration.
         * <p>
         * You can't change the name of a TLS inspection configuration after you create it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfigurationname</a>
         * @param tlsInspectionConfigurationName The descriptive name of the TLS inspection configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsInspectionConfigurationName(final java.lang.String tlsInspectionConfigurationName) {
            this.props.tlsInspectionConfigurationName(tlsInspectionConfigurationName);
            return this;
        }

        /**
         * A description of the TLS inspection configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-description</a>
         * @param description A description of the TLS inspection configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The key:value pairs to associate with the resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tags</a>
         * @param tags The key:value pairs to associate with the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration build() {
            return new software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
