package software.amazon.awscdk.services.ram;

/**
 * Properties for defining a <code>CfnResourceShare</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ram.*;
 * CfnResourceShareProps cfnResourceShareProps = CfnResourceShareProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .allowExternalPrincipals(false)
 *         .permissionArns(List.of("permissionArns"))
 *         .principals(List.of("principals"))
 *         .resourceArns(List.of("resourceArns"))
 *         .sources(List.of("sources"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:54.750Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ram.CfnResourceShareProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceShareProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceShareProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the name of the resource share.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share.
     * <p>
     * A value of <code>true</code> lets you share with individual AWS accounts that are <em>not</em> in your organization. A value of <code>false</code> only has meaning if your account is a member of an AWS Organization. The default value is <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-allowexternalprincipals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-allowexternalprincipals</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowExternalPrincipals() {
        return null;
    }

    /**
     * Specifies the <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the AWS RAM permission to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-permissionarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-permissionarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissionArns() {
        return null;
    }

    /**
     * Specifies the principals to associate with the resource share. The possible values are:.
     * <p>
     * <ul>
     * <li>An AWS account ID</li>
     * <li>An Amazon Resource Name (ARN) of an organization in AWS Organizations</li>
     * <li>An ARN of an organizational unit (OU) in AWS Organizations</li>
     * <li>An ARN of an IAM role</li>
     * <li>An ARN of an IAM user</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Not all resource types can be shared with IAM roles and users. For more information, see the column <em>Can share with IAM roles and users</em> in the tables on <a href="https://docs.aws.amazon.com/ram/latest/userguide/shareable.html">Shareable AWS resources</a> in the <em>AWS Resource Access Manager User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-principals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-principals</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrincipals() {
        return null;
    }

    /**
     * Specifies a list of one or more ARNs of the resources to associate with the resource share.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-resourcearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-resourcearns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceArns() {
        return null;
    }

    /**
     * Specifies from which source accounts the service principal has access to the resources in this resource share.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-sources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSources() {
        return null;
    }

    /**
     * Specifies one or more tags to attach to the resource share itself.
     * <p>
     * It doesn't attach the tags to the resources associated with the resource share.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ram-resourceshare.html#cfn-ram-resourceshare-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceShareProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceShareProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceShareProps> {
        java.lang.String name;
        java.lang.Object allowExternalPrincipals;
        java.util.List<java.lang.String> permissionArns;
        java.util.List<java.lang.String> principals;
        java.util.List<java.lang.String> resourceArns;
        java.util.List<java.lang.String> sources;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnResourceShareProps#getName}
         * @param name Specifies the name of the resource share. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getAllowExternalPrincipals}
         * @param allowExternalPrincipals Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share.
         *                                A value of <code>true</code> lets you share with individual AWS accounts that are <em>not</em> in your organization. A value of <code>false</code> only has meaning if your account is a member of an AWS Organization. The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExternalPrincipals(java.lang.Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getAllowExternalPrincipals}
         * @param allowExternalPrincipals Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share.
         *                                A value of <code>true</code> lets you share with individual AWS accounts that are <em>not</em> in your organization. A value of <code>false</code> only has meaning if your account is a member of an AWS Organization. The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExternalPrincipals(software.amazon.awscdk.IResolvable allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getPermissionArns}
         * @param permissionArns Specifies the <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the AWS RAM permission to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionArns(java.util.List<java.lang.String> permissionArns) {
            this.permissionArns = permissionArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getPrincipals}
         * @param principals Specifies the principals to associate with the resource share. The possible values are:.
         *                   <ul>
         *                   <li>An AWS account ID</li>
         *                   <li>An Amazon Resource Name (ARN) of an organization in AWS Organizations</li>
         *                   <li>An ARN of an organizational unit (OU) in AWS Organizations</li>
         *                   <li>An ARN of an IAM role</li>
         *                   <li>An ARN of an IAM user</li>
         *                   </ul>
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   Not all resource types can be shared with IAM roles and users. For more information, see the column <em>Can share with IAM roles and users</em> in the tables on <a href="https://docs.aws.amazon.com/ram/latest/userguide/shareable.html">Shareable AWS resources</a> in the <em>AWS Resource Access Manager User Guide</em> .
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principals(java.util.List<java.lang.String> principals) {
            this.principals = principals;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getResourceArns}
         * @param resourceArns Specifies a list of one or more ARNs of the resources to associate with the resource share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getSources}
         * @param sources Specifies from which source accounts the service principal has access to the resources in this resource share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(java.util.List<java.lang.String> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceShareProps#getTags}
         * @param tags Specifies one or more tags to attach to the resource share itself.
         *             It doesn't attach the tags to the resources associated with the resource share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceShareProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceShareProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceShareProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceShareProps {
        private final java.lang.String name;
        private final java.lang.Object allowExternalPrincipals;
        private final java.util.List<java.lang.String> permissionArns;
        private final java.util.List<java.lang.String> principals;
        private final java.util.List<java.lang.String> resourceArns;
        private final java.util.List<java.lang.String> sources;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowExternalPrincipals = software.amazon.jsii.Kernel.get(this, "allowExternalPrincipals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permissionArns = software.amazon.jsii.Kernel.get(this, "permissionArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.principals = software.amazon.jsii.Kernel.get(this, "principals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourceArns = software.amazon.jsii.Kernel.get(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.allowExternalPrincipals = builder.allowExternalPrincipals;
            this.permissionArns = builder.permissionArns;
            this.principals = builder.principals;
            this.resourceArns = builder.resourceArns;
            this.sources = builder.sources;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAllowExternalPrincipals() {
            return this.allowExternalPrincipals;
        }

        @Override
        public final java.util.List<java.lang.String> getPermissionArns() {
            return this.permissionArns;
        }

        @Override
        public final java.util.List<java.lang.String> getPrincipals() {
            return this.principals;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final java.util.List<java.lang.String> getSources() {
            return this.sources;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAllowExternalPrincipals() != null) {
                data.set("allowExternalPrincipals", om.valueToTree(this.getAllowExternalPrincipals()));
            }
            if (this.getPermissionArns() != null) {
                data.set("permissionArns", om.valueToTree(this.getPermissionArns()));
            }
            if (this.getPrincipals() != null) {
                data.set("principals", om.valueToTree(this.getPrincipals()));
            }
            if (this.getResourceArns() != null) {
                data.set("resourceArns", om.valueToTree(this.getResourceArns()));
            }
            if (this.getSources() != null) {
                data.set("sources", om.valueToTree(this.getSources()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ram.CfnResourceShareProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceShareProps.Jsii$Proxy that = (CfnResourceShareProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.allowExternalPrincipals != null ? !this.allowExternalPrincipals.equals(that.allowExternalPrincipals) : that.allowExternalPrincipals != null) return false;
            if (this.permissionArns != null ? !this.permissionArns.equals(that.permissionArns) : that.permissionArns != null) return false;
            if (this.principals != null ? !this.principals.equals(that.principals) : that.principals != null) return false;
            if (this.resourceArns != null ? !this.resourceArns.equals(that.resourceArns) : that.resourceArns != null) return false;
            if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.allowExternalPrincipals != null ? this.allowExternalPrincipals.hashCode() : 0);
            result = 31 * result + (this.permissionArns != null ? this.permissionArns.hashCode() : 0);
            result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
            result = 31 * result + (this.resourceArns != null ? this.resourceArns.hashCode() : 0);
            result = 31 * result + (this.sources != null ? this.sources.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
