package software.amazon.awscdk.services.rds;

/**
 * The versions for the Aurora PostgreSQL cluster engine (those returned by <code>DatabaseClusterEngine.auroraPostgres</code>).
 * <p>
 * https://docs.aws.amazon.com/AmazonRDS/latest/AuroraPostgreSQLReleaseNotes/AuroraPostgreSQL.Updates.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraPostgres(AuroraPostgresClusterEngineProps.builder().version(AuroraPostgresEngineVersion.VER_15_2).build()))
 *         .credentials(Credentials.fromUsername("adminuser", CredentialsFromUsernameOptions.builder().password(SecretValue.unsafePlainText("7959866cacc02c2d243ecfe177464fe6")).build()))
 *         .writer(ClusterInstance.provisioned("writer", ProvisionedClusterInstanceProps.builder()
 *                 .publiclyAccessible(false)
 *                 .build()))
 *         .readers(List.of(ClusterInstance.provisioned("reader")))
 *         .storageType(DBClusterStorageType.AURORA_IOPT1)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_EGRESS)
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:54.778Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.AuroraPostgresEngineVersion")
public class AuroraPostgresEngineVersion extends software.amazon.jsii.JsiiObject {

    protected AuroraPostgresEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AuroraPostgresEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_10_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_15_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_15_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_4_LIMITLESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_4_LIMITLESS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_6_LIMITLESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_6_LIMITLESS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_16_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_16_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_17_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_17_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_17_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_17_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_17_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_17_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
    }

    /**
     * Create a new AuroraPostgresEngineVersion with an arbitrary version.
     * <p>
     * @param auroraPostgresFullVersion the full version string, for example "9.6.25.1". This parameter is required.
     * @param auroraPostgresMajorVersion the major version of the engine, for example "9.6". This parameter is required.
     * @param auroraPostgresFeatures
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresMajorVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.AuroraPostgresEngineFeatures auroraPostgresFeatures) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(auroraPostgresFullVersion, "auroraPostgresFullVersion is required"), java.util.Objects.requireNonNull(auroraPostgresMajorVersion, "auroraPostgresMajorVersion is required"), auroraPostgresFeatures });
    }

    /**
     * Create a new AuroraPostgresEngineVersion with an arbitrary version.
     * <p>
     * @param auroraPostgresFullVersion the full version string, for example "9.6.25.1". This parameter is required.
     * @param auroraPostgresMajorVersion the major version of the engine, for example "9.6". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(auroraPostgresFullVersion, "auroraPostgresFullVersion is required"), java.util.Objects.requireNonNull(auroraPostgresMajorVersion, "auroraPostgresMajorVersion is required") });
    }

    /**
     * (deprecated) Version "10.11".
     * <p>
     * @deprecated Version 10.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_11;

    /**
     * (deprecated) Version "10.12".
     * <p>
     * @deprecated Version 10.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_12;

    /**
     * (deprecated) Version "10.13".
     * <p>
     * @deprecated Version 10.13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_13;

    /**
     * (deprecated) Version "10.14".
     * <p>
     * @deprecated Version 10.14 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_14;

    /**
     * (deprecated) Version "10.16".
     * <p>
     * @deprecated Version 10.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_16;

    /**
     * (deprecated) Version "10.17".
     * <p>
     * @deprecated Version 10.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_17;

    /**
     * (deprecated) Version "10.18".
     * <p>
     * @deprecated Version 10.18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_18;

    /**
     * (deprecated) Version "10.19".
     * <p>
     * @deprecated Version 10.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_19;

    /**
     * (deprecated) Version "10.20".
     * <p>
     * @deprecated Version 10.20 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_20;

    /**
     * (deprecated) Version "10.21".
     * <p>
     * @deprecated Version 10.21 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_21;

    /**
     * (deprecated) Version "10.4".
     * <p>
     * @deprecated Version 10.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_4;

    /**
     * (deprecated) Version "10.5".
     * <p>
     * @deprecated Version 10.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_5;

    /**
     * (deprecated) Version "10.6".
     * <p>
     * @deprecated Version 10.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_6;

    /**
     * (deprecated) Version "10.7".
     * <p>
     * @deprecated Version 10.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_7;

    /**
     * (deprecated) Version "11.11".
     * <p>
     * @deprecated Version 11.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_11;

    /**
     * (deprecated) Version "11.12".
     * <p>
     * @deprecated Version 11.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_12;

    /**
     * (deprecated) Version "11.13".
     * <p>
     * @deprecated Version 11.13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_13;

    /**
     * (deprecated) Version "11.14".
     * <p>
     * @deprecated Version 11.14 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_14;

    /**
     * (deprecated) Version "11.15".
     * <p>
     * @deprecated Version 11.15 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_15;

    /**
     * (deprecated) Version "11.16".
     * <p>
     * @deprecated Version 11.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_16;

    /**
     * (deprecated) Version "11.17".
     * <p>
     * @deprecated Version 11.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_17;

    /**
     * (deprecated) Version "11.18".
     * <p>
     * @deprecated Version 11.18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_18;

    /**
     * (deprecated) Version "11.19".
     * <p>
     * @deprecated Version 11.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_19;

    /**
     * (deprecated) Version "11.20".
     * <p>
     * @deprecated Version 11.20 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_20;

    /**
     * Version "11.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_21;

    /**
     * (deprecated) Version "11.4".
     * <p>
     * @deprecated Version 11.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_4;

    /**
     * (deprecated) Version "11.6".
     * <p>
     * @deprecated Version 11.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_6;

    /**
     * (deprecated) Version "11.7".
     * <p>
     * @deprecated Version 11.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_7;

    /**
     * (deprecated) Version "11.8".
     * <p>
     * @deprecated Version 11.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_8;

    /**
     * Version "11.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_9;

    /**
     * (deprecated) Version "12.10".
     * <p>
     * @deprecated Version 12.10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_10;

    /**
     * Version "12.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_11;

    /**
     * Version "12.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_12;

    /**
     * Version "12.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_13;

    /**
     * Version "12.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_14;

    /**
     * Version "12.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_15;

    /**
     * Version "12.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_16;

    /**
     * Version "12.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_17;

    /**
     * Version "12.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_18;

    /**
     * Version "12.19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_19;

    /**
     * Version "12.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_20;

    /**
     * Version "12.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_21;

    /**
     * Version "12.22".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_22;

    /**
     * (deprecated) Version "12.4".
     * <p>
     * @deprecated Version 12.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_4;

    /**
     * (deprecated) Version "12.6".
     * <p>
     * @deprecated Version 12.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_6;

    /**
     * (deprecated) Version "12.7".
     * <p>
     * @deprecated Version 12.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_7;

    /**
     * (deprecated) Version "12.8".
     * <p>
     * @deprecated Version 12.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_8;

    /**
     * Version "12.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_9;

    /**
     * Version "13.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_10;

    /**
     * Version "13.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_11;

    /**
     * Version "13.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_12;

    /**
     * Version "13.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_13;

    /**
     * Version "13.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_14;

    /**
     * Version "13.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_15;

    /**
     * Version "13.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_16;

    /**
     * Version "13.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_17;

    /**
     * Version "13.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_18;

    /**
     * Version "13.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_20;

    /**
     * (deprecated) Version "13.3".
     * <p>
     * @deprecated Version 13.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_3;

    /**
     * (deprecated) Version "13.4".
     * <p>
     * @deprecated Version 13.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_4;

    /**
     * (deprecated) Version "13.5".
     * <p>
     * @deprecated Version 13.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_5;

    /**
     * (deprecated) Version "13.6".
     * <p>
     * @deprecated Version 13.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_6;

    /**
     * Version "13.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_7;

    /**
     * Version "13.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_8;

    /**
     * Version "13.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_9;

    /**
     * Version "14.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_10;

    /**
     * Version "14.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_11;

    /**
     * Version "14.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_12;

    /**
     * Version "14.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_13;

    /**
     * Version "14.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_14;

    /**
     * Version "14.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_15;

    /**
     * Version "14.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_17;

    /**
     * Version "14.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_3;

    /**
     * Version "14.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_4;

    /**
     * Version "14.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_5;

    /**
     * Version "14.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_6;

    /**
     * Version "14.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_7;

    /**
     * Version "14.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_8;

    /**
     * Version "14.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_9;

    /**
     * Version "15.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_10;

    /**
     * Version "15.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_12;

    /**
     * Version "15.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_2;

    /**
     * Version "15.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_3;

    /**
     * Version "15.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_4;

    /**
     * Version "15.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_5;

    /**
     * Version "15.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_6;

    /**
     * Version "15.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_7;

    /**
     * Version "15.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_8;

    /**
     * Version "15.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_15_9;

    /**
     * (deprecated) Version "16.0".
     * <p>
     * @deprecated Version 16.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_0;

    /**
     * Version "16.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_1;

    /**
     * Version "16.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_2;

    /**
     * Version "16.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_3;

    /**
     * Version "16.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_4;

    /**
     * Version "16.4 limitless".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_4_LIMITLESS;

    /**
     * (deprecated) Version "16.5".
     * <p>
     * @deprecated Version 16.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_5;

    /**
     * Version "16.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_6;

    /**
     * Version "16.6 limitless".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_6_LIMITLESS;

    /**
     * Version "16.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_16_8;

    /**
     * (deprecated) Version "17.1".
     * <p>
     * @deprecated Version 17.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_17_1;

    /**
     * (deprecated) Version "17.2".
     * <p>
     * @deprecated Version 17.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_17_2;

    /**
     * Version "17.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_17_4;

    /**
     * (deprecated) Version "9.6.11".
     * <p>
     * @deprecated Version 9.6.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_11;

    /**
     * (deprecated) Version "9.6.12".
     * <p>
     * @deprecated Version 9.6.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_12;

    /**
     * (deprecated) Version "9.6.16".
     * <p>
     * @deprecated Version 9.6.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_16;

    /**
     * (deprecated) Version "9.6.17".
     * <p>
     * @deprecated Version 9.6.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_17;

    /**
     * (deprecated) Version "9.6.18".
     * <p>
     * @deprecated Version 9.6.18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_18;

    /**
     * (deprecated) Version "9.6.19".
     * <p>
     * @deprecated Version 9.6.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_19;

    /**
     * (deprecated) Version "9.6.22".
     * <p>
     * @deprecated Version 9.6.22 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_22;

    /**
     * (deprecated) Version "9.6.8".
     * <p>
     * @deprecated Version 9.6.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_8;

    /**
     * (deprecated) Version "9.6.9".
     * <p>
     * @deprecated Version 9.6.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_9;

    /**
     * The full version string, for example, "9.6.25.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuroraPostgresFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "auroraPostgresFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "9.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuroraPostgresMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "auroraPostgresMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
