package software.amazon.awscdk.services.s3objectlambda;

/**
 * The <code>AWS::S3ObjectLambda::AccessPoint</code> resource specifies an Object Lambda Access Point used to access a bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * Object contentTransformation;
 * CfnAccessPoint cfnAccessPoint = CfnAccessPoint.Builder.create(this, "MyCfnAccessPoint")
 *         .objectLambdaConfiguration(ObjectLambdaConfigurationProperty.builder()
 *                 .supportingAccessPoint("supportingAccessPoint")
 *                 .transformationConfigurations(List.of(TransformationConfigurationProperty.builder()
 *                         .actions(List.of("actions"))
 *                         .contentTransformation(contentTransformation)
 *                         .build()))
 *                 // the properties below are optional
 *                 .allowedFeatures(List.of("allowedFeatures"))
 *                 .cloudWatchMetricsEnabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:55.689Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint")
public class CfnAccessPoint extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAccessPoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessPoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAccessPoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3objectlambda.CfnAccessPointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAlias() {
        return software.amazon.jsii.Kernel.get(this, "attrAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The status of the Object Lambda Access Point alias.
     * <p>
     * Valid Values: <code>PROVISIONING</code> | <code>READY</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAliasStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrAliasStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The alias name value of the Object Lambda Access Point.
     * <p>
     * For example: <code>myolap-1a4n8yjrb3kda96f67zwrwiiuse1a--ol-s3</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAliasValue() {
        return software.amazon.jsii.Kernel.get(this, "attrAliasValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ARN for the Object Lambda Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the specified Object Lambda Access Point was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPolicyStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrPolicyStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Specifies whether the Object lambda Access Point Policy is Public or not.
     * <p>
     * Object lambda Access Points are private by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPolicyStatusIsPublic() {
        return software.amazon.jsii.Kernel.get(this, "attrPolicyStatusIsPublic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Public Access Block Configuration is used to block policies that would allow public access to this Object lambda Access Point.
     * <p>
     * All public access to Object lambda Access Points are blocked by default, and any policy that would give public access to them will be also blocked. This behavior cannot be changed for Object lambda Access Points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPublicAccessBlockConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPublicAccessBlockConfigurationBlockPublicAcls() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicAccessBlockConfigurationBlockPublicAcls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPublicAccessBlockConfigurationBlockPublicPolicy() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicAccessBlockConfigurationBlockPublicPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPublicAccessBlockConfigurationIgnorePublicAcls() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicAccessBlockConfigurationIgnorePublicAcls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrPublicAccessBlockConfigurationRestrictPublicBuckets() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicAccessBlockConfigurationRestrictPublicBuckets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A configuration used when creating an Object Lambda Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getObjectLambdaConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "objectLambdaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A configuration used when creating an Object Lambda Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLambdaConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "objectLambdaConfiguration", java.util.Objects.requireNonNull(value, "objectLambdaConfiguration is required"));
    }

    /**
     * A configuration used when creating an Object Lambda Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectLambdaConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "objectLambdaConfiguration", java.util.Objects.requireNonNull(value, "objectLambdaConfiguration is required"));
    }

    /**
     * The name of this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }
    /**
     * The alias of an Object Lambda Access Point.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-use.html#ol-access-points-alias">How to use a bucket-style alias for your S3 bucket Object Lambda Access Point</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * AliasProperty aliasProperty = AliasProperty.builder()
     *         .value("value")
     *         // the properties below are optional
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-alias.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-alias.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.AliasProperty")
    @software.amazon.jsii.Jsii.Proxy(AliasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AliasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The alias value of the Object Lambda Access Point.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-alias.html#cfn-s3objectlambda-accesspoint-alias-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-alias.html#cfn-s3objectlambda-accesspoint-alias-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * The status of the Object Lambda Access Point alias.
         * <p>
         * If the status is <code>PROVISIONING</code> , the Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the status is <code>READY</code> , the Object Lambda Access Point alias is successfully provisioned and ready for use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-alias.html#cfn-s3objectlambda-accesspoint-alias-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-alias.html#cfn-s3objectlambda-accesspoint-alias-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AliasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AliasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AliasProperty> {
            java.lang.String value;
            java.lang.String status;

            /**
             * Sets the value of {@link AliasProperty#getValue}
             * @param value The alias value of the Object Lambda Access Point. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AliasProperty#getStatus}
             * @param status The status of the Object Lambda Access Point alias.
             *               If the status is <code>PROVISIONING</code> , the Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the status is <code>READY</code> , the Object Lambda Access Point alias is successfully provisioned and ready for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AliasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AliasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AliasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasProperty {
            private final java.lang.String value;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.AliasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AliasProperty.Jsii$Proxy that = (AliasProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * AwsLambdaProperty awsLambdaProperty = AwsLambdaProperty.builder()
     *         .functionArn("functionArn")
     *         // the properties below are optional
     *         .functionPayload("functionPayload")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-awslambda.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-awslambda.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.AwsLambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsLambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsLambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-awslambda.html#cfn-s3objectlambda-accesspoint-awslambda-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-awslambda.html#cfn-s3objectlambda-accesspoint-awslambda-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-awslambda.html#cfn-s3objectlambda-accesspoint-awslambda-functionpayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-awslambda.html#cfn-s3objectlambda-accesspoint-awslambda-functionpayload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunctionPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsLambdaProperty> {
            java.lang.String functionArn;
            java.lang.String functionPayload;

            /**
             * Sets the value of {@link AwsLambdaProperty#getFunctionArn}
             * @param functionArn the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsLambdaProperty#getFunctionPayload}
             * @param functionPayload the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionPayload(java.lang.String functionPayload) {
                this.functionPayload = functionPayload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsLambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsLambdaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsLambdaProperty {
            private final java.lang.String functionArn;
            private final java.lang.String functionPayload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionPayload = software.amazon.jsii.Kernel.get(this, "functionPayload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
                this.functionPayload = builder.functionPayload;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            public final java.lang.String getFunctionPayload() {
                return this.functionPayload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                if (this.getFunctionPayload() != null) {
                    data.set("functionPayload", om.valueToTree(this.getFunctionPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.AwsLambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsLambdaProperty.Jsii$Proxy that = (AwsLambdaProperty.Jsii$Proxy) o;

                if (!functionArn.equals(that.functionArn)) return false;
                return this.functionPayload != null ? this.functionPayload.equals(that.functionPayload) : that.functionPayload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn.hashCode();
                result = 31 * result + (this.functionPayload != null ? this.functionPayload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * ContentTransformationProperty contentTransformationProperty = ContentTransformationProperty.builder()
     *         .awsLambda(AwsLambdaProperty.builder()
     *                 .functionArn("functionArn")
     *                 // the properties below are optional
     *                 .functionPayload("functionPayload")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-contenttransformation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-contenttransformation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.ContentTransformationProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentTransformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentTransformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-contenttransformation.html#cfn-s3objectlambda-accesspoint-contenttransformation-awslambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-contenttransformation.html#cfn-s3objectlambda-accesspoint-contenttransformation-awslambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAwsLambda();

        /**
         * @return a {@link Builder} of {@link ContentTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentTransformationProperty> {
            java.lang.Object awsLambda;

            /**
             * Sets the value of {@link ContentTransformationProperty#getAwsLambda}
             * @param awsLambda the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsLambda(software.amazon.awscdk.IResolvable awsLambda) {
                this.awsLambda = awsLambda;
                return this;
            }

            /**
             * Sets the value of {@link ContentTransformationProperty#getAwsLambda}
             * @param awsLambda the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsLambda(software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.AwsLambdaProperty awsLambda) {
                this.awsLambda = awsLambda;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentTransformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentTransformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentTransformationProperty {
            private final java.lang.Object awsLambda;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsLambda = software.amazon.jsii.Kernel.get(this, "awsLambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsLambda = java.util.Objects.requireNonNull(builder.awsLambda, "awsLambda is required");
            }

            @Override
            public final java.lang.Object getAwsLambda() {
                return this.awsLambda;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsLambda", om.valueToTree(this.getAwsLambda()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.ContentTransformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentTransformationProperty.Jsii$Proxy that = (ContentTransformationProperty.Jsii$Proxy) o;

                return this.awsLambda.equals(that.awsLambda);
            }

            @Override
            public final int hashCode() {
                int result = this.awsLambda.hashCode();
                return result;
            }
        }
    }
    /**
     * A configuration used when creating an Object Lambda Access Point.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * Object contentTransformation;
     * ObjectLambdaConfigurationProperty objectLambdaConfigurationProperty = ObjectLambdaConfigurationProperty.builder()
     *         .supportingAccessPoint("supportingAccessPoint")
     *         .transformationConfigurations(List.of(TransformationConfigurationProperty.builder()
     *                 .actions(List.of("actions"))
     *                 .contentTransformation(contentTransformation)
     *                 .build()))
     *         // the properties below are optional
     *         .allowedFeatures(List.of("allowedFeatures"))
     *         .cloudWatchMetricsEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectLambdaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectLambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Standard access point associated with the Object Lambda Access Point.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-supportingaccesspoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-supportingaccesspoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSupportingAccessPoint();

        /**
         * A container for transformation configurations for an Object Lambda Access Point.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-transformationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-transformationconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformationConfigurations();

        /**
         * A container for allowed features.
         * <p>
         * Valid inputs are <code>GetObject-Range</code> , <code>GetObject-PartNumber</code> , <code>HeadObject-Range</code> , and <code>HeadObject-PartNumber</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-allowedfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-allowedfeatures</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedFeatures() {
            return null;
        }

        /**
         * A container for whether the CloudWatch metrics configuration is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-cloudwatchmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration-cloudwatchmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchMetricsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObjectLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectLambdaConfigurationProperty> {
            java.lang.String supportingAccessPoint;
            java.lang.Object transformationConfigurations;
            java.util.List<java.lang.String> allowedFeatures;
            java.lang.Object cloudWatchMetricsEnabled;

            /**
             * Sets the value of {@link ObjectLambdaConfigurationProperty#getSupportingAccessPoint}
             * @param supportingAccessPoint Standard access point associated with the Object Lambda Access Point. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportingAccessPoint(java.lang.String supportingAccessPoint) {
                this.supportingAccessPoint = supportingAccessPoint;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLambdaConfigurationProperty#getTransformationConfigurations}
             * @param transformationConfigurations A container for transformation configurations for an Object Lambda Access Point. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformationConfigurations(software.amazon.awscdk.IResolvable transformationConfigurations) {
                this.transformationConfigurations = transformationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLambdaConfigurationProperty#getTransformationConfigurations}
             * @param transformationConfigurations A container for transformation configurations for an Object Lambda Access Point. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformationConfigurations(java.util.List<? extends java.lang.Object> transformationConfigurations) {
                this.transformationConfigurations = transformationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLambdaConfigurationProperty#getAllowedFeatures}
             * @param allowedFeatures A container for allowed features.
             *                        Valid inputs are <code>GetObject-Range</code> , <code>GetObject-PartNumber</code> , <code>HeadObject-Range</code> , and <code>HeadObject-PartNumber</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedFeatures(java.util.List<java.lang.String> allowedFeatures) {
                this.allowedFeatures = allowedFeatures;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLambdaConfigurationProperty#getCloudWatchMetricsEnabled}
             * @param cloudWatchMetricsEnabled A container for whether the CloudWatch metrics configuration is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchMetricsEnabled(java.lang.Boolean cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ObjectLambdaConfigurationProperty#getCloudWatchMetricsEnabled}
             * @param cloudWatchMetricsEnabled A container for whether the CloudWatch metrics configuration is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectLambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectLambdaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObjectLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectLambdaConfigurationProperty {
            private final java.lang.String supportingAccessPoint;
            private final java.lang.Object transformationConfigurations;
            private final java.util.List<java.lang.String> allowedFeatures;
            private final java.lang.Object cloudWatchMetricsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.supportingAccessPoint = software.amazon.jsii.Kernel.get(this, "supportingAccessPoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transformationConfigurations = software.amazon.jsii.Kernel.get(this, "transformationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowedFeatures = software.amazon.jsii.Kernel.get(this, "allowedFeatures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.supportingAccessPoint = java.util.Objects.requireNonNull(builder.supportingAccessPoint, "supportingAccessPoint is required");
                this.transformationConfigurations = java.util.Objects.requireNonNull(builder.transformationConfigurations, "transformationConfigurations is required");
                this.allowedFeatures = builder.allowedFeatures;
                this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.String getSupportingAccessPoint() {
                return this.supportingAccessPoint;
            }

            @Override
            public final java.lang.Object getTransformationConfigurations() {
                return this.transformationConfigurations;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedFeatures() {
                return this.allowedFeatures;
            }

            @Override
            public final java.lang.Object getCloudWatchMetricsEnabled() {
                return this.cloudWatchMetricsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("supportingAccessPoint", om.valueToTree(this.getSupportingAccessPoint()));
                data.set("transformationConfigurations", om.valueToTree(this.getTransformationConfigurations()));
                if (this.getAllowedFeatures() != null) {
                    data.set("allowedFeatures", om.valueToTree(this.getAllowedFeatures()));
                }
                if (this.getCloudWatchMetricsEnabled() != null) {
                    data.set("cloudWatchMetricsEnabled", om.valueToTree(this.getCloudWatchMetricsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectLambdaConfigurationProperty.Jsii$Proxy that = (ObjectLambdaConfigurationProperty.Jsii$Proxy) o;

                if (!supportingAccessPoint.equals(that.supportingAccessPoint)) return false;
                if (!transformationConfigurations.equals(that.transformationConfigurations)) return false;
                if (this.allowedFeatures != null ? !this.allowedFeatures.equals(that.allowedFeatures) : that.allowedFeatures != null) return false;
                return this.cloudWatchMetricsEnabled != null ? this.cloudWatchMetricsEnabled.equals(that.cloudWatchMetricsEnabled) : that.cloudWatchMetricsEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.supportingAccessPoint.hashCode();
                result = 31 * result + (this.transformationConfigurations.hashCode());
                result = 31 * result + (this.allowedFeatures != null ? this.allowedFeatures.hashCode() : 0);
                result = 31 * result + (this.cloudWatchMetricsEnabled != null ? this.cloudWatchMetricsEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * PolicyStatusProperty policyStatusProperty = PolicyStatusProperty.builder()
     *         .isPublic(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-policystatus.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-policystatus.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.PolicyStatusProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyStatusProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyStatusProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the Object lambda Access Point Policy is Public or not.
         * <p>
         * Object lambda Access Points are private by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-policystatus.html#cfn-s3objectlambda-accesspoint-policystatus-ispublic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-policystatus.html#cfn-s3objectlambda-accesspoint-policystatus-ispublic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsPublic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyStatusProperty> {
            java.lang.Object isPublic;

            /**
             * Sets the value of {@link PolicyStatusProperty#getIsPublic}
             * @param isPublic Specifies whether the Object lambda Access Point Policy is Public or not.
             *                 Object lambda Access Points are private by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isPublic(java.lang.Boolean isPublic) {
                this.isPublic = isPublic;
                return this;
            }

            /**
             * Sets the value of {@link PolicyStatusProperty#getIsPublic}
             * @param isPublic Specifies whether the Object lambda Access Point Policy is Public or not.
             *                 Object lambda Access Points are private by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isPublic(software.amazon.awscdk.IResolvable isPublic) {
                this.isPublic = isPublic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyStatusProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyStatusProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyStatusProperty {
            private final java.lang.Object isPublic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isPublic = software.amazon.jsii.Kernel.get(this, "isPublic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isPublic = builder.isPublic;
            }

            @Override
            public final java.lang.Object getIsPublic() {
                return this.isPublic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsPublic() != null) {
                    data.set("isPublic", om.valueToTree(this.getIsPublic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.PolicyStatusProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyStatusProperty.Jsii$Proxy that = (PolicyStatusProperty.Jsii$Proxy) o;

                return this.isPublic != null ? this.isPublic.equals(that.isPublic) : that.isPublic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isPublic != null ? this.isPublic.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * This data type is not supported for Amazon S3 on Outposts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * PublicAccessBlockConfigurationProperty publicAccessBlockConfigurationProperty = PublicAccessBlockConfigurationProperty.builder()
     *         .blockPublicAcls(false)
     *         .blockPublicPolicy(false)
     *         .ignorePublicAcls(false)
     *         .restrictPublicBuckets(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicAccessBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account.
         * <p>
         * Setting this element to <code>TRUE</code> causes the following behavior:
         * <p>
         * <ul>
         * <li><code>PutBucketAcl</code> and <code>PutObjectAcl</code> calls fail if the specified ACL is public.</li>
         * <li>PUT Object calls fail if the request includes a public ACL.</li>
         * <li>PUT Bucket calls fail if the request includes a public ACL.</li>
         * </ul>
         * <p>
         * Enabling this setting doesn't affect existing policies or ACLs.
         * <p>
         * This property is not supported for Amazon S3 on Outposts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-blockpublicacls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-blockpublicacls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicAcls() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should block public bucket policies for buckets in this account.
         * <p>
         * Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
         * <p>
         * Enabling this setting doesn't affect existing bucket policies.
         * <p>
         * This property is not supported for Amazon S3 on Outposts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-blockpublicpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-blockpublicpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicPolicy() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should ignore public ACLs for buckets in this account.
         * <p>
         * Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain.
         * <p>
         * Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
         * <p>
         * This property is not supported for Amazon S3 on Outposts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-ignorepublicacls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-ignorepublicacls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnorePublicAcls() {
            return null;
        }

        /**
         * Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account.
         * <p>
         * Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only AWS service principals and authorized users within this account.
         * <p>
         * Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
         * <p>
         * This property is not supported for Amazon S3 on Outposts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-restrictpublicbuckets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-publicaccessblockconfiguration.html#cfn-s3objectlambda-accesspoint-publicaccessblockconfiguration-restrictpublicbuckets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictPublicBuckets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            java.lang.Object blockPublicAcls;
            java.lang.Object blockPublicPolicy;
            java.lang.Object ignorePublicAcls;
            java.lang.Object restrictPublicBuckets;

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account.
             *                        Setting this element to <code>TRUE</code> causes the following behavior:
             *                        <p>
             *                        <ul>
             *                        <li><code>PutBucketAcl</code> and <code>PutObjectAcl</code> calls fail if the specified ACL is public.</li>
             *                        <li>PUT Object calls fail if the request includes a public ACL.</li>
             *                        <li>PUT Bucket calls fail if the request includes a public ACL.</li>
             *                        </ul>
             *                        <p>
             *                        Enabling this setting doesn't affect existing policies or ACLs.
             *                        <p>
             *                        This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(java.lang.Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicAcls}
             * @param blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account.
             *                        Setting this element to <code>TRUE</code> causes the following behavior:
             *                        <p>
             *                        <ul>
             *                        <li><code>PutBucketAcl</code> and <code>PutObjectAcl</code> calls fail if the specified ACL is public.</li>
             *                        <li>PUT Object calls fail if the request includes a public ACL.</li>
             *                        <li>PUT Bucket calls fail if the request includes a public ACL.</li>
             *                        </ul>
             *                        <p>
             *                        Enabling this setting doesn't affect existing policies or ACLs.
             *                        <p>
             *                        This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicAcls(software.amazon.awscdk.IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for buckets in this account.
             *                          Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
             *                          <p>
             *                          Enabling this setting doesn't affect existing bucket policies.
             *                          <p>
             *                          This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getBlockPublicPolicy}
             * @param blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for buckets in this account.
             *                          Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
             *                          <p>
             *                          Enabling this setting doesn't affect existing bucket policies.
             *                          <p>
             *                          This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockPublicPolicy(software.amazon.awscdk.IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for buckets in this account.
             *                         Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain.
             *                         <p>
             *                         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
             *                         <p>
             *                         This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(java.lang.Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getIgnorePublicAcls}
             * @param ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for buckets in this account.
             *                         Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain.
             *                         <p>
             *                         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
             *                         <p>
             *                         This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePublicAcls(software.amazon.awscdk.IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account.
             *                              Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only AWS service principals and authorized users within this account.
             *                              <p>
             *                              Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
             *                              <p>
             *                              This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(java.lang.Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Sets the value of {@link PublicAccessBlockConfigurationProperty#getRestrictPublicBuckets}
             * @param restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account.
             *                              Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only AWS service principals and authorized users within this account.
             *                              <p>
             *                              Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
             *                              <p>
             *                              This property is not supported for Amazon S3 on Outposts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictPublicBuckets(software.amazon.awscdk.IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicAccessBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessBlockConfigurationProperty {
            private final java.lang.Object blockPublicAcls;
            private final java.lang.Object blockPublicPolicy;
            private final java.lang.Object ignorePublicAcls;
            private final java.lang.Object restrictPublicBuckets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockPublicAcls = software.amazon.jsii.Kernel.get(this, "blockPublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blockPublicPolicy = software.amazon.jsii.Kernel.get(this, "blockPublicPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignorePublicAcls = software.amazon.jsii.Kernel.get(this, "ignorePublicAcls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictPublicBuckets = software.amazon.jsii.Kernel.get(this, "restrictPublicBuckets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockPublicAcls = builder.blockPublicAcls;
                this.blockPublicPolicy = builder.blockPublicPolicy;
                this.ignorePublicAcls = builder.ignorePublicAcls;
                this.restrictPublicBuckets = builder.restrictPublicBuckets;
            }

            @Override
            public final java.lang.Object getBlockPublicAcls() {
                return this.blockPublicAcls;
            }

            @Override
            public final java.lang.Object getBlockPublicPolicy() {
                return this.blockPublicPolicy;
            }

            @Override
            public final java.lang.Object getIgnorePublicAcls() {
                return this.ignorePublicAcls;
            }

            @Override
            public final java.lang.Object getRestrictPublicBuckets() {
                return this.restrictPublicBuckets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockPublicAcls() != null) {
                    data.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                }
                if (this.getBlockPublicPolicy() != null) {
                    data.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                }
                if (this.getIgnorePublicAcls() != null) {
                    data.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                }
                if (this.getRestrictPublicBuckets() != null) {
                    data.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.PublicAccessBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessBlockConfigurationProperty.Jsii$Proxy that = (PublicAccessBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.blockPublicAcls != null ? !this.blockPublicAcls.equals(that.blockPublicAcls) : that.blockPublicAcls != null) return false;
                if (this.blockPublicPolicy != null ? !this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy != null) return false;
                if (this.ignorePublicAcls != null ? !this.ignorePublicAcls.equals(that.ignorePublicAcls) : that.ignorePublicAcls != null) return false;
                return this.restrictPublicBuckets != null ? this.restrictPublicBuckets.equals(that.restrictPublicBuckets) : that.restrictPublicBuckets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockPublicAcls != null ? this.blockPublicAcls.hashCode() : 0;
                result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
                result = 31 * result + (this.ignorePublicAcls != null ? this.ignorePublicAcls.hashCode() : 0);
                result = 31 * result + (this.restrictPublicBuckets != null ? this.restrictPublicBuckets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A configuration used when creating an Object Lambda Access Point transformation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3objectlambda.*;
     * Object contentTransformation;
     * TransformationConfigurationProperty transformationConfigurationProperty = TransformationConfigurationProperty.builder()
     *         .actions(List.of("actions"))
     *         .contentTransformation(contentTransformation)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.TransformationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A container for the action of an Object Lambda Access Point configuration.
         * <p>
         * Valid inputs are <code>GetObject</code> , <code>HeadObject</code> , <code>ListObject</code> , and <code>ListObjectV2</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html#cfn-s3objectlambda-accesspoint-transformationconfiguration-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html#cfn-s3objectlambda-accesspoint-transformationconfiguration-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * A container for the content transformation of an Object Lambda Access Point configuration.
         * <p>
         * Can include the FunctionArn and FunctionPayload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AwsLambdaTransformation.html">AwsLambdaTransformation</a> in the <em>Amazon S3 API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html#cfn-s3objectlambda-accesspoint-transformationconfiguration-contenttransformation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html#cfn-s3objectlambda-accesspoint-transformationconfiguration-contenttransformation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContentTransformation();

        /**
         * @return a {@link Builder} of {@link TransformationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformationConfigurationProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.Object contentTransformation;

            /**
             * Sets the value of {@link TransformationConfigurationProperty#getActions}
             * @param actions A container for the action of an Object Lambda Access Point configuration. This parameter is required.
             *                Valid inputs are <code>GetObject</code> , <code>HeadObject</code> , <code>ListObject</code> , and <code>ListObjectV2</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link TransformationConfigurationProperty#getContentTransformation}
             * @param contentTransformation A container for the content transformation of an Object Lambda Access Point configuration. This parameter is required.
             *                              Can include the FunctionArn and FunctionPayload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AwsLambdaTransformation.html">AwsLambdaTransformation</a> in the <em>Amazon S3 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentTransformation(java.lang.Object contentTransformation) {
                this.contentTransformation = contentTransformation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformationConfigurationProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.Object contentTransformation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.contentTransformation = software.amazon.jsii.Kernel.get(this, "contentTransformation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.contentTransformation = java.util.Objects.requireNonNull(builder.contentTransformation, "contentTransformation is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getContentTransformation() {
                return this.contentTransformation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("contentTransformation", om.valueToTree(this.getContentTransformation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPoint.TransformationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformationConfigurationProperty.Jsii$Proxy that = (TransformationConfigurationProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.contentTransformation.equals(that.contentTransformation);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.contentTransformation.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3objectlambda.CfnAccessPointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3objectlambda.CfnAccessPointProps.Builder();
        }

        /**
         * A configuration used when creating an Object Lambda Access Point.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration</a>
         * @param objectLambdaConfiguration A configuration used when creating an Object Lambda Access Point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLambdaConfiguration(final software.amazon.awscdk.IResolvable objectLambdaConfiguration) {
            this.props.objectLambdaConfiguration(objectLambdaConfiguration);
            return this;
        }
        /**
         * A configuration used when creating an Object Lambda Access Point.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration</a>
         * @param objectLambdaConfiguration A configuration used when creating an Object Lambda Access Point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLambdaConfiguration(final software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty objectLambdaConfiguration) {
            this.props.objectLambdaConfiguration(objectLambdaConfiguration);
            return this;
        }

        /**
         * The name of this access point.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-name</a>
         * @param name The name of this access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint build() {
            return new software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
