package software.amazon.awscdk.services.ses;

/**
 * An event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * ConfigurationSet myConfigurationSet;
 * IEventBus bus = EventBus.fromEventBusName(this, "EventBus", "default");
 * myConfigurationSet.addEventDestination("ToEventBus", ConfigurationSetEventDestinationOptions.builder()
 *         .destination(EventDestination.eventBus(bus))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:56.603Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.EventDestination")
public abstract class EventDestination extends software.amazon.jsii.JsiiObject {

    protected EventDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected EventDestination() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use CloudWatch dimensions as event destination.
     * <p>
     * @param dimensions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination cloudWatchDimensions(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.ses.CloudWatchDimension> dimensions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EventDestination.class, "cloudWatchDimensions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class), new Object[] { java.util.Objects.requireNonNull(dimensions, "dimensions is required") });
    }

    /**
     * Use Event Bus as event destination.
     * <p>
     * @param eventBus This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination eventBus(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus eventBus) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EventDestination.class, "eventBus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class), new Object[] { java.util.Objects.requireNonNull(eventBus, "eventBus is required") });
    }

    /**
     * Use Firehose Delivery Stream as event destination.
     * <p>
     * @param stream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination firehoseDeliveryStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.FirehoseDeliveryStreamDestination stream) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EventDestination.class, "firehoseDeliveryStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class), new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * Use a SNS topic as event destination.
     * <p>
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination snsTopic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EventDestination.class, "snsTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class), new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * Use Event Bus as event destination.
     * <p>
     * Default: - do not send events to Event bus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IEventBus getBus();

    /**
     * A list of CloudWatch dimensions upon which to categorize your emails.
     * <p>
     * Default: - do not send events to CloudWatch
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ses.CloudWatchDimension> getDimensions();

    /**
     * Use Firehose Delivery Stream.
     * <p>
     * Default: - do not send events to Firehose Delivery Stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.FirehoseDeliveryStreamDestination getStream();

    /**
     * A SNS topic to use as event destination.
     * <p>
     * Default: - do not send events to a SNS topic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ses.EventDestination {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Use Event Bus as event destination.
         * <p>
         * Default: - do not send events to Event bus
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IEventBus getBus() {
            return software.amazon.jsii.Kernel.get(this, "bus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class));
        }

        /**
         * A list of CloudWatch dimensions upon which to categorize your emails.
         * <p>
         * Default: - do not send events to CloudWatch
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ses.CloudWatchDimension> getDimensions() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ses.CloudWatchDimension>)(software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.CloudWatchDimension.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * Use Firehose Delivery Stream.
         * <p>
         * Default: - do not send events to Firehose Delivery Stream
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.FirehoseDeliveryStreamDestination getStream() {
            return software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.FirehoseDeliveryStreamDestination.class));
        }

        /**
         * A SNS topic to use as event destination.
         * <p>
         * Default: - do not send events to a SNS topic
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic() {
            return software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }
    }
}
