package software.amazon.awscdk.services.ssmguiconnect;

/**
 * Properties for defining a <code>CfnPreferences</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmguiconnect.*;
 * CfnPreferencesProps cfnPreferencesProps = CfnPreferencesProps.builder()
 *         .connectionRecordingPreferences(ConnectionRecordingPreferencesProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .recordingDestinations(RecordingDestinationsProperty.builder()
 *                         .s3Buckets(List.of(S3BucketProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .bucketOwner("bucketOwner")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmguiconnect-preferences.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmguiconnect-preferences.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:56.826Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmguiconnect.CfnPreferencesProps")
@software.amazon.jsii.Jsii.Proxy(CfnPreferencesProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPreferencesProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region.
     * <p>
     * This includes details such as which S3 bucket recordings are stored in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmguiconnect-preferences.html#cfn-ssmguiconnect-preferences-connectionrecordingpreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmguiconnect-preferences.html#cfn-ssmguiconnect-preferences-connectionrecordingpreferences</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionRecordingPreferences() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPreferencesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPreferencesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPreferencesProps> {
        java.lang.Object connectionRecordingPreferences;

        /**
         * Sets the value of {@link CfnPreferencesProps#getConnectionRecordingPreferences}
         * @param connectionRecordingPreferences The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region.
         *                                       This includes details such as which S3 bucket recordings are stored in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionRecordingPreferences(software.amazon.awscdk.IResolvable connectionRecordingPreferences) {
            this.connectionRecordingPreferences = connectionRecordingPreferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnPreferencesProps#getConnectionRecordingPreferences}
         * @param connectionRecordingPreferences The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region.
         *                                       This includes details such as which S3 bucket recordings are stored in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionRecordingPreferences(software.amazon.awscdk.services.ssmguiconnect.CfnPreferences.ConnectionRecordingPreferencesProperty connectionRecordingPreferences) {
            this.connectionRecordingPreferences = connectionRecordingPreferences;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPreferencesProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPreferencesProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPreferencesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPreferencesProps {
        private final java.lang.Object connectionRecordingPreferences;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionRecordingPreferences = software.amazon.jsii.Kernel.get(this, "connectionRecordingPreferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionRecordingPreferences = builder.connectionRecordingPreferences;
        }

        @Override
        public final java.lang.Object getConnectionRecordingPreferences() {
            return this.connectionRecordingPreferences;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConnectionRecordingPreferences() != null) {
                data.set("connectionRecordingPreferences", om.valueToTree(this.getConnectionRecordingPreferences()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmguiconnect.CfnPreferencesProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPreferencesProps.Jsii$Proxy that = (CfnPreferencesProps.Jsii$Proxy) o;

            return this.connectionRecordingPreferences != null ? this.connectionRecordingPreferences.equals(that.connectionRecordingPreferences) : that.connectionRecordingPreferences == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionRecordingPreferences != null ? this.connectionRecordingPreferences.hashCode() : 0;
            return result;
        }
    }
}
