package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a Map state that using JSONata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object assign;
 * Object itemSelector;
 * Object outputs;
 * Object parameters;
 * ProvideItems provideItems;
 * MapJsonataProps mapJsonataProps = MapJsonataProps.builder()
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .comment("comment")
 *         .items(provideItems)
 *         .itemSelector(Map.of(
 *                 "itemSelectorKey", itemSelector))
 *         .maxConcurrency(123)
 *         .outputs(outputs)
 *         .parameters(Map.of(
 *                 "parametersKey", parameters))
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .stateName("stateName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:56.970Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.MapJsonataProps")
@software.amazon.jsii.Jsii.Proxy(MapJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MapJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.StateBaseProps, software.amazon.awscdk.services.stepfunctions.MapBaseOptions, software.amazon.awscdk.services.stepfunctions.MapBaseJsonataOptions {

    /**
     * (deprecated) The JSON that you want to override your default iteration input (mutually exclusive  with <code>itemSelector</code>).
     * <p>
     * Default: $
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html</a>
     * @deprecated Step Functions has deprecated the <code>parameters</code> field in favor of
     * the new <code>itemSelector</code> field
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MapJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MapJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MapJsonataProps> {
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        java.lang.Number maxConcurrency;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        software.amazon.awscdk.services.stepfunctions.ProvideItems items;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link MapJsonataProps#getParameters}
         * @param parameters The JSON that you want to override your default iteration input (mutually exclusive  with <code>itemSelector</code>).
         * @return {@code this}
         * @deprecated Step Functions has deprecated the `parameters` field in favor of
the new `itemSelector` field
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getItemSelector}
         * @param itemSelector The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder itemSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> itemSelector) {
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)itemSelector;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getMaxConcurrency}
         * @param maxConcurrency MaxConcurrency.
         *                       An upper bound on the number of iterations you want running at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.Number maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getItems}
         * @param items The array that the Map state will iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(software.amazon.awscdk.services.stepfunctions.ProvideItems items) {
            this.items = items;
            return this;
        }

        /**
         * Sets the value of {@link MapJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MapJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MapJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MapJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapJsonataProps {
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        private final java.lang.Number maxConcurrency;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final software.amazon.awscdk.services.stepfunctions.ProvideItems items;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.itemSelector = software.amazon.jsii.Kernel.get(this, "itemSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProvideItems.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.itemSelector;
            this.maxConcurrency = builder.maxConcurrency;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.items = builder.items;
            this.outputs = builder.outputs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getItemSelector() {
            return this.itemSelector;
        }

        @Override
        public final java.lang.Number getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ProvideItems getItems() {
            return this.items;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getItemSelector() != null) {
                data.set("itemSelector", om.valueToTree(this.getItemSelector()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getItems() != null) {
                data.set("items", om.valueToTree(this.getItems()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.MapJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MapJsonataProps.Jsii$Proxy that = (MapJsonataProps.Jsii$Proxy) o;

            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.itemSelector != null ? !this.itemSelector.equals(that.itemSelector) : that.itemSelector != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.items != null ? !this.items.equals(that.items) : that.items != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parameters != null ? this.parameters.hashCode() : 0;
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.itemSelector != null ? this.itemSelector.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
