package software.amazon.awscdk.services.stepfunctions;

/**
 * Role to be assumed by the State Machine's execution role for invoking a task's resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function submitLambda;
 * Role iamRole;
 * // use a fixed role for all task invocations
 * TaskRole role = TaskRole.fromRole(iamRole);
 * // or use a json expression to resolve the role at runtime based on task inputs
 * //const role = sfn.TaskRole.fromRoleArnJsonPath('$.RoleArn');
 * LambdaInvoke submitJob = LambdaInvoke.Builder.create(this, "Submit Job")
 *         .lambdaFunction(submitLambda)
 *         .outputPath("$.Payload")
 *         // use credentials
 *         .credentials(Credentials.builder().role(role).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-state-fields">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-state-fields</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:57.011Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.TaskRole")
public abstract class TaskRole extends software.amazon.jsii.JsiiObject {

    protected TaskRole(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskRole(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TaskRole() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Construct a task role based on the provided IAM Role.
     * <p>
     * @param role IAM Role. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskRole fromRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.TaskRole.class, "fromRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskRole.class), new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Construct a task role retrieved from task inputs using a json expression.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * TaskRole.fromRoleArnJsonPath("$.RoleArn");
     * </pre></blockquote>
     * <p>
     * @param expression json expression to roleArn. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskRole fromRoleArnJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.TaskRole.class, "fromRoleArnJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskRole.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * Retrieves the resource for use in IAM Policies for this TaskRole.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getResource();

    /**
     * Retrieves the roleArn for this TaskRole.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.TaskRole {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Retrieves the resource for use in IAM Policies for this TaskRole.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getResource() {
            return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Retrieves the roleArn for this TaskRole.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
            return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
