package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The excecution class of the job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GlueStartJobRun.Builder.create(this, "Task")
 *         .glueJobName("my-glue-job")
 *         .executionClass(ExecutionClass.FLEX)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:57.342Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ExecutionClass")
public enum ExecutionClass {
    /**
     * The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may vary.
     * <p>
     * Only jobs with AWS Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set <code>ExecutionClass</code> to <code>FLEX</code>.
     * The flexible execution class is available for Spark jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FLEX,
    /**
     * The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
}
