package software.amazon.awscdk.services.synthetics;

/**
 * Encryption mode for canary artifacts.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * Key key = new Key(this, "myKey");
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_7_0)
 *         .artifactsBucketLifecycleRules(List.of(LifecycleRule.builder()
 *                 .expiration(Duration.days(30))
 *                 .build()))
 *         .artifactS3EncryptionMode(ArtifactsEncryptionMode.KMS)
 *         .artifactS3KmsKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:57.514Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.ArtifactsEncryptionMode")
public enum ArtifactsEncryptionMode {
    /**
     * Server-side encryption (SSE) with an Amazon S3-managed key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_MANAGED,
    /**
     * Server-side encryption (SSE) with an AWS KMS customer managed key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
}
