package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a <code>CfnAgreement</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnAgreementProps cfnAgreementProps = CfnAgreementProps.builder()
 *         .accessRole("accessRole")
 *         .localProfileId("localProfileId")
 *         .partnerProfileId("partnerProfileId")
 *         .serverId("serverId")
 *         // the properties below are optional
 *         .baseDirectory("baseDirectory")
 *         .customDirectories(CustomDirectoriesProperty.builder()
 *                 .failedFilesDirectory("failedFilesDirectory")
 *                 .mdnFilesDirectory("mdnFilesDirectory")
 *                 .payloadFilesDirectory("payloadFilesDirectory")
 *                 .statusFilesDirectory("statusFilesDirectory")
 *                 .temporaryFilesDirectory("temporaryFilesDirectory")
 *                 .build())
 *         .description("description")
 *         .enforceMessageSigning("enforceMessageSigning")
 *         .preserveFilename("preserveFilename")
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:57.580Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnAgreementProps")
@software.amazon.jsii.Jsii.Proxy(CfnAgreementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAgreementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Connectors are used to send files using either the AS2 or SFTP protocol.
     * <p>
     * For the access role, provide the Amazon Resource Name (ARN) of the AWS Identity and Access Management role to use.
     * <p>
     * <em>For AS2 connectors</em>
     * <p>
     * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the request parameter, <code>SendFilePaths</code> . We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
     * <p>
     * If you are using Basic authentication for your AS2 connector, the access role requires the <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a customer-managed key instead of the AWS managed key in Secrets Manager, then the role also needs the <code>kms:Decrypt</code> permission for that key.
     * <p>
     * <em>For SFTP connectors</em>
     * <p>
     * Make sure that the access role provides read and write access to the parent directory of the file location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides <code>secretsmanager:GetSecretValue</code> permission to AWS Secrets Manager .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-accessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-accessrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessRole();

    /**
     * A unique identifier for the AS2 local profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-localprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-localprofileid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalProfileId();

    /**
     * A unique identifier for the partner profile used in the agreement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-partnerprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-partnerprofileid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPartnerProfileId();

    /**
     * A system-assigned unique identifier for a server instance.
     * <p>
     * This identifier indicates the specific server that the agreement uses.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-serverid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-serverid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerId();

    /**
     * The landing directory (folder) for files that are transferred by using the AS2 protocol.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-basedirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-basedirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBaseDirectory() {
        return null;
    }

    /**
     * A <code>CustomDirectoriesType</code> structure.
     * <p>
     * This structure specifies custom directories for storing various AS2 message files. You can specify directories for the following types of files.
     * <p>
     * <ul>
     * <li>Failed files</li>
     * <li>MDN files</li>
     * <li>Payload files</li>
     * <li>Status files</li>
     * <li>Temporary files</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-customdirectories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-customdirectories</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomDirectories() {
        return null;
    }

    /**
     * The name or short description that's used to identify the agreement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Determines whether or not unsigned messages from your trading partners will be accepted.
     * <p>
     * <ul>
     * <li><code>ENABLED</code> : Transfer Family rejects unsigned messages from your trading partner.</li>
     * <li><code>DISABLED</code> (default value): Transfer Family accepts unsigned messages from your trading partner.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-enforcemessagesigning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-enforcemessagesigning</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnforceMessageSigning() {
        return null;
    }

    /**
     * Determines whether or not Transfer Family appends a unique string of characters to the end of the AS2 message payload filename when saving it.
     * <p>
     * <ul>
     * <li><code>ENABLED</code> : the filename provided by your trading parter is preserved when the file is saved.</li>
     * <li><code>DISABLED</code> (default value): when Transfer Family saves the file, the filename is adjusted, as described in <a href="https://docs.aws.amazon.com/transfer/latest/userguide/send-as2-messages.html#file-names-as2">File names and locations</a> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-preservefilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-preservefilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreserveFilename() {
        return null;
    }

    /**
     * The current status of the agreement, either <code>ACTIVE</code> or <code>INACTIVE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for agreements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAgreementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAgreementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAgreementProps> {
        java.lang.String accessRole;
        java.lang.String localProfileId;
        java.lang.String partnerProfileId;
        java.lang.String serverId;
        java.lang.String baseDirectory;
        java.lang.Object customDirectories;
        java.lang.String description;
        java.lang.String enforceMessageSigning;
        java.lang.String preserveFilename;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAgreementProps#getAccessRole}
         * @param accessRole Connectors are used to send files using either the AS2 or SFTP protocol. This parameter is required.
         *                   For the access role, provide the Amazon Resource Name (ARN) of the AWS Identity and Access Management role to use.
         *                   <p>
         *                   <em>For AS2 connectors</em>
         *                   <p>
         *                   With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the request parameter, <code>SendFilePaths</code> . We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
         *                   <p>
         *                   If you are using Basic authentication for your AS2 connector, the access role requires the <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a customer-managed key instead of the AWS managed key in Secrets Manager, then the role also needs the <code>kms:Decrypt</code> permission for that key.
         *                   <p>
         *                   <em>For SFTP connectors</em>
         *                   <p>
         *                   Make sure that the access role provides read and write access to the parent directory of the file location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides <code>secretsmanager:GetSecretValue</code> permission to AWS Secrets Manager .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRole(java.lang.String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getLocalProfileId}
         * @param localProfileId A unique identifier for the AS2 local profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localProfileId(java.lang.String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getPartnerProfileId}
         * @param partnerProfileId A unique identifier for the partner profile used in the agreement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerProfileId(java.lang.String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getServerId}
         * @param serverId A system-assigned unique identifier for a server instance. This parameter is required.
         *                 This identifier indicates the specific server that the agreement uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getBaseDirectory}
         * @param baseDirectory The landing directory (folder) for files that are transferred by using the AS2 protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseDirectory(java.lang.String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getCustomDirectories}
         * @param customDirectories A <code>CustomDirectoriesType</code> structure.
         *                          This structure specifies custom directories for storing various AS2 message files. You can specify directories for the following types of files.
         *                          <p>
         *                          <ul>
         *                          <li>Failed files</li>
         *                          <li>MDN files</li>
         *                          <li>Payload files</li>
         *                          <li>Status files</li>
         *                          <li>Temporary files</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDirectories(software.amazon.awscdk.IResolvable customDirectories) {
            this.customDirectories = customDirectories;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getCustomDirectories}
         * @param customDirectories A <code>CustomDirectoriesType</code> structure.
         *                          This structure specifies custom directories for storing various AS2 message files. You can specify directories for the following types of files.
         *                          <p>
         *                          <ul>
         *                          <li>Failed files</li>
         *                          <li>MDN files</li>
         *                          <li>Payload files</li>
         *                          <li>Status files</li>
         *                          <li>Temporary files</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDirectories(software.amazon.awscdk.services.transfer.CfnAgreement.CustomDirectoriesProperty customDirectories) {
            this.customDirectories = customDirectories;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getDescription}
         * @param description The name or short description that's used to identify the agreement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getEnforceMessageSigning}
         * @param enforceMessageSigning Determines whether or not unsigned messages from your trading partners will be accepted.
         *                              <ul>
         *                              <li><code>ENABLED</code> : Transfer Family rejects unsigned messages from your trading partner.</li>
         *                              <li><code>DISABLED</code> (default value): Transfer Family accepts unsigned messages from your trading partner.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceMessageSigning(java.lang.String enforceMessageSigning) {
            this.enforceMessageSigning = enforceMessageSigning;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getPreserveFilename}
         * @param preserveFilename Determines whether or not Transfer Family appends a unique string of characters to the end of the AS2 message payload filename when saving it.
         *                         <ul>
         *                         <li><code>ENABLED</code> : the filename provided by your trading parter is preserved when the file is saved.</li>
         *                         <li><code>DISABLED</code> (default value): when Transfer Family saves the file, the filename is adjusted, as described in <a href="https://docs.aws.amazon.com/transfer/latest/userguide/send-as2-messages.html#file-names-as2">File names and locations</a> .</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveFilename(java.lang.String preserveFilename) {
            this.preserveFilename = preserveFilename;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getStatus}
         * @param status The current status of the agreement, either <code>ACTIVE</code> or <code>INACTIVE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for agreements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAgreementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAgreementProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAgreementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAgreementProps {
        private final java.lang.String accessRole;
        private final java.lang.String localProfileId;
        private final java.lang.String partnerProfileId;
        private final java.lang.String serverId;
        private final java.lang.String baseDirectory;
        private final java.lang.Object customDirectories;
        private final java.lang.String description;
        private final java.lang.String enforceMessageSigning;
        private final java.lang.String preserveFilename;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessRole = software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localProfileId = software.amazon.jsii.Kernel.get(this, "localProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partnerProfileId = software.amazon.jsii.Kernel.get(this, "partnerProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverId = software.amazon.jsii.Kernel.get(this, "serverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.baseDirectory = software.amazon.jsii.Kernel.get(this, "baseDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customDirectories = software.amazon.jsii.Kernel.get(this, "customDirectories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enforceMessageSigning = software.amazon.jsii.Kernel.get(this, "enforceMessageSigning", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preserveFilename = software.amazon.jsii.Kernel.get(this, "preserveFilename", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessRole = java.util.Objects.requireNonNull(builder.accessRole, "accessRole is required");
            this.localProfileId = java.util.Objects.requireNonNull(builder.localProfileId, "localProfileId is required");
            this.partnerProfileId = java.util.Objects.requireNonNull(builder.partnerProfileId, "partnerProfileId is required");
            this.serverId = java.util.Objects.requireNonNull(builder.serverId, "serverId is required");
            this.baseDirectory = builder.baseDirectory;
            this.customDirectories = builder.customDirectories;
            this.description = builder.description;
            this.enforceMessageSigning = builder.enforceMessageSigning;
            this.preserveFilename = builder.preserveFilename;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAccessRole() {
            return this.accessRole;
        }

        @Override
        public final java.lang.String getLocalProfileId() {
            return this.localProfileId;
        }

        @Override
        public final java.lang.String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        @Override
        public final java.lang.String getServerId() {
            return this.serverId;
        }

        @Override
        public final java.lang.String getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        public final java.lang.Object getCustomDirectories() {
            return this.customDirectories;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEnforceMessageSigning() {
            return this.enforceMessageSigning;
        }

        @Override
        public final java.lang.String getPreserveFilename() {
            return this.preserveFilename;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessRole", om.valueToTree(this.getAccessRole()));
            data.set("localProfileId", om.valueToTree(this.getLocalProfileId()));
            data.set("partnerProfileId", om.valueToTree(this.getPartnerProfileId()));
            data.set("serverId", om.valueToTree(this.getServerId()));
            if (this.getBaseDirectory() != null) {
                data.set("baseDirectory", om.valueToTree(this.getBaseDirectory()));
            }
            if (this.getCustomDirectories() != null) {
                data.set("customDirectories", om.valueToTree(this.getCustomDirectories()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnforceMessageSigning() != null) {
                data.set("enforceMessageSigning", om.valueToTree(this.getEnforceMessageSigning()));
            }
            if (this.getPreserveFilename() != null) {
                data.set("preserveFilename", om.valueToTree(this.getPreserveFilename()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnAgreementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAgreementProps.Jsii$Proxy that = (CfnAgreementProps.Jsii$Proxy) o;

            if (!accessRole.equals(that.accessRole)) return false;
            if (!localProfileId.equals(that.localProfileId)) return false;
            if (!partnerProfileId.equals(that.partnerProfileId)) return false;
            if (!serverId.equals(that.serverId)) return false;
            if (this.baseDirectory != null ? !this.baseDirectory.equals(that.baseDirectory) : that.baseDirectory != null) return false;
            if (this.customDirectories != null ? !this.customDirectories.equals(that.customDirectories) : that.customDirectories != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enforceMessageSigning != null ? !this.enforceMessageSigning.equals(that.enforceMessageSigning) : that.enforceMessageSigning != null) return false;
            if (this.preserveFilename != null ? !this.preserveFilename.equals(that.preserveFilename) : that.preserveFilename != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessRole.hashCode();
            result = 31 * result + (this.localProfileId.hashCode());
            result = 31 * result + (this.partnerProfileId.hashCode());
            result = 31 * result + (this.serverId.hashCode());
            result = 31 * result + (this.baseDirectory != null ? this.baseDirectory.hashCode() : 0);
            result = 31 * result + (this.customDirectories != null ? this.customDirectories.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enforceMessageSigning != null ? this.enforceMessageSigning.hashCode() : 0);
            result = 31 * result + (this.preserveFilename != null ? this.preserveFilename.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
