package software.amazon.awscdk;

/**
 * Construction properties of <code>BootstraplessSynthesizer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * BootstraplessSynthesizerProps bootstraplessSynthesizerProps = BootstraplessSynthesizerProps.builder()
 *         .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *         .deployRoleArn("deployRoleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:48.830Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.BootstraplessSynthesizerProps")
@software.amazon.jsii.Jsii.Proxy(BootstraplessSynthesizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BootstraplessSynthesizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CFN execution Role ARN to use.
     * <p>
     * Default: - No CloudFormation role (use CLI credentials)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRoleArn() {
        return null;
    }

    /**
     * The deploy Role ARN to use.
     * <p>
     * Default: - No deploy role (use CLI credentials)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BootstraplessSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BootstraplessSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BootstraplessSynthesizerProps> {
        java.lang.String cloudFormationExecutionRoleArn;
        java.lang.String deployRoleArn;

        /**
         * Sets the value of {@link BootstraplessSynthesizerProps#getCloudFormationExecutionRoleArn}
         * @param cloudFormationExecutionRoleArn The CFN execution Role ARN to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(java.lang.String cloudFormationExecutionRoleArn) {
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link BootstraplessSynthesizerProps#getDeployRoleArn}
         * @param deployRoleArn The deploy Role ARN to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(java.lang.String deployRoleArn) {
            this.deployRoleArn = deployRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BootstraplessSynthesizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BootstraplessSynthesizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BootstraplessSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstraplessSynthesizerProps {
        private final java.lang.String cloudFormationExecutionRoleArn;
        private final java.lang.String deployRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudFormationExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployRoleArn = software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudFormationExecutionRoleArn = builder.cloudFormationExecutionRoleArn;
            this.deployRoleArn = builder.deployRoleArn;
        }

        @Override
        public final java.lang.String getCloudFormationExecutionRoleArn() {
            return this.cloudFormationExecutionRoleArn;
        }

        @Override
        public final java.lang.String getDeployRoleArn() {
            return this.deployRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudFormationExecutionRoleArn() != null) {
                data.set("cloudFormationExecutionRoleArn", om.valueToTree(this.getCloudFormationExecutionRoleArn()));
            }
            if (this.getDeployRoleArn() != null) {
                data.set("deployRoleArn", om.valueToTree(this.getDeployRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.BootstraplessSynthesizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BootstraplessSynthesizerProps.Jsii$Proxy that = (BootstraplessSynthesizerProps.Jsii$Proxy) o;

            if (this.cloudFormationExecutionRoleArn != null ? !this.cloudFormationExecutionRoleArn.equals(that.cloudFormationExecutionRoleArn) : that.cloudFormationExecutionRoleArn != null) return false;
            return this.deployRoleArn != null ? this.deployRoleArn.equals(that.deployRoleArn) : that.deployRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudFormationExecutionRoleArn != null ? this.cloudFormationExecutionRoleArn.hashCode() : 0;
            result = 31 * result + (this.deployRoleArn != null ? this.deployRoleArn.hashCode() : 0);
            return result;
        }
    }
}
