package software.amazon.awscdk;

/**
 * Determines the ignore behavior to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function.Builder.create(this, "Function")
 *         .code(Code.fromAsset(join(__dirname, "my-python-handler"), AssetOptions.builder()
 *                 .exclude(List.of("*.ignore"))
 *                 .ignoreMode(IgnoreMode.DOCKER)
 *                 .build()))
 *         .runtime(Runtime.PYTHON_3_9)
 *         .handler("index.handler")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:49.005Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.IgnoreMode")
public enum IgnoreMode {
    /**
     * Ignores file paths based on simple glob patterns.
     * <p>
     * This is the default for file assets.
     * <p>
     * It is also the default for Docker image assets, unless the '&#64;aws-cdk/aws-ecr-assets:dockerIgnoreSupport'
     * context flag is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GLOB,
    /**
     * Ignores file paths based on the <a href="https://git-scm.com/docs/gitignore"><code>.gitignore specification</code></a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GIT,
    /**
     * Ignores file paths based on the <a href="https://docs.docker.com/engine/reference/builder/#dockerignore-file"><code>.dockerignore specification</code></a>.
     * <p>
     * This is the default for Docker image assets if the '&#64;aws-cdk/aws-ecr-assets:dockerIgnoreSupport'
     * context flag is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DOCKER,
}
