package software.amazon.awscdk.customresources;

/**
 * Log Options for the state machine.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.customresources.*;
 * LogGroup logGroup;
 * LogOptions logOptions = LogOptions.builder()
 *         .destination(logGroup)
 *         .includeExecutionData(false)
 *         .level(LogLevel.OFF)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:05.470Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.LogOptions")
@software.amazon.jsii.Jsii.Proxy(LogOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log group where the execution history events will be logged.
     * <p>
     * Default: - a new log group will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getDestination() {
        return null;
    }

    /**
     * Determines whether execution data is included in your log.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeExecutionData() {
        return null;
    }

    /**
     * Defines which category of execution history events are logged.
     * <p>
     * Default: - ERROR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.LogLevel getLevel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogOptions> {
        software.amazon.awscdk.services.logs.ILogGroup destination;
        java.lang.Boolean includeExecutionData;
        software.amazon.awscdk.services.stepfunctions.LogLevel level;

        /**
         * Sets the value of {@link LogOptions#getDestination}
         * @param destination The log group where the execution history events will be logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.logs.ILogGroup destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link LogOptions#getIncludeExecutionData}
         * @param includeExecutionData Determines whether execution data is included in your log.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeExecutionData(java.lang.Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
            return this;
        }

        /**
         * Sets the value of {@link LogOptions#getLevel}
         * @param level Defines which category of execution history events are logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder level(software.amazon.awscdk.services.stepfunctions.LogLevel level) {
            this.level = level;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogOptions {
        private final software.amazon.awscdk.services.logs.ILogGroup destination;
        private final java.lang.Boolean includeExecutionData;
        private final software.amazon.awscdk.services.stepfunctions.LogLevel level;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.includeExecutionData = software.amazon.jsii.Kernel.get(this, "includeExecutionData", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.LogLevel.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = builder.destination;
            this.includeExecutionData = builder.includeExecutionData;
            this.level = builder.level;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.Boolean getIncludeExecutionData() {
            return this.includeExecutionData;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.LogLevel getLevel() {
            return this.level;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDestination() != null) {
                data.set("destination", om.valueToTree(this.getDestination()));
            }
            if (this.getIncludeExecutionData() != null) {
                data.set("includeExecutionData", om.valueToTree(this.getIncludeExecutionData()));
            }
            if (this.getLevel() != null) {
                data.set("level", om.valueToTree(this.getLevel()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.custom_resources.LogOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogOptions.Jsii$Proxy that = (LogOptions.Jsii$Proxy) o;

            if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
            if (this.includeExecutionData != null ? !this.includeExecutionData.equals(that.includeExecutionData) : that.includeExecutionData != null) return false;
            return this.level != null ? this.level.equals(that.level) : that.level == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination != null ? this.destination.hashCode() : 0;
            result = 31 * result + (this.includeExecutionData != null ? this.includeExecutionData.hashCode() : 0);
            result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
            return result;
        }
    }
}
