package software.amazon.awscdk.customresources;

/**
 * Initialization properties for the <code>WaiterStateMachine</code> construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.customresources.*;
 * Function function_;
 * LogGroup logGroup;
 * WaiterStateMachineProps waiterStateMachineProps = WaiterStateMachineProps.builder()
 *         .backoffRate(123)
 *         .interval(Duration.minutes(30))
 *         .isCompleteHandler(function_)
 *         .maxAttempts(123)
 *         .timeoutHandler(function_)
 *         // the properties below are optional
 *         .disableLogging(false)
 *         .logOptions(LogOptions.builder()
 *                 .destination(logGroup)
 *                 .includeExecutionData(false)
 *                 .level(LogLevel.OFF)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:05.476Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.WaiterStateMachineProps")
@software.amazon.jsii.Jsii.Proxy(WaiterStateMachineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WaiterStateMachineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Backoff between attempts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getBackoffRate();

    /**
     * The interval to wait between attempts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getInterval();

    /**
     * The main handler that notifies if the waiter to decide 'complete' or 'incomplete'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler();

    /**
     * Number of attempts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxAttempts();

    /**
     * The handler to call if the waiter times out and is incomplete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getTimeoutHandler();

    /**
     * Whether logging for the state machine is disabled.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableLogging() {
        return null;
    }

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * Default: - A default log group will be created if logging is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.LogOptions getLogOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WaiterStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WaiterStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WaiterStateMachineProps> {
        java.lang.Number backoffRate;
        software.amazon.awscdk.Duration interval;
        software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        java.lang.Number maxAttempts;
        software.amazon.awscdk.services.lambda.IFunction timeoutHandler;
        java.lang.Boolean disableLogging;
        software.amazon.awscdk.customresources.LogOptions logOptions;

        /**
         * Sets the value of {@link WaiterStateMachineProps#getBackoffRate}
         * @param backoffRate Backoff between attempts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffRate(java.lang.Number backoffRate) {
            this.backoffRate = backoffRate;
            return this;
        }

        /**
         * Sets the value of {@link WaiterStateMachineProps#getInterval}
         * @param interval The interval to wait between attempts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(software.amazon.awscdk.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link WaiterStateMachineProps#getIsCompleteHandler}
         * @param isCompleteHandler The main handler that notifies if the waiter to decide 'complete' or 'incomplete'. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCompleteHandler(software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.isCompleteHandler = isCompleteHandler;
            return this;
        }

        /**
         * Sets the value of {@link WaiterStateMachineProps#getMaxAttempts}
         * @param maxAttempts Number of attempts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAttempts(java.lang.Number maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        /**
         * Sets the value of {@link WaiterStateMachineProps#getTimeoutHandler}
         * @param timeoutHandler The handler to call if the waiter times out and is incomplete. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutHandler(software.amazon.awscdk.services.lambda.IFunction timeoutHandler) {
            this.timeoutHandler = timeoutHandler;
            return this;
        }

        /**
         * Sets the value of {@link WaiterStateMachineProps#getDisableLogging}
         * @param disableLogging Whether logging for the state machine is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableLogging(java.lang.Boolean disableLogging) {
            this.disableLogging = disableLogging;
            return this;
        }

        /**
         * Sets the value of {@link WaiterStateMachineProps#getLogOptions}
         * @param logOptions Defines what execution history events are logged and where they are logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logOptions(software.amazon.awscdk.customresources.LogOptions logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WaiterStateMachineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WaiterStateMachineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WaiterStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WaiterStateMachineProps {
        private final java.lang.Number backoffRate;
        private final software.amazon.awscdk.Duration interval;
        private final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private final java.lang.Number maxAttempts;
        private final software.amazon.awscdk.services.lambda.IFunction timeoutHandler;
        private final java.lang.Boolean disableLogging;
        private final software.amazon.awscdk.customresources.LogOptions logOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backoffRate = software.amazon.jsii.Kernel.get(this, "backoffRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.isCompleteHandler = software.amazon.jsii.Kernel.get(this, "isCompleteHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.maxAttempts = software.amazon.jsii.Kernel.get(this, "maxAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeoutHandler = software.amazon.jsii.Kernel.get(this, "timeoutHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.disableLogging = software.amazon.jsii.Kernel.get(this, "disableLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logOptions = software.amazon.jsii.Kernel.get(this, "logOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.LogOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backoffRate = java.util.Objects.requireNonNull(builder.backoffRate, "backoffRate is required");
            this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
            this.isCompleteHandler = java.util.Objects.requireNonNull(builder.isCompleteHandler, "isCompleteHandler is required");
            this.maxAttempts = java.util.Objects.requireNonNull(builder.maxAttempts, "maxAttempts is required");
            this.timeoutHandler = java.util.Objects.requireNonNull(builder.timeoutHandler, "timeoutHandler is required");
            this.disableLogging = builder.disableLogging;
            this.logOptions = builder.logOptions;
        }

        @Override
        public final java.lang.Number getBackoffRate() {
            return this.backoffRate;
        }

        @Override
        public final software.amazon.awscdk.Duration getInterval() {
            return this.interval;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
            return this.isCompleteHandler;
        }

        @Override
        public final java.lang.Number getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getTimeoutHandler() {
            return this.timeoutHandler;
        }

        @Override
        public final java.lang.Boolean getDisableLogging() {
            return this.disableLogging;
        }

        @Override
        public final software.amazon.awscdk.customresources.LogOptions getLogOptions() {
            return this.logOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backoffRate", om.valueToTree(this.getBackoffRate()));
            data.set("interval", om.valueToTree(this.getInterval()));
            data.set("isCompleteHandler", om.valueToTree(this.getIsCompleteHandler()));
            data.set("maxAttempts", om.valueToTree(this.getMaxAttempts()));
            data.set("timeoutHandler", om.valueToTree(this.getTimeoutHandler()));
            if (this.getDisableLogging() != null) {
                data.set("disableLogging", om.valueToTree(this.getDisableLogging()));
            }
            if (this.getLogOptions() != null) {
                data.set("logOptions", om.valueToTree(this.getLogOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.custom_resources.WaiterStateMachineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WaiterStateMachineProps.Jsii$Proxy that = (WaiterStateMachineProps.Jsii$Proxy) o;

            if (!backoffRate.equals(that.backoffRate)) return false;
            if (!interval.equals(that.interval)) return false;
            if (!isCompleteHandler.equals(that.isCompleteHandler)) return false;
            if (!maxAttempts.equals(that.maxAttempts)) return false;
            if (!timeoutHandler.equals(that.timeoutHandler)) return false;
            if (this.disableLogging != null ? !this.disableLogging.equals(that.disableLogging) : that.disableLogging != null) return false;
            return this.logOptions != null ? this.logOptions.equals(that.logOptions) : that.logOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backoffRate.hashCode();
            result = 31 * result + (this.interval.hashCode());
            result = 31 * result + (this.isCompleteHandler.hashCode());
            result = 31 * result + (this.maxAttempts.hashCode());
            result = 31 * result + (this.timeoutHandler.hashCode());
            result = 31 * result + (this.disableLogging != null ? this.disableLogging.hashCode() : 0);
            result = 31 * result + (this.logOptions != null ? this.logOptions.hashCode() : 0);
            return result;
        }
    }
}
