package software.amazon.awscdk.services.apigatewayv2;

/**
 * Explicitly configure no authorizers on specific HTTP API routes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * String issuer = "https://test.us.auth0.com";
 * HttpJwtAuthorizer authorizer = HttpJwtAuthorizer.Builder.create("DefaultAuthorizer", issuer)
 *         .jwtAudience(List.of("3131231"))
 *         .build();
 * HttpApi api = HttpApi.Builder.create(this, "HttpApi")
 *         .defaultAuthorizer(authorizer)
 *         .defaultAuthorizationScopes(List.of("read:books"))
 *         .build();
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .build());
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIdIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books/{id}")
 *         .methods(List.of(HttpMethod.GET))
 *         .build());
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .methods(List.of(HttpMethod.POST))
 *         .authorizationScopes(List.of("write:books"))
 *         .build());
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("LoginIntegration", "https://get-books-proxy.example.com"))
 *         .path("/login")
 *         .methods(List.of(HttpMethod.POST))
 *         .authorizer(new HttpNoneAuthorizer())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:49.599Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpNoneAuthorizer")
public class HttpNoneAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer {

    protected HttpNoneAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpNoneAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpNoneAuthorizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Bind this authorizer to a specified Http route.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * The authorizationType used for IAM Authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
