package software.amazon.awscdk.services.appconfig;

/**
 * An AWS AppConfig application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application app = new Application(this, "MyApp");
 * Environment env = Environment.Builder.create(this, "MyEnv")
 *         .application(app)
 *         .build();
 * HostedConfiguration.Builder.create(this, "MyHostedConfig")
 *         .application(app)
 *         .deployTo(List.of(env))
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-application.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:49.710Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Application")
public class Application extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appconfig.IApplication, software.amazon.awscdk.services.appconfig.IExtensible {

    protected Application(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Application(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.Application.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Application(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Application(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds the AWS AppConfig Agent as a container to the provided ECS task definition.
     * <p>
     * @param taskDef The ECS task definition [disable-awslint:ref-via-interface]. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void addAgentToEcs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDef) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Application.class, "addAgentToEcs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(taskDef, "taskDef is required") });
    }

    /**
     * Imports an AWS AppConfig application into the CDK using its Amazon Resource Name (ARN).
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the application construct. This parameter is required.
     * @param applicationArn The Amazon Resource Name (ARN) of the application. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IApplication fromApplicationArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String applicationArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Application.class, "fromApplicationArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(applicationArn, "applicationArn is required") });
    }

    /**
     * Imports an AWS AppConfig application into the CDK using its ID.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the application construct. This parameter is required.
     * @param applicationId The ID of the application. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IApplication fromApplicationId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String applicationId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Application.class, "fromApplicationId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(applicationId, "applicationId is required") });
    }

    /**
     * Retrieves the Lambda layer version Amazon Resource Name (ARN) for the AWS AppConfig Lambda extension.
     * <p>
     * @return Lambda layer version ARN
     * @param region The region for the Lambda layer (for example, 'us-east-1'). This parameter is required.
     * @param platform The platform for the Lambda layer (default is Platform.X86_64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getLambdaLayerVersionArn(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.Platform platform) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Application.class, "getLambdaLayerVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required"), platform });
    }

    /**
     * Retrieves the Lambda layer version Amazon Resource Name (ARN) for the AWS AppConfig Lambda extension.
     * <p>
     * @return Lambda layer version ARN
     * @param region The region for the Lambda layer (for example, 'us-east-1'). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getLambdaLayerVersionArn(final @org.jetbrains.annotations.NotNull java.lang.String region) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Application.class, "getLambdaLayerVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required") });
    }

    /**
     * Adds an environment.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.EnvironmentOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Adds an environment.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds an existing environment.
     * <p>
     * @param environment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addExistingEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment environment) {
        software.amazon.jsii.Kernel.call(this, "addExistingEnvironment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(environment, "environment is required") });
    }

    /**
     * Adds an extension association to the application.
     * <p>
     * @param extension The extension to create an association for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension) {
        software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
    }

    /**
     * Adds a hosted configuration.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.HostedConfiguration addHostedConfiguration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.HostedConfigurationOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addHostedConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.HostedConfiguration.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a sourced configuration.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.SourcedConfiguration addSourcedConfiguration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.SourcedConfigurationOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addSourcedConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.SourcedConfiguration.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Returns the list of associated environments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment> environments() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "environments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class))));
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to an application.
     * <p>
     * @param actionPoint The action point which triggers the event. This parameter is required.
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to an application.
     * <p>
     * @param actionPoint The action point which triggers the event. This parameter is required.
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Amazon Resource Name (ARN) of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase getExtensible() {
        return software.amazon.jsii.Kernel.get(this, "extensible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ExtensibleBase.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setExtensible(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase value) {
        software.amazon.jsii.Kernel.set(this, "extensible", java.util.Objects.requireNonNull(value, "extensible is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.Application}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.Application> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.appconfig.ApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the application.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param applicationName The name of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props().applicationName(applicationName);
            return this;
        }

        /**
         * The description for the application.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.Application}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.Application build() {
            return new software.amazon.awscdk.services.appconfig.Application(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.appconfig.ApplicationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.appconfig.ApplicationProps.Builder();
            }
            return this.props;
        }
    }
}
