package software.amazon.awscdk.services.appconfig;

/**
 * Attributes of an existing AWS AppConfig extension to import.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appconfig.*;
 * Action action;
 * ExtensionAttributes extensionAttributes = ExtensionAttributes.builder()
 *         .extensionId("extensionId")
 *         .extensionVersionNumber(123)
 *         // the properties below are optional
 *         .actions(List.of(action))
 *         .description("description")
 *         .extensionArn("extensionArn")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:49.753Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ExtensionAttributes")
@software.amazon.jsii.Jsii.Proxy(ExtensionAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExtensionAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExtensionId();

    /**
     * The version number of the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getExtensionVersionNumber();

    /**
     * The actions of the extension.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Action> getActions() {
        return null;
    }

    /**
     * The description of the extension.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the extension.
     * <p>
     * Default: - The extension ARN is generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExtensionArn() {
        return null;
    }

    /**
     * The name of the extension.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExtensionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExtensionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExtensionAttributes> {
        java.lang.String extensionId;
        java.lang.Number extensionVersionNumber;
        java.util.List<software.amazon.awscdk.services.appconfig.Action> actions;
        java.lang.String description;
        java.lang.String extensionArn;
        java.lang.String name;

        /**
         * Sets the value of {@link ExtensionAttributes#getExtensionId}
         * @param extensionId The ID of the extension. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionId(java.lang.String extensionId) {
            this.extensionId = extensionId;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionAttributes#getExtensionVersionNumber}
         * @param extensionVersionNumber The version number of the extension. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionVersionNumber(java.lang.Number extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionAttributes#getActions}
         * @param actions The actions of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.appconfig.Action> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.appconfig.Action>)actions;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionAttributes#getDescription}
         * @param description The description of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionAttributes#getExtensionArn}
         * @param extensionArn The Amazon Resource Name (ARN) of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionArn(java.lang.String extensionArn) {
            this.extensionArn = extensionArn;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionAttributes#getName}
         * @param name The name of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExtensionAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExtensionAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExtensionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionAttributes {
        private final java.lang.String extensionId;
        private final java.lang.Number extensionVersionNumber;
        private final java.util.List<software.amazon.awscdk.services.appconfig.Action> actions;
        private final java.lang.String description;
        private final java.lang.String extensionArn;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.extensionId = software.amazon.jsii.Kernel.get(this, "extensionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extensionVersionNumber = software.amazon.jsii.Kernel.get(this, "extensionVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Action.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extensionArn = software.amazon.jsii.Kernel.get(this, "extensionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.extensionId = java.util.Objects.requireNonNull(builder.extensionId, "extensionId is required");
            this.extensionVersionNumber = java.util.Objects.requireNonNull(builder.extensionVersionNumber, "extensionVersionNumber is required");
            this.actions = (java.util.List<software.amazon.awscdk.services.appconfig.Action>)builder.actions;
            this.description = builder.description;
            this.extensionArn = builder.extensionArn;
            this.name = builder.name;
        }

        @Override
        public final java.lang.String getExtensionId() {
            return this.extensionId;
        }

        @Override
        public final java.lang.Number getExtensionVersionNumber() {
            return this.extensionVersionNumber;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.Action> getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExtensionArn() {
            return this.extensionArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("extensionId", om.valueToTree(this.getExtensionId()));
            data.set("extensionVersionNumber", om.valueToTree(this.getExtensionVersionNumber()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExtensionArn() != null) {
                data.set("extensionArn", om.valueToTree(this.getExtensionArn()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.ExtensionAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExtensionAttributes.Jsii$Proxy that = (ExtensionAttributes.Jsii$Proxy) o;

            if (!extensionId.equals(that.extensionId)) return false;
            if (!extensionVersionNumber.equals(that.extensionVersionNumber)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.extensionArn != null ? !this.extensionArn.equals(that.extensionArn) : that.extensionArn != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.extensionId.hashCode();
            result = 31 * result + (this.extensionVersionNumber.hashCode());
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.extensionArn != null ? this.extensionArn.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
