package software.amazon.awscdk.services.appconfig;

/**
 * Options for HostedConfiguration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appconfig.*;
 * import software.amazon.awscdk.services.kms.*;
 * ConfigurationContent configurationContent;
 * DeploymentStrategy deploymentStrategy;
 * Environment environment;
 * Key key;
 * IValidator validator;
 * HostedConfigurationOptions hostedConfigurationOptions = HostedConfigurationOptions.builder()
 *         .content(configurationContent)
 *         // the properties below are optional
 *         .deploymentKey(key)
 *         .deploymentStrategy(deploymentStrategy)
 *         .deployTo(List.of(environment))
 *         .description("description")
 *         .latestVersionNumber(123)
 *         .name("name")
 *         .type(ConfigurationType.FREEFORM)
 *         .validators(List.of(validator))
 *         .versionLabel("versionLabel")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:49.756Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.HostedConfigurationOptions")
@software.amazon.jsii.Jsii.Proxy(HostedConfigurationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HostedConfigurationOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appconfig.ConfigurationOptions {

    /**
     * The content of the hosted configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent getContent();

    /**
     * The latest version number of the hosted configuration.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLatestVersionNumber() {
        return null;
    }

    /**
     * The version label of the hosted configuration.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionLabel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HostedConfigurationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HostedConfigurationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HostedConfigurationOptions> {
        software.amazon.awscdk.services.appconfig.ConfigurationContent content;
        java.lang.Number latestVersionNumber;
        java.lang.String versionLabel;
        software.amazon.awscdk.services.kms.IKey deploymentKey;
        software.amazon.awscdk.services.appconfig.IDeploymentStrategy deploymentStrategy;
        java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment> deployTo;
        java.lang.String description;
        java.lang.String name;
        software.amazon.awscdk.services.appconfig.ConfigurationType type;
        java.util.List<software.amazon.awscdk.services.appconfig.IValidator> validators;

        /**
         * Sets the value of {@link HostedConfigurationOptions#getContent}
         * @param content The content of the hosted configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.services.appconfig.ConfigurationContent content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getLatestVersionNumber}
         * @param latestVersionNumber The latest version number of the hosted configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestVersionNumber(java.lang.Number latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getVersionLabel}
         * @param versionLabel The version label of the hosted configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionLabel(java.lang.String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getDeploymentKey}
         * @param deploymentKey The deployment key of the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentKey(software.amazon.awscdk.services.kms.IKey deploymentKey) {
            this.deploymentKey = deploymentKey;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getDeploymentStrategy}
         * @param deploymentStrategy The deployment strategy for the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStrategy(software.amazon.awscdk.services.appconfig.IDeploymentStrategy deploymentStrategy) {
            this.deploymentStrategy = deploymentStrategy;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getDeployTo}
         * @param deployTo The list of environments to deploy the configuration to.
         *                 If this parameter is not specified, then there will be no
         *                 deployment created alongside this configuration.
         *                 <p>
         *                 Deployments can be added later using the <code>IEnvironment.addDeployment</code> or
         *                 <code>IEnvironment.addDeployments</code> methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder deployTo(java.util.List<? extends software.amazon.awscdk.services.appconfig.IEnvironment> deployTo) {
            this.deployTo = (java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment>)deployTo;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getDescription}
         * @param description The description of the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getName}
         * @param name The name of the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getType}
         * @param type The type of configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.appconfig.ConfigurationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link HostedConfigurationOptions#getValidators}
         * @param validators The validators for the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder validators(java.util.List<? extends software.amazon.awscdk.services.appconfig.IValidator> validators) {
            this.validators = (java.util.List<software.amazon.awscdk.services.appconfig.IValidator>)validators;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostedConfigurationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HostedConfigurationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HostedConfigurationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedConfigurationOptions {
        private final software.amazon.awscdk.services.appconfig.ConfigurationContent content;
        private final java.lang.Number latestVersionNumber;
        private final java.lang.String versionLabel;
        private final software.amazon.awscdk.services.kms.IKey deploymentKey;
        private final software.amazon.awscdk.services.appconfig.IDeploymentStrategy deploymentStrategy;
        private final java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment> deployTo;
        private final java.lang.String description;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.appconfig.ConfigurationType type;
        private final java.util.List<software.amazon.awscdk.services.appconfig.IValidator> validators;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class));
            this.latestVersionNumber = software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.versionLabel = software.amazon.jsii.Kernel.get(this, "versionLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentKey = software.amazon.jsii.Kernel.get(this, "deploymentKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.deploymentStrategy = software.amazon.jsii.Kernel.get(this, "deploymentStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IDeploymentStrategy.class));
            this.deployTo = software.amazon.jsii.Kernel.get(this, "deployTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationType.class));
            this.validators = software.amazon.jsii.Kernel.get(this, "validators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IValidator.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.latestVersionNumber = builder.latestVersionNumber;
            this.versionLabel = builder.versionLabel;
            this.deploymentKey = builder.deploymentKey;
            this.deploymentStrategy = builder.deploymentStrategy;
            this.deployTo = (java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment>)builder.deployTo;
            this.description = builder.description;
            this.name = builder.name;
            this.type = builder.type;
            this.validators = (java.util.List<software.amazon.awscdk.services.appconfig.IValidator>)builder.validators;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.ConfigurationContent getContent() {
            return this.content;
        }

        @Override
        public final java.lang.Number getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        @Override
        public final java.lang.String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getDeploymentKey() {
            return this.deploymentKey;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.IDeploymentStrategy getDeploymentStrategy() {
            return this.deploymentStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment> getDeployTo() {
            return this.deployTo;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.ConfigurationType getType() {
            return this.type;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.IValidator> getValidators() {
            return this.validators;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("content", om.valueToTree(this.getContent()));
            if (this.getLatestVersionNumber() != null) {
                data.set("latestVersionNumber", om.valueToTree(this.getLatestVersionNumber()));
            }
            if (this.getVersionLabel() != null) {
                data.set("versionLabel", om.valueToTree(this.getVersionLabel()));
            }
            if (this.getDeploymentKey() != null) {
                data.set("deploymentKey", om.valueToTree(this.getDeploymentKey()));
            }
            if (this.getDeploymentStrategy() != null) {
                data.set("deploymentStrategy", om.valueToTree(this.getDeploymentStrategy()));
            }
            if (this.getDeployTo() != null) {
                data.set("deployTo", om.valueToTree(this.getDeployTo()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getValidators() != null) {
                data.set("validators", om.valueToTree(this.getValidators()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.HostedConfigurationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HostedConfigurationOptions.Jsii$Proxy that = (HostedConfigurationOptions.Jsii$Proxy) o;

            if (!content.equals(that.content)) return false;
            if (this.latestVersionNumber != null ? !this.latestVersionNumber.equals(that.latestVersionNumber) : that.latestVersionNumber != null) return false;
            if (this.versionLabel != null ? !this.versionLabel.equals(that.versionLabel) : that.versionLabel != null) return false;
            if (this.deploymentKey != null ? !this.deploymentKey.equals(that.deploymentKey) : that.deploymentKey != null) return false;
            if (this.deploymentStrategy != null ? !this.deploymentStrategy.equals(that.deploymentStrategy) : that.deploymentStrategy != null) return false;
            if (this.deployTo != null ? !this.deployTo.equals(that.deployTo) : that.deployTo != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.validators != null ? this.validators.equals(that.validators) : that.validators == null;
        }

        @Override
        public final int hashCode() {
            int result = this.content.hashCode();
            result = 31 * result + (this.latestVersionNumber != null ? this.latestVersionNumber.hashCode() : 0);
            result = 31 * result + (this.versionLabel != null ? this.versionLabel.hashCode() : 0);
            result = 31 * result + (this.deploymentKey != null ? this.deploymentKey.hashCode() : 0);
            result = 31 * result + (this.deploymentStrategy != null ? this.deploymentStrategy.hashCode() : 0);
            result = 31 * result + (this.deployTo != null ? this.deployTo.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.validators != null ? this.validators.hashCode() : 0);
            return result;
        }
    }
}
