package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Properties for a concrete TargetTrackingPolicy.
 * <p>
 * Adds the scalingTarget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Metric metric;
 * ScalableTarget scalableTarget;
 * TargetTrackingScalingPolicyProps targetTrackingScalingPolicyProps = TargetTrackingScalingPolicyProps.builder()
 *         .scalingTarget(scalableTarget)
 *         .targetValue(123)
 *         // the properties below are optional
 *         .customMetric(metric)
 *         .disableScaleIn(false)
 *         .policyName("policyName")
 *         .predefinedMetric(PredefinedMetric.APPSTREAM_AVERAGE_CAPACITY_UTILIZATION)
 *         .resourceLabel("resourceLabel")
 *         .scaleInCooldown(Duration.minutes(30))
 *         .scaleOutCooldown(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:49.948Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.TargetTrackingScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TargetTrackingScalingPolicyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BasicTargetTrackingScalingPolicyProps {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.IScalableTarget getScalingTarget();

    /**
     * @return a {@link Builder} of {@link TargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyProps> {
        software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget;
        java.lang.Number targetValue;
        software.amazon.awscdk.services.cloudwatch.IMetric customMetric;
        software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric;
        java.lang.String resourceLabel;
        java.lang.Boolean disableScaleIn;
        java.lang.String policyName;
        software.amazon.awscdk.Duration scaleInCooldown;
        software.amazon.awscdk.Duration scaleOutCooldown;

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getScalingTarget}
         * @param scalingTarget the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTarget(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getTargetValue}
         * @param targetValue The target value for the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetValue(java.lang.Number targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getCustomMetric}
         * @param customMetric A custom metric for application autoscaling.
         *                     The metric must track utilization. Scaling out will happen if the metric is higher than
         *                     the target value, scaling in will happen in the metric is lower than the target value.
         *                     <p>
         *                     Exactly one of customMetric or predefinedMetric must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customMetric(software.amazon.awscdk.services.cloudwatch.IMetric customMetric) {
            this.customMetric = customMetric;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getPredefinedMetric}
         * @param predefinedMetric A predefined metric for application autoscaling.
         *                         The metric must track utilization. Scaling out will happen if the metric is higher than
         *                         the target value, scaling in will happen in the metric is lower than the target value.
         *                         <p>
         *                         Exactly one of customMetric or predefinedMetric must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predefinedMetric(software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric) {
            this.predefinedMetric = predefinedMetric;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getResourceLabel}
         * @param resourceLabel Identify the resource associated with the metric type.
         *                      Only used for predefined metric ALBRequestCountPerTarget.
         *                      <p>
         *                      Example value: <code>app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceLabel(java.lang.String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getDisableScaleIn}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled.
         *                       If the value is true, scale in is disabled and the target tracking policy
         *                       won't remove capacity from the scalable resource. Otherwise, scale in is
         *                       enabled and the target tracking policy can remove capacity from the
         *                       scalable resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getPolicyName}
         * @param policyName A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getScaleInCooldown}
         * @param scaleInCooldown Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleInCooldown(software.amazon.awscdk.Duration scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        /**
         * Sets the value of {@link TargetTrackingScalingPolicyProps#getScaleOutCooldown}
         * @param scaleOutCooldown Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleOutCooldown(software.amazon.awscdk.Duration scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetTrackingScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TargetTrackingScalingPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingPolicyProps {
        private final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget;
        private final java.lang.Number targetValue;
        private final software.amazon.awscdk.services.cloudwatch.IMetric customMetric;
        private final software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric;
        private final java.lang.String resourceLabel;
        private final java.lang.Boolean disableScaleIn;
        private final java.lang.String policyName;
        private final software.amazon.awscdk.Duration scaleInCooldown;
        private final software.amazon.awscdk.Duration scaleOutCooldown;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scalingTarget = software.amazon.jsii.Kernel.get(this, "scalingTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget.class));
            this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.customMetric = software.amazon.jsii.Kernel.get(this, "customMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.predefinedMetric = software.amazon.jsii.Kernel.get(this, "predefinedMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric.class));
            this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scalingTarget = java.util.Objects.requireNonNull(builder.scalingTarget, "scalingTarget is required");
            this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
            this.customMetric = builder.customMetric;
            this.predefinedMetric = builder.predefinedMetric;
            this.resourceLabel = builder.resourceLabel;
            this.disableScaleIn = builder.disableScaleIn;
            this.policyName = builder.policyName;
            this.scaleInCooldown = builder.scaleInCooldown;
            this.scaleOutCooldown = builder.scaleOutCooldown;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget getScalingTarget() {
            return this.scalingTarget;
        }

        @Override
        public final java.lang.Number getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getCustomMetric() {
            return this.customMetric;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric getPredefinedMetric() {
            return this.predefinedMetric;
        }

        @Override
        public final java.lang.String getResourceLabel() {
            return this.resourceLabel;
        }

        @Override
        public final java.lang.Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final software.amazon.awscdk.Duration getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public final software.amazon.awscdk.Duration getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scalingTarget", om.valueToTree(this.getScalingTarget()));
            data.set("targetValue", om.valueToTree(this.getTargetValue()));
            if (this.getCustomMetric() != null) {
                data.set("customMetric", om.valueToTree(this.getCustomMetric()));
            }
            if (this.getPredefinedMetric() != null) {
                data.set("predefinedMetric", om.valueToTree(this.getPredefinedMetric()));
            }
            if (this.getResourceLabel() != null) {
                data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
            }
            if (this.getDisableScaleIn() != null) {
                data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
            }
            if (this.getPolicyName() != null) {
                data.set("policyName", om.valueToTree(this.getPolicyName()));
            }
            if (this.getScaleInCooldown() != null) {
                data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
            }
            if (this.getScaleOutCooldown() != null) {
                data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.TargetTrackingScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TargetTrackingScalingPolicyProps.Jsii$Proxy that = (TargetTrackingScalingPolicyProps.Jsii$Proxy) o;

            if (!scalingTarget.equals(that.scalingTarget)) return false;
            if (!targetValue.equals(that.targetValue)) return false;
            if (this.customMetric != null ? !this.customMetric.equals(that.customMetric) : that.customMetric != null) return false;
            if (this.predefinedMetric != null ? !this.predefinedMetric.equals(that.predefinedMetric) : that.predefinedMetric != null) return false;
            if (this.resourceLabel != null ? !this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel != null) return false;
            if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
            if (this.policyName != null ? !this.policyName.equals(that.policyName) : that.policyName != null) return false;
            if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
            return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scalingTarget.hashCode();
            result = 31 * result + (this.targetValue.hashCode());
            result = 31 * result + (this.customMetric != null ? this.customMetric.hashCode() : 0);
            result = 31 * result + (this.predefinedMetric != null ? this.predefinedMetric.hashCode() : 0);
            result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
            result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
            result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
            return result;
        }
    }
}
