package software.amazon.awscdk.services.appmesh;

/**
 * Supported values for matching routes based on the HTTP request method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.exactly("/exact"))
 *                         .method(HttpRouteMethod.POST)
 *                         .protocol(HttpRouteProtocol.HTTPS)
 *                         .headers(List.of(HeaderMatch.valueIs("Content-Type", "application/json"), HeaderMatch.valueIsNot("Content-Type", "application/json")))
 *                         .queryParameters(List.of(QueryParameterMatch.valueIs("query-field", "value")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.153Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpRouteMethod")
public enum HttpRouteMethod {
    /**
     * GET request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * HEAD request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
    /**
     * POST request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * PUT request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
    /**
     * DELETE request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * CONNECT request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONNECT,
    /**
     * OPTIONS request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONS,
    /**
     * TRACE request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRACE,
    /**
     * PATCH request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
}
