package software.amazon.awscdk.services.appsync;

/**
 * Interface to specify default or additional authorization(s).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.appsync.*;
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .definition(Definition.fromFile("schema.graphql"))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder().authorizationType(AuthorizationType.IAM).build())
 *                 .build())
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(AppSync.Builder.create(api)
 *         .graphQLOperation("mutation Publish($message: String!){ publish(message: $message) { message } }")
 *         .variables(RuleTargetInput.fromObject(Map.of(
 *                 "message", "hello world")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.328Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AuthorizationMode")
@software.amazon.jsii.Jsii.Proxy(AuthorizationMode.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuthorizationMode extends software.amazon.jsii.JsiiSerializable {

    /**
     * One of possible four values AppSync supports.
     * <p>
     * Default: - `AuthorizationType.API_KEY`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">https://docs.aws.amazon.com/appsync/latest/devguide/security.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AuthorizationType getAuthorizationType();

    /**
     * If authorizationType is <code>AuthorizationType.API_KEY</code>, this option can be configured.
     * <p>
     * Default: - name: 'DefaultAPIKey' | description: 'Default API Key created by CDK'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ApiKeyConfig getApiKeyConfig() {
        return null;
    }

    /**
     * If authorizationType is <code>AuthorizationType.LAMBDA</code>, this option is required.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.LambdaAuthorizerConfig getLambdaAuthorizerConfig() {
        return null;
    }

    /**
     * If authorizationType is <code>AuthorizationType.OIDC</code>, this option is required.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.OpenIdConnectConfig getOpenIdConnectConfig() {
        return null;
    }

    /**
     * If authorizationType is <code>AuthorizationType.USER_POOL</code>, this option is required.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.UserPoolConfig getUserPoolConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthorizationMode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthorizationMode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuthorizationMode> {
        software.amazon.awscdk.services.appsync.AuthorizationType authorizationType;
        software.amazon.awscdk.services.appsync.ApiKeyConfig apiKeyConfig;
        software.amazon.awscdk.services.appsync.LambdaAuthorizerConfig lambdaAuthorizerConfig;
        software.amazon.awscdk.services.appsync.OpenIdConnectConfig openIdConnectConfig;
        software.amazon.awscdk.services.appsync.UserPoolConfig userPoolConfig;

        /**
         * Sets the value of {@link AuthorizationMode#getAuthorizationType}
         * @param authorizationType One of possible four values AppSync supports. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(software.amazon.awscdk.services.appsync.AuthorizationType authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationMode#getApiKeyConfig}
         * @param apiKeyConfig If authorizationType is <code>AuthorizationType.API_KEY</code>, this option can be configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyConfig(software.amazon.awscdk.services.appsync.ApiKeyConfig apiKeyConfig) {
            this.apiKeyConfig = apiKeyConfig;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationMode#getLambdaAuthorizerConfig}
         * @param lambdaAuthorizerConfig If authorizationType is <code>AuthorizationType.LAMBDA</code>, this option is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationMode#getOpenIdConnectConfig}
         * @param openIdConnectConfig If authorizationType is <code>AuthorizationType.OIDC</code>, this option is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.OpenIdConnectConfig openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationMode#getUserPoolConfig}
         * @param userPoolConfig If authorizationType is <code>AuthorizationType.USER_POOL</code>, this option is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(software.amazon.awscdk.services.appsync.UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthorizationMode}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuthorizationMode build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuthorizationMode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationMode {
        private final software.amazon.awscdk.services.appsync.AuthorizationType authorizationType;
        private final software.amazon.awscdk.services.appsync.ApiKeyConfig apiKeyConfig;
        private final software.amazon.awscdk.services.appsync.LambdaAuthorizerConfig lambdaAuthorizerConfig;
        private final software.amazon.awscdk.services.appsync.OpenIdConnectConfig openIdConnectConfig;
        private final software.amazon.awscdk.services.appsync.UserPoolConfig userPoolConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class));
            this.apiKeyConfig = software.amazon.jsii.Kernel.get(this, "apiKeyConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ApiKeyConfig.class));
            this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LambdaAuthorizerConfig.class));
            this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.OpenIdConnectConfig.class));
            this.userPoolConfig = software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.UserPoolConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationType = java.util.Objects.requireNonNull(builder.authorizationType, "authorizationType is required");
            this.apiKeyConfig = builder.apiKeyConfig;
            this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
            this.openIdConnectConfig = builder.openIdConnectConfig;
            this.userPoolConfig = builder.userPoolConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AuthorizationType getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.ApiKeyConfig getApiKeyConfig() {
            return this.apiKeyConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.LambdaAuthorizerConfig getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.OpenIdConnectConfig getOpenIdConnectConfig() {
            return this.openIdConnectConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.UserPoolConfig getUserPoolConfig() {
            return this.userPoolConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            if (this.getApiKeyConfig() != null) {
                data.set("apiKeyConfig", om.valueToTree(this.getApiKeyConfig()));
            }
            if (this.getLambdaAuthorizerConfig() != null) {
                data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
            }
            if (this.getOpenIdConnectConfig() != null) {
                data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
            }
            if (this.getUserPoolConfig() != null) {
                data.set("userPoolConfig", om.valueToTree(this.getUserPoolConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AuthorizationMode"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthorizationMode.Jsii$Proxy that = (AuthorizationMode.Jsii$Proxy) o;

            if (!authorizationType.equals(that.authorizationType)) return false;
            if (this.apiKeyConfig != null ? !this.apiKeyConfig.equals(that.apiKeyConfig) : that.apiKeyConfig != null) return false;
            if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
            if (this.openIdConnectConfig != null ? !this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig != null) return false;
            return this.userPoolConfig != null ? this.userPoolConfig.equals(that.userPoolConfig) : that.userPoolConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationType.hashCode();
            result = 31 * result + (this.apiKeyConfig != null ? this.apiKeyConfig.hashCode() : 0);
            result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
            result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
            result = 31 * result + (this.userPoolConfig != null ? this.userPoolConfig.hashCode() : 0);
            return result;
        }
    }
}
