package software.amazon.awscdk.services.appsync;

/**
 * Abstract AppSync datasource implementation.
 * <p>
 * Do not use directly but use subclasses for concrete datasources
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction;
 * Resolver pipelineResolver = Resolver.Builder.create(this, "pipeline")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .typeName("typeName")
 *         .fieldName("fieldName")
 *         .requestMappingTemplate(MappingTemplate.fromFile("beforeRequest.vtl"))
 *         .pipelineConfig(List.of(appsyncFunction))
 *         .responseMappingTemplate(MappingTemplate.fromFile("afterResponse.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.331Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.BaseDataSource")
public abstract class BaseDataSource extends software.constructs.Construct {

    protected BaseDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param extended This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BaseDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BackedDataSourceProps props, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ExtendedDataSourceProps extended) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), java.util.Objects.requireNonNull(extended, "extended is required") });
    }

    /**
     * creates a new appsync function for this datasource and API using the given properties.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppsyncFunction createFunction(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseAppsyncFunctionProps props) {
        return software.amazon.jsii.Kernel.call(this, "createFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppsyncFunction.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * creates a new resolver for this datasource and API using the given properties.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver createResolver(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseResolverProps props) {
        return software.amazon.jsii.Kernel.call(this, "createResolver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * the underlying CFN data source resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnDataSource getDs() {
        return software.amazon.jsii.Kernel.get(this, "ds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CfnDataSource.class));
    }

    /**
     * the name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getApi() {
        return software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi value) {
        software.amazon.jsii.Kernel.set(this, "api", java.util.Objects.requireNonNull(value, "api is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setServiceRole(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole value) {
        software.amazon.jsii.Kernel.set(this, "serviceRole", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.BaseDataSource implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
