package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnSourceApiAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnSourceApiAssociationProps cfnSourceApiAssociationProps = CfnSourceApiAssociationProps.builder()
 *         .description("description")
 *         .mergedApiIdentifier("mergedApiIdentifier")
 *         .sourceApiAssociationConfig(SourceApiAssociationConfigProperty.builder()
 *                 .mergeType("mergeType")
 *                 .build())
 *         .sourceApiIdentifier("sourceApiIdentifier")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.405Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnSourceApiAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSourceApiAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSourceApiAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description field of the association configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The identifier of the AppSync Merged API.
     * <p>
     * This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-mergedapiidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-mergedapiidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMergedApiIdentifier() {
        return null;
    }

    /**
     * The <code>SourceApiAssociationConfig</code> object data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiassociationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiassociationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceApiAssociationConfig() {
        return null;
    }

    /**
     * The identifier of the AppSync Source API.
     * <p>
     * This is generated by the AppSync service. In most cases, source APIs (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceApiIdentifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSourceApiAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSourceApiAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSourceApiAssociationProps> {
        java.lang.String description;
        java.lang.String mergedApiIdentifier;
        java.lang.Object sourceApiAssociationConfig;
        java.lang.String sourceApiIdentifier;

        /**
         * Sets the value of {@link CfnSourceApiAssociationProps#getDescription}
         * @param description The description field of the association configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceApiAssociationProps#getMergedApiIdentifier}
         * @param mergedApiIdentifier The identifier of the AppSync Merged API.
         *                            This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApiIdentifier(java.lang.String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceApiAssociationProps#getSourceApiAssociationConfig}
         * @param sourceApiAssociationConfig The <code>SourceApiAssociationConfig</code> object data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceApiAssociationConfig(software.amazon.awscdk.IResolvable sourceApiAssociationConfig) {
            this.sourceApiAssociationConfig = sourceApiAssociationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceApiAssociationProps#getSourceApiAssociationConfig}
         * @param sourceApiAssociationConfig The <code>SourceApiAssociationConfig</code> object data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceApiAssociationConfig(software.amazon.awscdk.services.appsync.CfnSourceApiAssociation.SourceApiAssociationConfigProperty sourceApiAssociationConfig) {
            this.sourceApiAssociationConfig = sourceApiAssociationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceApiAssociationProps#getSourceApiIdentifier}
         * @param sourceApiIdentifier The identifier of the AppSync Source API.
         *                            This is generated by the AppSync service. In most cases, source APIs (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceApiIdentifier(java.lang.String sourceApiIdentifier) {
            this.sourceApiIdentifier = sourceApiIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSourceApiAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSourceApiAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSourceApiAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSourceApiAssociationProps {
        private final java.lang.String description;
        private final java.lang.String mergedApiIdentifier;
        private final java.lang.Object sourceApiAssociationConfig;
        private final java.lang.String sourceApiIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mergedApiIdentifier = software.amazon.jsii.Kernel.get(this, "mergedApiIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceApiAssociationConfig = software.amazon.jsii.Kernel.get(this, "sourceApiAssociationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceApiIdentifier = software.amazon.jsii.Kernel.get(this, "sourceApiIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.mergedApiIdentifier = builder.mergedApiIdentifier;
            this.sourceApiAssociationConfig = builder.sourceApiAssociationConfig;
            this.sourceApiIdentifier = builder.sourceApiIdentifier;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getMergedApiIdentifier() {
            return this.mergedApiIdentifier;
        }

        @Override
        public final java.lang.Object getSourceApiAssociationConfig() {
            return this.sourceApiAssociationConfig;
        }

        @Override
        public final java.lang.String getSourceApiIdentifier() {
            return this.sourceApiIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMergedApiIdentifier() != null) {
                data.set("mergedApiIdentifier", om.valueToTree(this.getMergedApiIdentifier()));
            }
            if (this.getSourceApiAssociationConfig() != null) {
                data.set("sourceApiAssociationConfig", om.valueToTree(this.getSourceApiAssociationConfig()));
            }
            if (this.getSourceApiIdentifier() != null) {
                data.set("sourceApiIdentifier", om.valueToTree(this.getSourceApiIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnSourceApiAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSourceApiAssociationProps.Jsii$Proxy that = (CfnSourceApiAssociationProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.mergedApiIdentifier != null ? !this.mergedApiIdentifier.equals(that.mergedApiIdentifier) : that.mergedApiIdentifier != null) return false;
            if (this.sourceApiAssociationConfig != null ? !this.sourceApiAssociationConfig.equals(that.sourceApiAssociationConfig) : that.sourceApiAssociationConfig != null) return false;
            return this.sourceApiIdentifier != null ? this.sourceApiIdentifier.equals(that.sourceApiIdentifier) : that.sourceApiIdentifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.mergedApiIdentifier != null ? this.mergedApiIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceApiAssociationConfig != null ? this.sourceApiAssociationConfig.hashCode() : 0);
            result = 31 * result + (this.sourceApiIdentifier != null ? this.sourceApiIdentifier.hashCode() : 0);
            return result;
        }
    }
}
