package software.amazon.awscdk.services.appsync;

/**
 * Properties for an AppSync Event API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function handler;
 * AppSyncAuthProvider iamProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.IAM)
 *         .build();
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * /* API with IAM and API Key providers.
 *  * Connection, default publish and default subscribe
 *  * can be done with either IAM and API Key.
 *  *&#47;
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("api")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 // set auth providers
 *                 .authProviders(List.of(iamProvider, apiKeyProvider))
 *                 .build())
 *         .build();
 * api.addChannelNamespace("default");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.EventApiProps")
@software.amazon.jsii.Jsii.Proxy(EventApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * the name of the Event API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiName();

    /**
     * Optional authorization configuration.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.EventApiAuthConfig getAuthorizationConfig() {
        return null;
    }

    /**
     * The domain name configuration for the Event API.
     * <p>
     * The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
     * enable custom domain URL
     * <p>
     * Default: - no domain name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncDomainOptions getDomainName() {
        return null;
    }

    /**
     * Logging configuration for this api.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncLogConfig getLogConfig() {
        return null;
    }

    /**
     * The owner contact information for an API resource.
     * <p>
     * This field accepts any string input with a length of 0 - 256 characters.
     * <p>
     * Default: - No owner contact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerContact() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventApiProps> {
        java.lang.String apiName;
        software.amazon.awscdk.services.appsync.EventApiAuthConfig authorizationConfig;
        software.amazon.awscdk.services.appsync.AppSyncDomainOptions domainName;
        software.amazon.awscdk.services.appsync.AppSyncLogConfig logConfig;
        java.lang.String ownerContact;

        /**
         * Sets the value of {@link EventApiProps#getApiName}
         * @param apiName the name of the Event API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(java.lang.String apiName) {
            this.apiName = apiName;
            return this;
        }

        /**
         * Sets the value of {@link EventApiProps#getAuthorizationConfig}
         * @param authorizationConfig Optional authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(software.amazon.awscdk.services.appsync.EventApiAuthConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        /**
         * Sets the value of {@link EventApiProps#getDomainName}
         * @param domainName The domain name configuration for the Event API.
         *                   The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
         *                   enable custom domain URL
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.appsync.AppSyncDomainOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link EventApiProps#getLogConfig}
         * @param logConfig Logging configuration for this api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(software.amazon.awscdk.services.appsync.AppSyncLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link EventApiProps#getOwnerContact}
         * @param ownerContact The owner contact information for an API resource.
         *                     This field accepts any string input with a length of 0 - 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(java.lang.String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventApiProps {
        private final java.lang.String apiName;
        private final software.amazon.awscdk.services.appsync.EventApiAuthConfig authorizationConfig;
        private final software.amazon.awscdk.services.appsync.AppSyncDomainOptions domainName;
        private final software.amazon.awscdk.services.appsync.AppSyncLogConfig logConfig;
        private final java.lang.String ownerContact;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiName = software.amazon.jsii.Kernel.get(this, "apiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.EventApiAuthConfig.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncDomainOptions.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncLogConfig.class));
            this.ownerContact = software.amazon.jsii.Kernel.get(this, "ownerContact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiName = java.util.Objects.requireNonNull(builder.apiName, "apiName is required");
            this.authorizationConfig = builder.authorizationConfig;
            this.domainName = builder.domainName;
            this.logConfig = builder.logConfig;
            this.ownerContact = builder.ownerContact;
        }

        @Override
        public final java.lang.String getApiName() {
            return this.apiName;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.EventApiAuthConfig getAuthorizationConfig() {
            return this.authorizationConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncDomainOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncLogConfig getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final java.lang.String getOwnerContact() {
            return this.ownerContact;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiName", om.valueToTree(this.getApiName()));
            if (this.getAuthorizationConfig() != null) {
                data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getOwnerContact() != null) {
                data.set("ownerContact", om.valueToTree(this.getOwnerContact()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.EventApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventApiProps.Jsii$Proxy that = (EventApiProps.Jsii$Proxy) o;

            if (!apiName.equals(that.apiName)) return false;
            if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            return this.ownerContact != null ? this.ownerContact.equals(that.ownerContact) : that.ownerContact == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiName.hashCode();
            result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.ownerContact != null ? this.ownerContact.hashCode() : 0);
            return result;
        }
    }
}
