package software.amazon.awscdk.services.apptest;

/**
 * Properties for defining a <code>CfnTestCase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apptest.*;
 * CfnTestCaseProps cfnTestCaseProps = CfnTestCaseProps.builder()
 *         .name("name")
 *         .steps(List.of(StepProperty.builder()
 *                 .action(StepActionProperty.builder()
 *                         .compareAction(CompareActionProperty.builder()
 *                                 .input(InputProperty.builder()
 *                                         .file(InputFileProperty.builder()
 *                                                 .fileMetadata(FileMetadataProperty.builder()
 *                                                         .databaseCdc(DatabaseCDCProperty.builder()
 *                                                                 .sourceMetadata(SourceDatabaseMetadataProperty.builder()
 *                                                                         .captureTool("captureTool")
 *                                                                         .type("type")
 *                                                                         .build())
 *                                                                 .targetMetadata(TargetDatabaseMetadataProperty.builder()
 *                                                                         .captureTool("captureTool")
 *                                                                         .type("type")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .dataSets(List.of(DataSetProperty.builder()
 *                                                                 .ccsid("ccsid")
 *                                                                 .format("format")
 *                                                                 .length(123)
 *                                                                 .name("name")
 *                                                                 .type("type")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .sourceLocation("sourceLocation")
 *                                                 .targetLocation("targetLocation")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .output(OutputProperty.builder()
 *                                         .file(OutputFileProperty.builder()
 *                                                 .fileLocation("fileLocation")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .mainframeAction(MainframeActionProperty.builder()
 *                                 .actionType(MainframeActionTypeProperty.builder()
 *                                         .batch(BatchProperty.builder()
 *                                                 .batchJobName("batchJobName")
 *                                                 // the properties below are optional
 *                                                 .batchJobParameters(Map.of(
 *                                                         "batchJobParametersKey", "batchJobParameters"))
 *                                                 .exportDataSetNames(List.of("exportDataSetNames"))
 *                                                 .build())
 *                                         .tn3270(TN3270Property.builder()
 *                                                 .script(ScriptProperty.builder()
 *                                                         .scriptLocation("scriptLocation")
 *                                                         .type("type")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .exportDataSetNames(List.of("exportDataSetNames"))
 *                                                 .build())
 *                                         .build())
 *                                 .resource("resource")
 *                                 // the properties below are optional
 *                                 .properties(MainframeActionPropertiesProperty.builder()
 *                                         .dmsTaskArn("dmsTaskArn")
 *                                         .build())
 *                                 .build())
 *                         .resourceAction(ResourceActionProperty.builder()
 *                                 .cloudFormationAction(CloudFormationActionProperty.builder()
 *                                         .resource("resource")
 *                                         // the properties below are optional
 *                                         .actionType("actionType")
 *                                         .build())
 *                                 .m2ManagedApplicationAction(M2ManagedApplicationActionProperty.builder()
 *                                         .actionType("actionType")
 *                                         .resource("resource")
 *                                         // the properties below are optional
 *                                         .properties(M2ManagedActionPropertiesProperty.builder()
 *                                                 .forceStop(false)
 *                                                 .importDataSetLocation("importDataSetLocation")
 *                                                 .build())
 *                                         .build())
 *                                 .m2NonManagedApplicationAction(M2NonManagedApplicationActionProperty.builder()
 *                                         .actionType("actionType")
 *                                         .resource("resource")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.494Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCaseProps")
@software.amazon.jsii.Jsii.Proxy(CfnTestCaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTestCaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the test case.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The steps in the test case.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-steps</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSteps();

    /**
     * The description of the test case.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The specified tags of the test case.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTestCaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTestCaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTestCaseProps> {
        java.lang.String name;
        java.lang.Object steps;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnTestCaseProps#getName}
         * @param name The name of the test case. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTestCaseProps#getSteps}
         * @param steps The steps in the test case. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(software.amazon.awscdk.IResolvable steps) {
            this.steps = steps;
            return this;
        }

        /**
         * Sets the value of {@link CfnTestCaseProps#getSteps}
         * @param steps The steps in the test case. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(java.util.List<? extends java.lang.Object> steps) {
            this.steps = steps;
            return this;
        }

        /**
         * Sets the value of {@link CfnTestCaseProps#getDescription}
         * @param description The description of the test case.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTestCaseProps#getTags}
         * @param tags The specified tags of the test case.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTestCaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTestCaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTestCaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTestCaseProps {
        private final java.lang.String name;
        private final java.lang.Object steps;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.steps = software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.steps = java.util.Objects.requireNonNull(builder.steps, "steps is required");
            this.description = builder.description;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSteps() {
            return this.steps;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("steps", om.valueToTree(this.getSteps()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTestCaseProps.Jsii$Proxy that = (CfnTestCaseProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!steps.equals(that.steps)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.steps.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
