package software.amazon.awscdk.services.autoscaling;

/**
 * Additional Health Check Type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .healthChecks(HealthChecks.withAdditionalChecks(AdditionalHealthChecksOptions.builder()
 *                 .gracePeriod(Duration.seconds(100))
 *                 .additionalTypes(List.of(AdditionalHealthCheckType.EBS, AdditionalHealthCheckType.ELB, AdditionalHealthCheckType.VPC_LATTICE))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.566Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.AdditionalHealthCheckType")
public enum AdditionalHealthCheckType {
    /**
     * ELB Health Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELB,
    /**
     * EBS Health Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EBS,
    /**
     * VPC LATTICE Health Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VPC_LATTICE,
}
