package software.amazon.awscdk.services.backup;

/**
 * Creates a logical container to where backups may be copied.
 * <p>
 * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention days, and optionally can include tags and a creator request ID.
 * <p>
 * <blockquote>
 * <p>
 * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object accessPolicy;
 * CfnLogicallyAirGappedBackupVault cfnLogicallyAirGappedBackupVault = CfnLogicallyAirGappedBackupVault.Builder.create(this, "MyCfnLogicallyAirGappedBackupVault")
 *         .backupVaultName("backupVaultName")
 *         .maxRetentionDays(123)
 *         .minRetentionDays(123)
 *         // the properties below are optional
 *         .accessPolicy(accessPolicy)
 *         .backupVaultTags(Map.of(
 *                 "backupVaultTagsKey", "backupVaultTags"))
 *         .notifications(NotificationObjectTypeProperty.builder()
 *                 .backupVaultEvents(List.of("backupVaultEvents"))
 *                 .snsTopicArn("snsTopicArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.809Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnLogicallyAirGappedBackupVault")
public class CfnLogicallyAirGappedBackupVault extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnLogicallyAirGappedBackupVault(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLogicallyAirGappedBackupVault(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLogicallyAirGappedBackupVault(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVaultProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBackupVaultArn() {
        return software.amazon.jsii.Kernel.get(this, "attrBackupVaultArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the server-side encryption key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The vault state.
     * <p>
     * The possible values are <code>CREATING</code> , <code>AVAILABLE</code> , and <code>FAILED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVaultState() {
        return software.amazon.jsii.Kernel.get(this, "attrVaultState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The vault type.
     * <p>
     * The possible values are <code>BACKUP_VAULT</code> and <code>LOGICALLY_AIR_GAPPED_BACKUP_VAULT</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVaultType() {
        return software.amazon.jsii.Kernel.get(this, "attrVaultType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of a logical container where backups are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBackupVaultName() {
        return software.amazon.jsii.Kernel.get(this, "backupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a logical container where backups are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupVaultName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupVaultName", java.util.Objects.requireNonNull(value, "backupVaultName is required"));
    }

    /**
     * The maximum retention period that the vault retains its recovery points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetentionDays() {
        return software.amazon.jsii.Kernel.get(this, "maxRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum retention period that the vault retains its recovery points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxRetentionDays(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxRetentionDays", java.util.Objects.requireNonNull(value, "maxRetentionDays is required"));
    }

    /**
     * This setting specifies the minimum retention period that the vault retains its recovery points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinRetentionDays() {
        return software.amazon.jsii.Kernel.get(this, "minRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * This setting specifies the minimum retention period that the vault retains its recovery points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinRetentionDays(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minRetentionDays", java.util.Objects.requireNonNull(value, "minRetentionDays is required"));
    }

    /**
     * The backup vault access policy document in JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicy() {
        return software.amazon.jsii.Kernel.get(this, "accessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The backup vault access policy document in JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "accessPolicy", value);
    }

    /**
     * The tags to assign to the vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBackupVaultTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "backupVaultTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags to assign to the vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupVaultTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "backupVaultTags", value);
    }

    /**
     * Returns event notifications for the specified backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifications() {
        return software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Returns event notifications for the specified backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifications", value);
    }

    /**
     * Returns event notifications for the specified backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault.NotificationObjectTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "notifications", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * NotificationObjectTypeProperty notificationObjectTypeProperty = NotificationObjectTypeProperty.builder()
     *         .backupVaultEvents(List.of("backupVaultEvents"))
     *         .snsTopicArn("snsTopicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-logicallyairgappedbackupvault-notificationobjecttype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-logicallyairgappedbackupvault-notificationobjecttype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnLogicallyAirGappedBackupVault.NotificationObjectTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationObjectTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationObjectTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-logicallyairgappedbackupvault-notificationobjecttype.html#cfn-backup-logicallyairgappedbackupvault-notificationobjecttype-backupvaultevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-logicallyairgappedbackupvault-notificationobjecttype.html#cfn-backup-logicallyairgappedbackupvault-notificationobjecttype-backupvaultevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getBackupVaultEvents();

        /**
         * The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events;
         * <p>
         * for example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-logicallyairgappedbackupvault-notificationobjecttype.html#cfn-backup-logicallyairgappedbackupvault-notificationobjecttype-snstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-logicallyairgappedbackupvault-notificationobjecttype.html#cfn-backup-logicallyairgappedbackupvault-notificationobjecttype-snstopicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSnsTopicArn();

        /**
         * @return a {@link Builder} of {@link NotificationObjectTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationObjectTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationObjectTypeProperty> {
            java.util.List<java.lang.String> backupVaultEvents;
            java.lang.String snsTopicArn;

            /**
             * Sets the value of {@link NotificationObjectTypeProperty#getBackupVaultEvents}
             * @param backupVaultEvents An array of events that indicate the status of jobs to back up resources to the backup vault. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupVaultEvents(java.util.List<java.lang.String> backupVaultEvents) {
                this.backupVaultEvents = backupVaultEvents;
                return this;
            }

            /**
             * Sets the value of {@link NotificationObjectTypeProperty#getSnsTopicArn}
             * @param snsTopicArn The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events;. This parameter is required.
             *                    for example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsTopicArn(java.lang.String snsTopicArn) {
                this.snsTopicArn = snsTopicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationObjectTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationObjectTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationObjectTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationObjectTypeProperty {
            private final java.util.List<java.lang.String> backupVaultEvents;
            private final java.lang.String snsTopicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backupVaultEvents = software.amazon.jsii.Kernel.get(this, "backupVaultEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.snsTopicArn = software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backupVaultEvents = java.util.Objects.requireNonNull(builder.backupVaultEvents, "backupVaultEvents is required");
                this.snsTopicArn = java.util.Objects.requireNonNull(builder.snsTopicArn, "snsTopicArn is required");
            }

            @Override
            public final java.util.List<java.lang.String> getBackupVaultEvents() {
                return this.backupVaultEvents;
            }

            @Override
            public final java.lang.String getSnsTopicArn() {
                return this.snsTopicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("backupVaultEvents", om.valueToTree(this.getBackupVaultEvents()));
                data.set("snsTopicArn", om.valueToTree(this.getSnsTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnLogicallyAirGappedBackupVault.NotificationObjectTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationObjectTypeProperty.Jsii$Proxy that = (NotificationObjectTypeProperty.Jsii$Proxy) o;

                if (!backupVaultEvents.equals(that.backupVaultEvents)) return false;
                return this.snsTopicArn.equals(that.snsTopicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.backupVaultEvents.hashCode();
                result = 31 * result + (this.snsTopicArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVaultProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVaultProps.Builder();
        }

        /**
         * The name of a logical container where backups are stored.
         * <p>
         * Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaultname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaultname</a>
         * @param backupVaultName The name of a logical container where backups are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultName(final java.lang.String backupVaultName) {
            this.props.backupVaultName(backupVaultName);
            return this;
        }

        /**
         * The maximum retention period that the vault retains its recovery points.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-maxretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-maxretentiondays</a>
         * @param maxRetentionDays The maximum retention period that the vault retains its recovery points. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetentionDays(final java.lang.Number maxRetentionDays) {
            this.props.maxRetentionDays(maxRetentionDays);
            return this;
        }

        /**
         * This setting specifies the minimum retention period that the vault retains its recovery points.
         * <p>
         * The minimum value accepted is 7 days.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-minretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-minretentiondays</a>
         * @param minRetentionDays This setting specifies the minimum retention period that the vault retains its recovery points. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minRetentionDays(final java.lang.Number minRetentionDays) {
            this.props.minRetentionDays(minRetentionDays);
            return this;
        }

        /**
         * The backup vault access policy document in JSON format.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-accesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-accesspolicy</a>
         * @param accessPolicy The backup vault access policy document in JSON format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicy(final java.lang.Object accessPolicy) {
            this.props.accessPolicy(accessPolicy);
            return this;
        }

        /**
         * The tags to assign to the vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaulttags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaulttags</a>
         * @param backupVaultTags The tags to assign to the vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultTags(final java.util.Map<java.lang.String, java.lang.String> backupVaultTags) {
            this.props.backupVaultTags(backupVaultTags);
            return this;
        }

        /**
         * Returns event notifications for the specified backup vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-notifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-notifications</a>
         * @param notifications Returns event notifications for the specified backup vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(final software.amazon.awscdk.IResolvable notifications) {
            this.props.notifications(notifications);
            return this;
        }
        /**
         * Returns event notifications for the specified backup vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-notifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-notifications</a>
         * @param notifications Returns event notifications for the specified backup vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(final software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault.NotificationObjectTypeProperty notifications) {
            this.props.notifications(notifications);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault build() {
            return new software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
